
/********************************************************
 * File:	bsc_req.c
 *
 * Description:
 *	This file handles all non-primitive requests
 *	destined for the BISYNC module.
 *
 * Routines:
 *	bsc_req
 *	bsc_init
 *
 * Author:
 *	Jonathan Masel
 ********************************************************/

#include "gct.h"
#include "modules.h"
#include "msg.h"
#include "types.h"
#include "status.h"
#include "fatal.h"
#include "bss.h"
#include "config.h"
#include "../driver/mtypes.h"

bsc_req(m, child)
MSG *m;
BISYNC_LINK *child;
{
	int status, code;
	MSG *msg;
	extern MSG *getm();

	code = status = 0;

	switch( (int)m->hdr.type ){
	case RESET:
		bsc_init(m->param, child);
		break;
	case R_CHILD:
		m->param[0] = (int)child;
		break;
	default:
		status = BAD_TYPE;
		break;
	}

	m->hdr.status = status;
	conf_msg(m, child->upper);
	return(code);
}


/********************************************************
 * routine:	bsc_init
 *
 * description:
 *	Initialize a BiSync child.
 *
 * arguments:
 *	b		bisync configuration structure
 *	child		pointer to the child structure
 *
 * return code:
 *
 * side effects:
 *
 ********************************************************/
bsc_init(b, child)
struct bisync_config *b;
BISYNC_LINK *child;
{
	child->flags = b->transparent? TRANSPARENT: 0;
	child->lower = b->lower;
	child->upper = b->upper;
	child->trace_mask = b->trace_mask;
	child->Tack = b->timer;
	child->vs = 0;		/* Send state variable		*/
	child->va = 0;		/* Acknowledge state variable	*/
	child->vr = 0;		/* Receive state variable	*/
	child->outst = 0;	/* # frames awaiting ack */
	child->wsize = 1;	/* window size */
	child->i_conf = 0;	/* I queue conf pointer	*/
	child->i_ack = 0;	/* I queue ack pointer	*/
	child->i_head = 0;	/* I queue head pointer	*/
	child->i_tail = 0;	/* I queue tail pointer	*/
	child->flags |= INITIALIZED;
}
