
/********************************************************
 *
 * File:	bss.h
 *
 * Description:
 *	This file contains definitions for all the
 *	BSS resident data structures of the BISYNC module.
 *
 * Author:
 *	Jonathan Masel
 *
 ********************************************************/

/*
 * Child (per link) flags
 */
#define	INITIALIZED	0x0001	/* Link initialized */
#define	TIMER_RECOVERY	0x0002	/* timer recovery state */
#define	TRANSPARENT	0x0004	/* transparent mode */


#define	BISYNC_TICK	10	/* one tick / second */
#define	BISYNC_TIMER	1	/* acknowledge timer */

/*
 * link structure.
 * This structure consists of CHILD structure fields,
 * followed by BISYNC specific fields which are located
 * in the CHILD's work area.
 */
typedef struct link {
	/*
	 * Fields common to all CHILD structures
	 */
	unsigned short	key;	/* Link ID		*/
	unsigned short	flags;
	unsigned char	upper;	/* module above BISYNC	*/
	unsigned char	lower;	/* module below BISYNC	*/
	unsigned char	layer;	/* protocl layer	*/
	unsigned char	state;	/* protocol state	*/
	int	(* *smac)();	/* state machine	*/

	/*
	 * BISYNC specific fields (work area)
	 */
	unsigned short	Tack;	/* acknowledge timer 		*/
	unsigned char	vs;	/* Send state variable		*/
	unsigned char	va;	/* Acknowledge state variable	*/
	unsigned char	vr;	/* Receive state variable	*/
	unsigned char	outst;	/* outstanding acks		*/
	unsigned short	wsize;	/* window size (always 1)	*/
	struct t_frame	*i_conf;	/* I queue conf pointer	*/
	struct t_frame	*i_ack;		/* I queue ack pointer	*/
	struct t_frame	*i_head;	/* I queue head pointer	*/
	struct t_frame	*i_tail;	/* I queue tail pointer	*/
	int		trace_mask;	/* mask for event tracing */
} BISYNC_LINK;
