/*
 * ddc.h
 *
 * This file contains defines used in the
 * implementation of the DDCMP protocol.
 * ASCII codes are assumed.
 */

#define	SOH	1	/* data message */
#define	ENQ	5	/* control message (see below) */
#define	DLE	0x10	/* maintenance message */

/*
 * types of control messages
 */
#define	ACK	1	/* acknowledge */
#define	NAK	2	/* negative acknowledge */
#define	REP	3	/* reply to message */
#define	STRT	6	/* start */
#define	STACK	7	/* start acknowledge */

typedef struct {
	unsigned	type : 8;
	unsigned	count1 : 8;
	unsigned	flags : 2;
	unsigned	count2 : 6;
	unsigned	rep : 8;
	unsigned	num : 8;
	unsigned	addr : 8;
} DDCMP_DHDR;

typedef struct {
	unsigned	type : 8;
	unsigned	ctype : 8;
	unsigned	flags : 2;
	unsigned	subtype : 6;
	unsigned	rep : 8;
	unsigned	num : 8;
	unsigned	addr : 8;
} DDCMP_CHDR;
