
/********************************************************
 * File:	ddc_req.c
 *
 * Description:
 *	This file handles all non-primitive requests
 *	destined for the DDCMP module.
 *
 * Routines:
 *	ddc_req
 *	ddc_init
 *
 * Author:
 *	Jonathan Masel
 ********************************************************/

#include "gct.h"
#include "modules.h"
#include "msg.h"
#include "types.h"
#include "status.h"
#include "fatal.h"
#include "bss.h"
#include "config.h"
#include "../driver/mtypes.h"

ddc_req(m, child)
MSG *m;
DDCMP_LINK *child;
{
	int status, code;
	MSG *msg;
	extern MSG *getm();

	code = status = 0;

	switch( (int)m->hdr.type ){
	case RESET:
		ddc_init(m->param, child);
		break;
	case R_CHILD:
		m->param[0] = (int)child;
		break;
	default:
		status = BAD_TYPE;
		break;
	}

	m->hdr.status = status;
	conf_msg(m, child->upper);
	return(code);
}


/********************************************************
 * routine:	ddc_init
 *
 * description:
 *	Initialize a BiSync child.
 *
 * arguments:
 *	b		ddcmp configuration structure
 *	child		pointer to the child structure
 *
 * return code:
 *
 * side effects:
 *
 ********************************************************/
ddc_init(d, child)
struct ddcmp_config *d;
DDCMP_LINK *child;
{
	GCT *gct;

	GETGCT(gct);
	child->flags = 0;
	if( d ){
		child->lower = d->lower;
		child->lower_id = d->lower_id;
		child->upper = d->upper;
		child->wsize = d->window_size;
		child->addr = d->addr;
		child->Tack = d->timer;
		child->trace_mask = d->trace_mask;
	}
	child->vs = 0;		/* Send state variable		*/
	child->va = 0;		/* Acknowledge state variable	*/
	child->vr = 0;		/* Receive state variable	*/
	child->outst = 0;	/* # frames awaiting ack */
	child->i_conf = 0;	/* I queue conf pointer	*/
	child->i_ack = 0;	/* I queue ack pointer	*/
	child->i_head = 0;	/* I queue head pointer	*/
	child->i_tail = 0;	/* I queue tail pointer	*/
	child->flags |= INITIALIZED;
	stop_timer(gct->ddcmp->timer_table, child->key);
}
