
/********************************************************
 * File:	ddcmp_rx
 *
 * Description:
 *	This file handles reception of DDCMP messages.
 *
 * Routines:
 *
 * Author:
 *	Jonathan Masel
 ********************************************************/


#include "gct.h"
#include "msg.h"
#include "modules.h"
#include "types.h"
#include "status.h"
#include "bss.h"
#include "ddc.h"
#include "fatal.h"


/********************************************************
 * routine:	ddc_rxind
 *
 * description:
 *	This is the primtive called to handle received frames.
 *
 * arguments:
 *	r		points to the R_FRAME received
 *	child		the channel's child structure
 *
 * return code:
 *
 * side effects:
 *
 ********************************************************/

ddc_rxind(r, child)
register R_FRAME *r;
DDCMP_LINK *child;
{
	T_FRAME *t;
	GCT *gct;
	register DDCMP_DHDR *dhdr;

	ddc_trace(r);

	GETGCT(gct);

	/* only handle valid frames */
	if( r->hdr.status ){
		ddc_sendnak(child);
		relm(r);
		start_timer(gct->ddcmp->timer_table,
			child->key, DDCMP_TIMER, child->Tack);
		return;
	}

	dhdr = (DDCMP_DHDR *)(r->buf + r->boff);
	r->boff += sizeof(DDCMP_DHDR);
	r->blen -= sizeof(DDCMP_DHDR);
	r->flen -= sizeof(DDCMP_DHDR);

	switch( dhdr->type ){
	case SOH:
	case DLE:
		ddc_confirm(child, dhdr->rep);
		ddc_rx(r, child);
		start_timer(gct->ddcmp->timer_table,
			child->key, DDCMP_TIMER, child->Tack);
		return;
	case ENQ:
		switch( (int)((DDCMP_CHDR *)dhdr)->ctype ){
		case REP:
			if( child->vr != dhdr->num )
				ddc_sendack(child);
			break;
		case NAK:
		case ACK:
			ddc_confirm(child, dhdr->rep);
			break;
		case STRT:
			ddc_sendstack(child);
		case STACK:
			ddc_init(child);
			break;
		default:
			FATAL("DDCMP: undefined control message (%x)\n",
					((DDCMP_CHDR *)dhdr)->ctype);
			break;
		}
		break;
	default:
		FATAL("DDCMP: undefined control (%x)\n", dhdr->type);
		break;
	}

	/* this is reached for all but data/maintenance messages */
	relm(r);
	start_timer(gct->ddcmp->timer_table,
		child->key, DDCMP_TIMER, child->Tack);
}


/********************************************************
 * routine:	ddc_rx
 *
 * description:
 *	Handle a received text message.
 *
 * arguments:
 *	r		the message received
 *	child		the channel's child structure
 *
 * return code:
 *
 * side effects:
 *
 ********************************************************/
ddc_rx(r, child)
register R_FRAME *r;
register DDCMP_LINK *child;
{
	register int i;
	GCT *gct;
	R_FRAME *r1;

	GETGCT(gct);

	/* if first buffer is empty, return it to the pool */
	if( r->blen == 0 ){
		r1 = r;
		r = r->nextb;
		r->flen = r1->flen;
		r1->nextb = 0;
		relm(r1);
	}

	/* send message to upper layer */
	(*gct->send)(child->upper, r);

	/* acknowledge message */
	ddc_sendack(child);
}
