
#include "proto.h"

static int		Objc_Next(OBJECT *,int);
static void 	Objc_Change(OBJECT *,int,int);
static int		Handle_Popup(OBJECT *,boolean);

int Objc_Next(OBJECT *tree,int start)
{
	register OBJECT *obj;
	register int i = start;
	
	do
	{
		obj = tree + i;
		if ((!(obj->ob_state & DISABLED)) && (obj->ob_flags & SELECTABLE))
			return(i);
		i = obj->ob_next;
	}
	while (i>=0);
	return(FAIL);
}

void Objc_Change(OBJECT *tree,int obj,int newstate)
{
	register OBJECT *ob = tree + obj;
	int x,y;

	objc_offset(tree,obj,&x,&y);
	objc_change(tree,obj,0,x,y,ob->ob_width,ob->ob_height,newstate,1);
}

int Handle_Popup(OBJECT *menu,boolean wrap)
{
	register int current;
	int old = -1,ret = -1,dummy;
	
	EVENT events =
	{
		MU_BUTTON | MU_M1 | MU_M2 | MU_KEYBD,
		1,1,1,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,
		{0,0,0,0,0,0,0,0}
	};
	
	graf_mkstate(&events.ev_mmox,&events.ev_mmoy,&dummy,&dummy);
	if ((current = objc_find(menu,ROOT,MAX_DEPTH,events.ev_mmox,events.ev_mmoy)) >= 0)
		current = Objc_Next(menu,current);
	
	if (current < 0)
		if ((current = Objc_Next(menu,menu->ob_head)) < 0)
			return(FAIL);
	
	for (;;)
	{
		register int mpos;

		if (current!=old)
		{
			if (old>0)
				Objc_Change(menu,old,menu[old].ob_state & (~SELECTED));
			
			if (current>0)
				Objc_Change(menu,current,menu[current].ob_state | SELECTED);

			old = current;
		}
		
		if ((mpos = objc_find(menu,ROOT,MAX_DEPTH,events.ev_mmox,events.ev_mmoy)) < 0)
		{
			events.ev_mm1flags	= 0;
			events.ev_mm1x		= menu->ob_x;
			events.ev_mm1y		= menu->ob_y;
			events.ev_mm1width	= menu->ob_width;
			events.ev_mm1height	= menu->ob_height;
			events.ev_mflags	&= ~MU_M2;
		}
		else
		{
			events.ev_mm1flags	= 1;
			objc_offset(menu,mpos,&events.ev_mm1x,&events.ev_mm1y);
			events.ev_mm1width	= menu[mpos].ob_width;
			events.ev_mm1height	= menu[mpos].ob_height;
			events.ev_mm2x		= events.ev_mmox;
			events.ev_mm2y		= events.ev_mmoy;
			events.ev_mflags	|= MU_M2;
		}
		
		events.ev_mwich = Event_Multi(&events,0);
		if (events.ev_mwich & MU_BUTTON)
		{
			if (!(events.ev_mmobutton & 1))
			{
				if ((ret = objc_find(menu,ROOT,MAX_DEPTH,events.ev_mmox,events.ev_mmoy)) >= 0)
					if ((menu[ret].ob_state & DISABLED) || !(menu[ret].ob_flags & SELECTABLE))
						ret = -1;
				break;
			}
			else
				events.ev_mbstate = 0;
		}
		
		if (events.ev_mwich & (MU_M1|MU_M2))
		{
			if ((mpos = objc_find(menu,ROOT,MAX_DEPTH,events.ev_mmox,events.ev_mmoy)) >= 0)
			{
				if (!(menu[mpos].ob_state & DISABLED))
				{
					int temp = Objc_Next(menu,mpos);
					if (temp>0)
						current = temp;
				}
			}
			
			if (events.ev_mwich & MU_M2)
			{
				events.ev_mm2x = events.ev_mmox;
				events.ev_mm2y = events.ev_mmoy;
			}
		}
		
		if (events.ev_mwich & MU_KEYBD)
		{
			int exitmode = FALSE,keyfound = FALSE;
			
			switch (events.ev_mkreturn & 0x00ff)
			{
			case 13:
			case 32:
				ret = current;
				exitmode = keyfound = TRUE;
				break;
			case 27:
				ret = FAIL;
				exitmode = keyfound = TRUE;
				break;
			}
			
			if (!keyfound)
			{
				switch ((events.ev_mkreturn & 0xFF00)>>8)
				{
				case 71:
					if (events.ev_mmokstate & 3)
					{
						register int j;
						
						for (j=menu->ob_head;j<=menu->ob_tail;j++)
							if (!(menu[j].ob_state & DISABLED) &&
								 (menu[j].ob_flags & SELECTABLE))
								 current = j;
					}
					else
						current = Objc_Next(menu,menu->ob_head);
					break;
				case 75:
				case 72:
					{
						register int j,temp = FAIL;

						if (current>menu->ob_head)
						{
							for (j=menu->ob_head;j<current;j++)
								if (!(menu[j].ob_state & DISABLED) &&
									 (menu[j].ob_flags & SELECTABLE))
									 temp = j;
						}

						if (temp<0 && wrap)
						{
							for (j=menu->ob_head;j<=menu->ob_tail;j++)
								if (!(menu[j].ob_state & DISABLED) &&
									 (menu[j].ob_flags & SELECTABLE))
									 temp = j;
						}

						if (temp>0)
							current = temp;
					}
					break;
				case 77:
				case 80:
					if (current<menu->ob_tail)
					{
						int temp = Objc_Next(menu,current+1);
						if (temp>0 && temp!=current)
							current = temp;
						else
							current = Objc_Next(menu,menu->ob_head);
					}
					else if (wrap)
						current = Objc_Next(menu,menu->ob_head);
					break;
				}
			}

			if (exitmode)
				break;
		}
	}
	return(ret);
}

int Popup(OBJECT *menu,OBJECT *ptree,int object,int popup,int center,int x,int y,boolean wrap)
{
	DIAINFO *info = NULL;
	int current = -1,exit;
	
	if (ptree)
	{
		info = get_info(ptree);
		ob_draw_chg(info,object,NULL,ptree[object].ob_state|SELECTED,FALSE);
	}

	if (popup<CYCLE)
	{
		register int w = menu->ob_width>>1,h = menu->ob_height>>1;
		int mx,my,dummy;

		graf_mkstate(&mx,&my,&dummy,&dummy);
		switch (center)
		{
		case CENTER:
			{
				INFOVSCR *vscr;
				form_center(menu,&dummy,&dummy,&dummy,&dummy);
				if ((get_cookie('VSCR',(long *) &vscr)==TRUE) && (vscr->cookie=='XBRA'))
				{
					menu->ob_x = vscr->x + (vscr->w>>1) - w;
					menu->ob_y = vscr->y + (vscr->h>>1) - h;
				}
			}
			break;
		case XYPOS:
			menu->ob_x = x;
			menu->ob_y = y;
			break;
		case MOUSEPOS:
			menu->ob_x = mx - w;
			menu->ob_y = my - h;
			break;
		case XPOS:
			menu->ob_x = x;
			menu->ob_y = my - h;
			break;
		case YPOS:
			menu->ob_x = mx - w;
			menu->ob_y = y;
		}

		Min(&menu->ob_x,clip.v_x2 - menu->ob_width - 3);
		Max(&menu->ob_x,clip.v_x1 + 3);
		Min(&menu->ob_y,clip.v_y2 - menu->ob_height - 3);
		Max(&menu->ob_y,clip.v_y1 + 3);
	}
	
	{
		register int i;;
		for (i=menu->ob_head;i<=menu->ob_tail;i++)
		{
			if (menu[i].ob_flags & SELECTABLE)
				menu[i].ob_state &= ~SELECTED;
			if (menu[i].ob_state & CHECKED);
			{
				if (popup==POPUP || current>=0)
					menu[i].ob_state &= ~CHECKED;
				else
					current = i;
			}
		}
	}

	if (popup<CYCLE)
	{
		beg_ctrl();
		{
			register long len;
			register int sx,sy,sw,sh;
			long mem = 0l;
			MFDB dial;

			sx = menu->ob_x - 3;
			sy = menu->ob_y - 3;
			sw = menu->ob_width + 6;
			sh = menu->ob_height + 6;

			mfdb(&dial,NULL,sw,sh,0,planes);
			len  = count_size(&dial);
			
			if ((long) Malloc(-1l)>(len+4096l))
			{
				if ((mem = (long) Malloc(len+256l))>0l)
				{
					dial.fd_addr	= (int *) ((mem & 0xfffffffel) + 2);
					bitblt(menu,&dial,TRUE);
					goto draw_popup;
				}
			}
			form_dial(FMD_START,sx,sy,sw,sh,sx,sy,sw,sh);
			
			draw_popup:
			objc_draw(menu,ROOT,MAX_DEPTH,sx,sy,sw,sh);
			exit = Handle_Popup(menu,wrap);
			
			if (mem)
			{
				bitblt(menu,&dial,FALSE);
				Mfree((void *) mem);
			}
			else
				form_dial(FMD_FINISH,sx,sy,sw,sh,sx,sy,sw,sh);
		}
		end_ctrl();
	}
	else
	{
		if (current < 0)
			exit = Objc_Next(menu,menu->ob_head);
		else if (current<menu->ob_tail)
		{
			int temp = Objc_Next(menu,current+1);
			if (temp>0 && temp!=current)
				exit = temp;
			else
				exit = Objc_Next(menu,menu->ob_head);
		}
		else
			exit = Objc_Next(menu,menu->ob_head);
		evnt_timer(100,0);
	}

	if (exit>0)
	{
		register int i = 1,radio = 0;

		if (current>0)
			menu[current].ob_state &= ~CHECKED;
		if (popup!=POPUP)
			menu[exit].ob_state |= CHECKED;
		
		do
		{
			if (menu[i].ob_flags & SELECTABLE)
			{
				if (i==exit)
					return(radio);
				radio++;
			}
			i = menu[i].ob_next;
		} while (i>=0);
	}
	
	if (info)
		ob_draw_chg(info,object,NULL,ptree[object].ob_state & (~SELECTED),FALSE);

	return(FAIL);
}
