#
# modules.g
# This file contains a list of all modules
# (together with each module's start address)
# to be used in the ADS-302 software
#
# Each line of input is arranged as follows
#        module_name      base_address
# or
#        module_name      base_address    moduleID     menu
# "base_address" is a hexa-decimal number (no leading 0x).
# This is the start address of the module concerned - it is
# passed to the module in its RESET message in the "rom" field.
# "module_name" is any of the following:
#       driver          (MC68302 chip driver module)
#       lapb            (LAPB module)
#       lapd            (LAPD - Q.921 - module)
#       x25             (X.25 PLP module)
#       bisync          (BISYNC module)
#       ddcmp           (DDCMP module)
#       ft              (file transfer module)
#
# Two additional fields may be added: moduleID and menu.
# If moduleID is present, a user module (of the given ID) is created
# instead of the named module. This is the means by which modules
# may be added: since a given number of tasks are created, a new
# module will only be executed if it replaces an existing one.
# The replaced module will not exist and cannot be contacted in
# any way.
# The module ID is constructed by Or-ing the module's layer
# (least significant nybble) with an index (MS nybble). Refer to
# "include/modules.h" for details.
# "menu" is the base address of a structure containing the
# menu options for the module concerned. If no value (or zero)
# appears for this field, the corresponding menu in the
# user-interface is de-activated.
# The menu structures are defined in "ui/menu.h".
#
#
# In order to run the DRIVER Working Example #1 (see Programmer's
# Manual), where LAPB is replaced with the code from
# Driver Working Example #1, include the following line:
# lapb 7a000
# 
# In order to run the LAPB module include the following line:
# lapb 7a000
#
#
# In order to run the LAPB Working Example task (see Programmer's
# Manual), where X25 is replaced with the code from LAPB Working
# Example, include the following lines:
# lapb 7a000
# x25  6c000
# 
# In order to run the X.25 module, using LAPB at layer 2,
# include the following lines:
# lapb 7a000
# x25  6c000
#
# In order to run the X25 Working Example task (see Programmer's
# Manual), where FT is replaced with the code from X25 Working Example
# and X.25 uses LAPB at layer 2, include the following lines:
# lapb 7a000
# x25  6c000
# ft   6a800
#
# In order to run the LAPD Working Example task (see Programmer's
# Manual), where X25 is replaced with the code from LAPD Working
# Example, include the following line:
# x25  6c000
