/*************** HEADER FILE FOR THE XBRAC MODULE ****************/

/*****************************************************************\
*    Parameters :
*        vector:
*           This is the address of the vector to intercept.
*
*        magic:
*           Is a pointer to a ~32 bytes struct, 
*           with the string "XBRA" first, followed by your 4 byte
*           id-string : ex. "_id_".
*			NOTE : Make sure that the 'magic' struct is wordaligned!
*
*        routine:
*           This is a pointer to your C routine.
\*****************************************************************/


int XB_isinstal(long vector, char *magic);
/* If 'magic' is in the XBRA chain 'vector' : return 1 */

int XB_install(long vector, char *magic, void *routine);
/* Installs an userdefined routine. */

int XB_remove(long vector, char *magic);
/* removes the routine from the vector, returns 1 if the
   routine could be found.
   NOTE : This can be called with an 8 byte 'magic' which
          contains the "XBRA" and '_id_' only! */
          
int XB_kill(long vector, char *magic); /* (the -9 option!) */
/* Like 'XB_remove' but will allways remove the routine
   from the vector (also if an non XBRA routine has taken the
   vector [- this will also be killed]).
   This routine depends on the fact that 'Magic' contains 
   the 'Oldvec' field. It uses this to unchain all the 
   routines after the last XBRA routine til your routine.
   NOTE : This _must_ be called with the same 'magic' as
          when the routine was installed... */
