/*
 * gct.h
 * This file contains the definition of the global
 * configuration table (GCT). It is found via the EVT.
 *
 * fields marked U are expected to be initialized by the user
 *
 * parameters and return values are defined as follows:
 *	getmem(class, size)
 *		class = class of memory block
 *		size = pointer to returned block size
 *		returns pointer to block (0 on failure)
 *		and the block size (in *size)
 *
 *	relmem(class, ptr)
 *		class = class of memory block
 *		ptr = points to memory block
 *		returns 0 on success, error code on failure
 *
 *	send(mod, hdr)
 *		mod = destination module
 *		hdr = 32 bit message header to be sent
 *
 *	receive(mod)
 *		mod = module calling the routine
 *		returns pointer to message (0 on failure)
 *
 *
 *	cput(c)
 *		prints character c to the terminal.
 */

/*
 * Force standalone option added 21/5/90
 * To remove the option - delete the following line.
 */
#define	FORCE_SA	1

typedef struct {
	unsigned long		flags;	/* global flags */
	unsigned long		time;	/* system time */
	int			(* send)();
	int			(* receive)();
	int			(* grab)();
	int			(* getmem)();
	int			(* relmem)();
	int			(* cput)();
	struct module_bss	*ui;
	struct module_bss	*driver;
	struct module_bss	*lapd;
	struct module_bss	*lapb;
	struct module_bss	*x25;
	struct module_bss	*sig;
	struct module_bss	*pad;
	struct module_bss	*vtad;
	struct module_bss	*bisync;
	struct module_bss	*ddcmp;

/* start service routines */

	int		(* rxchar)();
	int		(* tick)();
	int		(* IMPgpip3)();
	int		(* IMPgpip2)();
	int		(* IMPscc0)();
	int		(* IMPdmae)();
	int		(* IMPdma)();
	int		(* IMPscc1)();
	int		(* IMPtim0)();
	int		(* IMPscc2)();
	int		(* IMPgpip1)();
	int		(* IMPtim1)();
	int		(* IMPscp)();
	int		(* IMPtim2)();
	int		(* IMPsmi0)();
	int		(* IMPsmi1)();
	int		(* IMPgpip0)();
	int		(* IMPerror)();

/* end service routines */

} GCT;

/*
 * in standalone systems,
 * the pointer to the GCT is located at 0xfc.
 * This corresponds to the entry for vector 59
 * in the 68000's EVT.
 */

#define	VECTOR_LOC(vector)	(4 * (vector))


#define	GCT_VEC			VECTOR_LOC(59)
#define	GETGCT(x)		(x = *((GCT **) GCT_VEC));
#define	SETGCT(x)		(*((GCT **) GCT_VEC) = x);





/*
 * The following macro's may be used to manipulate 
 * short-word's located at odd addresses.
 * This is required in 68000, since
 * odd addresses may only be accessed as a byte.
 * -DODDACC may be used in 'cc' if short-word's MAY be
 * accessed at odd addresses (e.g, 68020).
 */
/*
 * Write a word at an odd address
 * input:
 *	to - pointer to destination word - may be an odd address.
 *	from - value (immediate, or at an even address).
 */
#define	WRT_ODD_WRD(to, from) { \
	((unsigned char *) (to))[0] = ((from) & 0xff00) >> 8;\
	((unsigned char *) (to))[1] = (from) & 0x00ff; \
}

/*
 * Read a word at an odd address
 * input:
 *	to - destination word - must be at an even address.
 *	from - pointer to source word - may be an odd address.
 */
#define	RD_ODD_WRD(to, from) { \
	(to) = ((((unsigned char *) (from))[0]) << 8) \
		| ((unsigned char *) (from))[1]; \
}

/*
 * Logical operations on odd word.
 * input:
 *	adr - pointer to target word - may be an odd address.
 *	op - binary logical operator followed by '=' (|=, &=, ^=).
 *	arg - argument (immediate, or at an even adress).
 */
#define	OP_ODD_WRD(adr, op, arg) { \
	((unsigned char *) (adr))[0] op (((arg) & 0xff00) >> 8); \
	((unsigned char *) (adr))[1] op ((arg) & 0x00ff);\
}



/*
 * GCT flag bits
 */
#define	IMP_POLLING		0x8000
#define	VT100_TERMINAL		0x0000
#define	VIRTUAL_TERMINAL	0x0001
#define	PORT_A			0x0000
#define	PORT_B			0x0010
#define	PORT_C			0x0020
#define	PORT_D			0x0030

#define	WHICH_TERMINAL(x)	((int)((x) & 0x000f))
#define	WHICH_PORT(x)		((int)((x) & 0x00f0))





/*
 * The following structure is allocated for 
 * each module for the maximum number of 
 * instances supported by this module.
 * It resides in the module bss area.
 * Note that the work area for each one
 * must not exceed WORK_AREA_SIZE
 * (eventually a union should be used).
 */
#define	WORK_AREA_SIZE	116

typedef struct child {
		unsigned short	key;	/* identifies child	*/
		unsigned short	flags;
		unsigned char	upper;	/* module above this	*/
		unsigned char	lower;	/* module below this	*/
		unsigned char	layer;	/* protocl layer	*/
		unsigned char	state;	/* protocol state	*/
		int	(* *smac)();	/* state machine	*/
		char		work_area[WORK_AREA_SIZE];
} CHILD;

/*
 * CHILD flags bits:
 */
#define	LOOP_MODE	0x8000		/* Loopback mode.	*/
					/* If set, lower is the	*/
					/* partner child id,	*/
					/* and upper is used as	*/
					/* in normal mode.	*/

/*
 * the bss area allocated for each module.
 * a child is allocated for each instance.
 */
#define	TABLE		(16 * 16)	/* protocol table size	*/
					/* max_state*max_event	*/
#define	GWA_SIZE	68		/* global work area size*/

typedef struct module_bss {
	unsigned int	rom;		/* module ROM address	*/
	unsigned int	max;		/* maximum number of	*/
					/* instantiations	*/
 	unsigned short	flags;
	struct t_table	*timer_table;	/* module's timer table */
	unsigned short	tx_pool_len;	/* Length of Tx pool	*/
	int	(* protocol[TABLE])();	/* (state * event)	*/
	unsigned char	work_area[GWA_SIZE];
	CHILD	child[1];		/* one for each protocol*/
					/* instantiation. user 	*/
					/* must allocate enough */
					/* RAM.			*/
} BSS;
