/********************************************************
 *
 * File:	l2_types.h
 *
 * Description:
 *	Layer 2 modules interface definitions.
 *	This file contains primitive definitions 
 *	common to the LAPB module and the LAPD module.
 *
 *	This includes:
 *	- Primitives for layer 1 - layer 2 interface
 *	- Primitives for layer 2 - layer 3 interface
 *
 *	The primitive which are used as inputs to layer
 *	2 are numbered sequentially. In the same manner,
 *	the primitives issued by layer 2 to layer 3,
 *	are numbered sequentially.
 *
 * Note:
 *	The primitives at the layer 1 - layer 2 interface
 *	are per SCC port number.
 *	The primitives at the layer 2 - layer 3 interface
 *	are per LLID for LAPD, and global for LAPB.
 *
 ********************************************************/

/*
 * Layer 2 state machine events (inputs):
 * These events include:
 * 	- Primitive indications from layer 1
 * 	- Primitive requests from layer 3
 *	- Internal events (timer expiry)
 *	- Protocol events (rx frame types)
 *
 * The primitives marked D are unique to LAPD.
 */

#define	PH_DATA_IND		RX_IND
#define	PH_BSY_IND		BUSY_IND
#define	DL_DATA_REQ		TX_REQ
#define	L2_TM_EXP		TM_EXP

#define	DL_EST_REQ		( PRIM_DOWN | ( HI_DRIVER_PRIM + 0x01 ))
#define	DL_REL_REQ		( PRIM_DOWN | ( HI_DRIVER_PRIM + 0x02 ))
#define	DL_CONN_REQ		DL_EST_REQ
#define	DL_DISC_REQ		DL_REL_REQ

#define	RX_ERR			( PRIM_INT  | ( HI_DRIVER_PRIM + 0x03 ))
#define	RX_I_CMD		( PRIM_INT  | ( HI_DRIVER_PRIM + 0x04 ))
#define	RX_RR			( PRIM_INT  | ( HI_DRIVER_PRIM + 0x05 ))
#define	RX_RNR			( PRIM_INT  | ( HI_DRIVER_PRIM + 0x06 ))
#define	RX_REJ			( PRIM_INT  | ( HI_DRIVER_PRIM + 0x07 ))
#define	RX_SABME_CMD		( PRIM_INT  | ( HI_DRIVER_PRIM + 0x08 ))
#define	RX_DM_RSP		( PRIM_INT  | ( HI_DRIVER_PRIM + 0x09 ))
#define	RX_DISC_CMD		( PRIM_INT  | ( HI_DRIVER_PRIM + 0x0a ))
#define	RX_UA_RSP		( PRIM_INT  | ( HI_DRIVER_PRIM + 0x0b ))
#define	RX_FRMR_RSP		( PRIM_INT  | ( HI_DRIVER_PRIM + 0x0c ))

#define	DL_UDATA_REQ		( PRIM_DOWN | ( HI_DRIVER_PRIM + 0x0d ))
							/* D */
#define	RX_UI_CMD		( PRIM_INT  | ( HI_DRIVER_PRIM + 0x0e ))
							/* D */
#define	RX_XID_CMD		( PRIM_INT  | ( HI_DRIVER_PRIM + 0x0f ))
							/* D */
#define	RX_XID_RSP		( PRIM_INT  | ( HI_DRIVER_PRIM + 0x10 ))
							/* D */

/*
 * DL_EST/DL_CONN request status field definition:
 */
#define	DL_LINK_RST		0	/* Reset the link even */
				 	/* if already established.    */
#define	DL_NO_LINK_RST		1	/* Establish the link only if */
					/* not already established.   */
/*
 * Highest layer 2 input primitive
 */
#define	HI_L2_EVENT		( RX_XID_RSP & SUBTYPE)
#define	HI_LAPD_EVENT		( RX_XID_RSP & SUBTYPE)
#define	HI_LAPB_EVENT		( RX_FRMR_RSP & SUBTYPE)



/*
 * Primitives issued by layer 2 to layer 1 (outputs):
 */
#define	PH_DATA_REQ		TX_REQ




/*
 * Primitives issued by layer 2 to layer 3 (outputs):
 * The primitives marked D are unique to LAPD.
 */
#define	DL_DATA_IND		RX_IND
#define	DL_EST_IND		( PRIM_UP | ( HI_COM_PRIM + 0x01 ))
#define	DL_EST_CNF		( PRIM_UP | ( HI_COM_PRIM + 0x02 ))
#define	DL_REL_IND		( PRIM_UP | ( HI_COM_PRIM + 0x03 ))
#define	DL_REL_CNF		( PRIM_UP | ( HI_COM_PRIM + 0x04 ))
#define	DL_CONN_IND		DL_EST_IND
#define	DL_CONN_CNF		DL_EST_CNF
#define	DL_DISC_IND		DL_REL_IND
#define	DL_DISC_CNF		DL_REL_CNF
#define	DL_UDATA_IND		( PRIM_UP | ( HI_COM_PRIM + 0x05 ))
							/* D */

/*
 * Highest layer 2 output primitive
 */
#define	HI_L2_PRIM		( DL_UDATA_IND & SUBTYPE )
#define	HI_LAPD_PRIM		( DL_UDATA_IND & SUBTYPE )
#define	HI_LAPB_PRIM		( DL_DISC_CNF & SUBTYPE )
