/*
 * mng.h
 * type definitions for mng module
 */

/*
 * mng specific primitives
 */



/*
 * mng specific action requests 
 */
#define	MNG_FOPEN	( ACT_REQ | (HI_COM_ACTION + 0x01) )
#define	MNG_FROPEN	( ACT_REQ | (HI_COM_ACTION + 0x02) )
#define	MNG_FWOPEN	( ACT_REQ | (HI_COM_ACTION + 0x03) )
#define	MNG_FCLOSE	( ACT_REQ | (HI_COM_ACTION + 0x04) )
#define	MNG_FREWIND	( ACT_REQ | (HI_COM_ACTION + 0x05) )
#define	MNG_FREAD	( ACT_REQ | (HI_COM_ACTION + 0x06) )
#define	MNG_FWRITE	( ACT_REQ | (HI_COM_ACTION + 0x07) )
#define	MNG_FGETS	( ACT_REQ | (HI_COM_ACTION + 0x08) )
#define	MNG_FSCANF	( ACT_REQ | (HI_COM_ACTION + 0x09) )
#define	MNG_FWRITE_CMP	( ACT_REQ | (HI_COM_ACTION + 0x0a) )
#define	MNG_FPRINTF	( ACT_REQ | (HI_COM_ACTION + 0x0b) )
#define	MNG_FBIN2HEX	( ACT_REQ | (HI_COM_ACTION + 0x0c) )

/*
 * mng specific read/set requests
 */


/*
 * mng specific event indications
 */
#define	MNG_FATAL_ERR	( EVENT_IND | (HI_COM_EVENT + 0x01) )
#define	INTERRUPT	( EVENT_IND | (HI_COM_EVENT + 0x02) )
#define	TRACE_EV	( EVENT_IND | (HI_COM_EVENT + 0x03) )
#define	DMA_TRANSFER	( EVENT_IND | (HI_COM_EVENT + 0x04) )



/******************************************************
	param definitions
	for management module event indications
 ******************************************************/


/*
 * The following structure is sent in message parameter
 * field of a MNG_FATAL_ERR event indication sent to the
 * management module.
 */
#define	FATAL_FN	80

typedef struct {
	char	file[FATAL_FN];	/* file name			*/
	long	line;		/* Line number			*/
	long	time;		/* time stamp 			*/
	long	p;		/* parameter 			*/
	char	fmt[2];		/* string or format for printf	*/
} FATAL_INFO;

#define MAX_FATAL_STR	(MAX_PARAM * sizeof(long) - \
			(sizeof(FATAL_INFO) - 2) - 1)


/*
 * The following structure is used in
 * TRACE_EV EVENT_IND messages.
 */
#define	EV_DATA_SIZE	32
#define	IMP_INTERRUPT	0		/* in event_info.type */
#define	SCC_INTERRUPT	1		/* in event_info.type */

typedef struct event_info {
	unsigned char	src;		/* Generating module ID	*/
	unsigned char	dst;		/* Destination module ID*/
	unsigned short	id;		/* Child ID		*/
	unsigned short	type;		/* Event type 		*/
	unsigned short	status;		/* Event status		*/
	unsigned long	time;		/* Time stamp		*/
	unsigned long	par;		/* parameter */
	unsigned short	data_length;	/* length of following field */
	unsigned char	data[EV_DATA_SIZE];
} EVENT_INFO;


typedef struct dma_info {
	unsigned long	source;
	unsigned long	dest;
	unsigned long	count;
} DMA_INFO;

/******************************************************
	param definitions
	for management module action requests
 ******************************************************/


/*
 * The following structure is sent in message parameter
 * field of MNG_FWRITE and MNG_FWRITE_CMP requests 
 * sent to the management module.
 */
typedef struct {
	long		fid;	/* file ID			*/
	unsigned short	par1;	/* user parameters		*/
	unsigned short	par2;
	unsigned char	flags;
	char		data[1];
} FW_INFO;

#define	FW_INFO_SIZE		(sizeof(FW_INFO) - 1)

/*
 * Flags bit definitions:
 */
#define	FW_EOF		0x01	/* EOF expected			     */
