/*
 * The number of modules is the maximum number of
 * supplied modules.
 */
#define	NUM_MODULES	16

/*
 * Module defines are arranged in two four bit fields:
 *	layer
 *	module ID
 * ID's are only unique within a given layer.
 */

/*
 * Layers
 */
#define	LAYER(module)	((module) & 0x0f)

#define	OLYMPUS		0x0f
#define	SYSTEM		0x0e
#define	L7		0x06
#define	L6		0x05
#define	L5		0x04
#define	L4		0x03
#define	L3		0x02
#define	L2		0x01
#define	L1		0x00	/* IMP driver */


/*
 * Modules
 * Up to 7 modules may be defined at each layer.
 * For modules that interface to a specific
 * layer management module, the layer management module ID
 * is derived from the module ID by setting the MNG bit.
 */
#define	MODULE		0xf0
#define	MNG		0x80



/*
 * Highest layer modules:
 */
#define	DBM		(0x10 | OLYMPUS)	/* Debug module	*/
#define	DEMO		(0x20 | OLYMPUS)
#define	SYS_MNG		(MNG | SYSTEM)		/* system management */

/*
 * Layer 4 modules:
 */
#define	PAD		(0x00 | L4)

/* 
 * Layer 3 modules:
 */
#define	X25		(0x00 | L3)
#define	Q931		(0x10 | L3)

/* 
 * Layer 2 modules:
 */
#define	LAPB		(0x00 | L2)
#define	LAPD		(0x10 | L2)
#define	VTAD		(0x20 | L2)
#define	DMI2		(0x30 | L2)
#define	BISYNC		(0x40 | L2)
#define	DDCMP		(0x50 | L2)

/*
 * Layer 2 management modules:
 */
#define	LAPD_MNG	(MNG | LAPD)
#define	LAPB_MNG	(MNG | LAPB)
#define	X25_MNG		(MNG | X25)

/* 
 * Layer 1 modules
 */
#define	DRIVER		(0x00 | L1)



/*
 * response bits
 * these definitions depend on the layers defined above
 */
#define	RSP(layer)	(((unsigned short) 1) << (layer))

#define	L1_RSP		RSP(L1)
#define	DRIVER_RSP	RSP(LAYER(DRIVER))

#define	L2_RSP		RSP(L2)
#define	LAPB_RSP	RSP(LAYER(LAPB))
#define	LAPD_RSP	RSP(LAYER(LAPD))
#define	VTAD_RSP	RSP(LAYER(VTAD))
#define	DMI2_RSP	RSP(LAYER(DMI2))
#define	BISYNC_RSP	RSP(LAYER(BISYNC))
#define	DDCMP_RSP	RSP(LAYER(DDCMP))

#define	LAPD_MNG_RSP	RSP(LAYER(LAPD_MNG))
#define	LAPB_MNG_RSP	RSP(LAYER(LAPB_MNG))
#define	X25_MNG_RSP	RSP(LAYER(X25_MNG))

#define	L3_RSP		RSP(L3)
#define	X25_RSP		RSP(LAYER(X25))
#define	SIG_RSP		RSP(LAYER(SIG))

#define	L4_RSP		RSP(L4)
#define	PAD_RSP		RSP(LAYER(PAD))

#define	SYS_MNG_RSP	RSP(LAYER(SYS_MNG))
#define	DBM_RSP		RSP(LAYER(DBM))

/*
 * in order to request a response, the bits
 * for all the lower layers are set, except the driver bit.
 */
#define	REQ_RSP(layer)	(((unsigned short) (~(-1 << ((layer) + 1)))) & \
			0xfffe)

#define	L1_REQ_RSP		REQ_RSP(L1)
#define	DRIVER_REQ_RSP		REQ_RSP(LAYER(DRIVER))

#define	L2_REQ_RSP		REQ_RSP(L2)
#define	LAPB_REQ_RSP		REQ_RSP(LAYER(LAPB))
#define	LAPD_REQ_RSP		REQ_RSP(LAYER(LAPD))
#define	VTAD_REQ_RSP		REQ_RSP(LAYER(VTAD))
#define	DMI2_REQ_RSP		REQ_RSP(LAYER(DMI2))
#define	BISYNC_REQ_RSP		REQ_RSP(LAYER(BISYNC))
#define	DDCMP_REQ_RSP		REQ_RSP(LAYER(DDCMP))

#define	LAPD_MNG_REQ_RSP	REQ_RSP(LAYER(LAPD_MNG))
#define	LAPB_MNG_REQ_RSP	REQ_RSP(LAYER(LAPB_MNG))

#define	L3_REQ_RSP		REQ_RSP(L3)
#define	X25_REQ_RSP		REQ_RSP(LAYER(X25))
#define	SIG_REQ_RSP		REQ_RSP(LAYER(SIG))

#define	L4_REQ_RSP		REQ_RSP(L4)
#define	PAD_REQ_RSP		REQ_RSP(LAYER(PAD))

#define	SYS_MNG_REQ_RSP		REQ_RSP(LAYER(SYS_MNG))
#define	DBM_REQ_RSP		REQ_RSP(LAYER(DBM))
