/*
 * timer.h
 * this file contains the definitions used in implementing
 * the imer services.
 */


/*
 * defines used in the flags field below
 * this must be reset by the module following notification
 * of timer expiry
 */
#define	TIMER_RUNNING	((unsigned char)0x80)	/* written by module */


/*
 * a timer table is kept in each module requiring
 * services of the timer.
 * it is scanned by the driver module after a
 * (programmable) number of timer ticks (this
 * is the resolution of the timer for this module).
 * the time field is incremented by the timer
 * each time the table is scanned: this is
 * equivalent to (resolution * ticks/second) seconds.
 * timer ticks will be taken as 1/10th second (every
 * 1/10th of a second, the timer interrupt routine
 * should send the driver a TIMER_TICK message).
 *
 * note that the notion of time as seen by the module
 * is the scanning of the table by the driver:
 * e.g. if the driver is notified of a TIMER_TICK every
 * 1/10th second and module requested resolution of 5,
 * its table is scanned every 1/2 second. All timer and
 * timeout values within that module are in units of 1/2 second,
 * so a timer value of 1 second is represented by 2 timer units.
 */
typedef struct t_table {
	unsigned short	module;	/* module requesting timekeeping */
	unsigned short	max;	/* number of children */
	unsigned short	time;	/* "time" of last scan */
	struct t_child {
		unsigned char	flags;
		unsigned char	t_type;		/* timer type */
		unsigned short	timeout;	/* when to timeout */
	} t_child[1];		/* one entry for each t_child */ 
} TIMER_TABLE;

/*
 * the following structure is sent in m->param
 * when initially requesting timer services
 * (in the KEEP_TIME action request)
 */
typedef struct {
	TIMER_TABLE	*timer_table;
	unsigned short	resolution;
} TIMER_SERVICES;
