/*
 * types.h
 * common type defintions used by all modules
 */

/*
 * common primitives
 * the following primitives are used by 
 * all modules:
 */
#define	TX_REQ		( PRIM_DOWN | 0x00 )	/* transmit request */
#define	RX_IND		( PRIM_UP | 0x01 )	/* receive indication */
#define	TM_EXP		( PRIM_INT | 0x02 )	/* timer expired */
#define	BUSY_IND	( PRIM_UP | 0x03 )	/* busy clear/set */

/*
 * hdr.status of BUSY_IND messages indicate local busy
 * clear/set:
 */
#define	LOCAL_BUSY_CLEARED	1
#define	LOCAL_BUSY_DETECTED	2

#define	HI_COM_PRIM	0x03	/* highest common primitive	*/


/*
 * common action requests
 */
#define	RESET		( ACT_REQ | 0x00 ) /* reset the module */
#define	RECEIVER	( ACT_REQ | 0x01 ) /* dis/enable/activate rx */
#define CONFIRMER	( ACT_REQ | 0x02 ) /* dis/enable/activate conf */

#define	HI_COM_ACTION	0x02	/* highest common action req	*/

/*
 * the following are codes used in
 * enabling/activating and disabling
 * either rx or confirm processes
 */
#define	ENABLE		1
#define	ACTIVATE	2
#define	DISABLE		3


/*
 * common read/set requests
 */
#define	TX_QUEUE	(READ_REQ | 0x00 )  /* module transmit queue    */
#define	RX_QUEUE	(READ_REQ | 0x01 ) /* module receive queue     */
#define	R_BSS		(READ_REQ | 0x02) /* Module's BSS	*/
#define	R_CHILD		(READ_REQ | 0x03) /* Read child		      */

#define	HI_COM_READSET	0x03	/* highest common read/set req	*/


/*
 * common event indications
 */
#define	HI_COM_EVENT	0x00	/* non currently defined	*/


/******************************************************
	param definitions
	for globally used types
 ******************************************************/


/*
 * used in reading/writing transmit queues
 */
typedef struct t_queue {
	struct t_frame	*conf_q;
	struct t_frame	*ack_q;
	struct t_frame	*tx_q;
	struct t_frame	*req_q;
} T_QUEUE;

/*
 * used in reading/writing receive queues
 */
typedef struct r_queue {
	struct r_frame	*rx_q;
	struct r_frame	*pool_q;
	struct r_frame	*rtp_q;
} R_QUEUE;
