/********************************************************
 *
 * File:	config.h
 *
 * Description:
 *	This file contains definitions for LAPB module
 *	configuration.
 *
 * Author:
 *	Dorit Ordentlich
 *
 ********************************************************/

/*
 * LAPB module configuration parameters
 */
typedef struct lapb_config {
	unsigned long	rom;		/* Module ROM address	   */
	unsigned long	max;		/* Maximum links supported */
	unsigned short	tx_pool_len;	/* Length of Tx pool	   */
	unsigned short	tick;		/* Module timers resolution  */
	unsigned int	pad1[3];	/* To prevent changes in   */
                                        /* EEPROM structure.       */
	unsigned short	ev_mask;	/* Module event mask	   */
} LAPB_CONF;
