/********************************************************
 *
 * File:	mtypes.h
 *
 * Description:
 *	LAPB module specific interface definitions.
 *	Note that the definitions which are common
 *	to LAPB and LAPD are in file l2_types.h.
 *
 *	This file includes:
 *	- Primitives for layer 2 - layer 2 management interface
 *	- Non-primitive requests and indications
 *	- Debug requests
 *
 * Note:
 *	The primitives at the layer 2 - layer 2 
 *	management interface are per link.
 *
 * Author:
 *	Dorit Ordentlich
 *
 ********************************************************/

/*
 * The total number of events for LAPB
 * state machine:
 */
#define	LAPB_EVENTS		( (RX_FRMR_RSP & SUBTYPE) + 1 )



/*
 * LAPB specific output primitives:
 * These are the primitives issued to layer 2
 * management.
 */
#define	LAPB_MDL_ERR_IND	( PRIM_UP | ( HI_LAPB_PRIM + 0x01 ))




/*
 * The following macro derives
 * the corresponding bit in LAPB
 * event mask for a given LAPB
 * output primitive.
 */
#define	LAPB_MASK(ev)		(((unsigned short) 1) << \
				((ev) & SUBTYPE))


/*
 *		Non-primitive types
 */

/* 
 * Action requests
 */
#define	CONFIG_LINK	( ACT_REQ | ( HI_COM_ACTION + 1 ))
#define	CLEAR_GARBAGE	( ACT_REQ | ( HI_COM_ACTION + 2 ))

/*
 * Read/Set requests
 */
#define	RL2_LINK_PAR	( READ_REQ | ( HI_COM_READSET + 1 ))
#define	SL2_LINK_PAR	( SET_REQ  | ( HI_COM_READSET + 1 ))
#define	RL2_LINK_ST	( READ_REQ | ( HI_COM_READSET + 2 ))
#define	SL2_LINK_ST	( SET_REQ  | ( HI_COM_READSET + 2 ))

/*
 * Set-only requests
 */
#define	SL2_EVMASK	( SET_REQ  | ( HI_COM_READSET + 3 ))
#define	SL2_RSTCNT	( SET_REQ  | ( HI_COM_READSET + 4 ))

/*
 * Read-only requests
 */
#define	RL2_TX_POOL	( READ_REQ | ( HI_COM_READSET + 5 ))
#define	RL2_TXI		( READ_REQ | ( HI_COM_READSET + 6 ))
#define	RL2_GARBAGE	( READ_REQ | ( HI_COM_READSET + 7 ))

/******************************************************
	param definitions
	for module specific action requests
 ******************************************************/

/*
 * CONFIG_LINK action request:
 * Message param contains link configuration
 * parameters.
 */
typedef struct {
	unsigned short	flags;
	unsigned char	upper;	/* Upper layer module		*/
	unsigned char	lower;	/* Lower layer module		*/
	unsigned short	T1;	/* Timer T1			*/
	unsigned short	N1;	/* Max bytes in I frame		*/
	unsigned char	N2;	/* Max number of retransmission	*/
	unsigned char	k;	/* Max outstanding I frames	*/
} LAPB_LINK_CONFIG;

/*
 * flags bit definition
 */
#define	CONFIG_LOOP	LOOP_MODE	/* Loopback mode	*/
#define	CONFIG_FLIP	FLIP_MODE	/* Flip addresses A & B	*/
#define	CONFIG_DCE	DCE		/* DCE/DTE		*/
#define	CONFIG_EXT	EXTENDED	/* Modulo 8/128		*/
#define	CONFIG_PCHAN	PCHAN		/* Physical channel ID */

/******************************************************
	param definitions
	for module specific read/set requests
 ******************************************************/

/*
 * Read/Set link parameters (RL2_LINK_PAR, SL2_LINK_PAR):
 * Message param contains link parameters which may be modified
 * while the link is active.
 */
typedef struct {
	unsigned short	T1;	/* Timer T1			*/
	unsigned short	N1;	/* Max bytes in I frame		*/
	unsigned char	N2;	/* Max number of retransmission	*/
	unsigned char	k;	/* Max outstanding I frames	*/
} LAPB_LINK_PAR;

/*
 * Read/Set link statistics (RL2_LINK_ST, SL2_LINK_ST):
 * Message param contains link counters.
 */
typedef struct {
	unsigned long	tx_i;		/* Tx I count		*/
	unsigned long	tx_rr;		/* Tx RR count		*/
	unsigned long	tx_rnr;		/* Tx RNR count		*/
	unsigned long	tx_rej;		/* Tx REJ count		*/
	unsigned long	tx_frmr;	/* Tx FRMR count	*/
	unsigned long	rx_i;		/* Rx I count		*/
	unsigned long	rx_rr;		/* Rx RR count		*/
	unsigned long	rx_rnr;		/* Rx RNR count		*/
	unsigned long	rx_rej;		/* Rx REJ count		*/
	unsigned long	rx_frmr;	/* Rx FRMR count	*/
	unsigned long	ns_err;		/* N(S) errors count	*/
} LAPB_LINK_ST;
