/********************************************************
 *
 * File:	states.h
 *
 * Description:
 *	LAPB states definitions.
 *
 * Author:
 *	Dorit Ordentlich
 *
 ********************************************************/

/*
 * LAPB states
 */
#define	DISCONNECTED	0x00
#define	AWAIT_EST	0x01
#define	AWAIT_REL	0x02
#define	EST		0x03
#define	TIMER_REC	0x04
#define	FRMR_COND	0x05

/*
 * The total number of states for LAPB
 * state machine:
 */
#define	LAPB_STATES	(FRMR_COND + 1)


/*
 * The following macro translates a
 * state number and an event number to an 
 * index in the protocol state table.
 */
#define	ITEM(state, event)	((state) * LAPB_EVENTS + (event))

/*
 * The following macro "returns" the pointer
 * to the state table entry corresponding to a 
 * given state. 
 */
#define	CUR_STATE_TAB(state, tab)	(&((tab)[ITEM((state), 0)]))
