/********************************************************
 *
 * File:	timers.h
 *
 * Description:
 *	LAPB timers definitions.
 *
 * Author:
 *	Dorit Ordentlich
 *
 ********************************************************/

/*
 * Timer ID's:
 */
#define	LAPB_T1		0

/*
 * Timer actions:
 */
#define	START_T1(link)	{ \
	start_timer(bss->timer_table, (link)->key, LAPB_T1, \
		(link)->T1); \
	(link)->flags |= T1_RUN; \
}

/*
 * It is assumed that a request to stop
 * a timer should not occur if the timer
 * is not running.
 */
#define	STOP_T1(link)	{ \
	stop_timer(bss->timer_table, (link)->key); \
	(link)->flags &= ~T1_RUN; \
}

#define	STOP_ALL_TIMERS(link) 		STOP_T1(link);


/*
 * Timer values definitions
 * (all measured in 0.1 second units).
 */
#define	TICK		1	/* 0.1 second			*/
#define	TIMER_RES	2	/* Two ticks (0.2 second)	*/
#define	TIMER_VAL(t)	((t) / (TIMER_RES * TICK))
