/********************************************************
 *
 * File:	config.h
 *
 * Description:
 *	This file contains definitions for LAPD module
 *	configuration.
 *
 * Author:
 *	Dorit Ordentlich
 *
 ********************************************************/

/*
 * LAPD module configuration parameters
 */
typedef struct lapd_config {
	unsigned long	rom;		/* Module ROM address	   */
	unsigned long	max;		/* Maximum links supported */
	unsigned short	tx_pool_len;	/* Length of Tx pool	   */
	unsigned short	tick;		/* Module timers resolution  */

	/*
	 * The following are pointers to user-allocated
	 * area for LAPD TEI's tables for physical channels 0, 1, and 2.
	 */
	char		*pchan0_tei_tab;
	char		*pchan1_tei_tab;
	char		*pchan2_tei_tab;
	unsigned short	ev_mask;	/* Module event mask	   */
} LAPD_CONF;

/*
 * LAPD link parameters
 * These parameters are set when the link is assigned.
 */
typedef struct {
	unsigned short	dlci;	/* Link address 		*/
	unsigned short	T200;	/* In seconds			*/
	unsigned short	N201;	/* Max bytes in I field		*/
	unsigned char	N200;	/* Max number of retransmission	*/
	unsigned char	k;	/* Max outstanding I frames	*/
	unsigned short	T203;	/* In seconds			*/
} LAPD_ASSIGN_PAR;
