/********************************************************
 *
 * File:	mtypes.h
 *
 * Description:
 *	LAPD module specific interface definitions.
 *	Note that the definitions which are common
 *	to LAPB and LAPD are in file l2_types.h.
 *
 *	This file includes:
 *	- Primitives for layer 2 - layer 2 management interface
 *	- Non-primitive requests and indications
 *	- Debug requests
 *
 * Note:
 *	The primitives at the layer 2 - layer 2 
 *	management interface are per link.
 *
 * Author:
 *	Dorit Ordentlich
 *
 ********************************************************/

/*
 * LAPD specific input primitives:
 * These are the primitives received from
 * layer 2 management.
 */
#define	MDL_UDATA_REQ		  DL_UDATA_REQ
#define	MDL_ASN_REQ		( PRIM_DOWN | ( HI_LAPD_EVENT + 0x01 ))
#define	MDL_RMV_REQ		( PRIM_DOWN | ( HI_LAPD_EVENT + 0x02 ))
#define	MDL_ERR_RSP		( PRIM_DOWN | ( HI_LAPD_EVENT + 0x03 ))
#define	MDL_XID_REQ		( PRIM_DOWN | ( HI_LAPD_EVENT + 0x04 ))
#define	MDL_XID_RSP		( PRIM_DOWN | ( HI_LAPD_EVENT + 0x05 ))

/*
 * The total number of events for LAPD
 * state machine:
 */
#define	LAPD_EVENTS		( (MDL_XID_RSP & SUBTYPE) + 1 )



/*
 * LAPD specific output primitives:
 * These are the primitives issued to layer 2
 * management.
 */
#define	MDL_ASN_IND		( PRIM_UP | ( HI_LAPD_PRIM + 0x01 ))
#define	MDL_ERR_IND		( PRIM_UP | ( HI_LAPD_PRIM + 0x02 ))
#define	MDL_UDATA_IND		( PRIM_UP | ( HI_LAPD_PRIM + 0x03 ))
#define	MDL_XID_CNF		( PRIM_UP | ( HI_LAPD_PRIM + 0x04 ))
#define	MDL_XID_IND		( PRIM_UP | ( HI_LAPD_PRIM + 0x05 ))


/*
 * Protocol extention output primitives:
 * These are the primitives issued to layer 2
 * management.
 */
#define	EXT_MDL_ERR_IND		( PRIM_UP | ( HI_LAPD_PRIM + 0x06 ))

/*
 * The following macro derives
 * the corresponding bit in LAPD
 * event mask for a given LAPD
 * output primitive.
 */
#define	LAPD_MASK(ev)		(((unsigned short) 1) << \
				((ev) & SUBTYPE))




/*
 *		Non-primitive types
 */

/* 
 * Action requests
 */
#define	CONFIG_LINK	( ACT_REQ | ( HI_COM_ACTION + 1 ))
#define	CLEAR_GARBAGE	( ACT_REQ | ( HI_COM_ACTION + 2 ))

/*
 * Read/Set requests
 */
#define	RL2_LINK_PAR	( READ_REQ | ( HI_COM_READSET + 1 ))
#define	SL2_LINK_PAR	( SET_REQ  | ( HI_COM_READSET + 1 ))
#define	RL2_LINK_ST	( READ_REQ | ( HI_COM_READSET + 2 ))
#define	SL2_LINK_ST	( SET_REQ  | ( HI_COM_READSET + 2 ))

/*
 * Set-only requests
 */
#define	SL2_EVMASK	( SET_REQ  | ( HI_COM_READSET + 3 ))
#define	SL2_RSTCNT	( SET_REQ  | ( HI_COM_READSET + 4 ))

/*
 * Read-only requests
 */
#define	RL2_TX_POOL	( READ_REQ | ( HI_COM_READSET + 5 ))
#define	RL2_TXI		( READ_REQ | ( HI_COM_READSET + 6 ))
#define	RL2_GARBAGE	( READ_REQ | ( HI_COM_READSET + 7 ))
#define	RLAPD_TXUI	( READ_REQ | ( HI_COM_READSET + 8 ))

/******************************************************
	param definitions
	for module specific action requests
 ******************************************************/

/*
 * CONFIG_LINK action request:
 * Message param contains link configuration
 * parameters.
 */
typedef struct {
	unsigned short	flags;
	unsigned char	upper;	/* Upper layer module		*/
	unsigned char	lower;	/* Lower layer module		*/
} LAPD_LINK_CONFIG;

/*
 * flags bit definition
 */
#define	CONFIG_LOOP	LOOP_MODE	/* Loopback mode	*/
#define	CONFIG_FLIP	FLIP_MODE	/* Flip TEI's LSbit 	*/
#define	CONFIG_MNG	MNG_LINK	/* Management link	*/
#define	CONFIG_B	B_LINK		/* Broadcast link	*/
#define	CONFIG_USER	CR		/* User/Network		*/
#define	CONFIG_PCHAN	PCHAN		/* Physical channel ID */

/******************************************************
	param definitions
	for module specific read/set requests
 ******************************************************/

/*
 * Read/Set link parameters (RL2_LINK_PAR, SL2_LINK_PAR):
 * Message param contains link parameters which may be modified
 * while the link is active.
 */
typedef struct {
	unsigned short	T200;	/* Timer T200			*/
	unsigned short	N201;	/* Max bytes in I field		*/
	unsigned char	N200;	/* Max number of retransmission	*/
	unsigned char	k;	/* Max outstanding I frames	*/
	unsigned short	T203;	/* Timer T203			*/
} LAPD_LINK_PAR;

/*
 * Read/Set link statistics (RL2_LINK_ST, SL2_LINK_ST):
 * Message param contains link counters.
 */
typedef struct {
	unsigned long	tx_i;		/* Tx I count		*/
	unsigned long	tx_rr;		/* Tx RR count		*/
	unsigned long	tx_rnr;		/* Tx RNR count		*/
	unsigned long	tx_rej;		/* Tx REJ count		*/
	unsigned long	tx_frmr;	/* Tx FRMR count	*/
	unsigned long	rx_i;		/* Rx I count		*/
	unsigned long	rx_rr;		/* Rx RR count		*/
	unsigned long	rx_rnr;		/* Rx RNR count		*/
	unsigned long	rx_rej;		/* Rx REJ count		*/
	unsigned long	rx_frmr;	/* Rx FRMR count	*/
	unsigned long	ns_err;		/* N(S) errors count	*/
	unsigned long	tx_ui;		/* Tx UI count		*/
	unsigned long	rx_ui;		/* Rx UI count		*/
} LAPD_LINK_ST;
