/********************************************************
 *
 * File:	states.h
 *
 * Description:
 *	LAPD states definitions.
 *
 * Author:
 *	Dorit Ordentlich
 *
 ********************************************************/

/*
 * LAPD states
 */
#define	TEI_UNASSIGNED	0x00
#define	ASSIGN_WAIT_TEI	0x01
#define	EST_WAIT_TEI	0x02
#define	TEI_ASSIGNED	0x03
#define	AWAIT_EST	0x04
#define	AWAIT_REL	0x05
#define	EST		0x06
#define	TIMER_REC	0x07
#define	BROADCAST	0x08

/*
 * The total number of states for LAPD
 * state machine:
 */
#define	LAPD_STATES	(BROADCAST + 1)


/*
 * The following macro translates a
 * state number and an event number to an 
 * index in the protocol state table.
 */
#define	ITEM(state, event)	((state) * LAPD_EVENTS + (event))

/*
 * The following macro "returns" the pointer
 * to the state table entry corresponding to a 
 * given state. 
 */
#define	CUR_STATE_TAB(state, tab)	(&((tab)[ITEM((state), 0)]))
