/********************************************************
 *
 * File:	timers.h
 *
 * Description:
 *	LAPD timers definitions.
 *	T200 and T203 are implemented as a single
 *	timer: starting one timer stops the other.
 *
 * Author:
 *	Dorit Ordentlich
 *
 ********************************************************/

/*
 * Timer ID's:
 */
#define	LAPD_T200	0
#define	LAPD_T203	1

/*
 * Timer actions:
 * Note: starting one timer stops the other.
 */
#define	START_T200(link)	{ \
	start_timer(bss->timer_table, (link)->key, LAPD_T200, \
		(link)->T200); \
	(link)->flags &= ~T203_RUN; \
	(link)->flags |= T200_RUN; \
}

#define	START_T203(link)	{ \
	start_timer(bss->timer_table, (link)->key, LAPD_T203, \
		(link)->T203); \
	(link)->flags &= ~T200_RUN; \
	(link)->flags |= T203_RUN; \
}

/*
 * It is assumed that a request to stop
 * a timer should not occur if the timer
 * is not running.
 */

#define	STOP_T200(link)	{ \
	stop_timer(bss->timer_table, (link)->key); \
	(link)->flags &= ~T200_RUN; \
}

#define	STOP_T203(link)	{ \
	stop_timer(bss->timer_table, (link)->key); \
	(link)->flags &= ~T203_RUN; \
}

#define	STOP_ALL_TIMERS(link) { \
	stop_timer(bss->timer_table, (link)->key); \
	(link)->flags &= ~(T200_RUN | T203_RUN); \
}


/*
 * Timer values definitions
 * (all measured in 0.1 second units).
 */
#define	TICK		1	/* 0.1 second			*/
#define	TIMER_RES	2	/* Two ticks (0.2 second)	*/
#define	TIMER_VAL(t)	((t) / (TIMER_RES * TICK))
