
/*
 *	defines for the M68302ADS board
 */
#define	PARALLEL	0x00600000	/* parallel port data	*/



/*
 *	parallel handshake bits
 */

/*
 * write bits
 */
#define	HOST_BRK	0x08
#define	ADS_INT		0x04
#define	ADS_REQ		0x02
#define	ADS_ACK		0x01


/*
 * read bits
 */
#define	HOST_IACK	0x40
#define	HOST_ACK	0x20
#define	HOST_REQ	0x10

/*
 * register map
 */
typedef struct ads {
	unsigned char	h;		/* handshake register */
	unsigned char	data;		/* data register */
} ADS;


/*
 * note that writes are to a s/w copy of register.
 * the register must be written in one go (can't do |=)
 */
#define	ASSERT_ADSREQ(sw)	sw->h |= ADS_REQ
#define	ASSERT_ADSACK(sw)	sw->h |= ADS_ACK
#define	ASSERT_ADSINT(sw)	sw->h |= ADS_INT
#define	ASSERT_HOSTBRK(sw)	sw->h &= ~HOST_BRK
#define	NEGATE_ADSREQ(sw)	sw->h &= ~ADS_REQ
#define	NEGATE_ADSACK(sw)	sw->h &= ~ADS_ACK
#define	NEGATE_ADSINT(sw)	sw->h &= ~ADS_INT
#define	NEGATE_HOSTBRK(sw)	sw->h |= HOST_BRK

#define	HOSTREQ_ASSERTED(a)	(a->h & HOST_REQ)
#define	HOSTACK_ASSERTED(a)	(a->h & HOST_ACK)
#define	HOST_IACK_ASSERTED(a)	(a->h & HOST_IACK)

#define	PARALLEL_TX(c)		a->data = c
#define	PARALLEL_RX(c)		c = a->data


/*
 * the following are defines for messages passed
 * to/from the host program via the parallel port
 */


#define	CONSOLE_IO	0x0200
#define	CONSOLE_POLL	0x0100

/* all other codes are assumed to be
	destined for the system management entity
	on the host computer*/



/*
 * pmsg is the structure of the entire
 * message sent over the parallel port
 */
typedef struct pmsg {
	unsigned int	code;		/* type of message */
	unsigned int	len;		/* length of data field */
	char		data[300];
} PMSG;

