/******************************************************************
 * Copyright (c) 1990  MOTOROLA, Inc.                             *
 * NOTICE: The information contained in this file is proprietary  *
 * to MOTOROLA, INC. and is being made available  to MOTOROLA'S   *
 * customers under strict license agreements.              *
 * Use or disclosure of this information is permissible only      *
 * under the terms of the existing license agreement.      *
 ******************************************************************/

/*
 * hdlc.h
 * definitions for the HDLC controllers
 */

/*
 * transmit BD's
 */
/* remainder of register in imp.h*/
#define	T_L	0x0800		/* last in frame */
#define	T_CRC	0x0400		/* transmit CRC (when last) */

#define	T_ERROR	0x000f
#define	T_UN	0x0002		/* error: underrun */
#define	T_CT	0x0001		/* error: CTS lost */

/*
 * receive BD's
 */
/* remainder of register in imp.h*/
#define	R_L	0x0800		/* last BD in frame */
#define	R_F	0x0400		/* first BD in frame */

#define	R_ERROR	0x00ff
#define	R_LG	0x0020		/* frame too long */
#define	R_NO	0x0010		/* non-octet aligned */
#define	R_AB	0x0008		/* received abort sequence */
#define	R_CR	0x0004		/* receive CRC error */
#define	R_OV	0x0002		/* receive overrun */
#define	R_CD	0x0001		/* carrier detect lost */


/*
 * hdlc interrupts
 */
#define	HDLC_CTS	0x80	/* clear to send changed */
#define	HDLC_CD		0x40	/* carrier detect changed */
#define	HDLC_IDLE	0x20	/* idle sequence status changed */
#define	HDLC_TXE	0x10	/* transmit error */
#define	HDLC_RXFR	0x08	/* receive frame */
#define	HDLC_BUSY	0x04	/* busy */
#define	HDLC_TXBD	0x02	/* transmit buffer */
#define	HDLC_RXBD	0x01	/* receive buffer */

/*
 * status register
 */
#define SCCS_ID	0x04	/* Idle Status (valid HDLC and UART modes only)*/
#define SCCS_CDB	0x02	/* Carrier Detect Bar (= CD* pin) */
