/******************************************************************
 * Copyright (c) 1990  MOTOROLA, Inc.                             *
 * NOTICE: The information contained in this file is proprietary  *
 * to MOTOROLA, INC. and is being made available  to MOTOROLA'S   *
 * customers under strict license agreements.              *
 * Use or disclosure of this information is permissible only      *
 * under the terms of the existing license agreement.      *
 ******************************************************************/

/*
 * imp.h
 * definitions of IMP memory structures
 */

/*
 * include registers and
 * parameter ram definitions files
 */
#include "register.h"
#include "pram.h"



/* Buffer Descriptors */
typedef struct imp_bd {
	UINT16	status;
	UINT16	length;
	UCHAR	*buf;
} IMP_BD;

/*
 * transmit BD's status (common to all modes)
 */
#define	T_R	0x8000		/* ready bit */
#define	T_X	0x4000		/* extern buffer */
#define	T_W	0x2000		/* wrap bit */
#define	T_I	0x1000		/* interrupt on completion */

/*
 * receive BD's status (common to all modes)
 */
#define	R_E	0x8000		/* buffer empty */
#define	R_X	0x4000		/* external buffer */
#define	R_W	0x2000		/* wrap bit */
#define	R_I	0x1000		/* interrupt on reception */



/*
 * internal ram
 */
typedef struct imp {
/* BASE + 0x000: user data memory */
	UCHAR	udata[0x240];	/* 0x240 bytes user data */
	UCHAR	uempty[0x1c0];	/* empty till 0x400 */

/* BASE + 0x400: PARAMETER RAM */
	union {
		struct scc_pram {
			IMP_BD	rbd[8];
			IMP_BD	tbd[8];
			union {
				struct hdlc_pram	h;
				struct uart_pram	u;
				struct bisync_pram	b;
				struct ddcmp_pram	d;
				UCHAR		sc[0x40];
			} pscc;/*scc parameter area (protocol dependent) */
		} scc;
		UCHAR	pr[0x100];
	} pram[3];
/* reserved */
	UCHAR	resrvd1[0x100];

/* BASE + 0x800: INTERNAL REGISTERS */
/* DMA */
	UINT16	dma_res1;	/* reserved */
	UINT16	dma_mode;	/* dma mode reg */
	UINT32	dma_s;		/* dma source */
	UINT32	dma_d;		/* dma destination */
	UINT16	dma_cnt;	/* dma byte count */
	UCHAR	dma_status;	/* dma status */
	UCHAR	dma_res2;	/* reserved */
	UCHAR	dma_fc;		/* dma function code */
	UCHAR	dma_res3;	/* reserved */
/* Interrupt Controller */
	UINT16	intr_mode;	/* interrupt mode register */
	UINT16	intr_pending;	/* interrupt pending register */
	UINT16	intr_mask;	/* interrupt mask register */
	UINT16	intr_inservice;	/* interrupt in service register */
	UINT32	intr_res;	/* reserved */
/* Parallel I/O */
	UINT16	pa_control;	/* port A control */
	UINT16	pa_direction;	/* port A data direction */
	UINT16	pa_data;	/* port A data register */
	UINT16	pb_control;	/* port B control */
	UINT16	pb_direction;	/* port B data direction */
	UINT16	pb_data;	/* port B data */
	UINT16	p_res;		/* reserved */
/* Chip Select */
	UINT32	cs_res;
	UINT16	cs0_base;	/* base address 0 */
	UINT16	cs0_option;	/* option register 0 */
	UINT16	cs1_base;
	UINT16	cs1_option;
	UINT16	cs2_base;
	UINT16	cs2_option;
	UINT16	cs3_base;
	UINT16	cs3_option;
/* Timer */
	UINT16	t0_mode;	/* timer 0 mode register */
	UINT16	t0_ref;		/* timer 0 reference register */
	UINT16	t0_cap;		/* timer 0 capture register */
	UINT16	t0_counter;	/* timer 0 counter */
	UCHAR	tim_res0;	/* reserved */
	UCHAR	t0_status;	/* timer 0 status */

	UINT16	wd_ref;		/* watch dog timer reference */
	UINT16	wd_counter;	/* watch dog counter */
	UINT16	tim_res2;	/* reserved */

	UINT16	t1_mode;	/* timer 1 mode register */
	UINT16	t1_ref;		/* timer 1 reference register */
	UINT16	t1_cap;		/* timer 1 capture register */
	UINT16	t1_counter;	/* timer 1 counter */
	UCHAR	tim_res3;	/* reserved */
	UCHAR	t1_status;	/* timer 1 status */
	UINT16	tim_res4[3];	/* reserved */
/* command register */
	UCHAR	cr;		/* command register */
	UCHAR	cr_res;		/* reserved */
/* reserved */
	UCHAR	resrvd2[0x1e];
/* SCC registers */
	struct scc_regs {
		UINT16	resvd;	/* reserved */
		UINT16	conf;	/* SCC configuration register */
		UINT16	mode;	/* SCC mode register */
		UINT16	sync;	/* SCC sync register */
		UCHAR	event;	/* SCC event register */
		UCHAR	res1;	/* reserved */
		UCHAR	mask;	/* SCC mask register */
		UCHAR	res2;	/* reserved */
		UCHAR	status;	/* SCC status register */
		UCHAR	res3;	/* reserved */
		UINT16	res4;	/* reserved */
	} scc_regs[3];
/* SP (SCP + SMI) */
	UINT16	sp_scm;		/* scp, smi mode + clock control */
/* Serial Interface */
	UINT16	si_mask;	/* mask register */
	UINT16	si_mode;	/* mode register */

/* reserved */
	UCHAR	resrvd3[0x74a];
} IMP;

