/******************************************************************
 * Copyright (c) 1990  MOTOROLA, Inc.                             *
 * NOTICE: The information contained in this file is proprietary  *
 * to MOTOROLA, INC. and is being made available  to MOTOROLA'S   *
 * customers under strict license agreements.              *
 * Use or disclosure of this information is permissible only      *
 * under the terms of the existing license agreement.      *
 ******************************************************************/

/*
 * pram.h
 * Definitions of the parameter area RAM.
 * Note that different structures are overlaid
 * at the same offsets for the different modes
 * of operation.
 */

/*****************************************************************
	HDLC parameter RAM
*****************************************************************/

struct hdlc_pram {
	UCHAR	rfc;		/* Rx FC register */
	UCHAR	tfc;		/* Tx FC register */
	UINT16	rblen;		/* Rx buffer length */
	UINT16	rstate;		/* Rx internal state */
	UINT16	rbuf;		/* Rx buffer number */
	UINT32	rptr;		/* Rx internal data pointer */
	UINT16	rcount;		/* Rx byte count */
	UINT16	rtemp;		/* Rx temp */

	UINT16	tstate;		/* Tx internal state */
	UINT16	tbuf;		/* Tx buffer number */
	UINT32	tptr;		/* Tx internal data pointer */
	UINT16	tcount;		/* Tx byte count */
	UINT16	ttemp;		/* Tx temp */

	UINT16	rcrc1;		/* CRC low word (Rx) */
	UINT16	rcrc2;		/* CRC high word (Rx) */
	UINT16	r_cmaskl;	/* constant */
	UINT16	r_cmaskh;	/* constant */
	UINT16	tcrc_l;		/* CRC low word (Tx) */
	UINT16	tcrc_h;		/* CRC high word (Tx) */

	UINT16	discard_cnt;	/* discarded frames counter */
	UINT16	crc_cnt;	/* CRC error counter */
	UINT16	abort_cnt;	/* rx-ed abort counter */
	UINT16	nmf_cnt;	/* not my frame counter */
	UINT16	retx_cnt;	/* retransmission counter */

	UINT16	r_max;		/* maximum frame length */
	UINT16	r_maxcnt;	/* maximum frame counter */
	UINT16	r_mask;		/* address mask */
	UINT16	r_addr1;	/* address 1 */
	UINT16	r_addr2;	/* address 2 */
	UINT16	r_addr3;	/* address 3 */
	UINT16	r_addr4;	/* address 4 */
};



/*****************************************************************
	UART parameter RAM
*****************************************************************/

/*
 * bits in uart control characters table
 */
#define	CC_INVALID	0x8000		/* control character is valid */
#define	CC_REJ		0x4000		/* don't store char in buffer */
#define	CC_CHAR		0x00ff		/* control character */

/* UART */
struct uart_pram {
	UCHAR	rfc;		/* Rx FC register */
	UCHAR	tfc;		/* Tx FC register */
	UINT16	rblen;		/* Rx buffer length */
	UINT16	rstate;		/* Rx internal state */
	UINT16	rbuf;		/* Rx buffer number */
	UINT32	rptr;		/* Rx internal data pointer */
	UINT16	rcount;		/* Rx byte count */
	UINT16	rtemp;		/* Rx temp */

	UINT16	tstate;		/* Tx internal state */
	UINT16	tbuf;		/* Tx buffer number */
	UINT32	tptr;		/* Tx internal data pointer */
	UINT16	tcount;		/* Tx byte count */
	UINT16	ttemp;		/* Tx temp */

	UINT16	maxi;		/* maximum idle characters */
	UINT16	rxidle;		/* rx idle counter (internal) */
	UINT16	brk;		/* break count register */

	UINT16	parity_cnt;	/* Rx parity error counter */
	UINT16	framing_cnt;	/* Rx framing error counter */
	UINT16	noise_cnt;	/* Rx noise counter */
	UINT16	break_cnt;	/* Rx break character counter */

	UINT16	r_addr1;	/* address 1 */
	UINT16	r_addr2;	/* address 2 */
	UINT16	ccr;		/* Rx control char register */
	UINT16	cc[8];		/* Rx control characters */
};



/*****************************************************************
	BISYNC parameter RAM
*****************************************************************/

struct bisync_pram {
	UCHAR	rfc;		/* Rx FC register */
	UCHAR	tfc;		/* Tx FC register */
	UINT16	rblen;		/* Rx buffer length */
	UINT16	rstate;		/* Rx internal state */
	UINT16	rbuf;		/* Rx buffer number */
	UINT32	rptr;		/* Rx internal data pointer */
	UINT16	rcount;		/* Rx byte count */
	UINT16	rtemp;		/* Rx temp */

	UINT16	tstate;		/* Tx internal state */
	UINT16	tbuf;		/* Tx buffer number */
	UINT32	tptr;		/* Tx internal data pointer */
	UINT16	tcount;		/* Tx byte count */
	UINT16	ttemp;		/* Tx temp */

	UINT16	rcrc;		/* temp Rx CRC */
	UINT16	crc_c;		/* CRC constant */
	UINT16	prcrc;		/* preset rx CRC value */
	UINT16	tcrc;		/* temp Tx CRC */
	UINT16	ptcrc;		/* preset tx CRC value */

	UINT16	res1;
	UINT16	res2;
	UINT16	parity_cnt;	/* Rx parity error counter */

	UINT16	sync;		/* SYNC character */
	UINT16	dle;		/* DLE character */
	UINT16	cc[8];		/* control characters */
};

/*****************************************************************
	DDCMP parameter RAM
*****************************************************************/

struct ddcmp_pram {
	UCHAR	rfc;		/* Rx FC register */
	UCHAR	tfc;		/* Tx FC register */
	UINT16	rblen;		/* Rx buffer length */
	UINT16	rstate;		/* Rx internal state */
	UINT16	rbuf;		/* Rx buffer number */
	UINT32	rptr;		/* Rx internal data pointer */
	UINT16	rcount;		/* Rx byte count */
	UINT16	rtemp;		/* Rx temp */

	UINT16	tstate;		/* Tx internal state */
	UINT16	tbuf;		/* Tx buffer number */
	UINT32	tptr;		/* Tx internal data pointer */
	UINT16	tcount;		/* Tx byte count */
	UINT16	ttemp;		/* Tx temp */

	UINT16	rcrc;		/* temp Rx CRC */
	UINT16	crc_c;		/* CRC constant */
	UINT16	pcrc;		/* preset CRC value */
	UINT16	tcrc;		/* temp Tx CRC */

	UINT16	soh;		/* SOH character */
	UINT16	enq;		/* ENQ character */
	UINT16	dle;		/* DLE character */

	UINT16	crc1_cnt;	/* CRC1 error counter */
	UINT16	crc2_cnt;	/* CRC2 error counter */
	UINT16	addr_cnt;	/* no address match counter */
	UINT16	discard_cnt;	/* discard message counter */

	UINT16	r_max;		/* maximum frame length */
	UINT16	r_maxcnt;	/* maximum frame counter */

	UINT16	r_mask;		/* address mask */
	UINT16	r_addr1;	/* address 1 */
	UINT16	r_addr2;	/* address 2 */
	UINT16	r_addr3;	/* address 3 */
	UINT16	r_addr4;	/* address 4 */
};


/*****************************************************************
	IOM2 parameter RAM
	(overlaid on tx bd[5] of SCC channel[2])
*****************************************************************/
struct iom2_pram {
	UINT16	ci_data;	/* ci data */
	UINT16	monitor_data;	/* monitor data */
	UINT16	tstate;		/* transmitter state */
	UINT16	rstate;		/* receiver state */
};

/*****************************************************************
	SCP/SMI parameter RAM
	(overlaid on tx bd[6,7] of SCC channel[2])
*****************************************************************/

#define	SCP_R	0x8000		/* Ready bit in BD */

struct scp_smi_pram {
	UINT16	res[3];		/* reserved */
	UINT16	smi0_r;		/* smi 0 Rx BD */
	UINT16	smi0_t;		/* smi 0 Tx BD */
	UINT16	smi1_r;		/* smi 1 Rx BD */
	UINT16	smi1_t;		/* smi 1 Tx BD */
	UINT16	internal[6];	/* for internal use only */
	UINT16	scp_bd;		/* Tx/Rx BD */
	UINT16	berr;		/* bus error channel number */
	UINT16	rev_number;	/* chip revision number */
};

