/******************************************************************
 * Copyright (c) 1990  MOTOROLA, Inc.                             *
 * NOTICE: The information contained in this file is proprietary  *
 * to MOTOROLA, INC. and is being made available  to MOTOROLA'S   *
 * customers under strict license agreements.              *
 * Use or disclosure of this information is permissible only      *
 * under the terms of the existing license agreement.      *
 ******************************************************************/

/*
 * registers.h
 * Definitions of the IMP registers
 */


/*****************************************************************
	Base Address Register (address 0xf2)
*****************************************************************/

#define	WRITE_BAR(x)		(*((UINT16 *)0xf2) = x)
#define	READ_BAR()		(*((UINT16 *)0xf2))

struct bar_reg {
	UINT16 fc  : 3;		/* 3 bit function code */
	UINT16 cfc : 1;		/* compare fc */
	UINT16 base : 12;	/* internal ram base address (bits 12-23) */
};


/*****************************************************************
	System Control Register (address 0xf4)
*****************************************************************/

struct scr_reg {
	UINT16 : 4;
	UINT16 ipa : 1;	/* interrupt priority active */
	UINT16 hwt : 1;	/* h/w watch dog timer */
	UINT16 wpv : 1;	/* write protect violation */
	UINT16 adc : 1;	/* address decode conflict */
	UINT16 : 3;
	UINT16 wpve : 1;	/* write protect violation enable */
	UINT16 rmcst : 1;	/* RMC cycles special treatment */
	UINT16 emws : 1;	/* external master wait state */
	UINT16 adce : 1;	/* address decode conflict enable */
	UINT16 bclm : 1;	/* bus clear mask */
	UINT16 frzw : 1;	/* freeze watchdog timer enable */
	UINT16 frz2 : 1;	/* freeze timer2 enable */
	UINT16 frz1 : 1;	/* freeze timer1 enable */
	UINT16 : 1;
	UINT16 hwden : 1;	/* hardware watchdog enable */
	UINT16 hwdcn : 3;	/* hardware watchdog count */
	UINT16 rsten : 1;	/* reset enable */
	UINT16 div16 : 1;	/* low power prescale divide by 16 */
	UINT16 lpen : 1;	/* low power enable */
	unsigned lpdiv : 5;	/* low power clock divider */
};

#define	WRITE_SCR(x)	(*((long *)0xf4) = x)
#define	CLEAR_IPA	(((struct scr_reg *)0xf4)->ipa = 1)


/*****************************************************************
	Command Register
*****************************************************************/

/* bit fields within command register */
#define	SOFTWARE_RESET	0x80
#define	CMD_GCI		0x40
#define	CMD_OPCODE	0x30
#define	CMD_CHANNEL	0x06
#define	CMD_FLAG	0x01

/* command opcodes */
#define	STOP_TX		0x00
#define	RESTART_TX	0x10
#define	ENTER_HUNT_MODE	0x20
#define	RESET_RX_BCS	0x30	/* bisync only */
#define	GCI_ABORT	CMD_GCI | 0x04
#define	GCI_TIMEOUT	CMD_GCI | 0x14



/*****************************************************************
	SCC configuration register
*****************************************************************/

#define	SCON_WOMS	0x8000		/* Wired-OR Mode Select */
#define	SCON_EXTC	0x4000		/* External Clock Source */
#define	SCON_TCS	0x2000		/* Transmit clock source */
#define	SCON_RCS	0x1000		/* Receive Clock Source */
#define	SCON_CD		0x0ffe		/* Clock Divider */
#define	SCON_DIV4	0x0001		/* Scc Clock PRescaler Divide by 4 */

struct scc_conf {
	UINT16 woms : 1;	/* wire-ORed mode */
	UINT16 extc : 1;	/* external clock */
	UINT16 txclk: 1;	/* tx clock source */
	UINT16 rxclk: 1;	/* rx clock source */
	UINT16 clock: 11;	/* clock divider */
	UINT16 div4 : 1;	/* prescaler divide by 4 */
};



/*****************************************************************
	SCC mode register
*****************************************************************/

/* SCC modes */
#define	HDLC_PORT		0
#define ASYNC_PORT		1	/* uart or ddcmp */
#define	DDCMP_PORT		2
#define	BISYNC_PORT		3

/*
 * diagnostics bits
 */
#define	NORMAL		0	/* normal operation with CTS and CD */
				/* automatically controlled by SCC */
#define	LOOPBACK	1	/* connect tx to rx */
#define	SERIAL_ECHO	2	/* connect rx to tx */
#define	NORMAL_SW	3	/* normal operation with CTS and CD */
				/* under control of s/w */


/* hdlc mode register */

struct hdlc_mode_reg {
	UINT16	min_flags : 4;	/* min flags between frames */
	UINT16	crc_32 : 1;	/* 32-bit CRC */
	UINT16	: 2;
	UINT16	retx : 1;	/* enable retx */
	UINT16	flg : 1;	/* send flags between frames */
	UINT16	data_enc : 1;	/* data encoding (NRZ/NRZ1) */

	UINT16	diag : 2;		/* diagnostic mode */
	UINT16	rx_enable : 1;		/* rx enable */
	UINT16	tx_enable : 1;		/* tx enable */
	UINT16	mode : 2;
};


/* uart mode register */

/*
 * tx parity (SCC asynchronous)
 */
#define	ODD_PARITY	0
#define	EVEN_PARITY	1
#define	LOW_PARITY	2
#define	HIGH_PARITY	3

/*
 * UART options
 */
#define	OPT_NORMAL	0
#define	OPT_MULTD	1	/* multi-drop, no auto */
#define	OPT_DDCMP	2	/* ddcmp */
#define	OPT_AUTO	3	/* mutli-drop with automatic */
				/* address recognition */

struct uart_mode_reg {
	UINT16	tx_parity : 2;		/* tx parity mode */
	UINT16	rx_parity : 1;		/* rx parity */
	UINT16	parity_enable : 1;
	UINT16	option : 2;
	UINT16	freeze : 1;		/* freeze tx */
	UINT16	char_length : 1;
	UINT16	rts : 1;
	UINT16	stop_bits : 1;		/* 1 or 2 bits */

	UINT16	diag : 2;		/* diagnostic mode */
	UINT16	rx_enable : 1;		/* rx enable */
	UINT16	tx_enable : 1;		/* tx enable */
	UINT16	mode : 2;
};


/* bisync mode register */

struct bisync_mode_reg {
	UINT16	parity : 1;	/* 0 = odd 1 = even */
	UINT16	ext_sync : 1;	/* external sync */
	UINT16	tsync : 1;	/* transmit SYNC */
	UINT16	rev_data : 1;	/* reverse char. bit order */
	UINT16	crc_16 : 1;	/* BCS is LRC (0) or CRC16 (1) */
	UINT16	: 1;
	UINT16	rx_trans : 1;	/* rx transparent */
	UINT16	rx_bcs : 1;	/* enable rx of BCS */
	UINT16	synf : 1;	/* tx SYNs between frames */
	UINT16	data_enc : 1;	/* data encoding (NRZ/NRZ1) */

	UINT16	diag : 2;		/* diagnostic mode */
	UINT16	rx_enable : 1;		/* rx enable */
	UINT16	tx_enable : 1;		/* tx enable */
	UINT16	mode : 2;
};


/* ddcmp mode register */

struct ddcmp_mode_reg {
	UINT16	min_syncs : 4;	/* minimum syncs between msgs */
	UINT16	: 1;
	UINT16	v_110 : 1;	/* V.110 support */
	UINT16	: 2;
	UINT16	synf : 1;	/* tx SYNs between frames */
	UINT16	data_enc : 1;	/* data encoding */

	UINT16	diag : 2;		/* diagnostic mode */
	UINT16	rx_enable : 1;		/* rx enable */
	UINT16	tx_enable : 1;		/* tx enable */
	UINT16	mode : 2;
};



/*****************************************************************
	SCP/SMI mode register
*****************************************************************/

/*
 * defines for SMI modes
 */
#define	IOM_UNUSED	0	/* IOM: monitor not used */
#define	IOM_DCHAN	1	/* IOM: monitor controls D channel */
#define	IOM_DATA_CNTRL	2	/* IOM: monitor txs data/control bytes */
#define	IDL_AM_HUNT	4	/* IDL: hunt M and A channels on zero */
#define	IDL_M_HUNT	5	/* IDL: hunt M channel on zero */
#define	IDL_A_HUNT	6	/* IDL: hunt A channel on zero */
#define	IDL_NORMAL	7	/* IDL: normal (no hunt on zero mode) */

struct scp_smi_mode {
/* SCP bits */
	UINT16 scp_start : 1;		/* start SCP tx bit */
	UINT16 scp_loop : 1;		/* SCP loopback mode */
	UINT16 : 1;
	UINT16 scp_prescale : 4;	/* SCP prescale modulus select */
	UINT16 scp_enable : 1;		/* enable SCP */
/* SMI bits */
	UINT16 : 2;
	UINT16 smi_mode : 3;		/* SMI mode */
	UINT16 smi_loop : 1;		/* SMI loopback mode */
	UINT16 smi2_enable : 1;	/* enable SMI2 */
	UINT16 smi1_enable : 1;	/* enable SMI1 */
};



/*****************************************************************
	serial interface mode register
*****************************************************************/

/*
 * defines for D/B channel routing
 * (b2_rout, b1_rout, d_rout)
 */
#define	NOT_SUPPORTED	0
#define	ROUTE_SCC0	1
#define	ROUTE_SCC1	2
#define	ROUTE_SCC2	3

/*
 * serial interface mode
 */
#define	IDL_MODE	0
#define	IOM_MODE	1
#define	PCM_MODE	2
#define	NMSI_MODE	3

struct si_mode {
	UINT16	stz : 1;	/* set L1TxD to 0 (IOM) */
	UINT16	sync_8 : 1;	/* PCM only */
	UINT16	loopback : 1;	/* loopback mode */
	UINT16	echo : 1;	/* echo mode */
	UINT16	: 2;
	UINT16	b2_rout : 2;	/* B2 routing (IDL, IOM) */
	UINT16	b1_rout : 2;	/* B1 routing (IDL, IOM) */
	UINT16	d_rout : 2;	/* D routing (IDL, IOM) */
	UINT16	nmsi_3 : 1;	/* SCC3 routing */
	UINT16	nmsi_2 : 1;	/* SCC2 routing */
	UINT16	mode : 2;
};


/*****************************************************************
	serial interface mask register
*****************************************************************/

struct si_mask {
	UINT16	b2 : 8;
	UINT16	b1 : 8;
};



/*****************************************************************
	interrupt registers
*****************************************************************/

#define	INTR_PB11	0x8000		/* parallel port B bit 11 */
#define	INTR_PB10	0x4000		/* parallel port B bit 10 */
#define	INTR_SCC0	0x2000		/* SCC port 0 */
#define	INTR_DMAERR	0x1000		/* dma error */
#define	INTR_DMA	0x0800		/* dma */
#define	INTR_SCC1	0x0400		/* SCC port 1 */
#define	INTR_TIMER0	0x0200		/* timer 0 */
#define	INTR_SCC2	0x0100		/* SCC port 2 */
#define	INTR_PB9	0x0080		/* parallel port B bit 9 */
#define	INTR_TIMER1	0x0040		/* timer 1 */
#define	INTR_SCP	0x0020		/* SCP port */
#define	INTR_TIMER2	0x0010		/* timer 2 */
#define	INTR_SMI0	0x0008		/* SMI port 0 */
#define	INTR_SMI1	0x0004		/* SMI port 1 */
#define	INTR_PB8	0x0002		/* parallel port B bit 8 */
#define	INTR_ERR	0x0001		/* error */

struct intr_reg {
	UINT16	pb11 : 1;	/* parallel port B bit 11 */
	UINT16	pb10 : 1;	/* parallel port B bit 10 */
	UINT16	scc0 : 1;	/* SCC port 0 */
	UINT16	dmaerr : 1;	/* dma error */
	UINT16	dma : 1;	/* dma */
	UINT16	scc1 : 1;	/* SCC port 1 */
	UINT16	timer1 : 1;	/* timer 1 */
	UINT16	scc2 : 1;	/* SCC port 2 */
	UINT16	pb9 : 1;	/* parallel port B bit 9 */
	UINT16	timer2 : 1;	/* timer 2 */
	UINT16	scp : 1;	/* SCP port */
	UINT16	timer3 : 1;	/* timer 3 */
	UINT16	smi0 : 1;	/* SMI port 0 */
	UINT16	smi1 : 1;	/* SMI port 1 */
	UINT16	pb8 : 1;	/* parallel port B bit 8 */
	UINT16	error : 1;	/* error */
};



/*****************************************************************
	dma mode register
*****************************************************************/

/*
 * request generation
 */
#define	EXTERNAL_REQG(x)	(x & 2)
#define	INTREQ_LIM		0
#define	INTREQ_MAX		1
#define	EXTREQ_BURST		2
#define	EXTREQ_CYCL		3

struct dma_mode_reg {
	UINT16	: 1;		/* reserved */
	UINT16	ext_cntl : 1;	/* external control option */
	UINT16	intr : 1;	/* interrupt on completion */
	UINT16	intr_e : 1;	/* interrupt on error */
	UINT16	req_gen : 2;	/* request generation options */
	UINT16	isource : 1;	/* increment source address */
	UINT16	idest : 1;	/* increment dest address */
	UINT16	ssize : 2;	/* source size */
	UINT16	dsize : 2;	/* destination size */
	UINT16	burst : 2;	/* burst transfer control */
	UINT16	reset : 1;	/* software reset */
	UINT16	start : 1;	/* start bit */
};


/*****************************************************************
	chip select option register
*****************************************************************/
#define	DTACK		0xe000
#define	ADR_MASK	0x1ffc
#define	RW_MASK		0x0002
#define	FC_MASK		0x0001
