#include "include/gct.h"
#include "include/msg.h"
#include "driver/config.h"
#include "driver/imp.h"

uart_application()
{
    HDR *h;
    GCT *gct;
    extern int my_rxchar();

    GETGCT(gct);
    for(;;){     /* do forever */
        h = (HDR *)(*gct->receive)();   /* wait for a message 
                                           from the receive queue */
        if( !h ) continue;              /* leave loop if error */

    /*
     * if the message is a RESET,
     * reset the driver module, first
     * resetting the GCT pointers for character handling
     */
        if( h->type == RESET ){
            conf_msg(h, DBM);   /* return reply or free memory */
            gct->rxchar = my_rxchar();
            reset_driver();
        } else {
     /* use anything else as a trigger to print "hello!" */
            (*gct->cput)([h]);
            (*gct->cput)([e]);
            (*gct->cput)([l]);
            (*gct->cput)([l]);
            (*gct->cput)([o]);
            (*gct->cput)([!]);
     /*
      * always call relm to release the message.
      * if the header is of an R_FRAME (h->class & RX)
      * then the R_FRAME is returned to the driver's
      * receive buffer pool for that channel
      */
            relm(h);
        }
/*
### Rev 0.5 bug fix
### The following line was previously missing
*/
    }
}

reset_driver()
{
     MSG *m;
     extern MSG *getm();
     struct driver_config *driver;

     m = getm(RESET, 0, LAPB_RSP, sizeof(struct driver_config));
     if( !m ) return(-1);
     driver = (struct driver_config *)m->param;

     /*
      * set up the global IMP registers here ...
      * (interrupt regs, parallel i/o, etc.)
      * and driver global configuration info.
      */
/*
### Rev 0.5 change
### following two lines added
*/
     driver->scc[0].imp = (struct imp *)0x700000;   /* IMP base adr */
     driver->scc[0].child_id = 0;   /* use child number 0 */
     driver->scc[0].upper = LAPB;   /* this module's ID */
     driver->scc[0].loop_mode = 0xffff;
     driver->scc[0].psize = 0;      /* indicates uart character mode */
     driver->scc[0].intr_trace = 0;
     driver->scc[0].conf = 0x0104;  /* set baud rate here */
     driver->scc[0].mode = 0x1d;    /* UART mode + loop-back */
     driver->scc[0].mask = 0x1;     /* interrupt on receive */
     driver->scc[0].tsize = 8;
     driver->scc[0].rsize = 8;
     driver->scc[0].rlen = 1;       /* one character buffers */
     (*gct->send)(DRIVER, m);
}

/*
 * This routine is called by the driver
 * for every character received.
 * It actually forms an extension to the
 * DRIVER module itself.
 */
my_rxchar(c)
char c;
{
      printf("received character %c\n", c);
}
