/********************************************************
 *
 * File:	bss.h
 *
 * Description:
 *	This file contains definitions for all the
 *	BSS resident data structures of the x25 module.
 *
 * Author:
 *	Tamar Mishory
 *
 ********************************************************/

/*
 * This macro converts the relocated load-time address
 * into an address relative to the start address in
 * ROM of the X25.
 * This macro can be used instead of calling x25_getadr()
 * in places where bss pointer exists.
 */
#define	X25_GETADR(adr)	(((unsigned long) (adr)) + bss->rom)

/*
 * module BSS (global) flags:
 */
#define	X25_INIT	0x8000	/* X25 module initialized	*/
#define	DIAG_SUPPORT	0x4000	/* diagnostic packets support	*/
#define	REG_SUPPORT	0x2000	/* registration packets support	*/
#define	NETWORK_ID	0x001f	/* NetWork id	*/

/*
 * Child (per lchan) flags:
 */
#define	X25_LCHAN_INIT	0x8000	/* Link initialized		*/
#define	PVC		0x4000	/* permanent virtual circuit	*/
/*
 * Facilities
 */
#define	USE_D_BIT	0x2000	/* use d bit fcility		*/
#define	TOANPI		0x1000	/* TOA/NPI address mode		*/

#define	UPPER_CONFRM	0x0800	/* upper confirmation		*/
#define	LCHAN_T11_RUN	0x0400	/* T11 is running		*/
#define	LCHAN_T12_RUN	0x0200	/* T12 is running		*/
#define	LCHAN_T13_RUN	0x0100	/* T13 is running		*/
#define	RNR_STATE	0x0080	/* Channel is in RNR state	*/
#define	INTR_ACK	0x0040	/* Channel waits for intr ack	*/
#define	PEND_ACK	0x0020	/* pending acknowlegement	*/
#define	CLREQ_PRIM	0x0010	/* user issued clear request	*/
#define	RESET_ACT	0x0008	/* user issued reset actreq	*/
#define	CALLREQ_PRIM	0x0004	/* user issued reset actreq	*/
#define	INTR_IND	0x0002	/* Interrupt sent issued to upper*/

/*
 * Interface structure.
 * This structure consists of DTE/DCE interface fields.
 */
typedef struct x25_intr {
	unsigned char	flags;		/* Interface flags	*/
	unsigned char	state;		/* Interface flags	*/
	unsigned char	lower; 		/* Lower module id	*/
	unsigned char	upper;	/* Upper layer module	*/
	unsigned short	lower_child;	/* Lower child id	*/
	unsigned short	T10;		/* Interface Timer T10	*/
	unsigned short	T28;		/* Interface Timer T28	*/
	struct x25_l	*childs;	/* childs queue	*/
	unsigned char	rc10; 		/* Retry counter	*/
	unsigned char	N10;		/* Max num of retransmission*/
	unsigned short	intr_id;	/* Retry counter	*/
	unsigned short	tx_def_max_ud;	/* Default max user data fied */
	unsigned short	rx_def_max_ud;	/* Default max user data fied */
	unsigned char	def_w_sz;	/* Default window size */
} X25_INTR;

/*
 * Per interface flags
 */
#define I_DCE_M		0x80	/* interface configured as DCE	*/
#define I_MODULO_128	0x40	/* modulo 128 interface		*/
#define INTR_T10_RUN	0x20	/* T10 is running		*/
#define INTR_REG_REQ	0x10	/* Interface sent registration pckt */
#define INTR_T28_RUN	0x08	/* T28 is running		*/


/*
 * retern intr state
 */
#define INTR_DCE(intr)		(((intr)->flags) & I_DCE_M)
#define INTR_MODULO_128(intr)	(((intr)->flags) & I_MODULO_128)
#define LOWER_CHILD(intr)	((intr)->lower_child)
#define LOWER_MODULE(intr)	((intr)->lower)
#define UPPER_MODULE(intr)	((intr)->upper)

/*
 * X25 global work area structure.
 * This structure resides in the work area
 * in X25 bss.
 */
typedef struct {
	struct t_frame	*tx_pool_head;	/* Tx pool head pointer	*/
	struct t_frame	*tx_pool_tail;	/* Tx pool tail pointer	*/
	struct x25_l	*active_head;	/* Head of active lchans queue */
	struct x25_l	*active_tail;	/* Tail of active lchans queue */
	unsigned short	tick;		/* Module timers resolution  */
	unsigned int	max_intr;	/* maximum number of intrfaces*/
	struct x25_intr	*intr;	/* module's DCE/DTE interfases table */
	unsigned short	ev_mask;	/* Module's event mask	*/
	struct t_table	*intr_timer_tab; /* module's interfaces t_tab */
	struct t_table	*reg_timer_tab; /* module's interfaces t_tab */
	struct t_table	*module_timeout; /* module's timeout */
	unsigned short	Tmodule;	/* module Timer TMODULE	*/
} X25_GWA;

/*

/*
 * Link structure.
 * This structure consists of CHILD structure fields,
 * followed by X25 specific fields which are located
 * in the CHILD's work area.
 */
typedef struct x25_l {
	/*
	 * Fields common to all CHILD structures
	 */
	unsigned short	key;	/* Link ID		*/
	unsigned short	flags;
	unsigned char	upper;	/* Upper layer module	*/
	unsigned char	lower;	/* Lower layer module	*/
	unsigned char	layer;	/* Protocl layer	*/
	unsigned char	state;	/* Protocol state	*/
	int	(* *smac)();	/* State machine	*/

	/*
	 * X25 specific fields (work area)
	 */
	struct x25_intr	*intr;		/* DCE/DTE interface	*/
	unsigned char	lcgn;		/* logical channel grp#	*/
	unsigned char	lcn;		/* logical channel num	*/
	unsigned char	ps;		/* Send state variable	*/
	unsigned char	pr;		/* Receive state var	*/
	unsigned char	pa;		/* Received ps		*/
	unsigned char	w;		/* transmit window	*/
	struct t_frame	*i_head;	/* data packets head pointer*/
	struct t_frame	*i_tail;	/* data packets tail pointer*/
	struct t_frame	*intrpt_head;	/* intrpt packets head pointer*/
	struct t_frame	*intrpt_tail;	/* intrpt packets tail pointer*/
	struct t_frame	*conf_head;	/* data packets head pointer*/
	struct t_frame	*conf_tail;	/* data packets tail pointer*/
	struct r_frame	*rx_head;	/* data packets head pointer*/
	struct r_frame	*rx_tail;	/* data packets tail pointer*/
	struct x25_l	*next;		/* Next active lchan	*/
	struct x25_l	*next_i;	/* Next active lchan in intr*/
	unsigned short	T11;		/* Link Timer T11	*/
	unsigned short	T12;		/* Link Timer T12	*/
	unsigned short	T13;		/* Link Timer T13	*/
	unsigned char	rc12;		/* Retry count		*/
	unsigned char	rc13;		/* Retry count		*/
	unsigned char	N12;		/* Max num of retransmission*/
	unsigned char	N13;		/* Max num of retransmission*/
	unsigned char	modulus;	/* Modulus*/
	unsigned short	tx_max_ud_field; /* max user data field	*/
	unsigned short	rx_max_ud_field; /* max user data field	*/
	/*
	 * Statistics counters
	 */
	unsigned long	tx_i;		/* Tx I count		*/
	unsigned long	rx_i;		/* Rx I count		*/
} X25_LCHAN;
