/********************************************************
 *
 * File:	mtypes.h
 *
 * Description:
 *	Layer 3 modules interface definitions.
 *	This file contains primitive definitions 
 *	for x25 module.
 *
 *	This includes:
 *	- Primitives from the neighbour DTE or DCE 
 *	 (Protocol primitives)
 *	- Primitives for layer 3 - layer 4 interface
 *
 *
 *	NOTE:
 *	- Primitives for layer 2 - layer 3 interface are defined
 *	  in layer2 primitives definition.
 *
 *	The primitive which are used as inputs to layer
 *	3 are numbered sequentially. In the same manner,
 *	the primitives issued by layer 3 to layer 4,
 *	are numbered sequentially.
 *
 *
 ********************************************************/

/*
 * Layer 3 state machine events (inputs):
 * These events include:
 * 	- Primitive indications from layer 2 are defined at l2
 *	  primitives definition.(file "l2types.h")
 *		
 * 	- Primitive requests from layer 4
 *	- Internal events (timer expiry)
 *	- Protocol events (rx frame types)
 */

#define	N_DATA_REQ		TX_REQ
#define	N_TM_EXP		TM_EXP

#define	N_CALL_REQ		( PRIM_DOWN | ( HI_L2_PRIM + 0x01 ))
#define	N_CALL_RSP		( PRIM_DOWN | ( HI_L2_PRIM + 0x02 ))
#define	N_CLR_REQ		( PRIM_DOWN | ( HI_L2_PRIM + 0x03 ))
#define	N_CLR_RSP		( PRIM_DOWN | ( HI_L2_PRIM + 0x04 ))
#define	N_INTRPT_REQ		( PRIM_DOWN | ( HI_L2_PRIM + 0x05 ))
#define	N_INTRPT_RSP		( PRIM_DOWN | ( HI_L2_PRIM + 0x06 ))
#define	N_RST_REQ		( PRIM_DOWN | ( HI_L2_PRIM + 0x07 ))
#define	N_RST_RSP		( PRIM_DOWN | ( HI_L2_PRIM + 0x08 ))
#define	PCT_CALL_REQIND		( PRIM_INT  | ( HI_L2_PRIM + 0x09 ))
#define	PCT_CALL_ACCONN		( PRIM_INT  | ( HI_L2_PRIM + 0x0a ))
#define	PCT_CLR_REQIND		( PRIM_INT  | ( HI_L2_PRIM + 0x0b ))
#define	PCT_CLR_CNF		( PRIM_INT  | ( HI_L2_PRIM + 0x0c ))
#define	PCT_RESET_REQ		( PRIM_INT  | ( HI_L2_PRIM + 0x0d ))
#define	PCT_RESET_CNF		( PRIM_INT  | ( HI_L2_PRIM + 0x0e ))
#define	PCT_INT_RNR		( PRIM_INT  | ( HI_L2_PRIM + 0x0f ))
#define	PCT_RR			( PRIM_INT  | ( HI_L2_PRIM + 0x10 ))
#define	PCT_DATA		( PRIM_INT  | ( HI_L2_PRIM + 0x11 ))

/*
 * The total number of events for X25
 * state machine:
 */
#define	X25_EVENTS		( (PCT_DATA & SUBTYPE) + 1 )

/*
 * Primitives issued by layer 3 to layer 4 (outputs):
 */
#define	N_DATA_IND		RX_IND
#define	N_CALL_IND		( PRIM_UP | ( HI_COM_PRIM + 0x01 ))
#define	N_CALL_CNF		( PRIM_UP | ( HI_COM_PRIM + 0x02 ))
#define	N_CLR_IND		( PRIM_UP | ( HI_COM_PRIM + 0x03 ))
#define	N_CLR_CNF		( PRIM_UP | ( HI_COM_PRIM + 0x04 ))
#define	N_INTRPT_IND		( PRIM_UP | ( HI_COM_PRIM + 0x05 ))
#define	N_RST_IND		( PRIM_UP | ( HI_COM_PRIM + 0x06 ))
#define	N_RST_CNF		( PRIM_UP | ( HI_COM_PRIM + 0x07 ))

/*
 * Highest layer 3 output primitive
 */
#define	HI_L3_PRIM		( N_RST_CNF & SUBTYPE )

/*
 * The following macro derives
 * the corresponding bit in X25
 * event mask for a given X25
 * output primitive.
 */
#define	X25_MASK(ev)		(((unsigned short) 1) << \
				((ev) & SUBTYPE))


/* 
 * Action requests
 */
#define	X25_CONFIG_LCHAN	( ACT_REQ | ( HI_COM_ACTION + 1 ))
#define	INTR_EST_RSTRT 	( ACT_REQ | ( HI_COM_ACTION + 2 ))
#define	CONFIG_INTR	( ACT_REQ | ( HI_COM_ACTION + 3 ))
#define	X25_REG_REQ	( ACT_REQ | ( HI_COM_ACTION + 4 ))

/* 
 * Read/Set requests
 */
#define	R_INTR	(READ_REQ | HI_COM_READSET + 1)	/* Read interface */

/*
 * Read-only requests
 */
#define	RL3_TXI	(READ_REQ | HI_COM_READSET + 2)	/* read txi queue */
#define	RL3_INTR (READ_REQ | HI_COM_READSET + 3) /* read intr queue */
#define	RL3_CNF	(READ_REQ | HI_COM_READSET + 4)	/* read acki queue */
#define	RL3_TX_POOL (READ_REQ | HI_COM_READSET + 5)/* read tx pool */


/*
 * CONFIG_LCHAN action request:
 * Message param contains lchan configuration
 * parameters.
 */
typedef struct {
	unsigned short	intr_id;	/* DCE/DTE interface	*/
	unsigned short	flags;
	unsigned char	upper;		/* Upper layer module	*/
	unsigned char	lcgn;	/* logical channel group number	*/
	unsigned char	lcn;	/* logical channel number	*/
	unsigned char	w;	/* transmit window		*/
	unsigned short	tx_max_ud_field; /* max user data field	*/
	unsigned short	rx_max_ud_field; /* max user data field	*/
	unsigned short	T11;		/* Link Timer T11	*/
	unsigned short	T12;		/* Link Timer T12	*/
	unsigned short	T13;		/* Link Timer T13	*/
	unsigned char	N12;		/* Max num of retransmission*/
	unsigned char	N13;		/* Max num of retransmission*/
} X25_LCHAN_CONFIG;

/*
 * CONFIG_INTR action request:
 * Message param contains interface configuration
 * parameters.
 */
typedef struct {
	unsigned char	flags;	/* Inrerface flags	*/
	unsigned char	lower; /* Lower module id	*/
	unsigned char	upper;	/* Upper layer module	*/
	unsigned char	N10;		/* Max num of retransmission*/
	unsigned short	T10;		/* Interface Timer T10	*/
	unsigned short	T28;		/* Interface Timer T28	*/
	unsigned short	lower_child;	/* Lower child id	*/
	unsigned short	tx_def_max_ud;	/* Default max user data fied */
	unsigned short	rx_def_max_ud;	/* Default max user data fied */
	unsigned char	def_w_sz;	/* Default window size */
} X25_INTR_CONFIG;

/*
 * X25 specific output primitives:
 * These are the primitives issued to layer 3
 * management.
 */
#define	X25_MN_ERR_IND	( PRIM_UP | ( HI_L3_PRIM + 0x01 ))

/*
 * x.25 specific event indications, these event indications
 * start from the maximun betwean HI_COM_EVENT and X25_MN_ERR_IND
 * inorder that the indication to the MNG task on thease events
 * could be masked with the same mask of x.25 output primitives.
 */
#define	X25_MN_REG_IND	( EVENT_IND | \
			((HI_COM_EVENT > X25_MN_ERR_IND & SUBTYPE ? \
				HI_COM_EVENT : X25_MN_ERR_IND) + 0x01) )
#define	X25_MN_REG_CNF		( EVENT_IND | (X25_MN_REG_IND + 0x01) )
#define	X25_MN_RESTART_IND	( EVENT_IND | (X25_MN_REG_IND + 0x02) )

/*
 * Specific flags for X25-L4 interface.
 * These flags can be written in "flags" field in R_FRAME
 * and in "flags" in x25_layer_info of a T_FRAME.
 * In the R_FRAME's flags field all code can be used except
 * of 0x80. (saved for the driver)
 */
#define	QBIT		0x01
#define	DBIT		0x02
#define	MORE		0x04
#define	LAST_SPLIT	0x08

/*
 * Flags to be written in the err_info field when a bad
 * packet has arrived. 
 */
#define	UNCONSISTENT_QBIT	0x01
