/*
 * Bit for each group of flag facilities
 */
#define P1_FAC		0x01 /* All vc's must be in p1 state */
#define ANY_FAC		0x02 /* can be negotiated any time */
#define AV_FAC		0x04 /* Availability of facilities */
#define NON_FAC		0x08 /* Non negotiable facilities */

/*
 * Coding of facilities
 */
#define VC_IN_P1_FACILS		0x05 /* All vc's must be in p1 state */
#define ANY_TIME_FACILS		0x45 /* can be negotiated any time */
#define FACILS_AVAILABLE	0x46 /* Availability of facilities */
#define NONEG_FACILS		0x06 /* Non negotiable facilities */
#define DEF_TRPUT		0x02 /* Default throughput */
#define DEF_PCKT_SZ		0x42 /* Default packet size */
#define DEF_W_SZ		0x43 /* Default window size */
#define LCHAN_TYPE		0xc8 /* Default window size */

/*
 * Bit definition for facilities that can be negotiated only
 * when all logical channels that are virtual calle are in
 * state p1.
 */
#define DBIT_MOD		0x04 /* Dbit modification facility */
#define PCKT_RET		0x02 /* Packet retransmission */
#define EXTENDED_MOD		0x01 /* Extended pckt sequence number */

/*
 * Bit definition for facilities that can be negotiated any time.
 */
#define CHARG_INFO		0x40 /* Charging information facility */
#define TRPT_NEG		0x20 /* Throughput class negotiation */
#define FLCTL_PARAM_NEG		0x10 /* Flow cntrl param negotiation */
#define REV_CHARG_ACCEPT	0x08 /* Reverse charging acceptance */
#define FASL_SLCT_ACCEPT	0x04 /* Fast select acceptance */
#define OUTGO_CALLS_BARRED	0x02 /* Outgoing calls barred */
#define INCOM_CALLS_BARRED	0x01 /* Incoming calls bared */

/*
 * Bit definition for availability facilities.
 */
#define REV_CHARG	0x8000 /* Reverse charging facility */
#define REV_CHARG_ACC	0x4000 /* Reverse charging acceptance */
#define CHARG_I_CALL	0x2000 /* Charging information per call */
#define CHARG_I_INTR	0x1000 /* Charging information per interface */
#define CLINE_ADDR_MN	0x0800 /* Called line address modified not */
#define DBIT_MOD_FC	0x0400 /* Dbit modification facility */
#define PCKT_RET_FC	0x0200 /* Packet retransmission */
#define EXTENDED_MOD_FC	0x0100 /* Extended pckt sequence number */
#define RPOA_SEL	0x0010 /* RPOA selection facility */
#define LTYPE_RANG	0x0008 /* Logical channel type ranges */
#define DEF_PSZ_REG	0x0004 /* default packet size registration */
#define DEF_WSZ_REG	0x0002 /* default window size registration */
#define DEF_TRPT_REG	0x0001 /* default trpt class assign reg */

/*
 * Bit definition for Non-negotiable facility values.
 */
#define LCL_CHARG_PREV		0x01 /* Local charging prevention */

#define MAX_CHAN_TYPE_RANGE	14 /* lchans type ranges */

typedef struct {
	unsigned char	facilities;
	unsigned char	vc_in_p1_facils;  /* Flag for each facility */
	unsigned char	any_time_facils;  /* Flag for each facility */
	unsigned short	facils_available; /* Flag for each facility */
	unsigned char	non_neg_facils;   /* Flag for each facility */
	unsigned char	def_trpt_class_dte; /* Default trput class */
	unsigned char	def_trpt_class_dce; /* Default trput class */
	unsigned char	def_pckt_sz_dte;  /* Default pckt size */
	unsigned char	def_pckt_sz_dce;  /* Default pckt size */
	unsigned char	def_w_sz_dte;	  /* Default window size */
	unsigned char	def_w_sz_dce;	  /* Default window size */
	unsigned char	chan_type_range[MAX_CHAN_TYPE_RANGE];
	unsigned char	cause;	  	/* cause */
	unsigned char	diag;	  	/* diagnostic */
} ONLINE_REG;
