/********************************************************
 *
 * File:	states.h
 *
 * Description:
 *	X25 states definitions.
 *
 * Author:
 *	Tamar Mishory
 *
 ********************************************************/

/*
 * X25 states per child states
 */
#define	N_READY			0x00
#define	N_WAIT_PEER		0x01
#define	N_WAIT_UPPER		0x02
#define	N_CALL_COLL		0x03
#define	N_CLR_REQ_PEER		0x04
#define	N_CLR_REQ_UPPER		0x05
#define	N_FLOW_CTL_R		0x06
#define	N_RESET_REQ_PEER	0x07
#define	N_RESET_REQ_UPPER	0x08

/*
 * The total number of states for X25
 * state machine:
 */
#define	X25_STATES	(N_RESET_REQ_UPPER + 1)


/*
 * The following macro translates a
 * state number and an event number to an 
 * index in the protocol state table.
 */
#define	ITEM(state, event)	((state) * X25_EVENTS + (event))

/*
 * The following macro "returns" the pointer
 * to the state table entry corresponding to a 
 * given state. 
 */
#define	CUR_STATE_TAB(state, tab)	(&((tab)[ITEM((state), 0)]))
