/********************************************************
 *
 * File:	timers.h
 *
 * Description:
 *	X25 timers definitions.
 *
 * Author:
 *	Tamar Mishory
 *
 ********************************************************/

/*
 * Timer ID's:
 */
#define	X25_T10		0
#define	X25_T11		1
#define	X25_T12		2
#define	X25_T13		3
#define	X25_TMODULE	4
#define	X25_T28		5

/*
 * Timer actions:
 */
#define	START_T10(intr)	{ \
	start_timer(gwa->intr_timer_tab, (intr)->intr_id, \
						X25_T10, (intr)->T10); \
	(intr)->flags |= INTR_T10_RUN; \
}

#define	START_T28(intr)	{ \
	start_timer(gwa->reg_timer_tab, (intr)->intr_id, \
						X25_T28, (intr)->T28); \
	(intr)->flags |= INTR_T28_RUN; \
}

#define	START_T11(lchan)	{ \
	start_timer(bss->timer_table, (lchan)->key, \
						X25_T11, (lchan)->T11); \
	(lchan)->flags |= LCHAN_T11_RUN; \
}

#define	START_T12(lchan)	{ \
	start_timer(bss->timer_table, (lchan)->key, \
						X25_T12, (lchan)->T12); \
	(lchan)->flags |= LCHAN_T12_RUN; \
}

#define	START_T13(lchan)	{ \
	start_timer(bss->timer_table, (lchan)->key, \
						X25_T13, (lchan)->T13); \
	(lchan)->flags |= LCHAN_T13_RUN; \
}

#define	START_X25_TMODULE { \
	start_timer(gwa->module_timeout, 0, \
				X25_TMODULE, gwa->Tmodule); \
}

/*
 * It is assumed that a request to stop
 * a timer should not occur if the timer
 * is not running.
 */
#define	STOP_T10(intr)	{ \
	stop_timer(gwa->intr_timer_tab, (intr)->intr_id); \
	(intr)->flags &= ~INTR_T10_RUN; \
}

#define	STOP_T28(intr)	{ \
	stop_timer(gwa->reg_timer_tab, (intr)->intr_id); \
	(intr)->flags &= ~INTR_T28_RUN; \
}

#define	STOP_T11(lchan)	{ \
	stop_timer(bss->timer_table, (lchan)->key); \
	(lchan)->flags &= ~LCHAN_T11_RUN; \
}

#define	STOP_T12(lchan)	{ \
	stop_timer(bss->timer_table, (lchan)->key); \
	(lchan)->flags &= ~LCHAN_T12_RUN; \
}

#define	STOP_T13(lchan)	{ \
	stop_timer(bss->timer_table, (lchan)->key); \
	(lchan)->flags &= ~LCHAN_T13_RUN; \
}

#define STOP_X25_TMODULE { \
	stop_timer(gwa->module_timeout, 0); \
}

#define	STOP_LCHAN_TIMERS(lchan)	{ \
			 		STOP_T11(lchan); \
			 		STOP_T12(lchan); \
			 		STOP_T13(lchan); \
}

#define	STOP_INTR_TIMERS(intr)	{ \
					STOP_T10(intr_num); \
					STOP_T28(intr_num); \
}
