*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
* Joypad handler					*
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
* Anthony Jacques - 30/1/96				*
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*

* this macro performs joypad read for one row - given in d0.
read_controller macro
	move.w	d0,$ff9202
	move.w	$ff9200,d1
	move.w	$ff9202,d2

	andi.w	#$f,d1
	andi.w	#$ff00,d2

	not.w	d1
	not.w	d2
	endm


* Function performs joypad read, updating 'joypad_buff'

* Bitmap of joypad_buff:
*      1 4 7 * 3 6 9 # 2 5 8 0 o p c b a r l d u
* o=option, p=pause, r=right, l=left, d=down, u=up


get_joypad:
	moveq.l	#0,d2	* These are used as .l later, but
	moveq.l	#0,d3	* are first writen to as .w
	moveq.l	#0,d4	* thus requiring them to be clear.

* read row 1

	move.w	#$ffee,d0
	read_controller

	move.w	d1,d0
	andi.w	#1,d0
	move.b	d0,d3

	move.w	d1,d0
	andi.w	#2,d0
	lsr.w	#1,d0
	move.b	d0,d4

	move.w	d2,d0
	andi.w	#$f00,d0
	lsr.w	#8,d0
	move.b	d0,d5

* read row 2

	move.w	#$ffdd,d0
	read_controller

	move.w	d1,d0
	andi.w	#2,d0
	or.b	d0,d4

	move.w	d2,d0
	andi.w	#$f00,d0
	lsr.w	#8,d0
	move.w	d0,d6

* read row 3

	move.w	#$ffbb,d0
	read_controller

	move.w	d1,d0
	andi.w	#2,d0
	lsl.w	#1,d0
	or.b	d0,d4

	move.w	d2,d0
	andi.w	#$f00,d0
	lsr.w	#4,d0
	or.w	d0,d6

* read row 4

	move.w	#$ff77,d0
	read_controller

	move.w	d1,d0
	andi.w	#2,d0
	or.b	d0,d3

	move.w	d2,d0
	andi.w	#$f00,d0
	or.w	d0,d6


	lsl.l	#7,d3
	lsl.l	#4,d4
	or.l	d4,d3
	or.l	d5,d3	

	move.w	d6,d2
	lsl.l	#5,d2

	or.l	d2,d3

; get rid of the gap - 1111xxxx11111111111111111
	move.l	d3,d4		
	andi.l	#%1111000000000000000000000,d4
	lsr.l	#4,d4
	andi.l	#%11111111111111111,d3
	or.l	d4,d3
	
	move.l	d3,joypad_buff
	rts


	bsslong

joypad_buff	ds.l	1

	txtlong
