/*--------------------------------*/
/*   DM game organizer            */
/*   Neil Davis  8/28/88          */
/*--------------------------------*/
/* Laser C */
#include <stdio.h>
#include <osbind.h>

/* usual stuff */
int   dummy, work_out[57],work_in[12],
  contrl[12],intin[128],ptsin[128],intout[128],ptsout[128],                        
  phys_handle,handle;

/* local buffers */

char loadpath[120];
char oldname[40]; /* same size as file, just rewrite each time */
char gamename[] = "DMGAME";  /* type 8 letters instead of 6! */

/*--------------------------------*/
/*     init_paths                 */
/*--------------------------------*/
void init_paths()
{
      loadpath[0]= Dgetdrv() + 'A';  /* fill global loadpath */
      loadpath[1]= ':';
      Dgetpath(&loadpath[2],0);
      strcat(loadpath,"\\*.DAT");    /* just display games */

} /* end init_paths */

/*--------------------------------*/
/*    open_work                   */
/*--------------------------------*/
void open_work()
{
   int i;

   appl_init();
   handle=phys_handle=graf_handle(&dummy,&dummy,&dummy,&dummy);

   for(i=0;i<10;work_in[i++]=1);
   work_in[10]=2;

   v_opnvwk(work_in,&handle,work_out);
} 
/*--------------------------------*/

/*--------------------------------*/
/*     init_app                   */
/*--------------------------------*/
void init_app()
{
  open_work();
  init_paths();
}

/*--------------------------------*/
void shut_app(code)
int code;
{

	appl_exit();

	exit(code);

} /* end shut_app */
/*--------------------------------*/

/*----------------------------*/
/*    trunc                   */
/*----------------------------*/
void trunc(wildcard)
char *wildcard;
   {
      register int  x;

      for(x=strlen(wildcard);x>=0;x--)
         {
            if (wildcard[x]=='\\')  
            break;
         }
      wildcard[++x]= '\0';
}  
/*----------------------------*/

/*--------------------------------*/
/*     build_fname                */
/*--------------------------------*/
void build_fname( fullname, path, file, suffix )
register char *fullname, *path, *file, *suffix;
{
  strcpy( fullname, path);  /* path has backslash already */
  trunc( fullname );        /* also still has *.DAT, must cut off */
  strcat( fullname, file);
  strcat( fullname, ".");
  strcat( fullname, suffix);
} 

/*--------------------------------*/
/*    choose_game                 */
/*--------------------------------*/
choose_game()
{
 int dum, but, f_hand;
 char playgame[120], dmgame[120], filepath[40];

 filepath[0] = '\0';
/* pick game to play  */
   dum = fsel_input( loadpath, filepath, &but);
      if(but != 1) return(0); /* File cancelled, but names are fixed */

/* cut off the period and extension */
  	for( dum = strlen(filepath); filepath[dum] != '.'; dum--);
 	  	filepath[dum] = '\0';

/* save oldname to disk */
   strcpy( oldname, filepath);
   f_hand = Fcreate("oldname.inf",0);
   Fwrite( f_hand, 40L, oldname);
   Fclose( f_hand);
  
/* rename files to DMGAME.DAT and BAK */
  build_fname( playgame, loadpath, oldname,"DAT");
  build_fname( dmgame, loadpath, gamename,"DAT");
     Frename( 0, playgame, dmgame);
  build_fname( playgame, loadpath, oldname,"BAK");
  build_fname( dmgame, loadpath, gamename,"BAK");
     Frename( 0, playgame, dmgame);

return( 1 );
}

/*--------------------------------*/
/*     get_old_name               */
/*--------------------------------*/
void get_old_name()
{
  int f_hand;

    if( (f_hand = Fopen("oldname.inf",0)) < 0 ){
       form_alert( 1,"[1][ Can't find oldname.inf| Better do it by hand ][Aiie]");
       shut_app( -1 );
       }
     Fread( f_hand, 40L, oldname );  /* fill global oldname */
     Fclose( f_hand);
}

/*--------------------------------*/
/*    fix_old_name                */
/*--------------------------------*/
void fix_old_name()
{
   char dirty[120], old[120];

  build_fname( dirty, loadpath, gamename, "DAT");

/* check to see if DMGAME.DAT exists */
  if( !Fsfirst( dirty,0) ){ 
/* if so, then rename with oldname */
    get_old_name();  /* fills global oldname from oldname.inf */
    build_fname( old, loadpath, oldname, "DAT");
    Frename( 0, dirty, old);

    build_fname( dirty, loadpath, gamename, "BAK");
    build_fname( old, loadpath, oldname, "BAK");
    Frename( 0, dirty, old);
  }
}

/*--------------------------------*/
/*     main                       */
/*--------------------------------*/
void main()
{
  init_app();       /* set path, open_vwk, etc. */
  fix_old_name();   /* if DMGAME exists, replace with oldname */
  choose_game();    /* take game choice from fsel_input, and rename */
  shut_app(0);      /* done */
}
