/*
// Maak kaart data en bereken de baan van de kaarten in heardland
*/
/*
// converteer een PI1 plaatje van de kaarten
// naar een .dat file.
// opbouw .dat file:
// data van de kaarten achter elkaar:
// achterkant
// aas
// heer
// vrouw
// boer
// 10
// 9
// 8
// 7
// 6
// 5
// 4
// 3
// 2
//
// Opbouw kaart data:
// 4 words 1e helft
// 4 words 2e helft
// en dat 4 maal omdat kaart 40 lijnen hoog is
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "..\hland.h"

#define BAAN_LEN 980
#define CARDDATA_LEN 8960

void bereken_baan(void);

int baandata[BAAN_LEN];  /* opkomen en wegvallen */
int screen[16384];
int data[16000];

void make_it(void)
{
  FILE*f;
  f=fopen("cards.pi1","rb");
  if(f==NULL)
  {
    printf("File open error for reading!\n");
    exit(-1);
  }
  fread(screen, 1, 32034, f);
  fclose(f);
  {
    int *p=screen+17;
    int *q=data;
    int i;
    for(i=0;i<14;i++)
    {
      int j;
      if(i==10)
      {
        p+=39*80;
      }
      for(j=0;j<40;j++)
      {
        *q++=*p++; /* 1e bitplane */
        *q++=*p++;
        *q++=*p++;
        *q++=*p++;
        *q++=*p++; /* 2e bitplane */
        *q++=*p++;
        *q++=*p++;
        *q++=*p++;
        p+=80-8;
      }
      p-=40*80-8;
    }
  }
}


int main(void)
{
  byte* carddata=(byte*)data;
  FILE* f;
  long cardlen;
  if((f=fopen("carddata.c","w"))==NULL)
  {
    printf("carddata file open error!\n");
    return -1;
  }
  bereken_baan();
  make_it();
  fprintf(f,"/*\n"
            "// file generated by: " __FILE__ "\n"
            "*/\n\n"
            "#include \"hland.h\"\n"
         );
  fprintf(f, "extern const int baan[%i] = {\n", BAAN_LEN);
  {
    int i;
    int w=0;
    for(i=0; i<BAAN_LEN; i++)
    {
      fprintf(f, "%i,", baandata[i]);
      w++;
      if(w>=16)
      {
        fprintf(f,"\n");
        w=0;
      }
    }
  }
  fprintf(f, "};\n");
  { /* save carddata for packer... */
    FILE *g;
    if((g=fopen("carddata.dat","wb"))==NULL)
    {
      printf("carddata output file open error!\n");
      return -1;
    }
    fwrite(carddata, CARDDATA_LEN, 1, g);
    fclose(g);
    if((g=fopen("carddata.pac","rb"))==NULL)
    {
      printf("carddata packed input file open error!\n");
      return -1;
    }
    cardlen=fread(carddata, 1, CARDDATA_LEN, g);
    fclose(g);
  }
  fprintf(f, "extern const byte carddata_pac[%li] = {\n", cardlen);
  {
    int i;
    int w=0;
    for(i=0; i<cardlen; i++)
    {
      fprintf(f, "%i,", (int)carddata[i]);
      w++;
      if(w>=16)
      {
        fprintf(f,"\n");
        w=0;
      }
    }
  }
  fprintf(f, "};\n");
  fclose(f);
  return 0;
}

void bereken_baan(void)
{
  int i;
  int *p=baandata;
  for(i=0;i<130;i++)
  {
    *p++=-40;
  } /* count = 130 */
  for(i=-40;i<90;i+=2)
  {
    *p++=i;
  } /* count = 195 */
  for(i=-30;i<0;i++)
  {
    *p++=(i*i)/30+60;
  }           /* count=225 */
  /* kaart uitlichten */
  for(i=0;i<260;i++)
  {
    *p++=60;
  } /* count = 485 */
  for(i=0;i<20;i++)
  {
    *p++=60-(i>>1);
  } /* count = 505 */
  for(i=0;i<20;i++)
  {
    *p++=50+(i>>1);
  } /* count=525 */
  for(i=0;i<260;i++)
  {
    *p++=60;
  } /* count=785 */
  /* laatste deel, kaarten vallen weg */
  for(i=1;i<=55;i++)
  {
    *p++=(i*i)/30+60;
  } /* count = 840 */
  for(i=0;i<140;i++)
  {
    *p++=170;
  } /* count=980 */
}
