/*
// make scherm_data
*/


#include <stdio.h>
#include <stdlib.h>
#include "hland.h"

byte buffer[500000UL];

void doit(FILE* outf, char *file_naam, char* naam, long len)
{
  printf("Doing: %s\n", naam);
  {
    FILE*f;
    f=fopen(file_naam, "rb");
    if(f==NULL)
    {
      printf("File open error on %s\n",file_naam);
      exit(-1);
    }
    fread(buffer, len, 1, f);
    fclose(f);
  }
  fprintf(outf, "extern const byte %s[%liUL] = {\n", naam, len);
  {
    long i;
    int w=0;
    for(i=0; i<len; i++)
    {
      fprintf(outf, "%i,", buffer[i]);
      w++;
      if(w>=16)
      {
        fprintf(outf,"\n");
        w=0;
      }
    }
  }
  fprintf(outf, "};\n");
}


int main(void)
{
  FILE*f;
  if((f=fopen("scrndata.c","w"))==NULL)
  {
    printf("shermdata file open error!\n");
    return -1;
  }
  fprintf(f,"/*\n"
            "// file generated by: " __FILE__ "\n"
            "*/\n\n"
            "#include \"hland.h\"\n"
         );
  doit(f, "balk.dat", "balk", 2080);
  doit(f, "wolk.dat", "wolk", 2240);
  fclose(f);
  return 0;
}
