/*
// make egg_data
*/
/*
// Converteer de PI1 plaatjes met de egg sprites naar egg data
// er zijn 33 sprites.
// Opbouw PI1 plaatje:
// Sprite staat in een matrix van 24 lijnen hoog en 32 pixels breed
// Naast de sprite staat de mask
// De sprite is 22 lijnen hoog, gemeten vanaf de bovenkant
*/

/*
//  output:
//  33 sprites
//  een sprite bestaat uit 22 lijnen data:
//    word sprite mask links
//    word sprite mask rechts
//    word i sprite data links
//    word i sprite data links
//    word i sprite data links
//    word i sprite data links
//    word i sprite data rechts
//    word i sprite data rechts
//    word i sprite data rechts
//    word i sprite data rechts
//  We beginnen echter met de onderkant van de sprite
*/

#include <stdio.h>
#include <stdlib.h>
#include "..\hland.h"

#define NUMBER_OF_SPRITES 33
#define HEIGHT 22
#define GRID_HEIGHT 24

byte buffer[500000UL];
unsigned int data[32000UL];

void doit(FILE* outf, char* naam, long len)
{
  long i;
  int w=0;
  printf("Doing: %s\n", naam);
  fprintf(outf, "extern const byte %s[%liUL] = {\n", naam, len);
  for(i=0; i<len; i++)
  {
    fprintf(outf, "%i,", buffer[i]);
    w++;
    if(w>=16)
    {
      fprintf(outf,"\n");
      w=0;
    }
  }
  fprintf(outf, "};\n");
}

long make_it(void)
{
  FILE* f;
  unsigned int *p;
  unsigned int *q;
  int i;
  int nummer=0;
  f=fopen("eggs.pi1","rb");
  if(f==NULL)
  {
    printf("File open error!\n");
    exit(-1);
  }
  fread(data, 34, 1, f); /* skip header */
  fread(data, 32000, 1, f);
  fclose(f);
  p=data-2*80;
  q=(unsigned int *)buffer;
  for(i=0;i<NUMBER_OF_SPRITES;i++)
  {
    int s;
    if((nummer%5)==0)
    {
      p+=(GRID_HEIGHT-1)*80;
    }
    s=HEIGHT;
    while(s>0)
    {
      *q++=p[8]; /* mask links */
      *q++=p[12]; /* mask rechts */
      *q++=~(*p++); /* data 0 links */
      *q++=~(*p++); /* data 1 links */
      *q++=~(*p++); /* data 2 links */
      *q++=~(*p++); /* data 3 links */
      *q++=~(*p++); /* data 0 rechts */
      *q++=~(*p++); /* data 1 rechts */
      *q++=~(*p++); /* data 2 rechts */
      *q++=~(*p++); /* data 3 rechts */
      p-=88;
      s--;
    }
    p+=HEIGHT*80+16; /* skip masks */
    printf("Sprite : %i\n",nummer);
    nummer++;
  }
  return (byte *)q-buffer;
}

int main(void)
{
  FILE*f;
  if((f=fopen("egg_data.c","w"))==NULL)
  {
    printf("eggdata file open error!\n");
    return -1;
  }
  fprintf(f,"/*\n"
            "// file generated by: " __FILE__ "\n"
            "*/\n\n"
            "#include \"hland.h\"\n"
         );
  doit(f, "eggs", make_it());
  fclose(f);
  return 0;
}
