/*
// make all music data
*/


#include <stdio.h>
#include <stdlib.h>

typedef unsigned char byte;

#define SAMPLE_LEN 69022UL /* lengte sample */
#define MUS_LEN 75250UL /* lengte chip music */
#define PLOING_LEN 714 /* lengte ridels */
#define RINKEL_LEN 294
#define PLOEF_LEN 322
#define PJOEW_LEN 322
#define CARD_LEN 10570
#define VEEG_LEN 546
#define GAMEOVER_LEN 15120
#define WELLDONE_LEN 3080

byte buffer[500000UL];

void doit(FILE* outf, char *file_naam, char* naam, long len)
{
  long muslen;
  printf("Doing: %s\n", naam);
  {
    FILE*f;
    f=fopen(file_naam, "rb");
    if(f==NULL)
    {
      printf("File open error on %s\n",file_naam);
      exit(-1);
    }
    muslen=fread(buffer, 1, len, f);
    if(muslen<len)
    {
      len=muslen;
    }
    fclose(f);
  }
  fprintf(outf, "EXPORT %s, %s_end\n", naam, naam);
  fprintf(outf, "%s: ", naam);
  {
    long i;
    int w=100;
    for(i=0; i<len; i++)
    {
      if(w>=32)
      {
        fprintf(outf,"\ndc.b ");
        w=0;
      }
      fprintf(outf, "%i,", buffer[i]);
      w++;
    }
  }
  fprintf(outf, "\n%s_end: \n", naam);
}

int main(void)
{
  FILE*f;
  if((f=fopen("mus_data.s","w"))==NULL)
  {
    printf("mus_data file open error!\n");
    return -1;
  }
  fprintf(f,";\n"
            "; file generated by: " __FILE__ "\n"
            ";\n\nDATA\n"
         );
  doit(f, "ploing.dat", "ploing", PLOING_LEN);
  doit(f, "rinkel.dat", "rinkel", RINKEL_LEN);
  doit(f, "ploef.dat", "ploef", PLOEF_LEN);
  doit(f, "pjoew.dat", "pjoew", PJOEW_LEN);
  doit(f, "card.pac", "card_pac", CARD_LEN);
  doit(f, "veeg.dat", "veeg", VEEG_LEN);
  doit(f, "gameover.pac", "gameover_pac", GAMEOVER_LEN);
  doit(f, "welldone.pac", "welldone_pac", WELLDONE_LEN);
  doit(f, "loop2.pac", "sample_pac", SAMPLE_LEN);
  doit(f, "musix.pac", "musix_pac", MUS_LEN);
  fclose(f);
  return 0;
}
