/*
 *  Sphere equation
 *
 *    (x-xo)^2 / a^2 + (y-yo)^2 / b^2 + (z-zo)^2 / c^2 = 1
 *
 */
#define Q_Sphere object {
  quadric {value <1 1 1 0 0 0 0 0 0 -1>}
}

/*
 *  Ellipsoid equation
 *
 *    x^2 + y^2 + z^2 = 1
 *
 */
#define Q_Ellipsoid object {
  quadric {value <1 1 1 0 0 0 0 0 0 -1>}
}

/*
 *  Cylinder equation
 *
 *    y^2 / b^2 + z^2 / c^2 = 1
 *    x^2 / a^2 + z^2 / c^2 = 1
 *    x^2 / a^2 + y^2 / b^2 = 1
 *
 */
#define Q_Cylinder_X object {
  quadric {value <0 1 1 0 0 0 0 0 0 -1>}
}

#define Q_Cylinder_Y object {
  quadric {value <1 0 1 0 0 0 0 0 0 -1>}
}

#define Q_Cylinder_Z object {
  quadric {value <1 1 0 0 0 0 0 0 0 -1>}
}

/*
 *  Cone equation
 *
 *    y^2 / b^2 + z^2 / c^2 = x^2 / a^2
 *    x^2 / a^2 + z^2 / c^2 = y^2 / b^2
 *    x^2 / a^2 + y^2 / b^2 = z^2 / c^2
 *
 */
#define Q_Cone_X object {
  quadric {value <-1 1 1 0 0 0 0 0 0 0>}
}

#define Q_Cone_Y object {
  quadric {value <1 -1 1 0 0 0 0 0 0 0>}
}

#define Q_Cone_Z object {
  quadric {value <1 1 -1 0 0 0 0 0 0 0>}
}

/*
 *  Plane equation
 *
 *    x = 0
 *    y = 0
 *    z = 0
 *
 */
#define Q_Plane_YZ object {
  quadric {value <0 0 0 0 0 0 1 0 0 0>}
}

#define Q_Plane_XZ object {
  quadric {value <0 0 0 0 0 0 0 1 0 0>}
}

#define Q_Plane_XY object {
  quadric {value <0 0 0 0 0 0 0 0 1 0>}
}

/*
 *  (Elliptic) Paraboloid equation
 *
 *    y^2 / b^2 + z^2 / c^2 = x / a
 *    x^2 / a^2 + z^2 / c^2 = y / b
 *    x^2 / a^2 + y^2 / b^2 = z / c
 *
 */
#define Q_Paraboloid_X object {
  quadric {value <0 1 1 0 0 0 -1 0 0 0>}
}

#define Q_Paraboloid_Y object {
  quadric {value <1 0 1 0 0 0 0 -1 0 0>}
}

#define Q_Paraboloid_Z object {
  quadric {value <1 1 0 0 0 0 0 0 -1 0>}
}

/*
 *  (Hyperbolic) Paraboloid equation
 *
 *    x^2 / a^2 - y^2 / b^2 = z / c
 *    y^2 / b^2 - z^2 / c^2 = x / a
 *    z^2 / c^2 - x^2 / a^2 = y / b
 *
 */
#define Q_Hyperbolic_Paraboloid_X object {
  quadric {value <1 -1 0 0 0 0 0 0 -1 0>}
}

#define Q_Hyperbolic_Paraboloid_Y object {
  quadric {value <0 1 -1 0 0 0 -1 0 0 0>}
}

#define Q_Hyperbolic_Paraboloid_Z object {
  quadric {value <-1 0 1 0 0 0 0 -1 0 0>}
}

/*
 *  Hyperboloid 1 equation
 *
 *    y^2 / b^2 + z^2 / c^2 - x^2 / a^2 = 1
 *    x^2 / a^2 + z^2 / c^2 - y^2 / b^2 = 1
 *    x^2 / a^2 + y^2 / b^2 - z^2 / c^2 = 1
 *
 */
#define Q_Hyperboloid_1_X object {
  quadric {value <-1 1 1 0 0 0 0 0 0 -1>}
}

#define Q_Hyperboloid_1_Y object {
  quadric {value <1 -1 1 0 0 0 0 0 0 -1>}
}

#define Q_Hyperboloid_1_Z object {
  quadric {value <1 1 -1 0 0 0 0 0 0 -1>}
}

/*
 *  Hyperboloid 2 equation
 *
 *     x^2 / a^2 - y^2 / b^2 - z^2 / c^2 = 1
 *    -x^2 / a^2 + y^2 / b^2 - z^2 / c^2 = 1
 *    -x^2 / a^2 - y^2 / b^2 + z^2 / c^2 = 1
 *
 */
#define Q_Hyperboloid_2_X object {
  quadric {value <1 -1 -1 0 0 0 0 0 0 -1>}
}

#define Q_Hyperboloid_2_Y object {
  quadric {value <-1 1 -1 0 0 0 0 0 0 -1>}
}

#define Q_Hyperboloid_2_Z object {
  quadric {value <-1 -1 1 0 0 0 0 0 0 -1>}
}
