
#ifndef __EAZY_GEM__
#define __EAZY_GEM__
/*/////////////////////////////////////////////////////////////////////*/
/*////////////////////////// I N C L U D E S //////////////////////////*/
/*/////////////////////////////////////////////////////////////////////*/
#include <limits.h>
#include <tos.h> 
#include <aes.h>
#include <vdi.h>
#include <stdio.h>
#include <portab.h> 
#include <time.h>
#include <stdlib.h>        
#include <string.h>     
#include <ext.h>      
#include <math.h>
#pragma warn -ucp
#define Min(a, b)             ((a) < (b) ? (a) : (b))
#define Max(a, b)             ((a) > (b) ? (a) : (b))
#define XTENDED_TYPE(a, b)    ((a)[(b)].ob_type>>8)
#define OB_ROOT      -1

#undef  NULL
#define NULL                  0L                                  
#define ZERO                  0
#define NIL                  -1

#define MESS_ENDPRG      0
#define MESS_TTONOFF     1

typedef struct
{
  unsigned int   rsh_vrsn;		    /* should be 3														     */
  unsigned int   rsh_extvrsn;		/* not used, initialised to 'IN' for Interface */
  unsigned long  rsh_object;
  unsigned long  rsh_tedinfo;
  unsigned long  rsh_iconblk; 		/* list of ICONBLKS			  				 	*/
  unsigned long  rsh_bitblk;
  unsigned long  rsh_frstr;
  unsigned long  rsh_string;
  unsigned long  rsh_imdata;			/* image data					  					*/
  unsigned long  rsh_frimg;
  unsigned long  rsh_trindex;
  unsigned long  rsh_nobs; 			/* counts of various structs 					*/
  unsigned long  rsh_ntree;
  unsigned long  rsh_nted;
  unsigned long  rsh_nib;
  unsigned long  rsh_nbb;
  unsigned long  rsh_nstring;
  unsigned long  rsh_nimages;
  unsigned long  rsh_rssize;			/* total bytes in resource   */
} RSXHDR;

typedef int CALLBACK ;
/*------------------------- AES ETENDU ----------------------------*/

typedef struct                    /* Box Spec or Color Spec        */
 {unsigned framecol    :  4;      /* border color                  */
  unsigned textcol     :  4;      /* text color                    */
  unsigned textmode    :  1;      /* 0=transparent, 1=opaque       */
  unsigned fillpattern :  3;      /* 0=no fill, ... 7=solid fill   */
  unsigned interiorcol :  4;      /* fill color using fill pattern */
 } BFTEDCOLOR;
 
/*........................... VA_START Definitions ................*/
# define  VA_START   0x4711
# define  VA_AKCNW   0x4738 

/*........................... Drag and Drop Definitions ...........*/    
#define	DD_OK			0
#define DD_NAK			1
#define DD_EXT			2
#define DD_LEN			3
#define DD_TRASH		4
#define DD_PRINTER		5
#define DD_CLIPBOARD	6

/* Timeout en Millisecondes (4 secondes.) */
#define DD_TIMEOUT		4000

/* Anzahl der Extensionen/Bytes der "bevorzugten Extensionen" */
#define DD_NUMEXTS		8
#define DD_EXTSIZE		32L

/* longueur max des noms de fichiers Drag&Drop */
#define DD_NAMEMAX		128

/* longueur max des Header Drag&Drop  */
#define DD_HDRMAX		(8+DD_NAMEMAX+DD_NAMEMAX)

/*........................... Resource definitions ..................................*/
                                /* data structure types */
#define R_TREE           0
#define R_OBJECT         1
#define R_TEDINFO        2
#define R_ICONBLK        3
#define R_BITBLK         4
#define R_STRING         5              /* gets pointer to free strings */
#define R_IMAGEDATA      6              /* gets pointer to free images */
#define R_OBSPEC         7
#define R_TEPTEXT        8              /* sub ptrs in TEDINFO */
#define R_TEPTMPLT       9
#define R_TEPVALID      10
#define R_IBPMASK       11              /* sub ptrs in ICONBLK */
#define R_IBPDATA       12
#define R_IBPTEXT       13
#define R_BIPDATA       14              /* sub ptrs in BITBLK */
#define R_FRSTR         15              /* gets addr of ptr to free strings */
#define R_FRIMG         16              /* gets addr of ptr to free images  */

#define TXT_NORMAL       0x0000 /* text effects */
#define TXT_THICKENED    0x0001
#define TXT_LIGHT        0x0002
#define TXT_SKEWED       0x0004
#define TXT_UNDERLINED   0x0008
#define TXT_OUTLINED     0x0010
#define TXT_SHADOWED     0x0020

#define ALI_LEFT         0 /* horizontal text alignment */
#define ALI_CENTER       1
#define ALI_RIGHT        2

#define ALI_BASE         0 /* vertical text alignment */
#define ALI_HALF         1
#define ALI_ASCENT       2
#define ALI_BOTTOM       3
#define ALI_DESCENT      4
#define ALI_TOP          5

typedef struct 
{
  void *mp;
  int fwp;
  int fh;
  int fww;
  int ff;
  int np;
  int r1;
  int r2;
  int r3;
} XMFDB;

/*--------------------------- EZ_GEM ------------------------------*/

#define BORDER  0x2000
#define XMOVER  0x0008000L
#define XSIZER  0x00010000L
#define XMODAL  0x00020000L

#define IDC_ARROW         0
#define IDC_SIZEWE        8
#define IDC_SIZENS        9
#define IDC_SIZEALL       10
#define IDC_SIZENWSE      11
#define IDC_SIZENESW      12
#define IDC_NO            13
#define IDC_UPARROW       14
#define IDC_INFO          15
#define IDC_INTERO        16 
#define IDC_LISTBOX       17
/*.............. type de parametres SCROLL_BOX .....................*/
#define SCROLL_TXT    1
/*...................... type d'objets etendus .....................*/
#define GROUP_LITLE   100     /* cadre d'entourement (ou de groupe) fin          */
#define GROUP_LARGE   101     /* cadre d'entourement (ou de groupe) epais        */
#define NEW_BUTTON    102     /* bouton EAZY GEM (s'adapte  l'echelle 9pts)     */
#define RADIO_BUTTON  103     /* boite radio button new look EAZY GEM            */
#define COCHE_BUTTON  104     /* boite a cocher new look EAZY GEM                */
#define TT_STATE_BOX  105     /* boite de type indicateur  d'etat bulle d'aide   */
#define LISTBOX       106     /* boite de type liste deroulante avec ascensseurs */
#define WINDMENU      107     /* boite devant recevoir un  menu en fenetre fils  */
#define ONGLET_MASTER 108     /* boite devant recevoir les dialogues fils        */
#define CADRE_VIDE    109     /* cadre invisible universel                       */
#define SCROLL_GROUP0 110     /* cadre invisible type scroll structure           */
#define SCROLL_BOX    111     /* boite de scroll contenant les info  afficher   */

#define ONGLET_SLAVE  200     /* boite o se trouvent les dialogues fils avant       */
#define MULTI_DIAL    201     /* arbre de type dialogues multiples                   */
#define TOP_DIAL      202     /* dialogue (fils d'un multiple) du sommet de fenetre  */
#define RIGHT_DIAL    203     /* dialogue (fils d'un multiple) du bord droit fenetre */
#define BOTTOM_DIAL   204     /* dialogue (fils d'un multiple) du bas de la fenetre  */
#define LEFT_DIAL     205     /* dialogue (fils d'un multiple) bord gauche fenetre   */

#define SCROLL_GROUP  206     /* cadre pere type scroll structure                              */
#define SCROLLV_UP    207     /* objet de type scrolling haut    (fils d'une Scroll structure) */
#define SCROLLV_DW    208     /* objet de type scrolling bas     (fils d'une Scroll structure) */
#define SCROLLV_AS    209     /* objet de type ascenseur vertic. (fils d'une Scroll structure) */
#define SCROLLV_BAR   210     /* objet de type barre verticale   (fils d'une Scroll structure) */
#define SCROLLH_LF    211     /* objet de type scrolling gauche  (fils d'une Scroll structure) */
#define SCROLLH_RG    212     /* objet de type scrolling droit   (fils d'une Scroll structure) */
#define SCROLLH_AS    213     /* objet de type ascenseur horiz.  (fils d'une Scroll structure) */
#define SCROLLH_BAR   214     /* objet de type barre horizontale (fils d'une Scroll structure) */

#define PAINT_BOX     215     /* objet envoyant un WM_PAINTBOX lors du redraw                  */

#define RSC_PLUS 6    /* debord pour effet relief */
#define RSC_DIAL 1    /* fenetre type dialogue    */
#define TOOL_BAR 2    /* fenetre type tool_bar    */ 
#define NO_SCALE 0
#define SCALE    1
#define NORELOG_NO_SCALE -1
#define NORELOG_SCALE    -2

#define DEF_BOX_WIND 1
#define DELT_LEFT    0
#define DELT_TOP     1
#define DELT_RIGHT   2
#define DELT_BOTTOM  3

#define CTRL_LEFT_TOP       1
#define CTRL_TOP            2
#define CTRL_RIGHT_TOP      3
#define CTRL_RIGHT          4
#define CTRL_RIGHT_BOTTOM   5
#define CTRL_BOTTOM         6
#define CTRL_LEFT_BOTTOM    7
#define CTRL_LEFT           8

#define VRLEFT      0
#define VRTOP       1
#define VRRIGHT     2
#define VRBOTTOM    3

/*.................. define lis aux tool tips ...................*/
#define TT_OBJECT     1    
#define TT_GRECT      2
#define TT_RECT       3
#define TT_RSXHDR     4
#define TT_RSHDR      5
#define TT_UPSMEN     6
#define TT_UPSTOOL    7   /* type tool barre upsis                      */
#define TT_XRSC       8   /* adresse ressource                          */

/*.................. define lis aux nouveaux messages .................*/
#define MU_MOVE       64

#define WM_CONSTRUCT     0x100
#define WM_DESTRUCT      0x101
#define WM_ABORT         0x102
#define WM_TT_GET_TXT    0x103
#define WM_PAINT         0x104
#define WM_UNTOP         0x105
#define WM_POPUP_CHANGE  0x106
#define WM_TT_ON_OFF     0x107
#define WM_STANDBY       0x108
#define WM_WND_MENU      0x109
#define WM_EXEFUNC       0x10A
#define WM_ONGLET_CHG    0x10B
#define WM_PAINTBOX      0x10C
#define WM_ACTIVEWIND    0x10D
#define WM_MODAL_END     0x10E
#define AID_REQUEST      1502    
#define AID_SEND         1500
/*------------------------- define de flag ------------------------*/
#define W_IS_OPEN 0x0001    /* fenetre ouverte                     */
#define W_IS_ICON 0x0002    /* fenetre iconifiee                   */
#define W_IS_ALLICON 0x0004 /* fenetre iconifiee                   */


#define END_QUEUE -1

#define MESG     0
#define APPL     1
#define SUPL     2
#define WHND     3
#define X_G      4
#define Y_G      5
#define W_G      6
#define H_G      7
#define X_B      8
#define Y_B      9
#define W_B      10
#define H_B      11
#define S_0      12
#define S_1      13
#define S_2      14

#define HORIZONTAL 1
#define VERTICAL   2

#define GETWINDTREE(a) Windtab[(a)].DlgVar.tree
#define GET_XOBTYPE(a,b) (((a)[(b)].ob_type>>8) & 0x00FF)
#define GET_FONTNAME(a) FontName + (a)*36

#define LST_MAJUS       1  /* le texte converti en majuscules     */ 
#define LST_C_MODE      2  /* la fin d'une ligne est un zero      */
#define LST_REVERSE     4  /* ligne selectionne en video inverse */
#define LST_AFFPOS      8  /* affichage de la position ascenseur  */
#define LST_RLLF        16 /* la fin d'une ligne est return ou lf */
#define LST_DRAW        2
#define LST_UP          0
#define LST_DOWN        1
#define LST_CLICK       3
#define LST_SCROLL      4
#define LST_NODRAW      -1

#define LSTBOXOPEN      1
#define LSTBOXCLICK     2
#define LSTBOXDOWN      4
#define LSTBOXUPP       8
#define LSTBOXLIST     16
#define LSTBOXEDIT     32
#define LSTBOXCLOSE    64
#define LSTBOXSTAY     128

#define LST_FNTSEL     'FntS'
#define LST_FNTPTS     'FntP'
#define LST_PATERN     'Pate'
#define LST_LGNTYP     'LgnT'
#define LST_TXTEFF     'TxtE'
#define LST_COLOR      'Colo'

#define POPUP_CHANGE   32000
#define ALERT_MODAL     2468
#define W_ALERT         2468
#define W_MODAL         2469
/*-------------- structure collectant les info sur la machine--------------------*/
typedef struct
{long machine;
 long cpu;
 long fpu;
 long video;
 long sound;
}MACHINE_INFO;

/*---------------------- Structure des Cookies ---------------------------*/
typedef struct
   {long ident;
    union {long l;
           int i[2];
           char c[4];
           }U_typ;
   } COOKIE;
/*---------------- LIST_GET_TXT -----------------------------------------------*/
typedef struct
 {int lign;
  int preml;
  int pointl;
  int h_lign;
  GRECT grect;
  GRECT clipgrect; 
  void *LstBoxParam;    
 }LIST_GET_TXT;

/*----------------------------- DID_HELP ------------------------------*/ 
/* definition de la structure permettant de communiquer avec l'aide    */
/* de DIDEROT. Les parametres de cette structure determinent, avec     */
/* quel fichier d'aide et quelle reference de ce fichier la fenetre de */
/* DIDEROT doit s'afficher.                                            */

 typedef struct
   {
    char Aid_file[256]; /*recevra le chemin complet du fichier d'aide */
	                      /* d'aide que l'on veut associer a notre       */
                        /* programme.                                  */
    long Ref;           /*Numro de la reference que l'on veut voir   */
                        /* dans ce fichier.                            */
    int  x_win;         /*position X de la fenetre d'aide             */
    int  y_win;         /*position Y de la fenetre d'aide             */
    int  w_win;         /*largeur de la fenetre d'aide                */
    int  h_win;         /*hauteur de la fenetre d'aide                */
                        /* Si il est fourni -1 comme parametre, la     */
                        /* fenetre de DIDEROT s'ouvrira avec des       */
                        /* dimensions par defaut.                      */
                        /* Ce sont les dimensions exterieures de la    */
                        /* fenetre que ces parametres decrivent.       */                  
    int  w_h;           /*handle de la fenetre demandeuse, DIDEROT a  */
                        /* besoin de la connaitre pour la remettre au  */
                        /* dessus des autres(l'activer), apres s'etre  */
                        /* ouvert !!!. Ce n'est utile que lors des     */
                        /* AES < 3.99.                                 */
                        /* Si l'on fourni -1 pour w_h, la fenetre      */
                        /* demandeuse ne sera pas remise au TOP.       */ 
                        
   }DID_HELP;
							 
/*---------------- SCROLLBOX_GET_AFFI -----------------------------------------------*/
typedef struct
 {int LgnH;              /* H ligne en pixels           */
  int ClnW;              /* L colonne en pixels         */
  int FstLgn;            /* premiere ligne en haut      */
  int FstCln;            /* premiere colonne a gauche   */
  int LgnAff;            /* ligne a afficher            */    
  int ClnAff;            /* colonne a afficher          */
  int LgnSel;            /* ligne selectionnee          */ 
  int ClnSel;            /* colonne selectionnee        */  
  GRECT Grect;           /* dimensions de fenetre affi  */
  GRECT ClipGrect;       /* rectangle de cliping        */
  void *ScrollBoxParam;  /* parametre de transmission   */
  int Back;              /* fond pour le redessin       */
  int VDIFntID;
  int Pts;
  int Col;
  int P4;
 }SCROLLBOX_GET_AFFI;
 
/*------------------------ USERBLK special pour les scrollbox -----------------*/
/*                         et G_BOXTEXT avec Xtype  20                        */
typedef struct
{
        int cdecl (*ub_code)(PARMBLK *parmblock);
                                   /* Zeiger auf eine Funktion */
        long ub_parm;              /* optionaler Parameter     */
        TEDINFO *tedinfo;
        int LgnH;
        int ClnW;
        int (*ScrollBoxGetAffiFunc)(SCROLLBOX_GET_AFFI *ptSCRLDRAWSTRUCT);  
        int NbLgn;                                        
        int NbCln;
        int FstLgn;
        int FstCln;
        int LgnSlct;
        int ClnSlct;
        int Do;
        int NScrol;
        void *ScrollBoxParam;
        int VDIFntID;
        int Pts;
        int Col;
        int P4;
} XSCROLLBLK;
/*------------------------ Structure pour SCROLL_TXT --------------------------*/
typedef struct
{       int Type;
        char *txt;
        char **PtLgnTab;
        int Pts;
        int Color;
        long FontId;
} SCROLL_TXT_PRM;   
/*------------------------ USERBLK special pour les editables -----------------*/
/*                         et G_BOXTEXT avec Xtype  20                        */
typedef struct
{
        int cdecl (*ub_code)(PARMBLK *parmblock);
                                   /* Zeiger auf eine Funktion */
        long ub_parm;              /* optionaler Parameter     */
        TEDINFO *tedinfo;
        int BlkDeb;
        int BlkEnd;
        int (*LstBoxGetLigneFunc)(LIST_GET_TXT *ptLISTGETTXT);  
        int LstBoxState;
        GRECT LstBoxGrect;
        int LstBoxHlign;
        int LstBoxNbItem;
        int LstBoxSel;
        void *LstBoxParam;
        int P1;
        int P2;
        int P3;
        int P4;
} XUSERBLK;


/*------------------------ USERBLK special pour les onglets -------------------*/
/*                         et G_BOXTEXT avec Xtype  108                       */
typedef struct
{
        int cdecl (*ub_code)(PARMBLK *parmblock);
                                   /* Zeiger auf eine Funktion */
        long ub_parm;              /* optionaler Parameter     */
        TEDINFO *tedinfo;        
        int nb_dial;               /* nombre d'onglets         */        
        int nb_lign;               /* nombre de ligne d'onglet */
        int h_onglt;               /* hauteur d'un onglet      */
} ONGLETUSERBLK;

/*------------------------ USERBLK special pour les menus en fenetre ----------*/
/*                         et G_BOXTEXT avec Xtype  107                       */
typedef struct
{
        int cdecl (*ub_code)(PARMBLK *parmblock);
                                   /* Zeiger auf eine Funktion */
        long ub_parm;              /* optionaler Parameter     */
        TEDINFO *tedinfo;
        OBJECT  *MenTree;
        int  Tree_ind;
        int res2;  
        int res3;
        GRECT MenBoxGrect;
        int res4;
        int res5;
        int res6;
} MENUSERBLK;

/*------------- Structure de flux evenementiel de sortie ----------------------*/
typedef struct
 {int evnt;
  int pipe[24];
  int x;
  int y;
  int k;
  int ksp;
  int key;
  int click;
 }EVNT_O;

/*------------- Structure de flux evenementiel d'entree ----------------------*/ 
typedef struct
 {int evnt_type;
  int Bclick;
  int Bmask;
  int Bstate;
  int  FlagBox_1;
  GRECT Box_1;
  int  FlagBox_2;
  GRECT Box_2;
  int lotimer;
  int hitimer;
 }EVNT_I;

/*...................... Structures de bulle d'aide ....................*/
typedef struct
{int w_h;        /* handle fenetre concernee                                      */
 int type;       /* type du pointeur suivant (RSXHDR, OBJECT, liste de GRECT ...) */
 int nbr;        /* si OBJECT, GRECT, donne le nbr d'objets  valuer             */
 void *ptr;      /* pointe sur la structure dfinie plus haut                     */
}TOOL_TIPS;

/*--------------- structure de dialogue en fenetre ----------------*/
typedef struct
 {int   type;         /* structure type ressource en fenetre          */
  void  *AdrRsc;      /* adresse ressource                            */
  int    NumTree;     /* numero arbre de cette ressource              */
  int    NbrTree;     /* nombre d'arbre de cette ressource            */
  OBJECT *tree;       /* adresse arbre de la resource de  fenetre     */
  int ObjEdit;        /* stocke numero objet en edition               */
  int PosCursX;       /* position du curseur dans le champ editable   */
  int CurState;       /* etat allume/1 ou eteint/0 du curseur         */
  int CurTim;         /* compteur de temps pour clignotage curseur    */
  int MoForm;         /* forme de la souris                           */
  int BlkDef;         /* bloc en mode edition/1  ou non edition/0     */  
  void *LstAdr;       /* adr d'une listbox si il y a en a une ouverte */
 }DLG_VAR;        

/*----------------------- Structures de fenetres -------------------------*/
typedef struct
{int ident;                                   /* Identificateur prive de la fenetre    */
 CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt); /* procedure de gestion de fenetre       */
 long w_attr;                                 /* attributs de la fenetre               */
 int w_h;                                     /* handle de la fenetre                  */
 int w_flag;                                  /* flags                                 */
 EVNT_I w_evnt_i;                             /* structure evenementielle              */
 GRECT ExtGrectUse;                           /* rectangle exterieur lorsque non full  */
 GRECT GemWorkGrect;                          /* espace de travail GEM de la fenetre   */
 DLG_VAR DlgVar;                              /* structure pour ressources en fenetre  */
 char titre[256];                             /* titre de la fenetre                   */
 void *UserPtr;                               /* Pointeur sur zone utilisateur         */
 char  MemSup[256];                           /* 256 octets par fenetre pour variables */
}WINDTAB;


/*------------------------- structure pour scroll box -------------*/ 
typedef struct
    {int sel;         /* indice de ligne selectionne  OPT   base (0)  */
     int prem_l;      /* indice de ligne affiche en premier base (0)  */
     int nbr_l;       /* nbr de ligne de la boite (retourne par init) */
     int nbr_e;       /* nbr d'lments de la liste                    */
     int len_e;       /* largeur d'un element de liste                 */
     char *adr_lst;   /* adresse de la liste                           */
     int flag;        /* flag d'usage gnral de fonctionnement        */
     int mode;        /* mode  d'affichage                             */
     int delty;       /* interligne                                    */
     int fnt_id;      /* indice de la police                           */
     int fnt_pt;      /* taille en points de la police de caracteres   */
     int fnt_col;     /* couleur des caracteres                        */
     int fnt_wr;      /* mode ecriture police                          */
     int back_style;  /* style fond                                    */
     int back_color;  /* couleur du fond                               */
    } LIST_BOX; 
    
typedef struct
    {int first_ob;
     int nb_ob;
    } ONG_LST;
/*---------------------- Structure de case de popup ----------------------*/
typedef struct
  {short x0;        
   short y0;
   short x1;
   short y1;
   short numfnc;
   short numicn;
   char  racc1;
   char  racc2;
   short numhlp;
  }MEN_CASE;
/*...................... Structures vqt_extent ....................*/
typedef struct
    {int XinfG;
     int YinfG;
     int XinfD;
     int YinfD;
     int XsupG;
     int YsupG;
     int XsupD;
     int YsupD;
    }EXTND_DIM;
/*...................... Structures vqt_fontinfo ....................*/    
typedef struct
    {int bot2bas;
     int des2bas;
     int hlf2bas;
     int asc2bas;
     int top2bas;
    }FNT_INF;    
/*...................... Structures rectangles ....................*/
typedef struct
    {int left;
     int top;
     int right;
     int bottom;
    }VRECT;
    
typedef struct
    {int left;
     int top;
     int right;
     int bottom;
    } RECT; 
    
typedef struct
    {int x;
     int y;
    } POINT; 

/*////////////////////////////////////////////////////////////////////////////*
/*                                                                            */
/*------- VARIABLES GLOBALES PUBLIQUES (liees au fichier EAZY_GEM.LIB)--------*/
/*         ces variables peuvent etre utilises par tous les fichiers         */
/*                                                                            */
/*////////////////////////////////////////////////////////////////////////////*/
/*.......... les deux variables suivantes doivent etre modifiees .............*/
/*           avant l'appel  la fonction: InitEazyGem() pour                  */
/*               que la modification soit prise en compte                     */
extern int MAX_TTIPS;   /* nbr maxi de structures TOOL_TIPS permises */
extern int MAX_WIND;    /* nbr maxi de fenetres de notre application */

extern char NomAppli[256]; /* contient apres initialisation nom du programme   */
extern char *EZ_message[]; /* table des adresses des messages, d'EAZY_GEM      */
extern int Appl_id;    /* variable globale publique identifiant l'application  */
                       /* que le gem nous attribue lorsque nous lui demandons  */
                       /* l'autorisation de demarrer. Cette variable est       */
                       /* retournee par la fonction InitEazyGem()              */ 
extern MACHINE_INFO MachineInfo; /* structure pour les info sur la machine   */
extern int AESversion;    /* version AES utilise          (ne pas modifier)  */
extern int VDIhandle;     /* handle que le systeme m'attribuera apres        */
                           /* ouverture de la station de travail graphique   */
extern int Ecran_l;        /* largeur en pixel de l'ecran (ne pas modifier)  */                     
extern int Ecran_h;        /* hauteur en pixel de l'ecran (ne pas modifier)  */  
extern int Nb_plan;        /* nbr de plans de l'ecran     (ne pas modifier) */
extern long Nb_color;      /* nbr de couleurs de l'ecran  (ne pas modifier) */
extern int EZGemRun; /* variable globale publique si zero le programme sort */
                /* de la boucle evenementielle                         */
                /* pour mettre fin au programme il faut la mettre a 0  */
                /* de n'importe quel endroit du programme              */
                
extern WINDTAB   *Windtab;     /* declaration des table de structures  */
                               /* de fenetre.                          */
extern int TTswitch;           /* si 0/pas de bulle si 1/bulle actives */                               
extern int TT_Time_ON;         /* delai avant apparition bulle         */
extern int TT_Time_OFF;        /* delai pour disparition bulle         */

extern int *MenTTBack;         /* pointe sur sauvegarde fond bulle d'aide  */                               
                               /* definition de la forme souris "I"        */
                               /* mise au debut des bulles d'aides         */                               
extern int NbFont;             /* nombre de fontes                         */
extern char *FontTab;     /* pointera sur tableau global des fontes        */
extern char *FontName;    /* pointera sur tableau des nom de fontes        */
extern long *FontID;      /* pointera sur tableau des ID de fontes         */
extern long Gdos;         /* contient: l'identificateur Gdos si ok         */
                          /*          -2 si Gdos pas charg                */
                          /*          '_FSM' si vectoriel possible         */
extern int ModalFSEL;
extern int ModalWind;                          
/*/////////////////////////////////////////////////////////////////////////////*
/*                                                                            */
/*------- FONCTIONS REDEFINIE (liees au fichier EAZY_GEM.LIB) ----------------*/
/*                                                                            */
/*////////////////////////////////////////////////////////////////////////////*/
int EZ_vst_font(int vh, int fnt);
#define vst_font(a,b)  EZ_vst_font((a),(b))

int EZ_vst_point( int vh, int point, int *c, int *d, int *e, int *f);
#define vst_point(a,b,c,d,e,f)   EZ_vst_point((a),(b),(c),(d),(e),(f))

int EZ_vst_rotation(int vh, int angle);
#define vst_rotation(a,b) EZ_vst_rotation((a),(b))

int EZ_vst_effect(int vh, int effect);
#define vst_effects(a,b)   EZ_vst_effect((a),(b))

int EZ_vst_color(int vh, int color);
#define vst_color(a,b)   EZ_vst_color((a),(b))

int EZwind_update(int mode);
#define wind_update(a)  EZwind_update((a))

int EZ_alert( int default_button, char *form_string );
#define form_alert(a,b)  EZ_alert((a),(b))

int EZ_menu_bar( OBJECT *tree, int show );
#define menu_bar(a,b)  EZ_menu_bar((a),(b))

/*/////////////////////////////////////////////////////////////////////////////*
/*                                                                            */
/*------- FONCTIONS PUBLIQUES (liees au fichier EAZY_GEM.LIB) ----------------*/
/*   ces fonctions peuvent etre utilises par tous les fichiers               */
/*                                                                            */
/*////////////////////////////////////////////////////////////////////////////*/

/*************************************************************************/
/*           F O N T I O N S   D 'I N I T I A L I S A T I O N  ( G E M ) */
/*************************************************************************/


/*--------------------------- InitEazyGem -----------------------------*/
/* ACTION: initialise sur des valeurs par defaut la structure WINDTAB  */
/*         et dclare l'application au gem                             */
/* elle declare notre programme  EAZY_GEM,                            */
/* Initialise l'application et son identificateur GEM: Appl_id,        */
/* Ouvre une station de travail VDI dont le handle est: VDIhandle,     */
/* Initialise le GDOS (si il existe), charge les polices de caracteres */
/*     Reserve et initialise la zone des donnees de fontes: FontTab,   */
/*     itialise la variable de nombre de fontes: NbFont,               */
/*     initialise le tableau d'identificateur de fontes: FontID[],     */
/*     initialise le tableau de nom des fontes: FontName,              */
/* Initialisation desvariables globales suivantes:                     */
/*                Appl_id  (identificateur GEM de l'application)       */
/*                VDIhandle (handle VDI de l'application)              */
/*                FontTab  (pointe sur zone memoire reservee pour les  */
/*                          variables lies aux fontes)                */
/*                FontID[] (tableau des identificateurs de fontes)     */
/*                FontName (zone des noms de fontes. Chaque nom de     */
/*                         fonte fait 36 caracteres y compris zero de  */
/*                         fin de chaine. EXP: Pour accder au nom de  */
/*                         la 12me fonte il faut faire, (le premier   */
/*                         lment commenant  zro):                 */
/*                         FontName + 11 * 36. L'adresse ainsi         */
/*                         calcule pointe sur le nom de la 12me      */
/*                         fonte charge.Ce nom est identique  celui  */
/*                         retourn par la fonction VDI: vqt_name      */ 
/*                         ouf !!)                                     */
/*                NbFont  (Nombre de fontes disponibles y compris la   */
/*                         fonte systme)                              */
/*                Ecran_l (largeur de l'ecran en pixels)               */
/*                Ecran_h (hauteur de l'ecran en pixels)               */    
/*                Nb_color(nombre de couleurs)                         */
/*                Nb_plan (nombre de plan de l'ecran)                  */
/*                NomAppli (pointe sur le nom du programme)            */
/*                AESversion (utile  tester pour certaines fonctions) */
/*                Screen_MFDB  (structure raster cran)                */
/*                MachineInfo  (structure renseignant sur la machine   */
/*                               et systme sur lequel l'on est)       */
/*                Gdos   contient: l'identificateur Gdos si ok         */
/*                                -2 si Gdos pas charg                */
/*                                '_FSM' si vectoriel possible         */
/* Initialisation de la structure WINDTAB sur zero et valeurs de defaut*/ 
/*                                                                     */ 
/* ENTREE:      char *nomappli   doit pointer sur le nom du programme  */ 
/* RETOUR:      un int  positif si reussite de l'operation, qui est    */ 
/*                         alors l'identificteur GEM de l'application  */
/*                      NEGATIF -2 alors station de travail VDI non     */
/*                                 ouverte il faut abandonner.          */
/*                      NEGATIF -1 alors tout est foutu il faut quitter */
/* PROTOTYPE:                                                          */ 
              int InitEazyGem(char *nomappli);


/*----------------------------- ExitEasyGem ---------------------------*/
/* ACTION: Libre la mmoire reserve par EAZY_GEM pour ses besoins    */ 
/*         internes, dcharge les polices de caractres, ferme la      */
/*         station VDI, libre l'application du GEM, et quitte.        */
/* ENTREE:    nant                                                    */
/* RETOUR:    sans intrt                                             */ 
/* PROTOTYPE:                                                          */
              int ExitEasyGem(void);

/*------------------------- BouclePrincipale  -------------------------*/
/* ACTION: Noyau d'EAZY_GEM cette fonction est celle qui gre          */
/*         l'vnementiel GEM le filtre, le redistribue aux diffrentes*/
/*         fonctions CALLBACK en les appelant                          */
/*         Pour mettre fin  cette boucle il faut mettre la variable   */
/*         globale: EZGemRun                                           */
/*                   0 (demande de confirmation avant sortie)         */
/*                   1 (sortie sans demande de confirmation)          */
/* ENTREE: CALLBACK (*MyEventProc)(int w_ind, void *adr) adresse de la */ 
/*                   fonction qui sera charge de grer l'vnmentiel  */ 
/*                   GEM par dfaut. Si cette valeur est NULL, alors   */ 
/*                   l'vnmentiel GEM ne pourra etre gr que par les */ 
/*                   fonctions CALLBACK  de fenetre                    */
/* RETOUR: nant                                                       */
/* PROTOTYPE:                                                          */

void BouclePrincipale(CALLBACK(*MyEventProc)(int w_ind,EVNT_O *Evnt));
              
/*************************************************************************/
/*           F O N T I O N S   D E   R E S S O U R C E S   ( G E M )     */
/*************************************************************************/

/* --------------------------- RscFicLoad ---------------------------- */
/* ACTION: charge un fichier ressource en memoire et l'adapte aux      */
/*         nouvelles specification d'EAZY_GEM.                         */
/*         La memoire est automatiquement reservee et la ressource est */
/*         relogee et convertie prete  l'emploi.                      */
/* ENTREE: char *path, char *name chemin et nom de la ressource        */
/*         int scale_flag = 1 SCALE affichage au standard GEM (normal) */
/*                        = 0 NO_SCALE affichage au standard EAZY_GEM  */      
/*                            (police moyenne taille 9)                */
/*         pour le menu GEM classique utilizez  SCALE ou 1             */
/*         pour un menu en fenetre ou une ressource en fenetre         */ 
/*              choisissez ce qui vous plait le plus.                  */           
/* RETOUR: adresse memoire o la ressource a t charge               */
/*         SI = 0 pas assez de memoire                                 */
/*            = 1 ce n'est pas un fichier de ressource                 */
/*            = 2 ouverture fichier impossible (fichier non trouv     */
/*                                              mauvais chemin ou nom) */
/*         il est fortement conseille de stocker cette adresse de      */
/*         chargement quelque part !!!                                 */
/* PROTOTYPE:                                                          */
          void *RscFicLoad(char *path, char *name, int scale_flag); 

/* ------------------------- RscFicUnLoad --------------------------------- */
/* ACTION: decharge la ressource et la memoire occupe par celle ci.        */
/*         il est obligatoire d'appeler cette fonction avant la fin du      */
/*         programme ou si l'on veut liberer et ejecter cette ressource     */         
/*         car l'on n'en a plus besoin. Il est evident que si l'on veut de  */
/*         nouveau utiliser cette ressource il faudra la recharger avec     */
/*         la fonction: RscFicLoad                                          */
/* ENTREE: void *adr_rsc adresse memoire o a t charge la ressource      */
/* SORTIE: void *adr_rsc est mise  zero                                    */        
/* PROTOTYPE:                                                               */
           void RscFicUnLoad(void *adr_rsc);                              

/*------------------------ LoadAppliRsc ----------------------------------*/
/* ACTION: charge la ressource dont le nom est donn en entree, dans les  */
/*         diffrents repertoires possibles de l'application.             */
/*         Soit celui de la chaine d'environnement lie  l'application,  */
/*         Soit dans un dossier portant le nom de l'application avec      */
/*              l'extension .RSC, situe dans meme repertoire que l'appli- */ 
/*              cation.                                                   */
/*         Soit dans un dossier portant le nom de l'application avec      */
/*              l'extension .SYS, situe dans meme repertoire que l'appli- */ 
/*              cation.                                                   */
/*         Soit au niveau du repertoire de l'application.                 */
/* ENTREE: char *nom_rsc: pointe sur nom du fichier ressource  charger   */
/*         int scale: NO_SCALE/0 echelle reduite.                         */
/*                       SCALE/1 echelle normale du GEM.                  */
/* SORTIE: adresse de chargement de la ressource.                         */

void *LoadAppliRsc(char *nom_rsc, int scale);

/*------------------------ xrsrc_gaddr -------------------------------------*/
/* ACTION: permet d'obtenir l'adresse des differents elements de la         */
/*         ressource. Cette fonction fonctionne comme  rsrc_gaddr du GEM    */
/*         avec comme parametre suplementaire l'adresse de la ressource     */
/* ENTREE: int type:     type d'element dont on veut l'adresse              */
/*                       (comme ceux du  rsrc_gaddr classique du GEM)       */        
/*         int index:    index de l'element dont on veut l'adresse          */
/*         int *adr_rsc: adresse de chargement de la ressource. C'est celle */
/*                       que l'on a obtenu avec la fonction: RscFicLoad     */ 
/* SORTIE: void *adr_ret: adresse de l'element recherch                    */
/* EXEMPLE: cet exemple indique comment obtenir l'adresse d'un arbre de     */
/*          ressource (dialogue, menu, etc..) Ici je desire avoir l'adresse */
/*          du premier objet du troisieme arbre (indexe  partie de zero)   */
/*          de la ressource chargee par: RscFicLoad  l'adresse: AdrRsc     */
/*          OBJECT *tree;   je declare un pointeur sur un objet             */
/*          xrsrc_gaddr (R_TREE, 2, &tree, AdrRsc);  j'appelle la fonction  */
/*          et apres cet appel, tree pointe sur le premier objet de la      */
/*                              ressource que je peux donc utiliser pour    */
/*                              affichage et autres  manipulations comme    */
/*                              dans le GEM traditionnel.                   */
/* PROTOTYPE:                                                               */
    int xrsrc_gaddr (int type, int index, void *adr_ret, int *adr_rsc);  

/*----------------------- SetBulleState ------------------------------*/
/* ACTION: cherche un indicateur d'tat de la bulle d'aide dans       */
/*         l'arbre de ressource point par OBJECT *object et le place */
/*         dans le bon etat d'activite et le redessine.               */
/* ENTREE: int w_h, handle GEM de la fenetre ou se trouve la ressource*/
/*         OBJECT *object, pointe sur l'arbre de ressource.           */    

void SetBulleState(int w_h, OBJECT *object);


/*------------------- FindFirstEditable -----------------------------*/   
/* ACTION: trouve le premier editable dans les fils d'un objet       */
/* ENTREE: OBJECT *object, pointe sur l'arbre dont on cherche le     */
/*                premier editable.                                  */
/*         int ind indice de l'objet pere dont il faut explorer la   */
/*                descendance.                                       */
/* RETOUR: indice du premier editable si trouv.                     */
/*         -1 si non trouv.                                         */

int FindFirstEditable(OBJECT *object, int ind);

/*------------------- FindNextEditable ------------------------------*/   
/* ACTION: trouve l'editable suivant un objet dans la descendance    */
/*         d'un objet.                                               */
/* ENTREE: OBJECT *object, pointe sur l'arbre dont on cherche        */
/*                l'editable.                                        */
/*         int ind, indice de l'objet pere dont il faut explorer la  */
/*                descendance.                                       */
/*         int ob_edit, indice de l'objet actuellement edit.        */
/* RETOUR: indice de  l'editable suivant si trouv.                  */
/*         -1 si non trouv.                                         */

int FindNextEditable(OBJECT *object, int ind, int ob_edit);

/*------------------- FindPreviousEditable --------------------------*/   
/* ACTION: trouve l'editable prcdant un objet dans la descendance  */
/*         d'un objet.                                               */
/* ENTREE: OBJECT *object, pointe sur l'arbre dont on cherche        */
/*                l'editable.                                        */
/*         int ind, indice de l'objet pere dont il faut explorer la  */
/*                descendance.                                       */
/*         int ob_edit, indice de l'objet actuellement edit.        */
/* RETOUR: indice de  l'editable precedent si trouv.                */
/*         -1 si non trouv.                                         */

int FindPreviousEditable(OBJECT *object, int ind, int ob_edit);

/*------------------- FindFirstObject -------------------------------*/
/* ACTION: donne l'indice du premier objet d'un arbre ressource      */
/*         par rapport  un objet quelconque passe en entree         */
/* ENTREE: OBJECT* object, pointe sur un objet quelconque            */               
/* RETOUR: indice de l'objet pere (forcement negatif)                */

int FindFirstObject(OBJECT *object);

/*--------------------------- ObjcGetTxt -----------------------------------*/
/* ACTION: permet d'obtenir l'adresse de la chaine texte d'un objet.        */
/*         Il est impratif de n'utiliser que cette fonction dans EAZY_GEM  */
/*         pour obtenir l'adresse de la chaine texte des objets.            */
/* ENTREE: OBJECT *adr, pointe sur l'arbre de l'objet.                      */
/*         int object, indice de l'objet.                                   */
/* RETOUR: un char* pointant sur la chaine de texte de cet objet.           */

char *ObjcGetTxt (OBJECT *adr, int object);

/*---------------------------- ObjcSetTxt ----------------------------------*/
/* ACTION : place la chaine string place en entr dans la zone texte       */
/*          de l'objet donn en entre. La chaine d'entree est tronque si  */
/*          elle depasse celle que l'objet peut admettre.                   */
/*          Il est impratif de n'utiliser que cette fonction dans EAZY_GEM */
/*          pour placer une chaine texte dans un objet .                    */
/* ENTREE: OBJECT *adr, pointe sur l'arbre de l'objet.                      */
/*         int object, indice de l'objet.                                   */
/*         char *string, pointe sur la chaine de caracteres  placer.       */

void ObjcSetTxt (OBJECT *adr, int object, char *string);

/*-----------------------  Wobjc_draw ------------------------------*/
/* ACTION: redessine l'objet place en entree, en tenant compte de   */
/*         la liste des rectangles.                                 */
/* ENTREE: int w_ind: indice EAZY_GEM de LA fenetre.                */
/*         OBJECT *object, adresse arbre auquel appartient l'objet. */
/*         int num_ob, numro de l'objet dans cet arbre.            */
/*         int niveau, profondeur de redessin dans la descendance   */
/*         GRECT *clipgrect, rectangle de clipping.                 */
/*                si il est non defini (==0), c'est le rectangle de */
/*                de l'objet qui est utilis.                       */

int Wobjc_draw(int w_ind, OBJECT *object, int num_ob, int niveau, GRECT *clip_grect);

/*-----------------------  Xobjc_draw ------------------------------*/
/* ACTION: redessine l'objet place en entree avec le rectangle de   */
/*         clipping                                                 */
/* ENTREE: OBJECT *object, adresse arbre auquel appartient l'objet. */
/*         int num_ob, numro de l'objet dans cet arbre.            */
/*         int niveau, profondeur de redessin dans la descendance   */
/*         GRECT *clipgrect, rectangle de clipping.                 */

void Xobjc_draw(OBJECT *object, int num_ob, int niveau, GRECT *clipgrect);

/*-------------------------------- PopupDo -------------------------------------*/
/* ACTION: affiche et controle un popup fait d'un objet quelconque contenant    */
/*         d'autres objets consideres comme des options.                        */
/* ENTREE: OBJECT *object:                                                      */
/*               adresse de l'arbre auquel appartient l'objet pere des options. */
/*         int ind:                                                             */
/*               indice dans cet arbre de l'objet pere des options .            */        
/*         int ob_sel:                                                          */
/*               indice dans cet arbre de l'objet option preselectionnee.       */
/*         int x,y:                                                             */
/*               coordonnes d'affichage du centre popup. Ce centre se recentre */
/*               sur l'option preselectionne                                   */
/* RETOUR: int: option selectionne si >0    click non valide sinon             */

int PopupDo(OBJECT *object, int ind, int ob_sel, int x, int y);

/*---------------------------- PopupListDo --------------------------------*/
/* ACTION: affiche un popup menu avec surveillance des rectangles de titre */
/*         -->> Si ces rectangles sont definis,                            */ 
/*                          (grecttitle_out !=0 et grecttitle_in != 0),    */
/*         lorsque la souris penetre dans la zone  grecttitle_out le popup */
/*         se referme et retourne le message POPUP_CHANGE (32000)          */
/*         -->> Si ces rectangles ne sont pas definis,                     */
/*                          (grecttitle_out ==0 et grecttitle_in == 0),    */
/*         le popup se referme soit si click en dehors, soit si click sur  */
/*         option valide (non disabled)                                    */
/*         Cette fonction est une sous fonction de la fonction de menu en  */
/*         fenetre, et peut etre utilise pour afficher un popup simple.   */
/*         c'est pourquoi son fonctionnement est particulier.              */
/* ENTREE: ............... 1) objet de reference graphique .............   */
/*         OBJECT *object: adresse arbre auquel appartient l'objet.        */
/*         int ob_ind: numro de l'objet dans cet arbre.                   */
/*               NOTE: l'objet designe par object[ob_ind] ne sert que pour */
/*                     indiquer les caractristiques graphiques du fond et */
/*                     du texte du popup. C'est en fait son TEDINFO qui    */
/*                     utilis pour dessiner le reste du menu.             */
/*                     Pour un popup simple, c'est l'objet pere des        */
/*                     options du menu. (par exemple).                     */ 
/*                     Cet objet pere peut etre: SOIT -> un type G_BOXTEXT */
/*                     (type BoxText sous Interface) type tendu doit      */
/*                     etre: 102.                                          */
/*                                               SOIT -> un type G_BOXTEXT */
/*                     (type BoxText sous Interface) type tendu doit      */
/*                     etre: 107. Pere d'un menu GEM en fenetre.           */
/*         ............... 2) objet de reference options ...............   */
/*         OBJECT *menu_tree: adresse arbre auquel appartient l'objet.     */  
/*         int ind_list: numro de l'objet dans cet arbre.                 */
/*               NOTE: l'objet designe par menu_tree[ind_list] doit        */
/*                     contenir comme objets fils les options de menu sous */
/*                     forme de string.                                    */
/*         int x,y;  coordonnees d'affichage du popup.                     */
/*         GRECT *grecttitle_out: rectangle de surveillance.               */
/*         GRECT *grecttitle_in: rectangle de surveillance.                */

int PopupListDo(OBJECT *object,     int ob_ind,  
                OBJECT *menu_tree,  int ind_list,
                int x, int y, 
                GRECT *grecttitle_out,
                GRECT *grecttitle_in);                                          
                
/*--------------------------- MakeEvntClicOnObjet ------------------------*/
/* ACTION: Modifie le flux evenementiel, represente par EVNT_O *Evnt, de  */
/*         maniere a silmuler le click sur un objet dont les coordonnees  */
/*         sont donnees en entree.                                        */
/* ENTREE: OBJECT *object, pointe sur le prem. objet de l'arbre d'objets  */
/*                         ou se trouve l'objet.                          */
/*         int ob_ind, indice de l'objet clique dans cet arbre.           */
/*         EVNT_O *Evnt, pointe sur la variable de flux evenementiel a    */
/*                       modifier.                                        */
/* SORTIE: EVNT_O *, pointe sur la variable de flux evenementiel modifiee */

EVNT_O *MakeEvntClicOnObjet(OBJECT *object, int ob_ind, EVNT_O *Evnt);

/*--------------------- GetFreeString ------------------------------------*/
/* ACTION: Retourne l'adresse du tableau de pointeurs de freestring, d'une*/
/*         ressource.                                                     */
/*         Il est ensuite possible d'acceder a chaque chaine de cette     */
/*         table par son indice. (utiliser pour les indices la table      */
/*                                symbolique .H que genere Interface.)    */                                          
/* ENTREE: void *adr_rsc, adresse ou a ete chargee la ressource dont on   */
/*                        cherche la table de FreeString.                 */
/* SORTIE: char **, pointe sur la table de pointeur de chaine.            */

char **GetFreeStringTab(void *adr_rsc);
                
/*************************************************************************/
/*           F O N T I O N S   D E   S O U R I S   ( G E M )             */
/*************************************************************************/ 
/* ----------------------------- Mouse_on ----------------------------- */
/* ACTION: cette fonction sert  afficher la souris. EAZY_GEM tient    */
/*         jour un flag de visibilit permettant d'utiliser cette       */
/*         fonction sans se procuper de l'tat anterieur de la souris. */
/*         Il est conseill de toujours utiliser cette fonction.        */ 

void Mouse_on( void );            

/* ----------------------------- Mouse_off ---------------------------- */
/* ACTION: cette fonction sert  effacer la souris. EAZY_GEM tient     */
/*         jour un flag de visibilit permettant d'utiliser cette       */
/*         fonction sans se procuper de l'tat anterieur de la souris. */
/*         Il est conseill de toujours utiliser cette fonction.        */ 

void Mouse_off( void );               

/*-------------------------- Mousek ------------------------------------*/
/* ACTION: cette fonction retourne l'etat du bouton de la souris.       */

int Mousek(void);

/*-------------------------- Mousex ------------------------------------*/
/* ACTION: cette fonction retourne la position X de la souris.          */

int Mousex(void);

/*----------------------- Mousey ---------------------------------------*/
/* ACTION: cette fonction retourne la position Y de la souris.          */

int Mousey(void);

/*--------------------------- SetMouseForm -----------------------------*/
/* ACTION: determine la forme de la souris.                             */
/*         Il est recommand d'utiliser cette fonction pour modifier la */
/*         forme de la souris avec EAZY_GEM                             */
/* ENTREE: long cursor, forme de la souris.                             */
/*                 Les formes 0  7 sont les formes GEM Classiques.     */
/*                 8   100 sont les formes EAZY_GEM                    */
/* RETOUR: mode effectivement mis en place                              */

int SetMouseForm(long cursor);

/*--------------------------- GetMouseForm -----------------------------*/
/* ACTION: retourne la forme actuelle de la souris.                     */
/* RETOUR: forme souris effectivement en place                          */

long GetMouseForm(void);
/*************************************************************************/
/* F O N T I O N S   D E   T E S T   I N T E R R O G A T I O N ( V D I ) */
/*************************************************************************/

/*-------------------------- IsMouseXYInGrect -----------------------------*/
/* ACTION: Teste si la souris est dans le rectangle GRECT *grect.          */
/* ENTREE: int x, int y, coordonnes x & y  de la souris                   */
/*         GRECT *grect pointe sur le rectangle  tester                   */
/* SORTIE: 1 si la souris est dans le rectangle 0/si en dehors.            */

int IsMouseXYInGrect(int x, int y, GRECT *grect);                     


/*-------------------------- IsMouseXYInVrect -----------------------------*/
/* ACTION: Teste si la souris est dans le rectangle VRECT *vrect.          */
/* ENTREE: int x, int y, coordonnes x & y  de la souris                   */
/*         VRECT *vrect pointe sur le rectangle  tester                   */
/* SORTIE: 1 si la souris est dans le rectangle 0/si en dehors.            */

int IsMouseXYInVrect(int x, int y, VRECT *vrect);

/*------------------------------ FntID_VDI_to_TabInd --------------------------*/
/* ACTION: retourne l'indice permettant de pointer sur le tableau de fontes   */
/*         partir de l'identificateur VDI de la fonte                          */
/* ENTREE: long Id_Vdi:  identificateur VDI de la fonte                        */
/* RETOUR: indice permettant de pointer sur le tableau de fonte                */       

int  FntID_VDI_to_TabInd(long Id_Vdi);

/*************************************************************************/
/*           F O N T I O N S   D E   T R A C E   ( V D I )               */
/*************************************************************************/
/*----------------------- Graphmode ---------------------------------*/
/* ACTION: Met en place un mode graphique VDI.                       */ 
/* ENTREE: int mode: mode graphique VDI qui peut prendre les valeurs */
/*            suivantes:  MD_REPLACE      1  Replace                 */
/*                        MD_TRANS        2  Transparent             */
/*                        MD_XOR          3  Xor                     */
/*                        MD_ERASE        4  Reverse Transparent     */

void Graphmode(int mode);

/*----------------------- Defline -----------------------------------*/
/* ACTION: Definie et positionne tous les attributs VDI de ligne     */
/* ENTREE: int type, type VDI de ligne                               */
/*         int width, epaisseur de la ligne.                         */
/*         int deb, type VDI du debut de ligne.                      */
/*         int fin, type VDI de fin de ligne.                        */
/*         int color, couleur de la ligne.                           */

void Defline(int type,int width,int deb,int fin,int color);

/*------------------------Deffill------------------------------------*/
/* ACTION: Positionne tous les attributs VDI de remplissage          */
/* ENTREE: int color, couleur de la ligne.                           */
/*         int interior, type VDI de remplissage.                    */
/*         int motif, type VDI de motif.                             */

void Deffill(int color,int interior,int motif);

/*------------------------ Deftext ----------------------------------*/
/* ACTION: Positionne tous les attributs VDI d'affichage de texte.   */
/*         si speedo est detecte alors les fonctions speedo seront   */
/*         utilisees.                                                */
/* ENTREE: int color, couleur du texte.                              */
/*         int effect, effet VDI du texte.                           */
/*         int angle, angle VDI (en 10me Degres) affichage texte.   */
/*         int point, taille en points du texte.                     */
/*         int font, indice VDI de la police de caracteres.          */

void Deftext(int color,int effect,int angle,int point,int font);

/*----------------------- VdiText --------------------------------------*/
/* ACTION: affiche un texte sur le peripherique de sortie  represente   */
/*         par VDIhandle. Si Speedo est detect alors les fonctions     */ 
/*         d'affichage speedo seront utilisees.                         */
/* ENTREE: int x, int y: coordonnes en pixels d'affichage de la chaine */
/*         texte.                                                       */
/*         char *string: pointeur sur la chaine de texte.               */

void VdiText(int x, int y, char *string);

/*------------------------ Box --------------------------------------*/
/* ACTION: dessine un rectangle non rempli (mode trait).             */
/* ENTREE: int *xyxy tableau de coordonnes VDI.                     */

void Box(int *xyxy);

/*------------------------ Box_p -------------------------------------*/
/* ACTION: dessine un rectangle non rempli (mode trait).              */
/*         Idem que Box mais coordonnes donnes spares, sous forme */
/*         de paramtres individuels et non de tableau de parametres. */            
/* ENTREE: int x0,int y0,int x1,int y1, Coordonnees VDI.              */

void Box_p(int x0,int y0,int x1,int y1);

/*------------------------ Pbox ---------------------------------------*/
/* ACTION: dessine un rectangle rempli avec le motif en vigueur.       */
/* ENTREE: int *xyxy tableau de coordonnes VDI.                       */

void Pbox(int *xyxy);

/*------------------------ Pbox_p -------------------------------------*/
/* ACTION: dessine un rectangle rempli avec le motif en vigueur.       */
/*         Idem que Pbox mais coordonnes donnes spares,sous forme  */
/*         de paramtres individuels et non de tableau de parametres.  */            
/* ENTREE: int x0,int y0,int x1,int y1, Coordonnees VDI.               */

void Pbox_p(int x0,int y0,int x1,int y1);

/*--------------------------- GrectBox ------------------------------*/
/* ACTION: dessine un rectangle non rempli (mode trait).             */
/* ENTREE: GRECT *grect, adresse du rectangle de Coordonnees GEM.    */

void GrectBox(GRECT *grect);

/*-------------------------- GrectPbox ------------------------------*/
/* ACTION: dessine un rectangle rempli avec le motif en vigueur.     */
/* ENTREE: GRECT *grect, adresse du rectangle de Coordonnees GEM.    */

void GrectPbox(GRECT *grect);

/*----------------------------- DrawCustomCadre ----------------------------*/
/* ACTION: dessine un cadre rectangulaire epais en relief ou fin grav.     */
/* ENTREE: VRECT *vrect, coordonnes VDI du rectangle.                      */
/*         int type, si 0/epais relief,   si 1/fin grav                    */

void DrawCustomCadre(VRECT *vrect, int type);

/*------------------------ DrawReliefCadre ---------------------------------*/
/* ACTION: dessine un cadre rectangulaire avec effet relief.                */
/* ENTREE: GRECT *grect: pointe sur le rectangle d'entree.                  */
/*         int flag_relief: Si zero le cadre sera dessine sans relief.      */
/*                          Si >0 le carde est en relief sortant.           */
/*                          Si <0 le cadre est en relief rentrant.          */
/*         int thickness: epaisseur du cadre.                               */
/* SORTIE: neant:                                                           */
/* PROTOTYPE:                                                               */
   
void DrawReliefCadre(GRECT *grect, int flag_relief, int cadreColor,int thick);

/*--------------------------- DrawEnjolivedBox ---------------------------*/
/* ACTION: Dessine une boite avec cadre semi_circulaire, ombre, et fond   */
/*         Jaune comme celle des bulles d'aide.                           */
/* ENTREE: GRECT *grect_in: coordonnes du rectangle de la boite.         */
/*         GRECT *grect_cli: adresse du rectangle dans lequel il sera     */
/*                          retourne la surface interne utile de la boite */
/* SORTIE: GRECT *grect_cli: contient le rectangle client. (rectangle     */
/*                           interieur au cadre semi-circulaire)          */
/* RETOUR: GRECT * pointe sur le rectangle: grect_cli                     */

GRECT *DrawEnjolivedGrectBox(GRECT *grect_in, GRECT *grect_cli, int ofs_ombre);


/*------------------------ Line_p -----------------------------------*/
/* ACTION: dessine une ligne avec les attributs de ligne en vigueur. */
/* ENTREE: int x0,int y0,int x1,int y1, Coordonnees VDI.             */

void Line_p(int x0,int y0, int x1, int y1);

/*-------------------------- ClipGrect -----------------------------------*/
/* ACTION: clippe le rectangle GEM, GRECT *grect donn en entre          */
/* ENTREE: GRECT *grect, pointe sur le rectangle GEM  clipper.           */

void ClipGrect(GRECT *grect);            


/*------------------------- Blk_size -----------------------------------*/
/* ACTION : calcule la taille memoire necessaire pour stocker le bloc   */
/*          ecran dont la hauteur et la largeur sont donnes en entree  */
/* ENTREE : l et h largeur et hauteur du bloc en nbr de pixels -1       */
/*          int nb_plan, nombre de plans de l'image.                    */
/* SORTIE : Long longueur calcule                                      */

unsigned long Blk_size(int l, int h, int nb_plan);

/*----------------------------- GetGRECT ---------------------------------*/
/* ACTION: sauve dans un buffer le fond de l'ecran du rectangle grect     */
/* ENTREE: GRECT *grect, pointe sur le rectangle GEM  sauver.            */
/* RETOUR: adresse de la zone memoire ou est sauve ce fond                */
/*         zero ou NULL si plus de memoire disponible                     */

int *GetGRECT(GRECT* grect);

/*----------------------------- Get --------------------------------------*/
/* ACTION: sauve dans un buffer, un bloc d'ecran rectangulaire (VDI)      */
/* ENTREE: int *xyxy, pointe sur les dimensions du rectangle  sauver.    */
/* RETOUR: adresse de la zone memoire ou est sauve le bloc graphique ou:  */
/*            Le 1er  int est la largeur du bloc en nbr de pixels-1       */
/*            le 2eme int est la hauteur du bloc en nbr de pixels-1       */
/*            le 3eme est le nbr de plans de l'image.                     */
/*            suivent les datas d'image.                                  */
/*         zero ou NULL si plus de memoire disponible                     */

int *Get(int *xyxy);

/*-------------------------- Put-----------------------------------------*/
/* ACTION: Place en x et y un bloc d'ecran precedemment sauv par Get.   */
/*         ce graphique doit obligatoirement etre avec les memes         */
/*         caracteristiques RASTER quel'ecran (meme nbr couleurs, plans  */
/*         et organisation memoire).                                     */
/* ENTREE: int x,int y:                                                  */
/*              coordonnes x et y (angle sup gauche) ou l'on            */
/*              desire placer le bloc graphique.                         */
/*         int *xyxy_buff:                                               */
/*              pointeur sur la zone memoire ou se trouve le bloc        */
/*              graphique. Le 1er  int est la largeur en nbr de pixels-1 */
/*                         le 2eme int est la hauteur en nbr de pixels-1 */
/*                         le 3eme est le nbr de plans de l'image.       */
/*                         suivent les datas d'image.                    */
/*         int mode:                                                     */
/*              mode de copie du bloc (voir doc VDI)                     */

void Put( int x,int y,int *blk_buff,int mode);

/*-------------------------Put_mono--------------------------------------*/
/* ACTION: Place en x et y un bloc d'ecran precedemment sauv par Get.   */
/*         ce graphique doit obligatoirement etre monochrome 1 plan.     */
/* ENTREE: int x,int y:                                                  */
/*              coordonnes x et y (angle sup gauche) ou l'on            */
/*              desire placer le bloc graphique.                         */
/*         int *xyxy_buff:                                               */
/*              pointeur sur la zone memoire ou se trouve le bloc        */
/*              graphique. Le 1er  int est la largeur en nbr de pixels-1 */
/*                         le 2eme int est la hauteur en nbr de pixels-1 */
/*                         le 3eme est le nbr de plans de l'image.       */
/*                         suivent les datas d'image.                    */
/*         int mode:                                                     */
/*              mode de copie du bloc (voir doc VDI)                     */

void Put_mono(int x,int y,int *xyxy_buff,int mode);

/*------------------------- Put_mono_color -------------------------------*/
/* ACTION: Place en x et y un bloc d'ecran precedemment sauv par Get.   */
/*         ce graphique doit obligatoirement etre monochrome 1 plan.     */
/* ENTREE: int x,int y:                                                  */
/*              coordonnes x et y (angle sup gauche) ou l'on            */
/*              desire placer le bloc graphique.                         */
/*         int *xyxy_buff:                                               */
/*              pointeur sur la zone memoire ou se trouve le bloc        */
/*              graphique. Le 1er  int est la largeur en nbr de pixels-1 */
/*                         le 2eme int est la hauteur en nbr de pixels-1 */
/*                         le 3eme est le nbr de plans de l'image.       */
/*                         suivent les datas d'image.                    */
/*         int mode:                                                     */
/*              mode de copie du bloc (voir doc VDI)                     */
/*         int *color:                                                   */
/*             pointe sur deux int, le 1er est la couleur avec laquelle  */
/*                                  les pixels  1 (mis) du bloc, seront */
/*                                  recopis sur l'ecran.                */ 
/*                                  le 2eme est la couleur avec laquelle */
/*                                  les pixels  0 (non mis) du bloc,    */
/*                                  seront recopis sur l'ecran.         */ 

void Put_mono_color(int x,int y,int *xyxy_buff,int mode, int *color);


/*-------------------------- Scroll_p---------------------------------------*/
/* ACTION: Cette fonction permet de faire scroller en vertical un rectangle */
/*         d'une certaine quantit.                                         */
/* ENTREE: int x0,int y0,int x1,int y1, coordonnes VDI du rectangle.       */
/*         int  delty, est la valeur dont doit scroller le rectangle xyxy   */
/*                   en entree: SI negative la partie haute xyxy descend.   */
/*                              SI positive la partie basse xyxy monte.     */

void Scroll_p(int x0,int y0,int x1,int y1,int delty);
 



/*************************************************************************/
/*         F O N T I O N S   D E    F E N E T R E S   ( G E M )          */
/*************************************************************************/

/* --------------------------- CreateWindow -----------------------------*/
/* DESCRIPTION:                                                          */
/* ------------                                                          */
/*      il est impratif de n'utiliser que cette fonction dans EAZY_GEM  */
/*       pour creer une fenetre.                                         */
/*  long w_attr: attributs GEM classique d'une fenetre                   */
/*               trois attributs de plus:                                */
/*                         BORDER permet d'avoir un cadre epais en       */
/*                                  relief autour de la fenetre.         */
/*                         XMOVER permet d'avoir une poigne de deplace- */
/*                                ment sur le bord sup du cadre epais    */
/*                         XSIZER permet l'agrandissement de la fenetre  */
/*                                en cliquant sur le cadre epais         */
/*  int Ident:  nbr arbitraire(jamais nul) que vous devez donner. Cela   */
/*              peut servir  reperer tel ou tel type de fenetre dans    */
/*              votre programme. Exemple votre application comporte      */
/*              plusieurs fenetres dont une de menu  laquelle vous      */
/*              donnez int ident=2 lors de sa cration. Il est           */
/*              alors facile pour le programme de savoir si la fenetre   */
/*              menu est ouverte en faisant appel  la fonction          */
/*              int IdentToIndice(2); qui vous retourne l'indice de la   */
/*              fenetre (si elle n'existe pas l'indice est >= MAX_WIND ) */
/*              pensez  utiliser des type symboliques declars avec:    */
/*              #define FENETRE_TRUC 2  plutot qu'un nombre sans sens.   */
/*                                                                       */
/*  void *adr:  adresse pointant sur diverses choses dependant du type   */
/*              gestion que l'on prevoit pour la fenetre. Cette adresse  */
/*              permet par exemple de passer un pointeur sur une struct- */
/*              ture, avec laquelle elle doit travailler. Ce parametre   */
/*              est donc facultatif. La fonction: CreateWindow() place   */
/*              ce parametre dans Wintab[w_ind].UserPtr de la fenetre.   */
/*                                                                       */                              
/*  CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt): L vous donnez le nom   */
/*              fonction qui sera charge de gerer tous les evenements   */
/*              de cette fenetre. Cette fonction sera appelee par la     */
/*              sur couche EAZY_GEM.                                     */
/* int x, int y, int w, int h,: coordonnees en pixels de la fenetre      */
/*              ces coordonnees doivent etre celles du contour exterieur */
/*              de la fenetre et non de la surface de travail            */
/*              si zero en entree alors les dimensions maxi possibles    */
/*              seront choisies.                                         */
/*              Ces dimensions peuvent etre modifiees avant ouverture de */
/*              la fenetre lors du traitement du message WM_CONSTRUCT    */
/*              au sein de la procedure de fenetre.                      */
/* char *nom:   titre de la fenetre                                      */
/*              de meme le titre de la fenetre peut etre modifie au sein */
/*              de la procedure de fenetre lors du traitement du message */
/*              WM_CONTRUCT.                                             */
/* RETOURNE: Le handle GEM de la fenetre si tout est OK.                 */
/*           -1 si Echec du constructeur de la fenetre                   */
/*           -2 si nbr fenetre superieur  MAX_WIND (maximum EAZY_GEM)   */
/*           -3 si l'AES n'a plus de fenetre  nous donner               */
/* PROTOTYPE:                                                            */
/*                                                                       */
  int  CreateWindow ( long w_attr,                                     
                      int ident,                                      
                      void *adr,                                                    
                      CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt),    
                      int x, int y, int w, int h,                      
                      char *nom                                        
                    );    
/*---------------------- CreateModalWindow -----------------------------*/
/* ACTION: cet appel est le meme que create window, a la difference     */
/*         qu'apres cet appel la main n'est rendue qu'apres fermeture   */
/*         de la fenetre. Lors de cet appel les autres fenetres, et le  */
/*         menu ne sont plus accessibles.                               */
                                                                 
int  CreateModalWindow ( long w_attr,                                     
                    int ident,                                         
                    void *adr,                                                        
                    CALLBACK (*w_proc)(int w_ind, EVNT_O *Evnt),      
                    int x, int y, int w, int h,                       
                    char *nom                                         
                  );
                  
/*-------------------------- DestroyWindow ---------------------------------*/
/* ACTION: dtruit une fenetre. Cette fonction gnre le message WM_DESTUCT */
/*         permettant  la fonction de fenetre de dsinitialiser ce qu'elle */
/*         avait ventuellement reserv (memoire, station de travail...)    */
/*         avant la destruction definitive de la fenetre GEM.               */
/*         Il est impratif de n'utiliser que cette fonction dans EAZY_GEM  */
/*         pour detruire une fenetre.                                       */
/* ENTREE: int w_h, handle GEM de la fenetre  detruire.                    */
  
void DestroyWindow(int w_h);

/*---------------------------- DestroyAllWindow ----------------------------*/
/* ACTION: dtruit toutes les fenetres de l'application. Cette fonction     */
/*         gnre pour chaque fenetre, le message WM_DESTUCT permettant     */
/*          la fonction de fenetre  de dsinitialiser ce qu'elle           */
/*         avait ventuellement reserv (memoire, station de travail...)    */
/*         avant la destruction definitive de la fenetre GEM.               */
/*         Il est impratif de n'utiliser que cette fonction dans EAZY_GEM  */
/*         pour detruire les fenetres.                                      */
/* ENTREE: neant                                                            */
  
void DestroyAllWindow(void);

/*-------------------------------- OpenWindow ------------------------------------*/
/* ACTION: ouvre une fenetre et note si elle est pas en FULL les coord.           */
/*         return 1 si FULL_SIZE return 0 si pas FULL_SIZE                        */
/*         Il est impratif de n'utiliser que cette fonction dans EAZY_GEM        */
/*         pour ouvrir une fenetre.                                               */
/* ENTREE: int w_ind:                                                             */
/*             indice EAZY_GEM de la fenetre (pointe sur tableau Windtab[w_ind]   */
/*             correspondant  cette fenetre.                                     */ 
/*         GRECT* grectb: coordonnees externes d'ouverture de la fenetre.         */
/* RETOUR: int: si 1/ouverture en full size  car coordonnes trop grandes.        */ 
/*                 0/ouverture selon coordonnes d'entre.                        */
                                 
int  OpenWindow(int w_ind, GRECT* grectb);

/*--------------------------- CloseWindow ---------------------------------*/
/* ACTION: ferme une fenetre EAZY_GEM. Il est absolument imperatif et      */
/*         indispensable d'utiliser cette fonction dans EAZY_GEM pour      */
/*         fermer une fenetre.                                             */
/* ENTREE: int w_ind, indice EAZY_GEM de cette fenetre.                    */
/* RETOUR: 0/si deja fermee    1/ si non deja fermee                       */

int  CloseWindow(int w_ind);

/*--------------------------- SetWindowSize ------------------------------*/
/* ACTION: redimensionne une fenetre EAZY_GEM et note si elle est pas en  */
/*         FULL les coord.                                                */
/*         Il est impratif d'utiliser cette fonction dans EAZY_GEM pour  */
/*         modifier les dimensions d'une fenetre.                         */
/* ENTREE: int w_ind, indice EAZY_GEM de cette fenetre.                   */
/*         GRECT* grectb dimensions exterieures souhaites de la fenetre. */             
/*         return 1 si FULL_SIZE return 0 si pas FULL_SIZE                */

int  SetWindowSize(int w_ind, GRECT* grectb);

/*-------------------------- IsWindOpen ----------------------------------*/
/* ACTION: teste si la fenetre EAZY_GEM est ouverte                       */
/* ENTREE: int ind, indice EAZY_GEM de cette fenetre.                     */
/* RETOUR: 0/si pas ouverte  1/si ouverte                                 */

int IsWindOpen(int ind);

/*--------------------------- IsWindFullSize -----------------------------*/
/* ACTION: teste si la fenetre EAZY_GEM est en plein ecran.               */
/* ENTREE: GRECT *grectb, dimensions exterieures de la fenetre.           */
/* RETOUR: 0/si pas plein ecran  1/si plein ecran                         */

int IsWindFullSize(GRECT *grectb);

/*--------------------------- IsWindExist --------------------------------*/
/* ACTION: teste si la fenetre EAZY_GEM existe.                           */
/* ENTREE: int ident, typage EAZY_GEM de cette fenetre (valeur donnee en  */
/*                    deuxime paramtre lors de CreateWindow() ).        */ 
/* RETOUR: -1/si existe pas  indice EAZY_GEM/si existe                    */

int IsWindExist(int ident);

/*--------------------------- IdentToIndice --------------------------------*/
/* ACTION: permet de retrouver l'indice EAZY_GEM d'une fenetre, dont le     */
/*         type: int ident, est donn en entre (celui que l'on met en      */
/*         deuxime paramtre de la fonction: CreateWindow() )              */
/* RETOUR: indice EAZY_GEM, permettant de pointer sur le tableau Windtab de */
/*         la fenetre correspondante. Cet indice doit etre < MAX_WIND sinon */
/*         la fenetre correspondant au type donn en entre n'existe pas.   */

int IdentToIndice(int ident);
            
/*--------------------------- WindHandToIndice -----------------------------*/
/* ACTION: permet de retrouver l'indice EAZY_GEM d'une fenetre, dont le     */
/*         handle GEM: int w_h, est donn en entre (celui retourn par  la */
/*         fonction: CreateWindow()  )                                      */
/* RETOUR: indice EAZY_GEM, permettant de pointer sur le tableau Windtab de */
/*         la fenetre correspondante. Cet indice doit etre < MAX_WIND sinon */
/*         la fenetre correspondant au type donn en entre n'existe pas.   */

int WindHandToIndice( int w_h);      

/*----------------------- GetGemWindWorkGRECT ----------------------------*/
/* ACTION: Retourne l'espace de travail GEM (interieur aux gadgets GEM de */
/*         la fenetre: Barre de titre, ascenseurs, cases etc ...          */
/* ENTREE: int hwnd, handle GEM de la fenetre.                            */
/* SORTIE: GRECT *grect, est initialis sur les valeurs de ce rectangle.  */

void GetGemWindWorkGRECT(int hwnd, GRECT *grect); 

/*----------------------- GetGemWindFullGRECT ----------------------------*/
/* ACTION: Retourne les coordonnes maxi exterieurs de la fenetre GEM     */
/* ENTREE: int hwnd, handle GEM de la fenetre.                            */
/* SORTIE: GRECT *grect, est initialis sur les valeurs de ce rectangle.  */

void GetGemWindFullGRECT(int hwnd,GRECT *grect);

/*----------------------- GetGemWindExtGRECT ------------------------------*/
/* ACTION: Retourne les coordonnes exterieurs actuelles de la fenetre GEM */
/* ENTREE: int hwnd, handle GEM de la fenetre.                             */
/* SORTIE: GRECT *grect, est initialis sur les valeurs de ce rectangle.   */

void GetGemWindExtGRECT(int hwnd,GRECT *grect);

/*------------------------------ GetClientGrect ----------------------------*/
/* ACTION: calcule l'espace de travail utilisateur laiss libre dans la     */
/*         fenetre, interieur au cadre epais et aux ressources de bords     */
/* ENTREE: int w_ind, indice EAZY_GEM de la fenetre dont on recherche       */
/*                    l'espace client.                                      */
/*         GRECT *grect, adresse d'un rectangle devant recevoir les         */
/*                     coordonnes de l'espace client.                      */
/* SORTIE: GRECT *grect, est initialis sur l'espace de travail.            */
/* RETOUR: adresse du rectangle d'entree GRECT *grect initialise sur        */
/*               l'espace client, si il existe                              */
/*         zero sinon                                                       */

GRECT *GetClientGrect(int w_ind, GRECT *grect);

/*--------------------------- GemWindWorkToClientGrect ---------------------*/
/* ACTION: calcule l'espace de travail utilisateur laiss libre dans la     */
/*         fenetre, interieur au cadre epais et aux ressources de bords     */
/* ENTREE: int w_ind, indice EAZY_GEM de la fenetre dont on recherche       */
/*                    l'espace client.                                      */
/*         GRECT *grect, rectangle de l'espace de travail GEM, qui sera     */
/*                     converti en coordonnes de l'espace client.          */
/* SORTIE: GRECT *grect, est initialis sur l'espace de travail client.     */
/* RETOUR: adresse du rectangle d'entree GRECT *grect initialise sur        */
/*               l'espace client, si il existe                              */
/*         zero sinon                                                       */

GRECT *GemWindWorkToClientGrect(int w_ind, GRECT *grect);

/*------------------------ WindEZWorkToGemBorder -----------------------*/ 
/* ACTION: calcule  partir de l'espace de travail interieur au cadre   */
/*         epais (si il existe) d'une fenetre EAZY_GEM, l'espace        */
/*         exterieur de la fenetre GEM.                                 */
/* ENTREE: long attr, attributs EAZY_GEM de la fenetre.                 */
/*         GRECT* grectw espace de travail interieur de la fenetre      */
/*                EAZY_GEM.                                             */
/* SORTIE: GRECT *grectb, est rempli avec les coordonnes externes GEM  */
/*                de la fenetre.                                        */

void WindEZWorkToGemBorder(long attr, GRECT* grectw, GRECT* grectb);


/*------------------------ WindGemBorderToEZWork -----------------------*/ 
/* ACTION: calcule  partir de l'espace de travail exterieur d'une      */
/*         fenetre GEM, l'espace interieur du fenetre EAZY_GEM          */
/*         (espace interieur au cadre epais si il existe)               */
/* ENTREE: long attr, attributs EAZY_GEM de la fenetre.                 */
/*         GRECT* grectb espace de travail exterieur de la fenetre      */
/*                GEM.                                                  */
/* SORTIE: GRECT *grectw, est rempli avec les coordonnes interieures   */
/*                de la fenetre EAZY_GEM.                               */

void WindGemBorderToEZWork(long attr,GRECT* grectb, GRECT* grectw);

/*------------------------- AdjustWindCoordToSrceen ------------------------------*/
/* ACTION: ajuste les coordonnes de la fenetre sous la souris, de faon  ce     */
/*         qu'elles ne dpassent pas de l'ecran et reajuste position ressource.   */
/* ENTREE: int w_ind:                                                             */
/*             indice EAZY_GEM de la fenetre (pointe sur tableau Windtab[w_ind]   */
/*             correspondant  cette fenetre.                                     */ 
/*         EVNT_O *Evnt: pointeur sur structure de flux evenementiel, d'ou l'on   */
/*             recupere les coordonnes de la souris.                             */
/*         GRECT *grect: pointeur sur un rectangle representant les coordonnes   */
/*             exterieures de la fenetre.                                         */
/* RETOUR: GRECT *: pointeur sur le rectangle d'entree modifie.                   */

GRECT *AdjustWindCoordToScreen (int w_ind, EVNT_O *Evnt, GRECT *grect);

/*----------------------------- UnconifyWindow -------------------------------*/
/* ACTION: desiconifie la fenetre iconifiee, si c'est une fenetre representant*/
/*         toute l'application, alors toutes les fenetres seront deployes.   */
/* ENTREE: int w_ind, indice EAZY_GEM de la fenetre devant etre desiconifiee. */
/* RETOUR: toujours 1                                                         */

int UnconifyWindow(int w_ind);

/*------------------------------- IconifyWindow ------------------------------*/
/* ACTION: iconifie une fenetre ou l'application si touche CONTROL appuye.   */
/* ENTREE: int w_ind, indice EAZY_GEM de la fenetre devant etre iconifiee.    */
/*         GRECT *grect, si pas egal  zero, alors les coordonnees fenetre    */
/*         icone seront celles donnes par ce rectangle et non celles         */
/*         automatiques que le GEM calcule.                                   */                                                     
/* RETOUR: toujours 1                                                         */

int IconifyWindow(int w_ind, GRECT *grect);

/*------------------------------- AllIconify ---------------------------------*/
/* ACTION: iconifie toute l'application.                                      */
/* ENTREE: GRECT *grect, si pas egal  zero, alors les coordonnees fenetre    */
/*         icone seront celles donnes par ce rectangle et non celles         */
/*         automatiques que le GEM calcule.                                   */                                                     
/* RETOUR: toujours 1                                                         */

int AllIconify(GRECT *grect);

/*------------------------------ Xform_keybd ---------------------------------*/
/* ACTION: gestion des actions clavier sur une ressource en fenetre           */
/* ENTREE: w_ind, indice EAZY_GEM de la fenetre conteneant le ressource.      */
/*         EVNT_O *Evnt structure de flux evenementiel                        */
/* SORTIE: modification des divers champs editables                           */
/*         modification des elements de la structure DLG_VAR *dlg             */
/*         retourne -1 ou le Numero d'un objet default exit active RETURN     */   

int Xform_keybd(int w_ind, EVNT_O *Evnt);     

/*------------------------------ OnWm_moved ----------------------------------*/
/* ACTION: fonction executant tout ce qu'il est classique de faire pour       */
/*         le message WM_MOVED pour une fenetre avec ressource                */
/* ENTREE: w_ind, indice EAZY_GEM de la fenetre conteneant le ressource.      */
/*         EVNT_O *Evnt structure de flux evenementiel                        */

int OnWm_moved( int w_ind, EVNT_O *Evnt);

/*------------------------------ OnWm_fulled ---------------------------------*/
/* ACTION: fonction executant tout ce qu'il est classique de faire pour       */
/*         le message WM_FULLED pour une fenetre avec ressource               */
/* ENTREE: w_ind, indice EAZY_GEM de la fenetre conteneant le ressource.      */
/*         EVNT_O *Evnt structure de flux evenementiel                        */

int OnWm_fulled( int w_ind, EVNT_O *Evnt);

/*------------------------------ OnWm_sized ----------------------------------*/
/* ACTION: fonction executant tout ce qu'il est classique de faire pour       */
/*         le message WM_SIZED pour une fenetre avec ressource                */
/* ENTREE: w_ind, indice EAZY_GEM de la fenetre conteneant le ressource.      */
/*         EVNT_O *Evnt structure de flux evenementiel                        */

int OnWm_sized( int w_ind, EVNT_O *Evnt); 

/*------------------------------ OnButtonBorder ------------------------------*/
/* ACTION: gestion des actions souris sur la bordure d'une fenetre            */
/* ENTREE: w_ind, indice EAZY_GEM de la fenetre conteneant le ressource.      */
/*         EVNT_O *Evnt structure de flux evenementiel                        */
/* SORTIE: messages d'agrandissement et deplacements envoys                  */
/*         retourne 0 si pas souris sur bord                                  */   
/*                  1 si souris sur bord                                      */

int OnButtonBorder( int w_ind, EVNT_O *Evnt);  

/*------------------------------ Xform_button  -------------------------------*/
/* ACTION: gestion des actions souris sur une ressource en fenetre            */
/* ENTREE: w_ind, indice EAZY_GEM de la fenetre conteneant le ressource.      */
/*         EVNT_O *Evnt structure de flux evenementiel                        */
/* SORTIE: modification des divers champs editables                           */
/*         modification des elements de la structure DLG_VAR *dlg             */
/*         retourne -1 ou le Numero d'un objet selectable cliqu              */   

int Xform_button( int w_ind, EVNT_O *Evnt);    

/*------------------------ Xform_moved -------------------------------*/
/* ACTION: reajuste les parametres de la ressource en fenetre apres   */
/*         un mouvement de fenetre                                    */
/* ENTREE: w_ind, indice EAZY_GEM de la fenetre conteneant le ressource.      */
/*         EVNT_O *Evnt structure de flux evenementiel                        */
/*         GRECT *grect coordonnees interieures GEM de la fenetre contenant la*/
/*               ressource.                                                   */

void Xform_moved(int w_ind, EVNT_O *Evnt);

/*------------------------------ Xform_timer ---------------------------------*/
/* ACTION: gestion des actions timersur une ressource en fenetre              */
/* ENTREE: w_ind, indice EAZY_GEM de la fenetre conteneant le ressource.      */
/* SORTIE: etat du curseur clignotant                                         */

int Xform_timer(int w_ind); 

/*------------------------------ Xform_mu_move -------------------------------*/
/* ACTION: gestion des actions des mouvements souris sur une ressource en     */
/*         fenetre.                                                           */
/* ENTREE: w_ind, indice EAZY_GEM de la fenetre conteneant le ressource.      */
/*         EVNT_O *Evnt structure de flux evenementiel                        */
/* SORTIE: forme EAZY_GEM de la souris                                        */

int Xform_mu_move(int w_ind, EVNT_O *Evnt); 

/*---------------------- WindDialogConstruct ---------------------------*/
/* ACTION: integre un dialogue en fenetre.                              */
/* ENTREE: int w_ind: indice de notre fenetre pointe sur bonne          */
/*                    structure Windtab[wind]                           */
/*         void *adr_rsc: adresse de chargement de la ressource.        */
/*         int tree:      numero de l'arbre a integrer.                 */
/*         int type:      type d'arbre a integrer RSC_DIAL ou TOOL_BAR  */
/*         EVNT_O *Evnt: pointe sur structure de flux evenementiel      */
/* SORTIE: Evnt->evnt = WM_ABORT; si echec / inchang si tout est ok    */
/*         Evnt->pipe[X_B]  Evnt->pipe[H_B] initialise sur dimenssions */
/*                                         d'ouverture de la ressource  */

int WindDialogConstruct(int w_ind, void *adr_rsc, int tree, int type, 
                        EVNT_O *Evnt );

/*--------------------------- Xform_construct --------------------------*/
/* ACTION: installe un arbre de ressource dans une fenetre et l'adapte  */
/* ENTREE: int w_ind indice de notre fenetre pointe sur bonne structure */
/*                   Windtab[wind]                                      */
/*         EVNT_O *Evnt pointe sur structure de flux evenementiel       */
/* IMPORTANT:                                                           */
/*         Windtab[wind].DlgVar.AdrRsc doit deja etre initialise sur    */
/*         l'adresse de chargement de la ressource avant l'appel.       */
/*         Windtab[wind].DlgVar.type doit deja etre initialise sur      */
/*         le type de ressource avant l'appel.                          */
/*         Windtab[wind].DlgVar.NumTree doit deja etre initialise sur   */
/*         l'arbre  installer (une ressource peut comporter plusieurs  */
/*         arbres)                                                      */
/* SORTIE: les elements de DLG_VAR *dlg sont initialises sur la ressour.*/
/*         Evnt->evnt = WM_ABORT; si echec / inchang si tout est ok    */
/*         Evnt->pipe[X_B]  Evnt->pipe[H_B] initialise sur dimenssions */
/*                                         d'ouverture de la ressource  */

int Xform_construct(int w_ind, EVNT_O *Evnt);

/*--------------------------- Xform_Destruct ---------------------------*/
/* ACTION: efface tous les blocs memoires reserve par la ressource lors */
/*         de sa mise en fenetre                                        */
/* ENTREE: int w_ind indice de notre fenetre pointe sur bonne structure */
/*                   Windtab[wind]                                      */
/*         EVNT_O *Evnt pointe sur structure de flux evenementiel       */

int Xform_Destruct(int w_ind, EVNT_O *Evnt);

/*----------------------------- CloseListBox ---------------------------------*/
/* ACTION: Verifie si une LISTBOX est ouverte dans la fenetre                 */
/*         et si oui la ferme.                                                */
/* ENTREE: w_ind, indice EAZY_GEM de la fenetre conteneant le ressource.      */

void CloseListBox (int w_ind);

/*----------------------------- SetCursObEditOff------------------------------*/
/* ACTION: eteint le curseur texte des champs editables                       */
/*         Il est recommand d'utiliser cette fonction avan le redessin d'un  */
/*         editable par la fonction Xobjc_draw().                             */
/* ENTREE: DLG_VAR *dlg structure dialogue rattache  la fenetre contenant   */
/*         l'arbre de ressource dont on souhaite eteindre le curseur.         */

void SetCursObEditOff(DLG_VAR *dlg);

/* --------------------------- Lister_rectangles -------------------------- */
/* ACTION: Gestion de la liste des rectangles GEM. Cette fonction est      */
/*         utiliser en reponse au message GEM WM_REDRAW.                    */
/*         Tout le redessin d'une ressource en fenetre est pris en          */
/*         charge par cette fonction, qui gnre le message WM_PAINT si     */
/*         il est  votre charge de redessiner quelque chose.               */
/* Ce nouveau message est envoy a notre procedure de fenetre               */
/* lorsqu'il faut retracer quelque chose  l'ecran: la surface client.      */
/* La surface client est le rectangle interieur  la fenetre, au cadre      */
/* epais, et aux eventuelles ressources de bord. Cette surface peut tres    */
/* bien ne pas exister par exemple dans le cas d'une ressource occupant     */
/* toute la fenetre, et alors le message WM_PAINT n'est pas genere.         */                                               
/*                                                                          */
/* En: Evnt->pipe[X_G], Evnt->pipe[Y_G], Evnt->pipe[W_G], et                */
/*     Evnt->pipe[W_G], se trouve le rectangle de clipping                  */              
/*                      qui est dej clipp par EAZY_GEM,                   */
/* En: Evnt->pipe[X_B], Evnt->pipe[Y_B], Evnt->pipe[W_B], et                */
/*     Evnt->pipe[W_B], se trouve le rectangle de la surface                */    
/*                      client qu'il est   votre charge de                 */
/*                      redessiner                                          */
/* ENTRE : w_h handle  de la fenetre  redessiner                           */
/*         xyly pointeur sur la zone a redessiner                           */

void Lister_rectangles(int w_h, GRECT *xylh);




/*************************************************************************/
/*           F O N T I O N S   D E  M E S S A G E S   ( G E M )          */
/*************************************************************************/

/*----------------------------- Pause_EZ ----------------------------------*/
/* ACTION: permet d'introduire un delai de x dixiemes de secondes          */
/*         Cette fonction est une fonction GEM et ne doit pas etre utilisee*/
/*         dans les fonctions cdecl.                                       */
/* ENTREE: long t, delai en dixiemes de secondes.                          */

void Pause_EZ(long t);
 
/*--------------------------- Send_VA_START ---------------------------*/
/* ACTION envoie  l'application dont l'ID est appl_id, un message     */
/*        VA_START afin qu'elle charge le fichier ou se mette au       */
/*                 premier plan ou fasse un peu ce qu'elle veut        */
/* ENTREE: appl_id iddentificateur de l'application destinataire       */
/*         path chemin complet envoy  l'application                  */

void  Send_VA_START(int appl_id, char *path); 

/*--------------------------- SendMessage --------------------------*/
/* ACTION: Envoie un message simple sans paramtres                 */
/* ENTREE: int messg, message  envoyer                             */

void SendMessage(int messg);

/*--------------------------- SendGrectRedrawMessage ---------------*/
/* ACTION: ordonne  une fenetre de redessiner une portion de sa    */
/*         surface.                                                 */
/* ENTREE: int w_h, handle GEM de la fenetre cible.                 */
/*         GRECT *grect coordonnes du rectangle  redessiner.      */

void SendGrectRedrawMessage(int w_h, GRECT *grect);

/*--------------------------- SendWindRedraw -----------------------*/
/* ACTION: ordonne  une fenetre de se redessiner sur toute sa      */
/*         surface.                                                 */
/* ENTREE: int w_h, handle GEM de la fenetre  redessiner           */

void SendWindRedraw(int w_h);

/*--------------------------- SendExeFunc ------------------------------*/
/* ACTION: envoie a l'application de destination app_id, un message  */
/*         d'execution de fonction.                                  */
/* ENTREE: int app_id: identificateur GEM de l'application a qui le  */
/*                     message est destin.                          */
/*         int num_func: numero de fonction que l'on desire executer */
/*                       dans cette application .                    */
 
void SendExeFunc(int app_id, int num_func);

/*----------------------- SendObjectRedraw -------------------------*/      
/* ACTION: envoie un message de redessin sur la surface occupee par */
/*         un objet  a une fenetre                                  */
/* ENTREE: int w_h, handle GEM de la fenetre cible.                 */
/*         OBJECT *object, adresse arbre auquel appartient l'objet. */
/*         int num_ob, numro de l'objet dans cet arbre.            */

void SendObjectRedraw(int w_h, OBJECT *object, int num_ob);

/*-------------------------- SendWindMessage --------------------------*/ 
/* ACTION: permet d'envoyer  une fenetre un message quelconque avec   */
/*         4 parametres de dimensions (ou autre chose)                 */
/* ENTREE: int w_h, handle GEM de la fenetre cible.                    */
/*         int messg, message  envoyer                                */
/*         GRECT *grect 4 parametres sous forme de rectangle.          */
/*                SI grect est egal  zero le rectangle est ignor     */

void SendWindMessage(int w_h, int messg, GRECT *grect);

/*----------------------------ExeAllMessage---------------------------------*/
/* ACTION: permet d'executer tous les messages empils                      */
/*         afin d'etre sur que notre action puisse se faire apres tous les  */
/*         autres messages                                                  */

int ExeAllMessage( void );
 

/*************************************************************************/
/*           F O N T I O N S   D E   F I C H I E R S   ( G E M  )        */
/*************************************************************************/

/*---------------------------Fic_select----------------------------------*/
/* ACTION: appelle le selecteur d'objet et met  jour le chemin d'entree */
/*         et le nom de fichier, si le fichier est valide et confirmer.  */
/* ENTREE: char *path_in, path d'entree de la forme A:\PATH\             */
/*         char *nom_in, nom du fichier de la forme  NOM_FIC.EXT         */
/*         char *ext, extension                                          */
/*         char *mess message d'information  afficher.                  */
/* RETOUR:                                                               */
/* <- longueur du fichier si zero fichier vide                           */   
/*                        si -1L     mauvaise extension                  */  
/*                        si -2L;    option annuler cliquee              */
/*                        si -3L;    ce Fichier n'existe pas             */
/* <- path eventuellement modifie (si Len_fic>0)                         */
/* <- nom eventuellement modifie  (si Len_fic>0)                         */

long Fic_select (char *path_in, char *nom_in, char *ext, char *mess);

/*---------------------- GetPathAppli ----------------------------------*/
/*  ACTION: cherche le path de demarrage de l'application  partir de   */
/*          son nom, eventuellement retourne le nom du fichier avec     */
/*          lequel le programme est demarr                             */
/* ENTREE:  nom_appli = NOM_PRG.PRG nom du programme cherch            */
/* SORTIE:  path  chemin A:\UPSIS\ dans lequel se trouve le programme   */
/*          fic_auto si non NUL il sera retourne le nom du fichier      */
/*                   eventuellement depose sur le programme au depart   */          
/* RETOUR: 0 si pas de fichier associe au lancement du programme        */
/*         1 si fichier associe au demarrage                            */

int GetPathAppli(char *path, char *nom_appli, char *fic_auto);

/*--------------------------- FindFicSys --------------------------------*/
/* ACTION: cherche le fichier nom, d'abord au niveau du repertoire       */
/*         path, puis au niveau du repertoire path\nom_appli.SYS puis au */
/*         niveau du repertoire path\nom_appli.RSC                       */
/* ENTREE: path = "A:\PATH\" chemin ou doit commencer la recherche       */
/*         nom_appli = "NOMPRG.PRG" nom de l'application                 */
/*         nom       = "NOMFIC.FIC" nom du fichier  chercher            */
/* RETOUR: <0 si pas trouve  >=0 si trouve                               */
/*         path contient le chemin "A:\PATH\" de dcouverte              */

long FindFicSys(char *path, char *nom_appli, char *nom);  

/*************************************************************************/
/*           F O N T I O N S   D E   F I C H I E R S   ( G E M D O S  )  */
/*************************************************************************/

/*---------------------- PathNomToNomFic -------------------------------*/
/* ACTION: extrait le nom du fichier  partir du nom complet du path    */
/* ENTREE: path = A:\DOSSIER\NOM.FIC                                    */
/* SORTIE: nom  = NOM.FIC                                               */
/*         path = A:\DOSSIER\                                           */
/* RETOUR: adresse de nom                                               */              
                           
char *PathNomToNomFic(char *path, char *nom);

/*--------------------------- Enleve_ext -------------------------------*/
/* ACTION: enleve l'extension  nom de fichier passe en entree.          */
/* ENTREE: char *nom, pointe sur le nom du fichier.                     */
/* RETOUR: un char* pointant sur le nom modifie                         */

char *Enleve_ext(char *nom);

/*---------------------Epure_path---------------------------------------*/
/* ACTION:  enleve au path l'eventuel "*.EXT"                           */
/* ENTREE: char *path, chaine  traiter           A:\PATH\*.EXT         */
/* RETOUR: un char* pointant sur chaine traite   A:\PATH\              */

char *Epure_path(char *path);

/*----------------------Fic-exist ---------------------------------------*/
/* ACTION: retourne la longueur d'un fichier, ou -1L si n'existe pas     */
/*         avec message Alert si il n'existe pas                         */
/*         les paths d'entree ne sont pas modifis                       */
/* ENTREE: char *path_in, path d'entree de la forme A:\PATH\             */
/*         char *nom_in, nom du fichier de la forme  NOM_FIC.EXT         */
/* RETOUR: longueur du fichier si il existe                              */
/*        -1 si il n'existe pas                                          */

long Fic_exist(char *path, char *nom);

/*--------------------------- FicLen ------------------------------------*/
/* ACTION: retourne la longueur d'un fichier, ou -1L si n'existe pas     */
/*         avec message Alert si il n'existe pas                         */
/*         les paths d'entree ne sont pas modifis                       */
/* ENTREE: char *path_in, path d'entree de la forme A:\PATH\             */
/*         char *nom_in, nom du fichier de la forme  NOM_FIC.EXT         */
/* RETOUR: longueur du fichier si il existe                              */
/*        -1 si il n'existe pas                                          */

long FicLen(char *path, char *nom);

/*---------------------------Bload--------------------------------------*/
/* ACTION: Charge un fichier a l'adresse specifiee en entree.           */
/* ENTREE: char *path_in, path d'entree de la forme A:\PATH\            */
/*         char *nom_in, nom du fichier de la forme  NOM_FIC.EXT        */
/* SORTIE: adresse memoire situee apres le dernier octet charge.        */
/*         (si egale a l'adresse de chargement c'est qu'il il n'y a     */
/*          rien de charge donc erreur.)                                */

void  *Bload( char *path, char *name, void *adr_load);

/*------------------------- Bsave --------------------------------------*/
/* ACTION: Sauve dans un fichier dont le nom et le path sont specifies  */
/*         un bloc memoire situe  l'adresse adr_src et de longueur len */
/*         si le fichier existait auparavant, il est detruit.           */
/* ENTREE: char *path_in, path d'entree de la forme A:\PATH\            */
/*         char *nom_in, nom du fichier de la forme  NOM_FIC.EXT        */
/*         void *adr_src, adresse de la zone memoire a sauver.          */
/*         size_t len, longueur de memoire a sauver.                    */
/* SORTIE: long positif, tout est OK. (nbr d'octets lus)                */
/*         Negatif: -300 ce fichier existait deja et n'a pu etre efface */
/*                  -301 impossible d'ouvrir le fichier.                */
/*                  autres nbr. negatifs = GEMDOS ERROR                 */

long Bsave(char *path_in, char *nom_in, void *adr_src, size_t len);           
/*************************************************************************/
/*           F O N T I O N S   D E   T R A N S F O R M A T I O N         */
/*************************************************************************/      
            
/*-------------------- VRECT_to_GRECT ------------------------------------*/ 
/* ACTION: transforme un rectangle VDI en rectangle GEM                   */
/* ENTREE: VRECT *vrect, pointe sur le rectangle VDI.                     */
/*         GRECT *grect, pointe sur le rectangle GEM.                     */
/* SORTIE: GRECT *grect, est initialis sur les valeurs transformes.     */
/* RETOUR: un pointeur sur le rectangle GRECT *grect, de l'entree.        */

GRECT *VRECT_to_GRECT(VRECT *vrect, GRECT *grect);            
            
/*-------------------- GRECT_to_VRECT ------------------------------------*/ 
/* ACTION: transforme un rectangle GEM en rectangle VDI                   */
/* ENTREE: GRECT *grect, pointe sur le rectangle GEM.                     */
/*         VRECT *vrect, pointe sur le rectangle VDI.                     */
/* SORTIE: VRECT *vrect, est initialis sur les valeurs transformes.     */
/* RETOUR: un pointeur sur le rectangle VRECT *vrect, de l'entree.        */

VRECT *GRECT_to_VRECT(GRECT *grect,VRECT *vrect);            
                        
/*-----------------------AdjustXYGrectToScreen -----------------------------*/
/* ACTION: rajuste les coordones du rectangle GRECT de faon  ce qu'il */
/*         soit centr sur x et y et qu'il tienne dans l'ecran            */
/* ENTREE: int x,int y, coordonnes du centre souhait du rectangle.      */
/*         GRECT *grect, pointe sur le rectangle GEM recentrer.           */
/* SORTIE: GRECT *grect, est initialis sur les valeurs transformes.     */

void AdjustXYGrectToScreen (int x, int y, GRECT *grect);

/*---------------------------- AdjustGrectToGrect ------------------------*/
/* ACTION: ajuste les coordonnes du rectangle grect, de faon  ce qu'il */
/*         tienne dans le rectangle limit_grect.                          */
/* ENTREE: GRECT *limit_grect: rectangle dans lequel il faut faire tenir  */
/*                             le rectangle grect.                        */
/*         GRECT *grect: rectangle dont il faut eventuellement reajuster  */
/*                       la position.                                     */
/* RETOUR: GRECT * pointe sur le rectangle reajust.                      */

GRECT *AdjustGrectToGrect(GRECT *limit_grect, GRECT *grect);

/*----------------------- Rc_intersect ------------------------------------*/
/* ACTION: calcule l'intersection de deux rectangles entre eux et retourne */ 
/*         TRUE si il ya intersection et FALSE si pas d'intersection       */
/* ENTREE: r1 pointe sur premier rectangle.                                */
/*         r2 pointe sur deuxieme rectangle.                               */
/* RETOUR: retourne TRUE si intersection et FALSE si pas d'intersection    */
/*         r2 est modifie en rectangle intersectant resultant.             */

int Rc_intersect(GRECT *r1,GRECT *r2);			

/*---------------------------- NumSelToTrame --------------------------------*/
/* ENTREE:un nombre compris entre 0 et 39                                    */
/*        representant tous les types possibles de trames systemes atari     */
/*        selon la valeur passee dans le parametre sel le remplissage des    */
/*        objets sera le suivant:                                            */
/*        si zero pas de remplissage les objets sont de type ligne           */
/*        si 1  c'est la couleur du fond d'indice zero (blanc) (trame unie)  */
/*        si 2  c'est la couleur en cours qui remplit l'objet  (trame unie)  */
/*        si 3   26  c'est le premier groupe de trame GEM                   */
/*        si 27  38  c'est le deuxieme groupe de trame GEM                  */
/* SORTIE: int *type et int *trame sont positionnes sur les bonnes valeurs  */
/*         pour faire vsf_style (VDIhandle, type);    suivi de               */
/*                    vsf_interior(VDIhandle, trame); afin de positionner    */
/*                    les atributs de traage sur les bonnes valeurs         */ 

void NumSelToTrame(int sel, int *type, int *trame);

/*---------------------------- TrameToNumSel --------------------------------*/
/* ACTION: transforme deux nombres diffrents reprsentant, le type VDI de   */
/*         remplissage correspondant aux fonctions: vsf_interior  () et      */
/*                                                  vsf_style()              */
/*         en un indice de liste, permettant de pointer sur une LISTBOX de   */
/*         trames.                                                           */   
/* ENTREE: int type correspond  la fonction  vsf_interior() et peut prendre */
/*                  les valeurs suivantes FIS_HOLLOW/0  FIS_SOLID/1          */
/*                  FIS_PATERN/2 FIS_HATCH/3 FIS_USER/4                      */
/*         int trame correspond  la fonction  vsf_style()                   */
/* SORTIE: un nombre compris entre 0 et 40                                   */ 

int TrameToNumSel(int type, int trame);

/*------------------------------ ScanToAscii --------------------------*/
/* ACTION: retourne  partir du scan code et de l'tat des touches     */
/*         ALTERNATE, CONTROL, SHIFT le caractre ASCII.               */
/* ENTREE: int scan, scan code de la touche clavier.                   */
/*         int state, etat des touches ALTERNATE, CONTROL, SHIFT       */
/* RETOUR: un int, qui est le code ASCII de la touche clavier.         */

int ScanToAscii(int scan, int state);   

/*------------------------- StrTrimEnd ---------------------------------*/
/* ACTION: enleve les espaces de fin de chaine.                         */
/* ENTREE: char *str:                                                   */
/*             pointe sur la chaine de caracteres  traiter.            */
/* RETOUR: char*: un pointeur sur cette chaine traitee.                 */               

char *StrTrimEnd(char *str);

/*---------------------------- StrTrimDeb ------------------------------*/
/* ACTION: recherche le premier caractere non espace d'une chaine       */
/*         en partant de son debut.                                     */
/* ENTREE: char *str:                                                   */
/*             pointe sur la chaine de caracteres  traiter.            */
/* RETOUR: char*: un pointeur sur le premier caractere non espace de la */
/*             chaine.                                                  */

char *StrTrimDeb(char *pt);

/*************************************************************************/
/*           F O N T I O N S   D ' O B J E T S    E T E N D U S          */
/*************************************************************************/           
                     
/*------------------------------ ActiveOnglet --------------------------------*/
/* ACTION: active un des dialogues d'une boite  onglet                       */
/* ENTREE: int w_ind,  indice EAZY_GEM de la fenetre contenant le dialogue    */
/*         int ob_onglet, numero d'objet de la boite  onglets                */
/*         int next_dial, numero du dialogue d'onglet  activer               */
/* SORTIE: neant                                                              */
void ActiveOnglet(int w_ind, int ob_onglet, int next_dial);     

/*--------------------------- SetListCallBackFunc ----------------------------*/
/* ACTION: Cette  fonction  permet de modifier la fonction d'affichage  d'une */
/*         LIST_BOX, ou d'une SCROLLBOX.                                      */
/* ENTREE: Dans le parametre:  OBJECT *tree l'on  place l'adresse de l'arbre  */
/*                             ou se situe la LISTBOX,                        */
/*         Dans le paramtre: int   ind_ob l'on  place l'indice  de l'objet   */
/*                            correspondant  la LIST_BOX.                    */
/*         Dans le paramtre: void *func l'on  place l'adresse de la fonction */
/*                            devant afficher les cases de la LISTBOX. Cette  */
/*                            fonction doit bien sur etre ecrite par vous.    */
/* RETOUR: l'adresse de l'ancienne fonction de gestion.                       */                                                   
                         
void *SetListCallBackFunc ( OBJECT *tree, int   ind_ob, void *func ); 

/*--------------------------- SetScrollBoxParam ------------------------------*/     
/* ACTION: Cette fonction permet de modifier les parametres de fonctionnement */
/*         la SCROLBOX.                                                       */
/*         Si vous fournissez la valeur -2, pour une valeur de parametre, le  */
/*         parametre correspondant ne sera pas modifi.                       */
/* ENTREE: Dans le parametre: OBJECT *tree l'on  place l'adresse de l'arbre   */
/*                            ou se situe la SCROLBOX,                        */
/*         Dans le paramtre: int   ind_ob l'on  place l'indice  de l'objet   */
/*                            correspondant  la SCROLBOX.                    */                                
/*         Dans le paramtre: int  LgnH  hauteur en pixels d'une ligne de     */
/*                             scrolling c'est de cette distance dont scrolle */
/*                             en vertical la boite.                          */
/*         Dans le paramtre: int  ClnW  largeur en pixels d'une colonne      */
/*                            scrolling  c'est de cette distance dont scrolle */
/*                            en horizontal la boite.                         */
/*         Dans le paramtre: int NbLgn nombre de lignes total (hauteur totale*/
/*                            du document / LgnH ).                           */
/*         Dans le paramtre: int NbCln nombre de colonnes total (largeur     */
/*                            totale du document / ClnW ).                    */     
/*         Dans le paramtre: int FstLgn indice de la ligne de scrolling     */
/*                            placer en haut e la boite  (offset d'affichage  */ 
/*                            vertical).                                      */
/*         Dans le paramtre: int FstCln indice de la colonne de scrolling   */
/*                            placer  droite de la boite  (offset d'affichage*/ 
/*                            horizontal).                                    */     
/*         Dans le paramtre: int LgnSlct indice de la ligne document         */
/*                            slectionne.                                   */
/*         Dans le paramtre: int ClnSlct indice de la colonne document       */
/*                            slectionne.                                   */
/*         Dans le paramtre: void *SclBoxParam  l'on  peut  placer  ce  que  */
/*                            l'on veut, une adresse de donnes, ou tout autre*/
/*                            chose. Ce  paramtre est transmis  la fonction */
/*                            d'affichage de la SCROLBOX.                     */
/*         Dans le paramtre: int Do, l'on  peut  placer une valeur qui       */
/*                            modifiera le comportement de la sroll_box lors  */
/*                            d'un affichages: si LST_DRAW elle sera dessinee */
/*                                             normalement.                   */
/*                                             si LST_NODRAW elle ne sera pas */
/*                                             redessinee.                    */                 
/* RETOUR: 0 erreur (ce n'est pas une SCROLBOX)                               */
/*         1 tout est Ok                                                      */     

int SetScrollBoxParam 
      ( 
        OBJECT *tree,      /* adresse de l'arbre ou se trouve la SCROLBOX     */
        int ind_ob,        /* indice de l'objet dans l'arbre                  */
        int LgnH,          /* hauteur en pixels d'une ligne de scrolling      */
        int ClnW,          /* largeur en pixels d'une colonne scrolling       */
        int NbLgn,         /* Nombre total de lignes document                 */     
        int NbCln,         /* nombre total de colonnes document               */
        int FstLgn,        /* indice ligne document  afficher en 1er         */ 
        int FstCln,        /* indice colonne document  afficher  gauche     */
        int LgnSlct,       /* ligne selectionne ( mettre en surbrillance)   */ 
        int ClnSlct,       /* colonne selectionne ( mettre en surbrillance) */
        void *SclBoxParam, /* paramtre optionnel  type de pointeur          */    
        int Do             /* parametre d'action                              */
      );  
                 
/*--------------------------- GetScrollBoxParam ------------------------------*/     
/* ACTION: Cette fonction permet de modifier les parametres de fonctionnement */
/*         la SCROLBOX.                                                       */
/*         Si vous fournissez la valeur 0, pour une adresse de parametre, le  */
/*         parametre correspondant ne sera pas retourn.                      */
/* ENTREE: Dans le parametre: OBJECT *tree l'on  place l'adresse de l'arbre   */
/*                            ou se situe la SCROLBOX,                        */
/*         Dans le paramtre: int ind_ob l'on doit placer l'indice de l'objet */
/*                            correspondant  la SCROLBOX.                    */                                
/* SORTIE:                                                                    */
/*         Dans le paramtre: int *LgnH on reoit la hauteur en pixels d'une  */
/*                            ligne de scrolling c'est de cette distance dont */
/*                            scrolle en vertical la boite.                   */
/*         Dans le paramtre: int *ClnW  on reoit la largeur en pixels d'une */
/*                            colonne scrolling  c'est de cette distance dont */
/*                            scrolle en horizontal la boite.                 */
/*         Dans le paramtre: int *NbLgn l'on reoit le nombre de lignes total*/
/*                            (hauteur totale du document / LgnH ).           */
/*         Dans le paramtre: int *NbCln on reoit le nombre de colonnes total*/
/*                            (largeur totale du document / ClnW ).           */     
/*         Dans le paramtre: int *FstLgn l'on reoit l'indice de la ligne de */
/*                            scrolling  placer en haut e la boite  (offset  */ 
/*                            d'affichage vertical).                          */
/*         Dans le paramtre: int *FstCln on reoit l'indice de la colonne de */
/*                            scrolling  placer  droite de la boite  (offset*/ 
/*                            d'affichage horizontal).                        */     
/*         Dans le paramtre: int *LgnSlct l'on reoit l'indice de la ligne   */
/*                            document slectionne.                          */
/*         Dans le paramtre: int *ClnSlct l'on reoit indice de la colonne   */
/*                            document slectionne.                          */
/*         Dans le paramtre: long *SclBoxParam l'on reoit le parametre      */
/*                            optionnel.                                      */
/*         Dans le paramtre: int *NbCase l'on reoit le nombre de lignes     */
/*                            affichables dans la scrollbox                   */
/* RETOUR: 0 erreur (ce n'est pas une SCROLBOX)                               */
/*         adresse de la structure TEDINFO de cet objet                       */     

TEDINFO *GetScrollBoxParam 
      ( 
        OBJECT *tree,       /* adresse de l'arbre ou se trouve la SCROLBOX     */
        int ind_ob,         /* indice de l'objet dans l'arbre                  */
        int *LgnH,          /* hauteur en pixels d'une ligne de scrolling      */
        int *ClnW,          /* largeur en pixels d'une colonne scrolling       */
        int *NbLgn,         /* Nombre total de lignes document                 */     
        int *NbCln,         /* nombre total de colonnes document               */
        int *FstLgn,        /* indice ligne document  afficher en 1er         */ 
        int *FstCln,        /* indice colonne document  afficher  gauche     */
        int *LgnSlct,       /* ligne selectionne ( mettre en surbrillance)   */ 
        int *ClnSlct,       /* colonne selectionne ( mettre en surbrillance) */
        long *SclBoxParam,  /* paramtre optionnel  type de pointeur          */          
        int *NbCase         /* nbr de cases afichables                         */     
      );
 
/*---------------------------- DoScrollBoxSlide ------------------------------*/     
/* ACTION: Cette fonction permet de modifier faire scroller la SCROLBOX, d'une*/
/*         certaine quantit de lignes en horizontal ou vertical.             */
/*         Si vous fournissez une valeur ngative le sens est vers le haut et */
/*         et la droite.                                                      */
/* ENTREE: Dans le parametre: OBJECT *tree l'on  place l'adresse de l'arbre   */
/*                            ou se situe la SCROLBOX,                        */
/*         Dans le paramtre: int ind_ob l'on doit placer l'indice de l'objet */
/*                            correspondant  la SCROLBOX.                    */                                
/*         Dans le paramtre: int n_vert nbr de lignes verticales  scroller. */
/*         Dans le paramtre: int n_hori nbr de lignes horizontales  scroller*/
/*                            colonne scrolling  c'est de cette distance dont */
/*         Dans le paramtre: GRECT *clip_grect il doit etre donn            */
/*                            rectangle de clipping.                          */
/* RETOUR: 0 erreur (ce n'est pas une SCROLBOX)                               */
/*         1 tout est Ok                                                      */   

int DoScrollBoxSlide 
     ( 
      OBJECT *tree,      /* adresse de l'arbre ou se trouve la SCROLBOX     */
      int ind_ob,        /* indice de l'objet dans l'arbre                  */
      int n_vert,        /* nombre de lignes  scroller                     */
      int n_hori,        /* nombre de colonnes  scroller                   */
      GRECT *clip_grect  /* rectangle de clipping                           */
     );

/*---------------------------- XYToScrollBoxItem -------------------------*/
/* ACTION: Retourne la ligne cliquee dans la SCROLLBOX.                   */
/* ENTREE: OBJECT *object, pointe sur le prem. objet de l'arbre d'objets  */
/*                         ou se trouve l'objet.                          */
/*         int ob_ind, indice de l'objet SCROLLBOX clique dans cet arbre.  */
/*         int x, int y, coordonnees X & Y de la souris                   */
/* SORTIE: int, ligne cliquee (option base 0) de la SCROLLBOX.            */

int XYToScrollBoxItem(OBJECT *object, int ob_ind, int x, int y);

/*------------------------------ VascPosAdjust ---------------------------------------------*/
/* ACTION: calcule la position de l'ascenseur vertical d'une SCROLLBAR  partir des donnes */
/*         d'un objet de type SCROLLBOX.                                                    */
/* ENTREE: OBJECT *object:                                                                  */
/*            pointe sur le premier objet (objet racine) de l'arbre ou sont contenus les    */
/*            autres objets.                                                                */
/*         int ob_scroll: numero ou indice de l'objet SCROLLBOX dans cet arbre.             */
/*         int ob_Vbar:   numero ou indice de l'objet SCROLLBAR dans cet arbre.             */
/*                        une SCROLLBAR est un objet contenant un objet fils ascenseur.     */
/* RETOUR: int: position y de l'ascenseur. (en relatif  la SCROLLBAR ob_Vbar).             */

int VascPosAdjust(OBJECT *object, int ob_scroll, int ob_Vbar);

/*------------------------------ VascHeightAdjust ------------------------------------------*/
/* ACTION: calcule la taille de l'ascenseur vertical d'une SCROLLBAR  partir des donnes   */
/*         d'un objet de type SCROLLBOX. La donne: scrollboxblk->FstLgn est si besoin      */
/*         ajuste de facon  etre coherente, ainsi que la position verticale ascenseur.    */
/* ENTREE: OBJECT *object:                                                                  */
/*            pointe sur le premier objet (objet racine) de l'arbre ou sont contenus les    */
/*            autres objets.                                                                */
/*         int ob_scroll: numero ou indice de l'objet SCROLLBOX dans cet arbre.             */
/*         int ob_Vbar:   numero ou indice de l'objet SCROLLBAR dans cet arbre.             */
/*                        une SCROLLBAR est un objet contenant un objet fils ascenseur.     */
/* RETOUR: int: position y de l'ascenseur. (en relatif  la SCROLLBAR ob_Vbar).             */

int VascHeightAdjust(OBJECT *object, int ob_scroll, int ob_Vbar);

/*------------------------ Scroll_window -------------------------------*/
/* ACTION: fait scroller le rectangle de fenetre specifie, et redessine */
/*         en faisant appel  la fonction de fenetre, la partie         */
/*         decouverte.                                                  */
/* ENTREE: int w_ind: indice EAZY_GEM de la fenetre dont il faut faire  */
/*                    sroller une partie.                               */
/*         GRECT *scrol_grect: coordonnes de la zone rectangulaire a   */
/*                             faire scroller.                          */
/*         int dir: egal  HORIZONTAL, VERTICAL (sens de scrolling).    */
/*         long delta: quantite  faire scroller si  <0 dans un sens,   */
/*                     si >0 dans l'autre.                              */ 

void Scroll_window (int w_ind, GRECT *scrol_grect, int dir, long delta);


/*---------------------------- SlidePosToDocPos ------------------------*/
/* ACTION: calcul de la nouvelle position document  partir de la       */
/*         position souris sur l'assenceur.                             */
/* ENTREE: OBJECT *object, int ob_Vbar objet de type SLIDEBAR c.a.d.    */
/*         barre de scroll avec en fils un assenceur (slide)            */
/*         unsigned long doc_total, taille totale du document.          */
/*         unsigned long doc_view, taille representable du document dans*/
/*                                 la fenetre de visualisation.         */
/*         unsigned long doc_pos, ofset d'affichage du document par     */
/*                                rapport a son debut.(en fait c'est le */
/*                                premier element affich).             */  
/*         int pos_mouse,         position de la souris.                */
/*         int scrolcoef,  coefficient de scrolling minimum.            */
/*         int mode, HORIZONTAL ou VERTICAL indique le type de barre de */
/*                   SLIDEBAR a laquelle l'on a affaire.                */
/* RETOUR: un long qui la nouvelle position document.                   */

long SlidePosToDocPos(OBJECT *object, int ob_Vbar,
                      unsigned long doc_total, 
                      unsigned long doc_view,
                      unsigned long doc_pos, 
                      int pos_mouse,
                      int scrolcoef,
                      int mode);
                      
/*---------------------------- SetSlideWidth ---------------------------*/
/* ACTION: calcul de la largeur d'un assenceur  partir des donnes du   */
/*         document.                                                    */
/* ENTREE: OBJECT *object, int ob_Vbar objet de type SLIDEBAR c.a.d.    */
/*         barre de scroll avec en fils un assenceur (slide)            */
/*         unsigned long doc_total, taille totale du document.          */
/*         unsigned long doc_view, taille representable du document dans*/
/*                                 la fenetre de visualisation.         */
/*         unsigned long doc_pos, ofset d'affichage du document par     */
/*                                rapport a son debut.(en fait c'est le */
/*                                premier element affich).             */  
/*         int min_slide,  taille minimum de l'assenceur.               */
/*         int mode, HORIZONTAL ou VERTICAL indique le type de barre de */
/*                   SLIDEBAR a laquelle l'on a affaire.                */
/* RETOUR: un long qui la nouvelle position document.                   */

long SetSlideWidth(OBJECT *object, int ob_Vbar, 
                  unsigned long doc_total, 
                  unsigned long doc_view, 
                  unsigned long doc_pos,
                  int min_slide,
                  int mode);
                                        
/*---------------------------- DocPosToSlidePos ------------------------*/
/* ACTION: calcul de la position d'un assenceur  partir des donnes du  */
/*         document.                                                    */
/* ENTREE: OBJECT *object, int ob_Vbar objet de type SLIDEBAR c.a.d.    */
/*         barre de scroll avec en fils un assenceur (slide)            */
/*         unsigned long doc_total, taille totale du document.          */
/*         unsigned long doc_view, taille representable du document dans*/
/*                                 la fenetre de visualisation.         */
/*         unsigned long doc_pos, ofset d'affichage du document par     */
/*                                rapport a son debut.(en fait c'est le */
/*                                premier element affich).             */  
/*         int mode, HORIZONTAL ou VERTICAL indique le type de barre de */
/*                   SLIDEBAR a laquelle l'on a affaire.                */
/* RETOUR: un int qui le nombre de pixels dont s'est deplace            */
/*         l'ascenseur                                                  */  
                     
int DocPosToSlidePos(OBJECT *object, int ob_Vbar,                     
                     unsigned long doc_total, 
                     unsigned long doc_view,
                     unsigned long doc_pos, 
                     int mode);

/*--------------------------- SetScrollTxtParam ------------------------------*/     
/* ACTION: Cette fonction permet de modifier les parametres de fonctionnement */
/*         la SCROLTEXT.                                                      */
/*         Si vous fournissez la valeur -2, pour une valeur de parametre, le  */
/*         parametre correspondant ne sera pas modifi.                       */
/* ENTREE: Dans le parametre: OBJECT *tree l'on  place l'adresse de l'arbre   */
/*                            ou se situe la SCROLTEXT,                       */
/*         Dans le paramtre: int   ind_ob l'on  place l'indice  de l'objet   */
/*                            correspondant  la SCROLTEXT.                   */                                
/*         Dans le paramtre: int  Clr  l'on  place la couleur du texte.      */
/*         Dans le paramtre: int Pts   l'on  place la taille du texte.       */
/*         Dans le paramtre: int Fnt   l'on  place l ID de la fonte.         */
/* RETOUR: 0 erreur (ce n'est pas une SCROLTEXT)                              */
/*         1 tout est Ok                                                      */ 

int SetScrollTxtParam 
      ( 
        OBJECT *tree,      /* adresse de l'arbre ou se trouve la SCROLBOX     */
        int ind_ob,        /* indice de l'objet dans l'arbre                  */                
        int Clr,           /* couleur du texte                                */ 
        int Pts,           /* taille en point du texte                        */
        int Fnt            /* Police de caractere                             */             
      );

/*--------------------------- GetScrollTxtParam ------------------------------*/     
/* ACTION: Cette fonction permet de recuperer les parametres de fonctionnement*/
/*         la SCROLTEXT.                                                      */
/* ENTREE: Dans le parametre: OBJECT *tree l'on  place l'adresse de l'arbre   */
/*                            ou se situe la SCROLTEXT,                       */
/*         Dans le paramtre: int   ind_ob l'on  place l'indice  de l'objet   */
/*                            correspondant  la SCROLTEXT.                   */                                
/* SORTIE:                                                                    */
/*         Dans le paramtre: int *Clr   l'on  reoit la couleur du texte.    */
/*         Dans le paramtre: int *Pts   l'on  reoit la taille du texte.     */
/*         Dans le paramtre: int *Fnt   l'on  reoit l'ID VDI de la fonte.   */
/* RETOUR: 0 erreur (ce n'est pas une SCROLTEXT)                              */
/*         adresse de la structure SCROLL_TXT_PRM                             */     
/* RAPPEL:                                                                    */
/*     typedef struct                                                         */
/*        { int Type;          type de donnes  afficher                     */
/*          char *txt;         adresse du texte                               */
/*          char **PtLgnTab;   adr. du tableau de pointeurs de lignes texte   */        
/*          int Pts;           taille en points des caractres                */
/*          int Color;         couleur des caractres                         */
/*          long FontId;       ID VDI de la police a employer pour l'affichage*/
/*        } SCROLL_TXT_PRM;                                                   */

SCROLL_TXT_PRM *GetScrollTxtParam 
      ( 
        OBJECT *tree,      /* adresse de l'arbre ou se trouve la SCROLBOX     */
        int ind_ob,        /* indice de l'objet dans l'arbre                  */                
        int *Clr,           /* couleur du texte                               */ 
        int *Pts,           /* taille en point du texte                       */
        int *Fnt            /* Police de caractere                            */             
      );

/*--------------------------- SetListBoxParam --------------------------------*/     
/* ACTION: Cette fonction permet de modifier les parametres de fonctionnement */
/*         la LIST_BOX.                                                       */
/*         Si vous fournissez la valeur -2, pour une valeur de parametre, le  */
/*         parametre correspondant ne sera pas modifi.                       */
/* ENTREE: Dans le parametre: OBJECT *tree l'on  place l'adresse de l'arbre   */
/*                            ou se situe la LISTBOX,                         */
/*         Dans le paramtre: int   ind_ob l'on  place l'indice  de l'objet   */
/*                            correspondant  la LIST_BOX.                    */
/*         Dans le paramtre: int   select l'on  place le numero de l'lment */
/*                            de la  liste    reprsenter devant etre affich*/
/*                            dans la case de slection (premier lment de la*/
/*                            LISTBOX).                                       */
/*         Dans le paramtre: int first, l'on place le numero de l'lment de */
/*                            la liste  reprsenter,devant etre affich dans */
/*                            la premire  case de liste (celle situe sousla */
/*                            case de slection, soit le deuxime  lment de */
/*                            la LISTBOX).                                    */
/*         Dans le paramtre: int nbcases l'on  place le nombre d'lments que*/
/*                            doit comporter la  LISTBOX, y compris la case de*/
/*                            slection.                                      */
/*         Dans le paramtre: int nb_item l'on place le nombre d'lments     */
/*                            de la liste  reprsenter.                      */
/*         Dans le paramtre: int h_lign l'on  place la hauteur d'une case de */
/*                            la  LISTBOX.                                    */
/*         Dans le paramtre: void *LstBoxParam l'on peut placer ce que l'on  */
/*                            veut, une adresse de donnes, ou tout autre     */
/*                            chose. Ce  paramtre est transmis  la fonction */
/*                            d'affichage de la LISTBOX.                      */
/* RETOUR: 0 erreur (ce n'est pas une LISTBOX)                                */
/*         1 tout est Ok                                                      */
                                               
int SetListBoxParam 
     ( OBJECT *tree,
       int   ind_ob,
       int select,
       int first,
       int nbcases,
       int nb_item,
       int h_lign,   
       void *LstBoxParam    
     );

/*------------------------GetSelectedListBoxItem------------------------------*/
/* ACTION: cette fonction permet d'obtenir l'indice (base 0) de l'element     */
/*         selectionne dans une LISTBOX, cet indice pointe donc sur une       */
/*         donnee de la liste.                                                */
/* ENTREE: Dans le parametre:  OBJECT *tree l'on  place l'adresse de l'arbre  */
/*                             ou se situe la LISTBOX,                        */
/*         Dans le paramtre: int   ind_ob l'on  place l'indice  de l'objet   */
/*                            correspondant  la LIST_BOX.                    */
/* RETOUR: indice (base 0) de l'element selectionne dans une LISTBOX, cet     */
/*         indice pointe donc sur une donnee de la liste. C'est cette donne  */
/*         qui doit etre affichee dans la boite de selection.                 */
                                                 
int GetSelectedListBoxItem(OBJECT *object, int ind);

/*--------------------------- GetListBoxParam --------------------------------*/     
/* ACTION: Cette  fonction  permet d'obtenir les parametres de fonctionnement */
/*         la LIST_BOX.                                                       */
/*         Si vous fournissez la valeur 0, pour une adresse de parametre, le  */
/*         parametre correspondant ne sera pas retourn.                      */
/* ENTREE: Dans le parametre:  OBJECT *tree l'on  place l'adresse de l'arbre  */
/*                             ou se situe la LISTBOX,                        */
/*         Dans le paramtre: int   ind_ob l'on  place l'indice  de l'objet   */
/*                            correspondant  la LIST_BOX.                    */
/* SORTIE:                                                                    */
/*         Dans le paramtre: int *select, l'on reoit le numero de l'lment */
/*                            de la  liste    reprsenter devant etre affich*/
/*                            dans la case de slection (premier lment de la*/
/*                            LISTBOX).                                       */
/*         Dans le paramtre: int *first, l'on  reoit le numero de l'lment */
/*                            de la liste  reprsenter,devant etre affich   */
/*                            dans la premire  case  de  liste (celle situe */
/*                            sous la case de slection, soit le deuxime     */
/*                            lment  de la LISTBOX).                        */
/*         Dans le paramtre: int *nbcases, l'on reoit le nombre d'lments  */
/*                            que doit comporter la  LISTBOX, y compris la    */
/*                            case de slection.                              */
/*         Dans le paramtre: int *nb_item, l'on reoit le nombre d'lments  */
/*                            de la liste  reprsenter.                      */
/*         Dans le paramtre: int *h_lign, l'on reoit la hauteur d'une case  */
/*                            la  LISTBOX.                                    */
/*         Dans le paramtre: long *LstBoxParam, l'on reoit le parametre     */
/*                            optionnel.                                      */
/* RETOUR: 0 erreur (ce n'est pas une LISTBOX)                                */
/*         1 tout est Ok                                                      */

int GetListBoxParam 
     ( OBJECT *tree,
       int   ind_ob,
       int *select,
       int *first,
       int *nbcases,
       int *nb_item,
       int *h_lign,   
       long *LstBoxParam    
     );

/*------------------------------ XYToListBoxItem -------------------------------*/
/* ACTION: si une listbox est ouverte dans la fenetre, il est recherche l'item  */
/*         pointe par la souris.                                                */
/* ENTREE: int w_ind: indice EAZY_GEM de la fenetre contenant la LISTBOX        */
/*         int x, int y: position de la souris.                                 */
/* RETOUR: int: si -1 pas d'item pointe, si >=0 item point dans liste.         */

int XYToListBoxItem( int w_ind, int x, int y);


/*---------------------- AdaptListBoxToWindHeight -----------------------*/
/* ACTION: adapte une LISTBOX de maniere a ce qu'elle occupe toute la    */
/*         la hauteur d'une fenetre dont les dimenssions exterieures     */
/*         donnees (ou pas) dans les limites fixees par maxcases.        */
/* ENTREE: int w_ind, indice EAZY_GEM de la fenetre ou se trouve la      */
/*                    LISTBOX.                                           */
/*         int ob_list, indice de l'objet LISTBOX dans l'arbre de        */
/*                      ressource de la fenetre.                         */
/*         int maxcases, Maximum de cases que l'on autorise.             */
/*         GRECT *ext_grect, rectangle exterieur de la fenetre.          */
/*                           Si 0 la fonction utilise le dernier que la  */
/*                                la fenetre a stocke dans sa structure  */
/*                                de fenetre: Windtab[w_ind].GemWorkGrect*/
/*                           Sinon c'est celui passe en entree qui est   */
/*                                 utilise.                              */

void AdaptListBoxToWindHeight(int w_ind, int ob_list, int maxcases, GRECT *ext_grect);
/*************************************************************************/
/*                   F O N T I O N S   D I V E R S E S                   */
/*************************************************************************/
/*---------------------- DiderotHelpReply -------------------------------*/
/* ACTION: repond au message AID_REQUEST envoy par DIDEROT lorsqu'il    */
/*         doit afficher une aide. Cette fonction rempli automatiquement */
/*         les membres de la structure DID_HELP *VIEWHLP: dont on fourni */
/*         en entree l'adresse. Le fichier d'aide est cherche dans les   */
/*         repertoires systemes de l'application.                        */
/*         Au premier affichage de la fenetre d'aide ses dimensions sont */
/*         automatiquement ajustees pour qu'elle s'affiche de facon a ne */
/*         pas recouvrir la fenetre demandeuse d'aide.                   */
/*                                                                       */ 
/* ENTREE: w_ind: indice EAZY_GEM de la fenetre correspondant au fichier */
/*                d'aide, specifie par la variable: char *fic_aide       */
/*                Si ce n'est pas la fenetre pour laquelle DIDEROT deman-*/
/*                de une aide, il ne se passera rien et la fonction      */
/*                retourne avec 0;                                       */   
/*         EVNT_O *Evnt: variable de flux evenementiel.                  */
/*         DID_HELP *VIEWHLP: pointeur sur la structure de retour, que   */
/*                            l'on va renvoyer a DIDEROT afin qu'il      */
/*                            afficher l'aide demandee.                  */ 
/*         char *fic_aide: nom du fichier d'aide. il sera cherch dans   */
/*                         les repertoires systemes de l'application.    */
/*         int ref: numero de la reference a afficher de ce fichier      */
/*                  d'aide.                                              */
/*         int w, h: largeur et hauteur que l'on veut pour l'affichage   */
/*                   de la fenetre d'aide.                               */
/* RETOUR:  1 tout est OK                                                */
/*          0 l'indice de fenetre fourni en entre n'est pas le bon.      */
/*         -1 l'application DIDEROT non presente.                        */
/*         -2 le fichier d'aide fourni en entre n'est pas trouve.        */

int DiderotHelpReply(int w_ind, EVNT_O *Evnt, 
                     DID_HELP *VIEWHLP, char *fic_aide, int ref, 
                     int w, int h);
/*------------------------------ Vq_cookie -----------------------------*/
/* ACTION :retourne l'adresse d'un Cookie dont l'identificateur est     */
/*        passe en entree sinon Zero                                    */

COOKIE *Vq_cookie (long id);

/*----------------------- GetTxtNbLigne -------------------------*/
/*ACTION: compte le nombre de lignes d'un texte, afin de prevoir */
/*        la taille  du tableau de pointeurs                     */
/* ENTREE: char *txt: adresse du texte dont il faut compter les  */
/*                    lignes.                                    */
/* RETOUR: int: nombre de lignes du texte.                       */

int GetTxtNbLigne(char *txt);

/*----------------------- InitTxtLgnPtr -------------------------*/
/* ACTION:initialise un tableau de pointeurs de lignes sur les   */
/*        adresse de debut de lignes d'un texte                  */
/* ENTREE: char *txt: adresse du texte dont il faut initialiser  */
/*                    les pointeurs de lignes.                   */
/*         char **PtLgnTab: pointeur sur un tableau de pointeurs */
/*                    qui sera rempli par les adresses correctes */
/* RETOUR: toujours 1                                            */

int InitTxtLgnPtr(char *txt, char **PtLgnTab);

/*------------------ GetDragDropList --------------------------------------*/
/* ACTION: recupere une liste de chaines, separes par des zero de fin     */
/*         lors du message AP_DRAGDROP. (en general liste de fichiers)     */
/* ENTREE: EVNT_O *Evnt: pointeur sur le flux evenementiel. Permet  la    */
/*               fonction de se servir du pipe.                            */
/*         char *path: pointeur sur la chaine dans laquelle la liste sera  */
/*               recopie.                                                 */
/*         long len_path: longueur de la chaine d'entree, afin que la      */
/*               recopie ne deborde pas.                                   */
/* RETOUR: long: longueur de la chaine pouvant etre recupre. Si cette    */
/*              longueur est plus longue que len_path, c'est qu'il ya eu   */
/*              non recopie d'une partie de la chaine.                     */

long GetDragDropList(EVNT_O *Evnt, char *path, long len_path);

/*------------------------- ClipboardSave -------------------------------------*/
/* ACTION: sauve le buffer passe en entree dans le clipboard (presse papier)   */
/* ENTREE: char *txt: adresse du buffer texte  sauver.                        */
/*         int mode: O_WRONLY   ecriture seulement                             */
/*                   O_APPEND   ajout du texte  la suite de celui deja present*/                            
/*                   O_CREAT    recree et efface l'ancien texte.               */    

int ClipboardSave(char *txt, int mode);
#endif	/* __EAZY_GEM__ */