// ****************************************************************
// ****        Fichier INCLUDE pour les scripts gnrs        ****
// ****        par EB Modeleur Universel                       ****
// ****        Version 3.00 Dec. 1996                         ****
// ****        pour P.O.V. (Persistence Of Vision) V. 3.xx     ****
// ****                                                        ****
// ****        (C) BARANGER Emmanuel              02/12/1996   ****
// ****************************************************************
// **** Tous les objets dfinis ici sont dfinie sur une base  ****
// **** de taille de 1. Il suffit donc de leur appliquer une   ****
// **** echelle (instruction scale < X Y Z > ) egale  la      ****
// **** valeur relle de la taille sur les trois axes.         ****
// ****************************************************************

#declare Ior_Vide    = 0.00
#declare Ior_Verre   = 1.71
#declare Ior_Diamant = 2.47
#declare Ior_Eau     = 1.33
#declare Ior_Air     = 1.000292

#declare Isotropic_Scattering         = 1
#declare Mie_Hazy_Scattering          = 2
#declare Mie_Murky_Scattering         = 3
#declare Rayleigh_Scattering          = 4
#declare Henyey_Greenstein_Scattering = 5

#declare Hemisphere =
intersection {
             sphere { < 0.0,0.0,0.0 >,0.5
                    scale     < 1.0, 2.0,1.0 >
                    translate < 0.0,-0.5,0.0 >
             }
             plane  { < 0.0,-1.0,0.0 >,0.5 }
}

#declare Prisme =
prism {
      linear_sweep
      linear_spline
      -0.5, 0.5,
      4,
      < -0.5,-0.5 >, < 0.0, 0.5 >, < 0.5,-0.5 >, < -0.5,-0.5 >
      rotate < -90.0, 0.0, 0.0 >
}

#declare Pyramide =
intersection {
       box   { < -0.5,-0.5,-0.5 >, < 0.5,0.5,0.5 > }
       plane { < 1.0, 0.0, 0.0 >,0.22
             rotate <  0.0,0.0, 26.0 >
       }
       plane { <-1.0, 0.0, 0.0 >,0.22
             rotate <  0.0,0.0,-26.0 >
       }
       plane { < 0.0, 0.0, 1.0 >,0.22
             rotate <-26.0,0.0,  0.0 >
       }
       plane { < 0.0, 0.0,-1.0 >,0.22
             rotate < 26.0,0.0,  0.0 >
       }
}

#declare Colonne =
merge {
      // La colonne
      cylinder { < 0.0,-0.4,0.0 >,< 0.0,0.4,0.0 >,0.3 }
      // Sa tte
      box { < -0.5,0.4,-0.5 >,< 0.5,0.5,0.5 > }
      // Son pied
      box { < -0.5,-0.5,-0.5 >,< 0.5,-0.4,0.5 > }
}

// Dclaration des types de projections
// pour tre utiliss avec image_map, bump_map, et material_map
//
// Format:
//   map_type Sphere_Map or map_type Torus_Map
//
#declare Plane_Map = 0
#declare Sphere_Map = 1
#declare Cylinder_Map = 2
#declare Dev1_Map = 3
#declare Dev2_Map = 4
#declare Torus_Map = 5

// Dclaration des types d'interpolation
// pour tre utiliss avec image_map et bump_map
//
// Format:
//   interpolate Bi ou interpolate Norm
//
#declare Bi   = 2    // Interpolation Bilinaire, la meilleur
#declare Norm = 4    // Distances rgulires, la plus rapide

