/********************************************************************
 *
 *                              N.AES
 *                             =======
 *
 * - naesbind.c -
 *
 * Bindings der AES-Erweiterungen von N.AES
 *
 * PureC-Version
 *
 ********************************************************************/

#include <naesbind.h>

/*-------
	       dieser Long   hat folgende Bedeutung:
	_aes(0,0x9f010100UL);
	         9f       = Opcode (159)
	           01     = Anzahl params in intin
	             01   = Anzahl Params in intout
	               00 = Anzahl params in addrin
-------*/

/*==================================================================
 * - appl_yield -
 *
 * AES-call #17
 *==================================================================*/
int appl_yield(void)
{
	_aes(0,0x11000100UL);
	return _GemParBlk.intout[0];
}

/*==================================================================
 * - objc_xfind -
 *
 * AES-call #49
 *==================================================================*/
int objc_xfind(OBJECT *obj, int start, int depth,  int x, int y)
{
	_GemParBlk.addrin[0] = obj;
	_GemParBlk.intin[0]  = start;
	_GemParBlk.intin[1]  = depth;
	_GemParBlk.intin[2]  = x;
	_GemParBlk.intin[3]  = y;
	_aes(0,0x31040101UL);
	return _GemParBlk.intout[0];
}

/*==================================================================
 * - graf_multirubber -
 *
 * AES-call #69
 *
 * Wird fr das Zeichnen der Boxen beim Klick auf ein Fenster-SIZER
 * verwendet. hnelt graf_rubberbox, nur mit zwei Rechtecken.
 *==================================================================*/
int graf_multirubber(int x, int y, int minw, int minh, GRECT *rec, int *outw, int *outh)
{
	_GemParBlk.intin[0]  = x;
	_GemParBlk.intin[1]  = y;
	_GemParBlk.intin[2]  = minw;
	_GemParBlk.intin[3]  = minh;
	_GemParBlk.addrin[0] = rec;
	_aes(0,0x45040301UL);

	*outw = _GemParBlk.intout[1];
	*outh = _GemParBlk.intout[2];
	return _GemParBlk.intout[0];
}

/*==================================================================
 * - wind_draw -
 *
 * AES-call #99
 *
 * Zeichnen der Non-Client-Area eines Fensters.
 *==================================================================*/
int	wind_draw(int wi_dhandle, int wi_dstartob)
{
	_GemParBlk.intin[0]  = wi_dhandle;
	_GemParBlk.intin[1]  = wi_dstartob;
	_aes(0, 0x63020100UL);
	return _GemParBlk.intout[0];
}

/*================================================
 * - wind_sget -
 *
 * AES-call #104
 *
 * Alternatives wind_get()-Binding zum Ermitteln von Fenstertitel
 * bzw. Infozeile.
 *================================================*/
int wind_sget(int w_handle, int w_field, char *buff)
{
	_GemParBlk.intin[0] = w_handle;
	_GemParBlk.intin[1] = w_field;
	_GemParBlk.intin[2] = (unsigned long)buff >> 16;
	_GemParBlk.intin[3] = (unsigned long)buff & 0xffff;
	_aes(0,0x68040100l);
	return _GemParBlk.intout[0];
}

/*================================================
 * - shel_rdef -
 *
 * AES-call #126
 *
 * Default Programm abfragen.
 *================================================*/
int shel_rdef(char *lpcmd, char *lpdir)
{
	_GemParBlk.addrin[0] = lpcmd;
	_GemParBlk.addrin[1] = lpdir;
	_aes(0, 0x7e000102UL);
	return _GemParBlk.intout[0];
}

/*================================================
 * - shel_wdef -
 *
 * AES-call #127
 *
 * Default Programm setzen.
 *================================================*/
int shel_wdef(char *lpcmd, char *lpdir)
{
	_GemParBlk.addrin[0] = lpcmd;
	_GemParBlk.addrin[1] = lpdir;
	_aes(0, 0x7f000102UL);
	return _GemParBlk.intout[0];
}

/*==================================================================
 * - shel_help -
 *
 * AES-call #128
 *
 * Hilfe anfordern.
 *==================================================================*/
int shel_help(int sh_hmode, char *sh_hfile, char *sh_hkey)
{
	_GemParBlk.intin[0]  = sh_hmode;
	_GemParBlk.addrin[0] = sh_hfile;
	_GemParBlk.addrin[1] = sh_hkey;
	_aes(0, 0x80010102UL);
	return _GemParBlk.intout[0];
}

/*==================================================================
 * - appl_control -
 *
 * AES-call #129
 *
 * Steuern von Applikationen.
 *==================================================================*/
int appl_control(int ap_cid, int ap_cwhat, void *ap_cout)
{
	_GemParBlk.intin[0]  = ap_cid;
	_GemParBlk.intin[1]  = ap_cwhat;
	_GemParBlk.addrin[0] = ap_cout;
	_aes(0, 0x81020101UL);
	return _GemParBlk.intout[0];
}

/*==================================================================
 * - form_popup - (MagiC-kompatibel)
 *
 * AES-call #135
 *
 * Popupmen darstellen und bearbeiten.
 *==================================================================*/
int form_popup(OBJECT *tree, int x, int y)
{
	_GemParBlk.intin[0]  = x;
	_GemParBlk.intin[1]  = y;
	_GemParBlk.addrin[0] = tree;
	_aes(0, 0x87020101UL);
	return _GemParBlk.intout[0];
}

