;
; Jaguar Sample Code
; Copyright (c)1994 Atari Corp.
; All Rights Reserved 
;
; Project: cpkdemo.cof - Cinepak Scaling/Motion Demo
;  Module: sclvars.s   - Read Joypad/Update scaling variables
;
; History: 11/09/94 - Created (SDS)
;

		.include "jaguar.inc"

		.68000
		.text

;;; Globals
		.globl	UpdateScale
;;; Externals
		.extern	x_pos
		.extern	y_pos
		.extern	h_scale
		.extern	v_scale
		.extern	cx_pos
		.extern	cy_pos
		.extern	reflect

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Procedure: UpdateScale
;            Update Joypad State -> Update Scaling/Motion Variables
;

UpdateScale:
		movem.l	d0-d1,-(sp)

		bsr	ReadJoypad

		move.l	joyedge,d0	; New button presses
		move.l	joycur,d1	; Joypad state

		movem.l	(sp)+,d0-d1
		rts


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Procedure: ReadJoypad
;            Read Joypad 1 and place values in joycur and joyedge
;

ReadJoypad:
		movem.l d0-d2,-(sp)

		move.l  #$f0fffffc,d1     ; d1 = Joypad data mask
		moveq.l #-1,d2            ; d2 = Cumulative joypad reading
	
		move.w  #$81fe,JOYSTICK   
		move.l  JOYSTICK,d0       ; Read joypad, pause button, A button
		or.l    d1,d0             ; Mask off unused bits
		ror.l   #4,d0             
		and.l   d0,d2             ; d2 = xxAPxxxx RLDUxxxx xxxxxxxx xxxxxxxx
		move.w  #$81fd,JOYSTICK
		move.l  JOYSTICK,d0       ; Read *741 keys, B button
		or.l    d1,d0             ; Mask off unused bits
		ror.l   #8,d0
		and.l   d0,d2             ; d2 = xxAPxxBx RLDU741* xxxxxxxx xxxxxxxx
		move.w  #$81fb,JOYSTICK
		move.l  JOYSTICK,d0       ; Read 2580 keys, C button
		or.l    d1,d0             ; Mask off unused bits
		rol.l   #6,d0
		rol.l   #6,d0
		and.l   d0,d2             ; d2 = xxAPxxBx RLDU741* xxCxxxxx 2580xxxx
		move.w  #$81f7,JOYSTICK
		move.l  JOYSTICK,d0       ; Read 369# keys, Option button
		or.l    d1,d0             ; Mask off unused bits
		rol.l   #8,d0
		and.l   d0,d2             ; d2 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== inputs active low

		moveq.l #-1,d1
		eor.l   d2,d1             ; d1 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== now inputs active high

		move.l  joycur,d0         ; old joycur needed for determining the new joyedge
		move.l  d1,joycur         ; Current joypad reading stored into joycur
		eor.l   d1,d0
		and.l   d1,d0
		move.l  d0,joyedge        ; joypad, buttons, keys that were just pressed

		movem.l (sp)+,d0-d2
		rts

		.bss

joyedge:	.ds.l	1
joycur:		.ds.l	1

		.end
