-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- NonConForm (c)kRadD  
-- -------------------
--    kradd@tscc.de
-- -------------------
-- lua library file
-- -------------------
-- Description: lua rendering functions
-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++

-- ********************************************************
--- non_displayTextWithTimer
-- display a text, then wait a specified time, and then remove the text
-- @text: text
-- @charset: charset of the text
-- @x: x coordinate of the text
-- @y: y coordinate of the text
-- @width: width of the text
-- @height: height of the text
-- @time: time to wait in seconds

function non_displayTextWithTimer(arg_text,arg_charset,arg_x,arg_y,arg_width,arg_height,arg_time)
	local show;

	-- +++ Create Sprite ++++++++++++++++++++++++++++++++++++++++++
	local displaybackground=NonSprite.new(arg_x,arg_y,arg_width,arg_height,nonShapes.EMPTY,0,0);

	-- +++ fetch background +++++++++++++++++++++++++++++++++++++++
	for show=1,2 do
		non_prePaint();

		displaybackground:fetchBackground();

		non_postPaint();
	end

	-- +++ Paint text +++++++++++++++++++++++++++++++++++++++++++++
	non_addToPaintList(NonText.new(arg_x,arg_y,arg_charset,arg_text,0));

--	non_prePaint()
	nonsys:suspendVBL();

	-- +++ Screen one +++++++++++++++++++++++++++++++++++++++++
	if nonsys:getAktScreen()==nonsys:getScreenOne() then
		counter=0

		if table.getn(nonInternals.nonSprites_bg1)>0 then
			for sprite in itervalues(nonInternals.nonSprites_bg1) do
				sprite:drawBackground();
				counter=counter+1;
			end

			for delete=1,counter do
				table.remove(nonInternals.nonSprites_bg1,1);
			end
		end
	else
		-- +++ Screen two +++++++++++++++++++++++++++++++++++++++++
		counter=0;

		if table.getn(nonInternals.nonSprites_bg2)>0 then
			for sprite in itervalues(nonInternals.nonSprites_bg2) do
				sprite:drawBackground();
				counter=counter+1;
			end
		end

		for delete=1,counter do
			table.remove(nonInternals.nonSprites_bg2,1);
		end
	end

----	nonsys:revokeVBL();
----	nonsys:waitForVBL();
----	nonsys:switchScreens();
--	non_postPaint();

	-- +++ Screen one +++++++++++++++++++++++++++++++++++++++++
	if nonsys:getAktScreen()==nonsys:getScreenOne() then
		if table.getn(nonInternals.nonSprites)>0 then
			for sprite in itervalues(nonInternals.nonSprites) do
				sprite:fetchBackground();
			end
		end
		for sprite in itervalues(nonInternals.nonSprites) do
			if bitand(sprite:getFlag(),1)==0 then
				sprite:draw();
				table.insert(nonInternals.nonSprites_bg1,sprite);
			end
		end
	else
		-- +++ Screen two +++++++++++++++++++++++++++++++++++++++++
		if table.getn(nonInternals.nonSprites)>0 then
			for sprite in itervalues(nonInternals.nonSprites) do
				if sprite~=nil then
					sprite:fetchBackground();
				end
			end
			
			for sprite in itervalues(nonInternals.nonSprites) do
				if sprite~=nil then
					if bitand(sprite:getFlag(),1)==0 then
						sprite:draw();
						table.insert(nonInternals.nonSprites_bg2,sprite);
					end
				end
			end
		end
	end

	non_paintSingleScreen();

	nonsys:revokeVBL();
	nonsys:waitForVBL();
	nonsys:switchScreens();

--	non_prePaint();
	nonsys:suspendVBL();

	-- +++ Screen one +++++++++++++++++++++++++++++++++++++++++
	if nonsys:getAktScreen()==nonsys:getScreenOne() then
		counter=0

		if table.getn(nonInternals.nonSprites_bg1)>0 then
			for sprite in itervalues(nonInternals.nonSprites_bg1) do
				sprite:drawBackground();
				counter=counter+1;
			end

			for delete=1,counter do
				table.remove(nonInternals.nonSprites_bg1,1);
			end
		end
	else
		-- +++ Screen two +++++++++++++++++++++++++++++++++++++++++
		counter=0;

		if table.getn(nonInternals.nonSprites_bg2)>0 then
			for sprite in itervalues(nonInternals.nonSprites_bg2) do
				sprite:drawBackground();
				counter=counter+1;
			end
		end

		for delete=1,counter do
			table.remove(nonInternals.nonSprites_bg2,1);
		end
	end

----	nonsys:revokeVBL();
----	nonsys:waitForVBL();
----	nonsys:switchScreens();
	-- +++ Screen one +++++++++++++++++++++++++++++++++++++++++
	if nonsys:getAktScreen()==nonsys:getScreenOne() then
		if table.getn(nonInternals.nonSprites)>0 then
			for sprite in itervalues(nonInternals.nonSprites) do
				sprite:fetchBackground();
			end
		end
		for sprite in itervalues(nonInternals.nonSprites) do
			if bitand(sprite:getFlag(),1)==0 then
				sprite:draw();
				table.insert(nonInternals.nonSprites_bg1,sprite);
			end
		end
	else
		-- +++ Screen two +++++++++++++++++++++++++++++++++++++++++
		if table.getn(nonInternals.nonSprites)>0 then
			for sprite in itervalues(nonInternals.nonSprites) do
				if sprite~=nil then
					sprite:fetchBackground();
				end
			end
			
			for sprite in itervalues(nonInternals.nonSprites) do
				if sprite~=nil then
					if bitand(sprite:getFlag(),1)==0 then
						sprite:draw();
						table.insert(nonInternals.nonSprites_bg2,sprite);
					end
				end
			end
		end
	end

	non_paintSingleScreen();

	nonsys:revokeVBL();
	nonsys:waitForVBL();
	nonsys:switchScreens();
--	non_postPaint();
	
	-- +++ Wait +++++++++++++++++++++++++++++++++++++++++++++++++++
	nonsys:wait(arg_time,1);
	
	-- +++ Draw background ++++++++++++++++++++++++++++++++++++++++
	for show=1,2 do
		non_prePaint();

		displaybackground:drawBackground();

		non_postPaint();
	end

	-- *** Cleanup ********************************************
	collectgarbage();
end

-- ********************************************************
--- non_clearSprites
-- clear the spritelists

function non_clearSprites()
	nonInternals.nonSprites={};
	nonInternals.nonSprites_bg1={};
	nonInternals.nonSprites_bg2={};
end

-- ********************************************************
--- non_showSprites
-- render the sprites

function non_showSprites()
	local counter;
	local sprite;
	local delete;

	-- +++ Screen one +++++++++++++++++++++++++++++++++++++++++
	if nonsys:getAktScreen()==nonsys:getScreenOne() then
		counter=0

		if table.getn(nonInternals.nonSprites_bg1)>0 then
			for sprite in itervalues(nonInternals.nonSprites_bg1) do
				sprite:drawBackground();
				counter=counter+1;
			end

			for delete=1,counter do
				table.remove(nonInternals.nonSprites_bg1,1);
			end
		end

		if table.getn(nonInternals.nonSprites)>0 then
			for sprite in itervalues(nonInternals.nonSprites) do
				sprite:fetchBackground();
			end
		
			for sprite in itervalues(nonInternals.nonSprites) do
				if bitand(sprite:getFlag(),1)==0 then
					sprite:draw();
					table.insert(nonInternals.nonSprites_bg1,sprite);
				end
			end
		end
	else
	-- +++ Screen two +++++++++++++++++++++++++++++++++++++++++
		counter=0;

		if table.getn(nonInternals.nonSprites_bg2)>0 then
			for sprite in itervalues(nonInternals.nonSprites_bg2) do
				sprite:drawBackground();
				counter=counter+1;
			end
		end

		for delete=1,counter do
			table.remove(nonInternals.nonSprites_bg2,1);
		end

		if table.getn(nonInternals.nonSprites)>0 then
			for sprite in itervalues(nonInternals.nonSprites) do
				if sprite~=nil then
					sprite:fetchBackground();
				end
			end
	
			for sprite in itervalues(nonInternals.nonSprites) do
				if sprite~=nil then
					if bitand(sprite:getFlag(),1)==0 then
						sprite:draw();
						table.insert(nonInternals.nonSprites_bg2,sprite);
					end
				end
			end
		end
	end
end

-- ********************************************************
--- non_showSpritesAndBackground
-- render the sprites
-- @spritelist: table of sprite objects 
-- @spritebackgroundlist1: table of sprite objets to restore their background (screen1) 
-- @spritebackgroundlist2: table of sprite objets to restore their background (screen2)
-- @showcounter: amount of repeats (2 means painig on both screens)

function non_showSpritesAndBackground(spritelist,spritebglist1,spritebglist2,showcounter)
	local show;

	for show=1,showcounter do
		nonsys:suspendVBL();
		nonsys:switchScreens();

		-- +++ Screen one +++++++++++++++++++++++++++++++++++++++++
		if nonsys:getAktScreen()==nonsys:getScreenOne() then
			counter=0
			for object in itervalues(nonInternals.nonPaintList1) do
				object:draw();
				counter=counter+1;
			end
			for delete=1,counter do
				table.remove(nonInternals.nonPaintList1,1);
			end
			counter=0
			for sprite in itervalues(spritebglist1) do
				sprite:drawBackground();
				counter=counter+1;
			end
			for delete=1,counter do
				table.remove(spritebglist1,1);
			end
			for sprite in itervalues(spritelist) do
				sprite:fetchBackground();
			end
			for sprite in itervalues(spritelist) do
				if bitand(sprite:getFlag(),1)==0 then
					sprite:draw();
					table.insert(spritebglist1,sprite);
				end
			end
		else
		-- +++ Screen two +++++++++++++++++++++++++++++++++++++++++
			counter=0
			for object in itervalues(nonInternals.nonPaintList2) do
				object:draw();
				counter=counter+1;
			end
			for delete=1,counter do
				table.remove(nonInternals.nonPaintList2,1);
			end
			for sprite in itervalues(spritebglist2) do
				sprite:drawBackground();
				counter=counter+1;
			end
			for delete=1,counter do
				table.remove(spritebglist2,1);
			end
			for sprite in itervalues(spritelist) do
				sprite:fetchBackground();
			end
			for sprite in itervalues(spritelist) do
				if bitand(sprite:getFlag(),1)==0 then
					sprite:draw();
					table.insert(spritebglist2,sprite);
				end
			end
		end

		nonsys:revokeVBL();
		nonsys:waitForVBL();
	end
end

-- *************************************************************
--- non_TextBox
-- renders a string into one or more text objects
-- @arg_x: x position of the textbox 
-- @arg_y: y position of the textbox
-- @arg_text:	the text to render
-- @@: (table) the textobjects

function non_TextBox(arg_x,arg_y,arg_text)
	local lines={};
	local parts={};
	local textobjects={};
	local start=1;
	local ende=1;
	local font=nil;
		
	while true do
		ende=string.find(arg_text,"<br>",ende);
		if ende==nil then break end
		table.insert(lines,string.sub(arg_text,start,ende-1));
		ende=ende+4;
		start=ende;
	end
	
	y=arg_y;
	
	for k,text in pairs(lines) do
		x=arg_x;

		if string.len(text)>0 then
			while true do
				fontstart,fontende=string.find(text,"<font%s%w*>",1);
			
				if fontstart~=nil then
					font=nonFonts[string.sub(text,fontstart+6,fontende-1)];
					text=string.sub(text,fontende+1,string.len(text));
				end

				textende=string.find(text,"<",1);

				if textende==nil then 
					table.insert(textobjects,NonText.new(x,y,font,text,0));
					break;
				else
					table.insert(textobjects,NonText.new(x,y,font,string.sub(text,1,textende-1),0));
					x=x+string.len(string.sub(text,1,textende-1))*font:getSpacing();
					text=string.sub(text,textende,string.len(text));
				end
			end
		end
		
		y=y+font:getY();
	end
	
	return textobjects; 
end