-- +++ play msx ++++++++++++++++++++++++++++++++++++++++++++++
--mods.mainmod:playMod();
--samples.rules:playSample();

-- ****************************************************
-- Global game variables
-- ****************************************************

startpositions={
	x={-1,-1,-1,-1,-1,-1,-1,-1},
	y={-1,-1,-1,-1,-1,-1,-1,-1}
};

pColors={42260,1296,41484,56128,1280,788,42240,41748};

-- ****************************************************
-- showGame
-- ****************************************************
function showGame(model,view)
	-- *** Variables ************************************
	local counter=0;
	local pads={-1,-1,-1,-1,-1,-1,-1,-1};
	local gameovercounter=0;
	local playergameover={0,0,0,0,0,0,0,0};
	local playerdirection={NON_CONTROLLERDOWN,NON_CONTROLLERDOWN,NON_CONTROLLERDOWN,NON_CONTROLLERDOWN,NON_CONTROLLERDOWN,NON_CONTROLLERDOWN,NON_CONTROLLERDOWN,NON_CONTROLLERDOWN};
	local randx;
	local randy;
	local freeingrid=false;
	local barriersgrid={};
	local endpaintcounter=0;
	local amountpadspressed=0;
	local playerpressedbutton={false,false,false,false,false,false,false,false};
	local playerpressed=false;
	local playerdied=false;
	
	-- +++ fillt collision array +++++++++++++++++++++++++
	nonsys:clearCollision();

	nonsys:paintCollision(0,0,320,4,15535);
	nonsys:paintCollision(0,236,320,4,15535);
	nonsys:paintCollision(0,0,4,240,15535);
	nonsys:paintCollision(316,0,4,240,15535);

	-- ++++++++++++++++++++++++++++++++++++++++++++++++++
	-- State One
	-- ++++++++++++++++++++++++++++++++++++++++++++++++++

	-- +++ fill paintlist +++++++++++++++++++++++++++++++
	non_paintView(view);

	-- +++ set barriers and calculate startpositions ++++
	barriersgrid=calculateStartPositions(barriersgrid);

	if nonGlobals.propBarriers > 0 then
		for counter=1,nonGlobals.propBarriers do
			freeingrid=false;			
			
			while freeingrid==false do
				randx=math.random(78)-1;
				randy=math.random(58)-1;
				
				if barriersgrid[(randx+1)+((randy+1)*80)]==nil then
					freeingrid=true;
					barriersgrid[(randx+1)+((randy+1)*80)]=1;
				end
			end
						
			non_addToPaintList(NonPicture.new(5+(randx*4),4+(randy*4),3,3,0,nonShapes.barrier));
			nonsys:paintCollision(5+(randx*4),4+(randy*4),3,3,15535);
		end
	end

	-- *** paint screen *********************************
	non_paintScreens();
	
	-- *** Save Screen for delete lines function ********
	nonsys:saveScreenToMemory();

	-- ++++++++++++++++++++++++++++++++++++++++++++++++++
	-- State two
	-- ++++++++++++++++++++++++++++++++++++++++++++++++++

	-- *** Prepare start ********************************
	for playercounter=1,nonGlobals.nonNumberOfPlayers do
		nonInternals.nonSprites[playercounter+nonGlobals.nonNumberOfPlayers]=NonSprite.new((startpositions.x[playercounter]*28)+5,(startpositions.y[playercounter]*28)+9,26,26,nonShapes.playerframe,0,0);
		nonInternals.nonSprites[playercounter+(nonGlobals.nonNumberOfPlayers*2)]=NonSprite.new((startpositions.x[playercounter]*28)+8,(startpositions.y[playercounter]*28)+12,20,20,nonInternals.nonPlayerShapes[playercounter],0,0);
		nonInternals.nonSprites[playercounter]=NonSprite.new((startpositions.x[playercounter]*28)+16,(startpositions.y[playercounter]*28)+20,4,4,nonShapes.cycles[playercounter],0,pColors[playercounter]);
		nonsys:paintCollision((startpositions.x[playercounter]*28+16),(startpositions.y[playercounter]*28)+20,4,4,pColors[playercounter]);
	end

	non_prePaint();
	non_postPaint();

	-- ++++++++++++++++++++++++++++++++++++++++++++++++++
	-- State Three
	-- ++++++++++++++++++++++++++++++++++++++++++++++++++

	non_displayTextWithTimer("CHOOSE A DIRECTION",nonFonts.font1616,16,112,288,17,1);
	nonInternals.nonControllers:waitAllButtonsNotPressed();

  -- ++++++++++++++++++++++++++++++++++++++++++++++++++
  -- State Four
  -- ++++++++++++++++++++++++++++++++++++++++++++++++++

	amountpadspressed=0;
	playerpressedbutton={false,false,false,false,false,false,false,false};

	while nonInternals.nonExitEvent==NON_NOTHING do
		non_prePaint();
	
		player=1;

		non_refreshControlls();

		for portcounter=1,2 do
			for controllercounter=1,4 do
				playerpressed=false;
				pads[player]=nonInternals.nonControllers:getPacket(player);

				if player<=nonGlobals.nonNumberOfPlayers and playerpressedbutton[player]==false then
					if bitand(pads[player],NON_CONTROLLERUP)==NON_CONTROLLERUP then
						playerdirection[player]=NON_CONTROLLERUP;
						playerpressed=true;
					elseif bitand(pads[player],NON_CONTROLLERDOWN)==NON_CONTROLLERDOWN then
						playerdirection[player]=NON_CONTROLLERDOWN;
						playerpressed=true;
					elseif bitand(pads[player],NON_CONTROLLERLEFT)==NON_CONTROLLERLEFT then
						playerdirection[player]=NON_CONTROLLERLEFT;
						playerpressed=true;
					elseif bitand(pads[player],NON_CONTROLLERRIGHT)==NON_CONTROLLERRIGHT then
						playerdirection[player]=NON_CONTROLLERRIGHT;
						playerpressed=true;
					end
					
					if playerpressed==true then
						nonInternals.nonSprites[player+nonGlobals.nonNumberOfPlayers]:setFlag(nonInternals.nonSprites[player+nonGlobals.nonNumberOfPlayers]:getFlag()+1);
						nonInternals.nonSprites[player+(nonGlobals.nonNumberOfPlayers)*2]:setFlag(nonInternals.nonSprites[player+(nonGlobals.nonNumberOfPlayers*2)]:getFlag()+1);
						playerpressedbutton[player]=true;
						amountpadspressed=amountpadspressed+1;
						
						if amountpadspressed == nonGlobals.nonNumberOfPlayers then
							nonInternals.nonExitEvent=NON_NEXTEVENT;
						end			
					end
				end
				player=player+1;
			end
		end
				
		non_controllsEvents(model);
		
		non_postPaint();
	end

	if nonInternals.nonExitEvent==NON_NEXTEVENT then
		nonInternals.nonExitEvent=NON_NOTHING;
	
		-- +++++++++++++++++++++++++++++++++++++++++++++++
		-- State Five
		-- +++++++++++++++++++++++++++++++++++++++++++++++

		-- +++ ensure both screens were shown

		non_paintScreens()

		non_displayTextWithTimer("START YOUR ENGINES",nonFonts.font1616,16,112,288,17,1);

		-- +++++++++++++++++++++++++++++++++++++++++++++++
		-- State Six
		-- +++++++++++++++++++++++++++++++++++++++++++++++

		-- *** ensure to be start with screen two ***********
		-- *** to avoid collision match right at the start **
		if nonsys:getAktScreen()==nonsys:getScreenTwo() then
			non_waitSwitchScreen();
		end

		-- *** Game loop ******************************************
		while nonInternals.nonExitEvent==NON_NOTHING do
			nonsys:suspendVBL();
			nonsys:switchScreens();

			non_refreshControlls();

			-- *** Screen one ***************************************
			if nonsys:getAktScreen()==nonsys:getScreenOne() then
				for counter=1,nonGlobals.nonNumberOfPlayers do
					if playergameover[counter]==0 then
						-- *** Collision test *****************************
						col=nonInternals.nonSprites[counter]:testCollision();
						if col~=0 then
							playergameover[counter]=1;	
						
							-- +++ Delete Line ++++++++++++++++++++++++++++++
							if nonGlobals.propDelLine==true then
								deleteLine(pColors[counter]);
							end
						
							-- +++ gameresult +++++++++++++++++++++++++++++++
							nonGlobals.nonGameResults[counter].result=nonGlobals.nonNumberOfPlayers-gameovercounter;
						
							-- +++ score ++++++++++++++++++++++++++++++++++++
							if nonGlobals.propPoints==false then
								nonGlobals.nonGameResults[counter].points=gameovercounter+1;
							end

							gameovercounter=gameovercounter+1;
							playerdied=true;
						else
							-- *** Draw sprite ******************************
							nonInternals.nonSprites[counter]:draw();
						end

						-- *** Jag Pad reactions **************************
						pads[counter]=nonInternals.nonControllers:getPacket(counter);
						if bitand(pads[counter],NON_CONTROLLERUP)==NON_CONTROLLERUP and playerdirection[counter]~=NON_CONTROLLERDOWN then
							playerdirection[counter]=NON_CONTROLLERUP;
						elseif bitand(pads[counter],NON_CONTROLLERDOWN)==NON_CONTROLLERDOWN and playerdirection[counter]~=NON_CONTROLLERUP then
							playerdirection[counter]=NON_CONTROLLERDOWN;
						elseif bitand(pads[counter],NON_CONTROLLERLEFT)==NON_CONTROLLERLEFT and playerdirection[counter]~=NON_CONTROLLERRIGHT then
							playerdirection[counter]=NON_CONTROLLERLEFT;
						elseif bitand(pads[counter],NON_CONTROLLERRIGHT)==NON_CONTROLLERRIGHT and playerdirection[counter]~=NON_CONTROLLERLEFT then
							playerdirection[counter]=NON_CONTROLLERRIGHT;
						end
					end
				end
			-- *** Screen two ***************************************
			else
				for counter=1,nonGlobals.nonNumberOfPlayers do
					if playergameover[counter]==0 then
						-- *** Draw sprite ********************************
						nonInternals.nonSprites[counter]:draw();
						-- *** Jag Pad reactions **************************
						pads[counter]=nonInternals.nonControllers:getPacket(counter);
						if bitand(pads[counter],NON_CONTROLLERUP)==NON_CONTROLLERUP and playerdirection[counter]~=NON_CONTROLLERDOWN then
							playerdirection[counter]=NON_CONTROLLERUP;
						elseif bitand(pads[counter],NON_CONTROLLERDOWN)==NON_CONTROLLERDOWN and playerdirection[counter]~=NON_CONTROLLERUP then
							playerdirection[counter]=NON_CONTROLLERDOWN;
						elseif bitand(pads[counter],NON_CONTROLLERLEFT)==NON_CONTROLLERLEFT and playerdirection[counter]~=NON_CONTROLLERRIGHT then
							playerdirection[counter]=NON_CONTROLLERLEFT;
						elseif bitand(pads[counter],NON_CONTROLLERRIGHT)==NON_CONTROLLERRIGHT and playerdirection[counter]~=NON_CONTROLLERLEFT then
							playerdirection[counter]=NON_CONTROLLERRIGHT;
						end
					
						if playerdirection[counter]==NON_CONTROLLERUP then
							nonInternals.nonSprites[counter]:setY((nonInternals.nonSprites[counter]:getY())-4);
						elseif playerdirection[counter]==NON_CONTROLLERDOWN then
							nonInternals.nonSprites[counter]:setY((nonInternals.nonSprites[counter]:getY())+4);
						elseif playerdirection[counter]==NON_CONTROLLERLEFT then
							nonInternals.nonSprites[counter]:setX((nonInternals.nonSprites[counter]:getX())-4);
						elseif playerdirection[counter]==NON_CONTROLLERRIGHT then
							nonInternals.nonSprites[counter]:setX((nonInternals.nonSprites[counter]:getX())+4);
						end
					
						if nonGlobals.propPoints==true then
							nonGlobals.nonGameResults[counter].points=nonGlobals.nonGameResults[counter].points+1;
						end
					end 
				end

				-- *** gameover test ***********************************
				if playerdied==true and gameovercounter>=nonGlobals.nonNumberOfPlayers-1 then
					nonInternals.nonExitEvent=NON_NEXTEVENT;
				end
				playerdied=false;

			end
		
			non_controllsEvents(model);
		
			nonsys:revokeVBL();
			nonsys:waitForVBL();
		end

		-- +++ set scores for the winner ++++++++++++++++++++++++++
		for counter=1,nonGlobals.nonNumberOfPlayers do
			if playergameover[counter]==0 then
				nonGlobals.nonGameResults[counter].result=nonGlobals.nonNumberOfPlayers-gameovercounter;
				if nonGlobals.propPoints==true then
					nonGlobals.nonGameResults[counter].points=nonGlobals.nonGameResults[counter].points+100;
  			else
					nonGlobals.nonGameResults[counter].points=gameovercounter+2;
				end
				break;
			end
		end
	
		-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		-- Stage seven
		-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++

		-- *** Finish *********************************************
		non_clearSprites();

		nonInternals.nonControllers:waitAllButtonsNotPressed();
		non_displayTextWithTimer("ROUND FINISHED",nonFonts.font1616,48,112,224,17,1);
	else
		non_clearSprites();
	end

	-- *** Cleanup ********************************************
	collectgarbage();
end

-- ****************************************************
-- calculateStartPositions
-- ****************************************************
function calculateStartPositions(barriersgrid)
	local freeingrid;
	local playercounter;
	local randx;
	local randy;
	local counterx;
	local countery;
	
	for playercounter=1,nonGlobals.nonNumberOfPlayers do
		freeingrid=false;

		while freeingrid==false do
			randx=math.random(11)-1;
			randy=math.random(8)-1;

			if barriersgrid[((randx*7)+1)+(((randy*7)+2)*80)]==nil then
				freeingrid=true;
				for countery=0,6 do
					for counterx=0,6 do
						barriersgrid[((randx*7)+1+counterx)+(((randy*7)+2+countery)*80)]=1;
					end
				end
			end

			startpositions.x[playercounter]=randx;
			startpositions.y[playercounter]=randy;	
		end
	end
	
	return barriersgrid;
end	
-- ****************************************************
-- delete line   
-- ****************************************************
function deleteLine(color)
	nonsys:suspendVBL();
	nonsys:switchScreens();

	nonsys:replaceColorWithBackground(color);

	nonsys:revokeVBL();
	nonsys:waitForVBL();

	nonsys:suspendVBL();
	nonsys:switchScreens();

	nonsys:replaceCollisionAndColorWithBackground(color);

	nonsys:revokeVBL();
	nonsys:waitForVBL();
end