/*
 * xrick/include/e_rick.h
 *
 * This source code file is part of the xrick distribution, and as such is
 * copyrighted. Please read the README file in the root directory of the
 * distribution for information about copyrights, trademarks, license,
 * disclaimers, etc.
 */

#ifndef _E_RICK_H
#define _E_RICK_H

#include "system.h"

#define E_RICK_NO 1
#define E_RICK_ENT ent_ents[E_RICK_NO]

extern U8 e_rick_state;
extern S16 e_rick_stop_x, e_rick_stop_y;

#define E_RICK_STSTOP 0x01
#define E_RICK_STSHOOT 0x02
#define E_RICK_STCLIMB 0x04
#define E_RICK_STJUMP 0x08
#define E_RICK_STZOMBIE 0x10
#define E_RICK_STDEAD 0x20
#define E_RICK_STCRAWL 0x40

#define E_RICK_STSET(X) e_rick_state |= (X)
#define E_RICK_STRST(X) e_rick_state &= ~(X)
#define E_RICK_STTST(X) (e_rick_state & (X))

extern void e_rick_save(void);
extern void e_rick_restore(void);
extern void e_rick_action(U8);
extern void e_rick_gozombie(void);
extern U8 e_rick_boxtest(U8);

#endif

/* eof */


