/*
 * xrick/include/game.h
 *
 * This source code file is part of the xrick distribution, and as such is
 * copyrighted. Please read the README file in the root directory of the
 * distribution for information about copyrights, trademarks, license,
 * disclaimers, etc.
 */

#ifndef _GAME_H
#define _GAME_H

#include <stddef.h> /* NULL */

#include "system.h"

#include "rects.h"

#define LEFT 1
#define RIGHT 0

#define TRUE 1
#define FALSE 0

#define GAME_PERIOD 75

typedef struct {
  U32 score;
  U8 name[10];
} hscore_t;

extern U8 game_lives;      /* lives counter */
extern U8 game_bombs;      /* bombs counter */
extern U8 game_bullets;    /* bullets counter */

extern U32 game_score;     /* score */

extern hscore_t game_hscores[8];  /* highest scores (hall of fame) */

extern U16 game_map;       /* current map */
extern U16 game_submap;    /* current submap */

extern U8 game_dir;        /* direction (LEFT, RIGHT) */
extern U8 game_chsm;       /* change submap request (TRUE, FALSE) */

extern U8 game_waitevt;    /* wait for events (TRUE, FALSE) */
extern U8 game_period;     /* time between each frame, in millisecond */

extern rect_t *game_rects; /* rectangles to redraw at each frame */

extern void game_run(void);


#ifdef ENABLE_CHEATS
extern U8 game_cheat1;     /* infinite lives, bombs and bullets */
extern U8 game_cheat2;     /* never die */
extern U8 game_cheat3;     /* highlight sprites */
extern void game_toggleCheat(U8);
#endif

#endif

/* eof */


