/*
 * xrick/data/dat_maps.c
 *
 * This source code file is part of the xrick distribution, and as such is
 * copyrighted. Please read the README file in the root directory of the
 * distribution for information about copyrights, trademarks, license,
 * disclaimers, etc.
 */

#include "system.h"
#include "maps.h"

map_t map_maps[MAP_NBR_MAPS] = {
  {0x0008, 0x008b, 0x0008, 000000},
  {0x0008, 0x008b, 0x0068, 0x0009},
  {0x0010, 0x008b, 0x0010, 0x0014},
  {0x0010, 0x008b, 0x0010, 0x0026},
  {0x0074, 0x00c8, 0x0008, 0x0026},
};

submap_t map_submaps[MAP_NBR_SUBMAPS] = {
  {000000, 000000, 000000, 000000},
  {000000, 0x0078, 0x0003, 0x0005},
  {000000, 0x0150, 0x0006, 0x0011},
  {000000, 0x0198, 0x0009, 0x0018},
  {000000, 0x02a0, 0x000c, 0x002b},
  {000000, 0x0348, 0x000f, 0x0035},
  {000000, 0x0398, 0x0012, 0x0039},
  {000000, 0x04a8, 0x0015, 0x0048},
  {000000, 0x05b8, 0x0018, 0x0057},
  {000000, 0x0800, 0x001b, 0x0065},
  {000000, 0x0900, 0x001e, 0x0079},
  {000000, 0x09c8, 0x0021, 0x0086},
  {000000, 0x0a40, 0x0024, 0x0091},
  {000000, 0x0aa8, 0x0027, 0x009b},
  {000000, 0x0b18, 0x002a, 0x00a4},
  {000000, 0x0be8, 0x002d, 0x00b1},
  {000000, 0x0ce8, 0x0030, 0x00c1},
  {000000, 0x0df8, 0x0033, 0x00d1},
  {000000, 0x0e78, 0x0036, 0x00d8},
  {000000, 0x0f58, 0x0039, 0x00e5},
  {0x0001, 0x1060, 0x003c, 0x00f2},
  {0x0001, 0x10f0, 0x003f, 0x00fa},
  {0x0001, 0x1140, 0x0044, 0x0103},
  {0x0001, 0x1190, 0x0049, 0x010a},
  {0x0001, 0x1240, 0x004c, 0x0117},
  {0x0001, 0x12c0, 0x004f, 0x0122},
  {0x0001, 0x1310, 0x0053, 0x0129},
  {0x0001, 0x13c0, 0x0057, 0x0132},
  {0x0001, 0x1410, 0x005c, 0x0138},
  {0x0001, 0x14c0, 0x0061, 0x0145},
  {0x0001, 0x1510, 0x0065, 0x014b},
  {0x0001, 0x1590, 0x0069, 0x0158},
  {0x0001, 0x15e0, 0x006c, 0x015f},
  {0x0001, 0x1690, 0x006f, 0x016a},
  {0x0001, 0x1740, 0x0072, 0x0176},
  {0x0001, 0x1850, 0x0075, 0x0185},
  {0x0001, 0x1900, 0x0078, 0x018d},
  {0x0001, 0x19b0, 0x007b, 0x0195},
  {0x0001, 0x1a8a, 0x007e, 0x01a0},
  {0x0001, 0x1aea, 0x0081, 0x01a9},
  {0x0001, 0x1bca, 0x0084, 0x01ba},
  {0x0001, 0x1c1a, 0x0087, 0x01c1},
  {0x0001, 0x1cfa, 0x008a, 0x01d3},
  {0x0001, 0x1d4a, 0x008d, 0x01dc},
  {0x0001, 0x1e2a, 0x0090, 0x01eb},
  {0x0001, 0x1e7a, 0x0093, 0x01f1},
  {0x0001, 0x1f5a, 0x0096, 0x0202},
};

connect_t map_connect[MAP_NBR_CONNECT] = {

  /* map 0 */

  /* map 0 submap 0 */
  {0x01, 0x18, 0xff, 0x00},
  {0000, 0x38, 0x01, 0x18},
  {0xff, 0x00, 0x00, 0x00},
  /* map 0 submap 1 */
  {0x01, 0x18, 0000, 0x38},
  {0000, 0x68, 0x02, 0x20},
  {0xff, 0x00, 0x00, 0x00},
  /* map 0 submap 2 */
  {0x01, 0x20, 0x01, 0x68},
  {0000, 0x18, 0x03, 0x18},
  {0xff, 0x00, 0x00, 0x00},
  /* map 0 submap 3 */
  {0x01, 0x18, 0x02, 0x18},
  {0000, 0x80, 0x04, 0x18},
  {0xff, 0x00, 0x00, 0x00},
  /* map 0 submap 4 */
  {0x01, 0x18, 0x03, 0x80},
  {0000, 0x50, 0x05, 0x18},
  {0xff, 0x00, 0x00, 0x00},
  /* map 0 submap 5 */
  {0x01, 0x18, 0x04, 0x50},
  {0000, 0x20, 0x06, 0x80},
  {0xff, 0x00, 0x00, 0x00},
  /* map 0 submap 6 */
  {0000, 0x18, 0x07, 0x80},
  {0x01, 0x80, 0x05, 0x20},
  {0xff, 0x00, 0x00, 0x00},
  /* map 0 submap 7 */
  {0000, 0x18, 0x08, 0x18},
  {0x01, 0x80, 0x06, 0x18},
  {0xff, 0x00, 0x00, 0x00},
  /* map 0 submap 8 */
  {0x01, 0x18, 0x07, 0x18},
  {0000, 0x80, 0xff, 0x00},
  {0xff, 0x00, 0x00, 0x00},

  /* map 1 */

  /* map 1 submap 9 */
  {0000, 0x18, 0x0a, 0x60},
  {0x01, 0x78, 0xff, 0x00},
  {0xff, 0x00, 0x00, 0x00},
  /* map 1 submap a */
  {0000, 0x18, 0x0b, 0x30},
  {0x01, 0x60, 0x09, 0x18},
  {0xff, 0x00, 0x00, 0x00},
  /* map 1 submap b */
  {0000, 0x18, 0x0c, 0x30},
  {0x01, 0x30, 0x0a, 0x18},
  {0xff, 0x00, 0x00, 0x00},
  /* map 1 submap c */
  {0000, 0x30, 0x0d, 0x18},
  {0x01, 0x30, 0x0b, 0x18},
  {0xff, 0x00, 0x00, 0x00},
  /* map 1 submap d */
  {0x01, 0x18, 0x0c, 0x30},
  {0000, 0x30, 0x0e, 0x18},
  {0xff, 0x00, 0x00, 0x00},
  /* map 1 submap e */
  {0x01, 0x18, 0x0d, 0x30},
  {0000, 0x60, 0x0f, 0x18},
  {0xff, 0x00, 0x00, 0x00},
  /* map 1 submap f */
  {0x01, 0x18, 0x0e, 0x60},
  {0000, 0x78, 0x10, 0x80},
  {0xff, 0x00, 0x00, 0x00},
  /* map 1 submap 10 */
  {0000, 0x18, 0x11, 0x18},
  {0x01, 0x80, 0x0f, 0x78},
  {0xff, 0x00, 0x00, 0x00},
  /* map 1 submap 11 */
  {0x01, 0x18, 0x10, 0x18},
  {0000, 0x38, 0x12, 0x18}, /* was {0000, 0x38, 0x13, 0x68} ?? - now OK */
  {0xff, 0x00, 0x00, 0x00},
  /* map 1 submap 12 */
  {0x01, 0x18, 0x11, 0x38}, /* pointless since it's not possible to go back */
  {0000, 0x68, 0x13, 0x68},
  {0xff, 0x00, 0x00, 0x00},
  /* map 1 submap 13 */
  {0000, 0x18, 0xff, 0x00},
  {0x01, 0x68, 0x12, 0x68},
  {0xff, 0x00, 0x00, 0x00},

  /* map 2 */

  /* map 2 submap 14 */     /* sequence 14-15-16-17 is clean */
  {0x01, 0x20, 0xff, 0x00},
  {0000, 0x40, 0x15, 0x18},
  {0xff, 0x00, 0x00, 0x00},
  /* map 2 submap 15 */
  {0x01, 0x18, 0x14, 0x40},
  {0000, 0x18, 0x16, 0x18},
  {0x01, 0x20, 0x16, 0x18},
  {0000, 0x20, 0x16, 0x20},
  {0xff, 0x00, 0x00, 0x00},
  /* map 2 submap 16 */
  {0000, 0x18, 0x15, 0x20},
  {0x01, 0x18, 0x15, 0x18},
  {0000, 0x20, 0x17, 0x20},
  {0x01, 0x20, 0x15, 0x20},
  {0xff, 0x00, 0x00, 0x00},
  /* map 2 submap 17 */
  {0x01, 0x20, 0x16, 0x20},
  {0000, 0x50, 0x18, 0x18},
  {0xff, 0x00, 0x00, 0x00},
  /* map 2 submap 18 */     /* sequence 18-...-1f ?? */
  {0x01, 0x18, 0x17, 0x50},
  {0000, 0x38, 0x19, 0x18},
  {0xff, 0x00, 0x00, 0x00},
  /* map 2 submap 19 */
  {0x01, 0x18, 0x18, 0x38},
  {0000, 0x18, 0x18, 0x20},
  {0000, 0x20, 0x1a, 0x18},
  {0xff, 0x00, 0x00, 0x00},
  /* map 2 submap 1a */
  {0x01, 0x18, 0x19, 0x20},
  {0000, 0x48, 0x1b, 0x20},
  {0000, 0x50, 0x19, 0x20},
  {0xff, 0x00, 0x00, 0x00},
  /* map 2 submap 1b */
  {0000, 0x18, 0x1b, 0x18},
  {0x01, 0x18, 0x1b, 0x18},
  {0x01, 0x20, 0x1a, 0x48},
  {0000, 0x20, 0x1c, 0x30},
  {0xff, 0x00, 0x00, 0x00},
  /* map 2 submap 1c */
  {0x01, 0x18, 0x1a, 0x18},
  {0x01, 0x30, 0x1b, 0x20},
  {0000, 0x48, 0x1d, 0x20},
  {0000, 0x50, 0x19, 0x20},
  {0xff, 0x00, 0x00, 0x00},
  /* map 2 submap 1d */
  {0000, 0x18, 0x1d, 0x18},
  {0x01, 0x20, 0x1c, 0x48},
  {0000, 0x20, 0x1e, 0x18},
  {0xff, 0x00, 0x00, 0x00},
  /* map 2 submap 1e */
  {0x01, 0x18, 0x1d, 0x20},
  {0000, 0x18, 0x17, 0x18},
  {0000, 0x38, 0x1f, 0x20},
  {0xff, 0x00, 0x00, 0x00},
  /* map 2 submap 1f */
  {0x01, 0x20, 0x1e, 0x38},
  {0000, 0x20, 0x20, 0x50},
  {0xff, 0x00, 0x00, 0x00},
  /* map 2 submap 20 */
  {0000, 0x18, 0x21, 0x50},
  {0x01, 0x50, 0x1f, 0x20},
  {0xff, 0x00, 0x00, 0x00},
  /* map 2 submap 21 */
  {0000, 0x18, 0x22, 0x18},
  {0x01, 0x50, 0x20, 0x18},
  {0xff, 0x00, 0x00, 0x00},
  /* map 2 submap 22 */
  {0x01, 0x18, 0x21, 0x18},
  {0000, 0x80, 0x23, 0x50},
  {0xff, 0x00, 0x00, 0x00},
  /* map 2 submap 23 */
  {0000, 0x18, 0x24, 0x50},
  {0x01, 0x50, 0x22, 0x80},
  {0xff, 0x00, 0x00, 0x00},
  /* map 2 submap 24 */
  {0000, 0x18, 0x25, 0x18},
  {0x01, 0x50, 0x23, 0x18},
  {0xff, 0x00, 0x00, 0x00},
  /* map 2 submap 25 */
  {0x01, 0x18, 0x24, 0x18},
  {0000, 0x50, 0xff, 0x00},
  {0xff, 0x00, 0x00, 0x00},

  /* map 3 */

  /* map 3 submap 26 */
  {0x01, 0x20, 0xff, 0x00},
  {0000, 0x28, 0x27, 0x68},
  {0xff, 0x00, 0x00, 0x00},
  /* map 3 submap 27 */
  {0000, 0x18, 0x28, 0x18},
  {0x01, 0x68, 0x26, 0x28},
  {0xff, 0x00, 0x00, 0x00},
  /* map 3 submap 28 */
  {0x01, 0x18, 0x27, 0x18},
  {0000, 0x20, 0x29, 0x18},
  {0xff, 0x00, 0x00, 0x00},
  /* map 3 submap 29 */
  {0x01, 0x18, 0x28, 0x20},
  {0000, 0x68, 0x2a, 0x18},
  {0xff, 0x00, 0x00, 0x00},
  /* map 3 submap 2a */
  {0x01, 0x18, 0x29, 0x68},
  {0000, 0x18, 0x2b, 0x68},
  {0xff, 0x00, 0x00, 0x00},
  /* map 3 submap 2b */
  {0000, 0x18, 0x2c, 0x20},
  {0x01, 0x68, 0x2a, 0x18},
  {0xff, 0x00, 0x00, 0x00},
  /* map 3 submap 2c */
  {0000, 0x18, 0x2d, 0x18},
  {0x01, 0x20, 0x2b, 0x18},
  {0xff, 0x00, 0x00, 0x00},
  /* map 3 submap 2d */
  {0x01, 0x18, 0x2c, 0x18},
  {0000, 0x60, 0x2e, 0x20},
  {0xff, 0x00, 0x00, 0x00},
  /* map 3 submap 2e */
  {0x01, 0x20, 0x2d, 0x60},
  {0000, 0x24, 0xff, 0x00},
  {0xff, 0x00, 0x00, 0x00},
};

U8 map_bnums[MAP_NBR_BNUMS] = {
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x54, 0x49, 0x48, 0x71, 0x54, 0x53, 0x55, 0x54,
  0x6d, 0x6e, 0x41, 0x41, 0x41, 0x41, 0x41, 0x52,
  0x51, 0x45, 0x45, 0x45, 0x50, 0x71, 0x43, 0x52,
  0x52, 0x46, 0x46, 0x46, 0x46, 0x50, 0x43, 0x76,
  0x71, 0x46, 0x54, 0x53, 0x55, 0x54, 0x43, 0x52,
  0x54, 0x48, 0x76, 0x42, 0x41, 0x41, 0x6e, 0x71,
  0x50, 0x42, 0x41, 0x6e, 0x52, 0x6f, 0x71, 0x52,
  0x4f, 0x43, 0x71, 0x6f, 0x46, 0x46, 0x46, 0x46,
  0x50, 0x43, 0x76, 0x48, 0x49, 0x49, 0x53, 0x52,
  0x71, 0x43, 0x41, 0x41, 0x79, 0x79, 0x41, 0x41,
  0x6d, 0x6e, 0x58, 0x59, 0x66, 0x65, 0x58, 0x59,
  0x51, 0x45, 0x45, 0x71, 0x76, 0x45, 0x71, 0x52,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x53, 0x51, 0x46, 0x46, 0x46, 0x54, 0x53, 0x51,
  0x42, 0x41, 0x52, 0x46, 0x50, 0x42, 0x41, 0x52,
  0x65, 0x40, 0x52, 0x50, 0x7e, 0x6e, 0x5c, 0x52,
  0x66, 0x65, 0x41, 0x41, 0x41, 0x40, 0x5b, 0x52,
  0x68, 0x66, 0x65, 0x40, 0x40, 0x5c, 0x58, 0x59,
  0x6f, 0x70, 0x50, 0x6c, 0x5d, 0x5b, 0x4a, 0x46,
  0x55, 0x46, 0x54, 0x43, 0x5f, 0x64, 0x40, 0x52,
  0x53, 0x55, 0x54, 0x6c, 0x5e, 0x5b, 0x5d, 0x52,
  0x50, 0x42, 0x41, 0x6e, 0x40, 0x64, 0x5f, 0x52,
  0x7e, 0x6b, 0x5e, 0x5d, 0x5e, 0x5b, 0x5e, 0x52,
  0x50, 0x6a, 0x40, 0x5f, 0x40, 0x64, 0x71, 0x52,
  0x50, 0x76, 0x6c, 0x5e, 0x40, 0x64, 0x52, 0x46,
  0x50, 0x42, 0x6e, 0x40, 0x40, 0x71, 0x51, 0x54,
  0x54, 0x43, 0x40, 0x40, 0x72, 0x52, 0x46, 0x46,
  0x50, 0x6c, 0x6e, 0x52, 0x70, 0x52, 0x53, 0x55,
  0x54, 0x43, 0x5e, 0x4a, 0x53, 0x55, 0x6f, 0x46,
  0x50, 0x43, 0x40, 0x40, 0x4a, 0x47, 0x49, 0x52,
  0x4f, 0x6c, 0x72, 0x40, 0x40, 0x4b, 0x4b, 0x52,
  0x46, 0x56, 0x71, 0x7a, 0x43, 0x40, 0x40, 0x52,
  0x54, 0x71, 0x51, 0x71, 0x73, 0x71, 0x43, 0x52,
  0x71, 0x71, 0x51, 0x54, 0x73, 0x76, 0x43, 0x71,
  0x7e, 0x41, 0x41, 0x41, 0x6e, 0x71, 0x43, 0x41,
  0x66, 0x65, 0x40, 0x40, 0x40, 0x41, 0x6e, 0x58,
  0x71, 0x71, 0x45, 0x45, 0x45, 0x45, 0x45, 0x71,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x50, 0x52, 0x49, 0x4a, 0x49, 0x47, 0x47, 0x4f,
  0x50, 0x42, 0x75, 0x40, 0x75, 0x4b, 0x4b, 0x41,
  0x54, 0x43, 0x5b, 0x5a, 0x5b, 0x5a, 0x40, 0x71,
  0x41, 0x6e, 0x64, 0x40, 0x64, 0x40, 0x5e, 0x7d,
  0x50, 0x6c, 0x5b, 0x5a, 0x5b, 0x5e, 0x5b, 0x52,
  0x50, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x46,
  0x71, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x54, 0x49, 0x4a, 0x49, 0x48, 0x49, 0x71, 0x76,
  0x41, 0x6e, 0x40, 0x4b, 0x41, 0x4b, 0x41, 0x52,
  0x71, 0x43, 0x40, 0x5b, 0x5e, 0x5b, 0x5a, 0x52,
  0x50, 0x43, 0x40, 0x5b, 0x5a, 0x7a, 0x40, 0x52,
  0x50, 0x56, 0x57, 0x60, 0x6f, 0x71, 0x43, 0x52,
  0x46, 0x50, 0x46, 0x46, 0x46, 0x76, 0x73, 0x52,
  0x51, 0x46, 0x46, 0x46, 0x50, 0x49, 0x74, 0x52,
  0x54, 0x54, 0x53, 0x55, 0x49, 0x74, 0x40, 0x52,
  0x4f, 0x42, 0x41, 0x4c, 0x43, 0x40, 0x72, 0x52,
  0x50, 0x43, 0x40, 0x4d, 0x43, 0x58, 0x59, 0x66,
  0x50, 0x43, 0x40, 0x4e, 0x43, 0x71, 0x51, 0x53,
  0x50, 0x6c, 0x40, 0x71, 0x71, 0x71, 0x54, 0x6f,
  0x4f, 0x6c, 0x5a, 0x41, 0x75, 0x4c, 0x76, 0x53,
  0x50, 0x43, 0x5c, 0x5e, 0x5b, 0x4d, 0x42, 0x51,
  0x50, 0x6c, 0x5b, 0x5a, 0x64, 0x4d, 0x43, 0x51,
  0x6d, 0x6e, 0x64, 0x40, 0x5b, 0x4e, 0x43, 0x51,
  0x51, 0x6f, 0x71, 0x73, 0x71, 0x76, 0x73, 0x52,
  0x46, 0x50, 0x76, 0x43, 0x76, 0x76, 0x73, 0x51,
  0x50, 0x71, 0x42, 0x6e, 0x52, 0x54, 0x73, 0x52,
  0x51, 0x76, 0x43, 0x40, 0x41, 0x4c, 0x43, 0x52,
  0x55, 0x76, 0x43, 0x72, 0x40, 0x4e, 0x43, 0x52,
  0x6f, 0x53, 0x76, 0x76, 0x76, 0x49, 0x6b, 0x52,
  0x76, 0x71, 0x49, 0x77, 0x77, 0x74, 0x5f, 0x76,
  0x50, 0x42, 0x79, 0x40, 0x7a, 0x76, 0x6f, 0x6f,
  0x4f, 0x6b, 0x76, 0x71, 0x49, 0x48, 0x46, 0x46,
  0x50, 0x6a, 0x41, 0x41, 0x6e, 0x41, 0x76, 0x46,
  0x50, 0x76, 0x76, 0x76, 0x76, 0x6b, 0x4a, 0x76,
  0x50, 0x49, 0x4c, 0x43, 0x4c, 0x6a, 0x40, 0x41,
  0x7a, 0x43, 0x4e, 0x43, 0x4e, 0x6a, 0x40, 0x76,
  0x46, 0x6f, 0x45, 0x6f, 0x45, 0x6f, 0x45, 0x51,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x54, 0x55, 0x47, 0x49, 0x4a, 0x55, 0x55, 0x46,
  0x41, 0x41, 0x4b, 0x79, 0x40, 0x41, 0x41, 0x54,
  0x71, 0x43, 0x40, 0x40, 0x40, 0x40, 0x40, 0x53,
  0x4f, 0x43, 0x44, 0x40, 0x69, 0x44, 0x40, 0x51,
  0x4f, 0x43, 0x40, 0x40, 0x69, 0x40, 0x72, 0x51,
  0x50, 0x43, 0x44, 0x40, 0x44, 0x40, 0x7a, 0x52,
  0x4f, 0x43, 0x72, 0x40, 0x40, 0x5c, 0x4a, 0x50,
  0x54, 0x43, 0x5b, 0x5e, 0x5d, 0x5b, 0x5a, 0x4f,
  0x6d, 0x72, 0x64, 0x40, 0x5f, 0x64, 0x40, 0x52,
  0x46, 0x50, 0x71, 0x76, 0x77, 0x64, 0x58, 0x59,
  0x50, 0x76, 0x77, 0x78, 0x6e, 0x58, 0x59, 0x76,
  0x4f, 0x42, 0x6e, 0x58, 0x59, 0x68, 0x68, 0x71,
  0x6d, 0x6e, 0x40, 0x75, 0x41, 0x75, 0x41, 0x51,
  0x50, 0x6c, 0x5e, 0x5b, 0x5e, 0x5b, 0x5a, 0x76,
  0x4f, 0x43, 0x40, 0x64, 0x40, 0x64, 0x40, 0x71,
  0x4f, 0x43, 0x5e, 0x5b, 0x5e, 0x5b, 0x5e, 0x41,
  0x7e, 0x6e, 0x40, 0x64, 0x40, 0x64, 0x40, 0x71,
  0x50, 0x71, 0x6f, 0x70, 0x45, 0x45, 0x70, 0x6f,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x71, 0x54, 0x53, 0x55, 0x47, 0x71, 0x54, 0x52,
  0x41, 0x41, 0x75, 0x41, 0x4b, 0x41, 0x41, 0x7d,
  0x76, 0x43, 0x76, 0x71, 0x43, 0x76, 0x73, 0x71,
  0x50, 0x43, 0x76, 0x42, 0x5b, 0x77, 0x74, 0x77,
  0x7e, 0x6e, 0x75, 0x6e, 0x64, 0x72, 0x72, 0x76,
  0x76, 0x45, 0x45, 0x45, 0x6f, 0x52, 0x71, 0x52,
  0x76, 0x46, 0x54, 0x53, 0x55, 0x51, 0x46, 0x76,
  0x46, 0x46, 0x51, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x53, 0x46, 0x54, 0x46, 0x54, 0x51, 0x46, 0x51,
  0x53, 0x51, 0x53, 0x53, 0x47, 0x53, 0x53, 0x51,
  0x53, 0x49, 0x78, 0x41, 0x41, 0x41, 0x41, 0x76,
  0x49, 0x43, 0x5d, 0x5d, 0x6e, 0x40, 0x40, 0x41,
  0x7e, 0x43, 0x40, 0x5f, 0x40, 0x5a, 0x40, 0x51,
  0x76, 0x43, 0x69, 0x76, 0x43, 0x40, 0x72, 0x52,
  0x50, 0x43, 0x40, 0x76, 0x43, 0x77, 0x70, 0x50,
  0x50, 0x43, 0x77, 0x77, 0x74, 0x69, 0x41, 0x7d,
  0x55, 0x6f, 0x70, 0x70, 0x50, 0x43, 0x69, 0x58,
  0x50, 0x49, 0x4c, 0x42, 0x4c, 0x43, 0x58, 0x59,
  0x50, 0x43, 0x4e, 0x43, 0x4e, 0x6b, 0x58, 0x55,
  0x50, 0x6b, 0x77, 0x77, 0x76, 0x76, 0x76, 0x51,
  0x6d, 0x6e, 0x40, 0x40, 0x41, 0x41, 0x41, 0x7d,
  0x4f, 0x43, 0x5e, 0x40, 0x5e, 0x5d, 0x5e, 0x52,
  0x50, 0x43, 0x44, 0x40, 0x5d, 0x5f, 0x40, 0x52,
  0x50, 0x43, 0x40, 0x5d, 0x5f, 0x5f, 0x40, 0x52,
  0x4f, 0x6b, 0x5e, 0x5e, 0x5e, 0x5e, 0x40, 0x52,
  0x7e, 0x6a, 0x40, 0x5c, 0x40, 0x40, 0x40, 0x51,
  0x4f, 0x6c, 0x5b, 0x5b, 0x5d, 0x6e, 0x58, 0x51,
  0x4f, 0x43, 0x64, 0x64, 0x5f, 0x58, 0x59, 0x51,
  0x4f, 0x43, 0x5d, 0x71, 0x77, 0x77, 0x71, 0x52,
  0x49, 0x43, 0x5f, 0x41, 0x40, 0x40, 0x41, 0x51,
  0x4f, 0x76, 0x50, 0x6c, 0x5e, 0x40, 0x5d, 0x52,
  0x4f, 0x42, 0x41, 0x6e, 0x40, 0x40, 0x5f, 0x51,
  0x7e, 0x6e, 0x40, 0x44, 0x72, 0x40, 0x5f, 0x7d,
  0x50, 0x6b, 0x76, 0x76, 0x71, 0x76, 0x71, 0x51,
  0x7e, 0x6a, 0x41, 0x41, 0x41, 0x41, 0x41, 0x71,
  0x50, 0x6c, 0x5b, 0x5d, 0x5e, 0x76, 0x71, 0x51,
  0x50, 0x43, 0x64, 0x5f, 0x40, 0x41, 0x41, 0x52,
  0x6d, 0x6e, 0x5e, 0x5e, 0x5d, 0x5e, 0x40, 0x52,
  0x50, 0x7a, 0x43, 0x40, 0x5f, 0x40, 0x7a, 0x51,
  0x6f, 0x6f, 0x45, 0x45, 0x45, 0x45, 0x52, 0x50,
  0x46, 0x51, 0x54, 0x48, 0x46, 0x51, 0x48, 0x46,
  0x46, 0x51, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x48, 0x46, 0x46,
  0x46, 0x49, 0x4a, 0x47, 0x48, 0x49, 0x4a, 0x46,
  0x4f, 0x43, 0x44, 0x41, 0x41, 0x6e, 0x44, 0x51,
  0x4f, 0x43, 0x40, 0x40, 0x40, 0x40, 0x40, 0x77,
  0x7e, 0x5d, 0x69, 0x69, 0x52, 0x70, 0x70, 0x70,
  0x50, 0x6a, 0x40, 0x40, 0x4a, 0x48, 0x48, 0x48,
  0x50, 0x6a, 0x40, 0x44, 0x40, 0x4c, 0x42, 0x4a,
  0x4f, 0x6a, 0x40, 0x40, 0x40, 0x4d, 0x43, 0x7d,
  0x50, 0x6c, 0x40, 0x7a, 0x43, 0x4e, 0x43, 0x51,
  0x50, 0x6b, 0x4a, 0x48, 0x48, 0x48, 0x6f, 0x48,
  0x4f, 0x6a, 0x40, 0x4c, 0x42, 0x41, 0x4a, 0x48,
  0x50, 0x6a, 0x40, 0x4e, 0x43, 0x40, 0x40, 0x52,
  0x46, 0x6f, 0x76, 0x71, 0x49, 0x74, 0x5e, 0x51,
  0x46, 0x49, 0x78, 0x41, 0x6e, 0x40, 0x5e, 0x7d,
  0x50, 0x43, 0x40, 0x69, 0x52, 0x6f, 0x6f, 0x70,
  0x4f, 0x6b, 0x44, 0x69, 0x4a, 0x48, 0x48, 0x46,
  0x50, 0x6a, 0x44, 0x69, 0x40, 0x4c, 0x4a, 0x48,
  0x7e, 0x6e, 0x40, 0x40, 0x40, 0x4e, 0x43, 0x52,
  0x6f, 0x6f, 0x76, 0x49, 0x74, 0x4a, 0x6f, 0x6f,
  0x46, 0x49, 0x78, 0x6e, 0x5d, 0x40, 0x4a, 0x52,
  0x50, 0x43, 0x69, 0x69, 0x5f, 0x5d, 0x5d, 0x51,
  0x7e, 0x6e, 0x69, 0x40, 0x40, 0x5f, 0x5f, 0x7d,
  0x7e, 0x69, 0x40, 0x40, 0x40, 0x40, 0x5f, 0x51,
  0x4f, 0x43, 0x40, 0x40, 0x7a, 0x43, 0x5f, 0x52,
  0x51, 0x71, 0x71, 0x76, 0x71, 0x6c, 0x5d, 0x51,
  0x46, 0x49, 0x78, 0x41, 0x41, 0x6e, 0x5f, 0x52,
  0x7e, 0x6e, 0x5e, 0x5d, 0x5e, 0x40, 0x40, 0x51,
  0x50, 0x6c, 0x5b, 0x5e, 0x5e, 0x69, 0x40, 0x51,
  0x71, 0x43, 0x64, 0x40, 0x40, 0x40, 0x69, 0x52,
  0x41, 0x6e, 0x7a, 0x6b, 0x5a, 0x72, 0x7a, 0x52,
  0x6f, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x51,
  0x52, 0x51, 0x54, 0x53, 0x51, 0x46, 0x54, 0x46,
  0x53, 0x46, 0x53, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x46, 0x46, 0x46, 0x54, 0x46, 0x54, 0x46, 0x46,
  0x53, 0x51, 0x53, 0x46, 0x54, 0x46, 0x52, 0x54,
  0x51, 0x48, 0x49, 0x4a, 0x47, 0x48, 0x48, 0x52,
  0x50, 0x42, 0x79, 0x69, 0x41, 0x41, 0x41, 0x52,
  0x6d, 0x6e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x51,
  0x50, 0x43, 0x76, 0x76, 0x43, 0x5a, 0x5d, 0x51,
  0x7e, 0x6e, 0x41, 0x41, 0x6e, 0x5d, 0x6e, 0x52,
  0x4f, 0x6c, 0x72, 0x72, 0x5d, 0x6e, 0x40, 0x7d,
  0x50, 0x6b, 0x5d, 0x5d, 0x6e, 0x40, 0x40, 0x52,
  0x4f, 0x43, 0x44, 0x40, 0x40, 0x76, 0x43, 0x51,
  0x7e, 0x6e, 0x40, 0x40, 0x40, 0x41, 0x6e, 0x7d,
  0x50, 0x43, 0x77, 0x77, 0x77, 0x77, 0x74, 0x71,
  0x50, 0x43, 0x71, 0x76, 0x71, 0x71, 0x76, 0x76,
  0x4f, 0x43, 0x41, 0x4d, 0x42, 0x41, 0x41, 0x52,
  0x4f, 0x76, 0x71, 0x76, 0x71, 0x71, 0x73, 0x51,
  0x4f, 0x49, 0x78, 0x41, 0x41, 0x77, 0x74, 0x52,
  0x7e, 0x6e, 0x40, 0x40, 0x40, 0x40, 0x40, 0x52,
  0x65, 0x40, 0x5e, 0x5a, 0x40, 0x5e, 0x5d, 0x51,
  0x66, 0x65, 0x40, 0x40, 0x40, 0x40, 0x40, 0x51,
  0x68, 0x66, 0x65, 0x72, 0x40, 0x40, 0x40, 0x52,
  0x71, 0x76, 0x76, 0x71, 0x43, 0x5a, 0x5d, 0x51,
  0x4f, 0x42, 0x41, 0x41, 0x6e, 0x40, 0x40, 0x52,
  0x50, 0x43, 0x5d, 0x6e, 0x4a, 0x6f, 0x6f, 0x51,
  0x4f, 0x6b, 0x6e, 0x40, 0x40, 0x4c, 0x4a, 0x51,
  0x4f, 0x6a, 0x5f, 0x40, 0x40, 0x4d, 0x43, 0x51,
  0x4f, 0x43, 0x5f, 0x7a, 0x43, 0x4e, 0x43, 0x52,
  0x50, 0x71, 0x76, 0x76, 0x76, 0x71, 0x43, 0x52,
  0x4f, 0x42, 0x4c, 0x42, 0x41, 0x4c, 0x43, 0x51,
  0x7e, 0x6e, 0x4e, 0x43, 0x40, 0x4e, 0x43, 0x7d,
  0x50, 0x43, 0x71, 0x76, 0x71, 0x76, 0x71, 0x52,
  0x50, 0x43, 0x77, 0x78, 0x41, 0x41, 0x41, 0x77,
  0x71, 0x71, 0x71, 0x71, 0x43, 0x71, 0x6f, 0x6f,
  0x46, 0x76, 0x46, 0x76, 0x71, 0x71, 0x76, 0x76,
  0x46, 0x55, 0x46, 0x52, 0x53, 0x51, 0x54, 0x46,
  0x46, 0x46, 0x51, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46, 0x46,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
  0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
  0x09, 0x06, 0x07, 0x1a, 0x07, 0x1a, 0x07, 0x09,
  0x09, 0x08, 0x1d, 0x1b, 0x02, 0x1b, 0x1d, 0x09,
  0x07, 0x2e, 0x16, 0x1c, 0x02, 0x1c, 0x16, 0xff,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x0a, 0x30, 0x1a, 0x07, 0x1a, 0x28, 0x37,
  0x37, 0x06, 0x2e, 0x1c, 0x16, 0x1c, 0x02, 0x07,
  0x37, 0x2d, 0x0b, 0x09, 0x09, 0x0a, 0x2d, 0x37,
  0x37, 0x22, 0x07, 0x07, 0x07, 0x07, 0x3d, 0x37,
  0x37, 0x22, 0x0b, 0x09, 0x09, 0x09, 0x09, 0x09,
  0x37, 0x22, 0x28, 0x33, 0x28, 0x28, 0x33, 0x37,
  0x0b, 0x09, 0x09, 0x09, 0x0a, 0x30, 0x0f, 0x37,
  0x0b, 0x09, 0x0a, 0x30, 0x33, 0x2e, 0x10, 0x37,
  0x37, 0x30, 0x33, 0x2e, 0x02, 0x29, 0x0b, 0x0a,
  0x37, 0x08, 0x01, 0x29, 0x0b, 0x09, 0x09, 0x0a,
  0x37, 0x2f, 0x34, 0x07, 0x07, 0x28, 0x0b, 0x0a,
  0x0b, 0x09, 0x32, 0x2f, 0x34, 0x1d, 0x07, 0x37,
  0x0b, 0x09, 0x09, 0x09, 0x32, 0x2f, 0x34, 0x37,
  0x37, 0x06, 0x1a, 0x07, 0x1a, 0x28, 0x0f, 0x37,
  0x7c, 0x2e, 0x1c, 0x01, 0x1c, 0x02, 0x10, 0x37,
  0x0b, 0x09, 0x0a, 0x2d, 0x0c, 0x0b, 0x09, 0x0a,
  0x0b, 0x0a, 0x06, 0x3d, 0x01, 0x07, 0x0b, 0x0a,
  0x37, 0x0d, 0x0c, 0x0f, 0x0c, 0x21, 0x0b, 0x0a,
  0x37, 0x08, 0x02, 0x10, 0x01, 0x1c, 0x07, 0x37,
  0x0b, 0x0a, 0x2d, 0x0c, 0x0c, 0x0c, 0x0f, 0x37,
  0x37, 0x06, 0x3d, 0x04, 0x03, 0x05, 0x10, 0x7b,
  0x0b, 0x0a, 0x0d, 0x0c, 0x0f, 0x0c, 0x0c, 0x37,
  0x37, 0x2c, 0x2e, 0x02, 0x10, 0x04, 0x03, 0x37,
  0x37, 0x2d, 0x0b, 0x09, 0x09, 0x31, 0x2b, 0x37,
  0x37, 0x22, 0x07, 0x07, 0x07, 0x07, 0x02, 0x37,
  0x2a, 0x28, 0x0b, 0x09, 0x09, 0x0a, 0x2d, 0x37,
  0x37, 0x08, 0x07, 0x07, 0x07, 0x07, 0x3d, 0x7b,
  0x0b, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x0a, 0x06, 0x1a, 0x07, 0x28, 0x0b, 0x0a,
  0x37, 0x30, 0x3c, 0x1b, 0x04, 0x05, 0x28, 0x37,
  0x37, 0x08, 0x02, 0x1c, 0x16, 0x02, 0x02, 0x07,
  0x37, 0x2d, 0x0c, 0x0c, 0x0c, 0x0c, 0x0f, 0x37,
  0x37, 0x22, 0x02, 0x29, 0x34, 0x01, 0x10, 0x37,
  0x37, 0x2d, 0x21, 0x37, 0x2f, 0x29, 0x38, 0x37,
  0x37, 0x22, 0x1b, 0x37, 0x30, 0x33, 0x07, 0x37,
  0x37, 0x22, 0x1b, 0x17, 0x2e, 0x04, 0x05, 0x37,
  0x7c, 0x22, 0x1c, 0x18, 0x04, 0x05, 0x0f, 0x37,
  0x0b, 0x09, 0x09, 0x09, 0x0a, 0x08, 0x10, 0x37,
  0x37, 0x06, 0x17, 0x07, 0x0b, 0x0a, 0x22, 0x37,
  0x37, 0x08, 0x18, 0x1d, 0x07, 0x28, 0x22, 0x37,
  0x37, 0x2d, 0x37, 0x2f, 0x34, 0x02, 0x10, 0x37,
  0x37, 0x22, 0x0b, 0x09, 0x0a, 0x30, 0x28, 0x37,
  0x37, 0x22, 0x17, 0x07, 0x07, 0x23, 0x2b, 0x37,
  0x37, 0x22, 0x18, 0x04, 0x03, 0x05, 0x02, 0x37,
  0x0b, 0x37, 0x3f, 0x02, 0x36, 0x29, 0x34, 0x37,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x0a, 0x2d, 0x37,
  0x37, 0x06, 0x28, 0x28, 0x28, 0x37, 0x22, 0x37,
  0x37, 0x2d, 0x37, 0x08, 0x36, 0x29, 0x22, 0x37,
  0x07, 0x3d, 0x0b, 0x30, 0x28, 0x17, 0x3d, 0x37,
  0x37, 0x30, 0x28, 0x3c, 0x19, 0x18, 0x10, 0x37,
  0x0b, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x37, 0x30, 0x3f, 0x1f, 0x07, 0x07, 0x07, 0x37,
  0x2a, 0x2e, 0x28, 0x1e, 0x16, 0x04, 0x05, 0x07,
  0x37, 0x2d, 0x0b, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x37, 0x22, 0x37, 0x3a, 0x39, 0x39, 0x39, 0x37,
  0x37, 0x22, 0x39, 0x23, 0x01, 0x1d, 0x01, 0x37,
  0x37, 0x22, 0x02, 0x26, 0x26, 0x29, 0x34, 0x37,
  0x0b, 0x0a, 0x2f, 0x0b, 0x09, 0x0a, 0x2d, 0x37,
  0x07, 0x28, 0x0b, 0x09, 0x09, 0x0a, 0x22, 0x37,
  0x37, 0x08, 0x3f, 0x39, 0x39, 0x37, 0x22, 0x37,
  0x37, 0x2f, 0x07, 0x04, 0x05, 0x28, 0x22, 0x37,
  0x0b, 0x09, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x37, 0x06, 0x28, 0x0b, 0x0a, 0x30, 0x33, 0x37,
  0x7c, 0x2e, 0x24, 0x39, 0x39, 0x24, 0x04, 0x7b,
  0x37, 0x08, 0x25, 0x04, 0x05, 0x25, 0x04, 0x37,
  0x37, 0x08, 0x3f, 0x11, 0x11, 0x37, 0x08, 0x37,
  0x37, 0x2d, 0x3f, 0x12, 0x12, 0x37, 0x2d, 0x37,
  0x37, 0x22, 0x3f, 0x13, 0x13, 0x37, 0x22, 0x37,
  0x37, 0x2d, 0x3f, 0x11, 0x11, 0x37, 0x2d, 0x37,
  0x37, 0x22, 0x3f, 0x12, 0x12, 0x37, 0x22, 0x37,
  0x07, 0x07, 0x1a, 0x12, 0x12, 0x1a, 0x3d, 0x07,
  0x37, 0x08, 0x1c, 0x13, 0x13, 0x1c, 0x10, 0x37,
  0x0b, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x09,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x37, 0x06, 0x07, 0x15, 0x07, 0x15, 0x37, 0x37,
  0x07, 0x2e, 0x2b, 0x14, 0x2b, 0x14, 0x1f, 0x37,
  0x37, 0x08, 0x02, 0x14, 0x16, 0x14, 0x1e, 0x7b,
  0x0b, 0x0a, 0x08, 0x0b, 0x09, 0x09, 0x09, 0x09,
  0x37, 0x06, 0x2e, 0x15, 0x07, 0x15, 0x07, 0x37,
  0x37, 0x08, 0x0b, 0x0a, 0x2d, 0x37, 0x08, 0x37,
  0x37, 0x08, 0x07, 0x07, 0x3d, 0x0b, 0x09, 0x0a,
  0x0b, 0x0a, 0x08, 0x0f, 0x0b, 0x0a, 0x06, 0x07,
  0x37, 0x06, 0x2e, 0x10, 0x37, 0x06, 0x2e, 0x37,
  0x37, 0x27, 0x37, 0x22, 0x07, 0x2e, 0x37, 0x0a,
  0x0b, 0x0e, 0x09, 0x0e, 0x0e, 0x0e, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x37, 0x3a, 0x07, 0x39, 0x39, 0x07, 0x39, 0x37,
  0x37, 0x08, 0x2b, 0x2b, 0x01, 0x1d, 0x01, 0x37,
  0x07, 0x2e, 0x04, 0x05, 0x01, 0x2b, 0x02, 0x37,
  0x0b, 0x09, 0x0a, 0x2f, 0x34, 0x04, 0x05, 0x37,
  0x37, 0x3a, 0x39, 0x39, 0x2e, 0x37, 0x08, 0x37,
  0x37, 0x08, 0x29, 0x34, 0x29, 0x37, 0x08, 0x0a,
  0x37, 0x08, 0x15, 0x27, 0x15, 0x15, 0x27, 0x37,
  0x37, 0x08, 0x0b, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x37, 0x08, 0x39, 0x39, 0x39, 0x39, 0x39, 0x37,
  0x37, 0x08, 0x02, 0x1d, 0x02, 0x1d, 0x02, 0x7b,
  0x0b, 0x0a, 0x27, 0x2b, 0x26, 0x2b, 0x02, 0x37,
  0x37, 0x30, 0x0c, 0x0c, 0x0c, 0x0c, 0x0f, 0x37,
  0x37, 0x08, 0x29, 0x29, 0x29, 0x34, 0x10, 0x37,
  0x37, 0x2d, 0x28, 0x28, 0x0b, 0x09, 0x09, 0x0a,
  0x37, 0x22, 0x29, 0x34, 0x07, 0x07, 0x39, 0x37,
  0x0b, 0x22, 0x37, 0x08, 0x29, 0x37, 0x08, 0x0a,
  0x37, 0x22, 0x37, 0x08, 0x07, 0x07, 0x2e, 0x37,
  0x37, 0x22, 0x28, 0x28, 0x28, 0x28, 0x3c, 0x37,
  0x37, 0x22, 0x29, 0x29, 0x29, 0x29, 0x0b, 0x0a,
  0x37, 0x06, 0x39, 0x39, 0x37, 0x3a, 0x39, 0x37,
  0x37, 0x08, 0x1d, 0x04, 0x39, 0x2e, 0x02, 0x07,
  0x37, 0x08, 0x26, 0x26, 0x26, 0x26, 0x26, 0x37,
  0x0b, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x37, 0x06, 0x0b, 0x09, 0x0a, 0x06, 0x07, 0x37,
  0x37, 0x08, 0x1f, 0x1f, 0x1f, 0x2e, 0x02, 0x37,
  0x07, 0x2e, 0x1e, 0x1e, 0x1e, 0x16, 0x01, 0xff,
  0x0b, 0x09, 0x09, 0x09, 0x0a, 0x30, 0x0f, 0x37,
  0x0b, 0x0a, 0x06, 0x07, 0x1f, 0x2e, 0x10, 0x37,
  0x2a, 0x07, 0x2e, 0x02, 0x1e, 0x01, 0x10, 0xff,
  0x0b, 0x0a, 0x08, 0x0b, 0x09, 0x09, 0x09, 0x0a,
  0x37, 0x06, 0x2e, 0x37, 0x3a, 0x07, 0x3b, 0x37,
  0x3f, 0x2e, 0x28, 0x28, 0x3c, 0x36, 0x34, 0x37,
  0x37, 0x2f, 0x29, 0x29, 0x29, 0x37, 0x08, 0x37,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x0a, 0x08, 0x37,
  0x37, 0x06, 0x15, 0x39, 0x07, 0x15, 0x2e, 0x37,
  0x37, 0x08, 0x14, 0x04, 0x05, 0x0b, 0x09, 0x0a,
  0x37, 0x30, 0x28, 0x3c, 0x0b, 0x0a, 0x3a, 0x37,
  0x3f, 0x2e, 0x04, 0x05, 0x07, 0x28, 0x3c, 0x37,
  0x3f, 0x02, 0x36, 0x26, 0x0b, 0x0a, 0x08, 0x37,
  0x3f, 0x01, 0x0b, 0x09, 0x0a, 0x30, 0x3c, 0x37,
  0x31, 0x2b, 0x07, 0x37, 0x3a, 0x2e, 0x2b, 0x37,
  0x37, 0x08, 0x02, 0x0b, 0x0a, 0x08, 0x02, 0x37,
  0x7c, 0x2e, 0x29, 0x37, 0x06, 0x2b, 0x2b, 0x37,
  0x37, 0x08, 0x39, 0x28, 0x3f, 0x2b, 0x01, 0x37,
  0x2a, 0x2e, 0x36, 0x26, 0x3f, 0x02, 0x2b, 0x37,
  0x37, 0x3f, 0x0b, 0x09, 0x0a, 0x08, 0x29, 0x37,
  0x37, 0x06, 0x07, 0x07, 0x07, 0x2e, 0x07, 0x37,
  0x37, 0x08, 0x29, 0x34, 0x01, 0x01, 0x16, 0x37,
  0x3f, 0x2e, 0x37, 0x3f, 0x26, 0x36, 0x0b, 0x0a,
  0x3f, 0x04, 0x28, 0x28, 0x28, 0x28, 0x33, 0x07,
  0x37, 0x2f, 0x29, 0x29, 0x29, 0x29, 0x29, 0x37,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
  0x3f, 0x07, 0x07, 0x28, 0x28, 0x33, 0x07, 0x37,
  0x2a, 0x36, 0x0b, 0x09, 0x09, 0x0a, 0x08, 0x28,
  0x31, 0x07, 0x17, 0x07, 0x07, 0x17, 0x28, 0x37,
  0x31, 0x02, 0x18, 0x02, 0x02, 0x18, 0x16, 0x37,
  0x0b, 0x0a, 0x30, 0x2d, 0x0f, 0x28, 0x0b, 0x0a,
  0x7c, 0x06, 0x16, 0x10, 0x10, 0x16, 0x07, 0x7b,
  0x37, 0x08, 0x37, 0x2d, 0x0f, 0x37, 0x08, 0x37,
  0x37, 0x08, 0x1f, 0x3d, 0x10, 0x1f, 0x2e, 0x37,
  0x37, 0x08, 0x1e, 0x01, 0x02, 0x1e, 0x02, 0x37,
  0x37, 0x08, 0x37, 0x2d, 0x0f, 0x37, 0x08, 0x37,
  0x7c, 0x2e, 0x3b, 0x23, 0x02, 0x3b, 0x2e, 0x7b,
  0x2a, 0x02, 0x1d, 0x01, 0x02, 0x1d, 0x02, 0xff,
  0x0b, 0x09, 0x31, 0x02, 0x02, 0x37, 0x2d, 0x37,
  0x37, 0x2c, 0x07, 0x02, 0x02, 0x15, 0x10, 0x7b,
  0x37, 0x2d, 0x23, 0x37, 0x30, 0x28, 0x0b, 0x0a,
  0x37, 0x22, 0x01, 0x07, 0x29, 0x01, 0x07, 0x37,
  0x37, 0x30, 0x28, 0x28, 0x17, 0x28, 0x23, 0x37,
  0x7c, 0x08, 0x1d, 0x16, 0x18, 0x1d, 0x02, 0x7b,
  0x37, 0x2d, 0x37, 0x0e, 0x0e, 0x0e, 0x0e, 0x0a,
  0x37, 0x22, 0x07, 0x3b, 0x3b, 0x11, 0x3b, 0x37,
  0x31, 0x2b, 0x01, 0x29, 0x34, 0x13, 0x02, 0x37,
  0x37, 0x08, 0x24, 0x1f, 0x24, 0x0c, 0x0f, 0x37,
  0x7c, 0x08, 0x25, 0x1e, 0x25, 0x02, 0x38, 0x37,
  0x37, 0x2d, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x37,
  0x37, 0x22, 0x1d, 0x01, 0x01, 0x01, 0x23, 0x37,
  0x37, 0x06, 0x23, 0x02, 0x28, 0x3c, 0x23, 0x37,
  0x0b, 0x0a, 0x08, 0x03, 0x29, 0x34, 0x01, 0x37,
  0x07, 0x15, 0x2e, 0x02, 0x1f, 0x2e, 0x2b, 0x37,
  0x0b, 0x0a, 0x27, 0x01, 0x1e, 0x2b, 0x01, 0x7b,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
  0x37, 0x06, 0x15, 0x07, 0x0b, 0x09, 0x09, 0x0a,
  0x2a, 0x2e, 0x37, 0x08, 0x39, 0x39, 0x39, 0x37,
  0x37, 0x08, 0x37, 0x2f, 0x34, 0x04, 0x05, 0x37,
  0x37, 0x27, 0x0b, 0x09, 0x09, 0x0a, 0x08, 0x37,
  0x37, 0x30, 0x28, 0x33, 0x11, 0x07, 0x2e, 0x37,
  0x32, 0x2f, 0x34, 0x02, 0x13, 0x02, 0x36, 0x37,
  0x0b, 0x09, 0x0a, 0x08, 0x0b, 0x09, 0x09, 0x0a,
  0x37, 0x3a, 0x07, 0x2e, 0x07, 0x3b, 0x3b, 0x37,
  0x37, 0x08, 0x01, 0x37, 0x08, 0x02, 0x01, 0x7b,
  0x37, 0x08, 0x0f, 0x28, 0x22, 0x01, 0x01, 0x07,
  0x37, 0x08, 0x10, 0x02, 0x10, 0x26, 0x0b, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x37, 0x3a, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x37,
  0x2a, 0x2e, 0x04, 0x03, 0x05, 0x04, 0x05, 0x7b,
  0x37, 0x08, 0x2b, 0x2b, 0x2b, 0x2b, 0x02, 0x37,
  0x37, 0x27, 0x01, 0x01, 0x02, 0x01, 0x26, 0x37,
  0x0b, 0x09, 0x0a, 0x08, 0x37, 0x08, 0x0b, 0x0a,
  0x37, 0x06, 0x37, 0x08, 0x37, 0x27, 0x0b, 0x0a,
  0x37, 0x08, 0x15, 0x2e, 0x15, 0x28, 0x28, 0x37,
  0x37, 0x08, 0x37, 0x27, 0x37, 0x08, 0x29, 0x37,
  0x37, 0x08, 0x21, 0x0c, 0x21, 0x3c, 0x1f, 0x37,
  0x7c, 0x08, 0x1c, 0x02, 0x1c, 0x02, 0x1e, 0x37,
  0x37, 0x0d, 0x0c, 0x3c, 0x0c, 0x0c, 0x0f, 0x37,
  0x37, 0x08, 0x16, 0x02, 0x02, 0x02, 0x10, 0x37,
  0x37, 0x08, 0x21, 0x0b, 0x32, 0x2f, 0x10, 0x37,
  0x37, 0x08, 0x1c, 0x07, 0x15, 0x07, 0x3d, 0x7b,
  0x37, 0x0d, 0x21, 0x0c, 0x0c, 0x3c, 0x10, 0x37,
  0x37, 0x08, 0x1c, 0x01, 0x01, 0x24, 0x10, 0x37,
  0x37, 0x0d, 0x0c, 0x3c, 0x24, 0x37, 0x38, 0x37,
  0x37, 0x08, 0x04, 0x24, 0x0b, 0x09, 0x09, 0x0a,
  0x3f, 0x2e, 0x04, 0x0b, 0x09, 0x09, 0x09, 0x0a,
  0x7c, 0x04, 0x26, 0x15, 0x07, 0x07, 0x14, 0x37,
  0x37, 0x08, 0x28, 0x37, 0x08, 0x0b, 0x09, 0x0a,
  0x0b, 0x0a, 0x08, 0x28, 0x3c, 0x07, 0x07, 0x15,
  0x7c, 0x2c, 0x2e, 0x36, 0x34, 0x16, 0x04, 0x37,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x37, 0x3a, 0x39, 0x39, 0x39, 0x39, 0x39, 0x37,
  0x37, 0x08, 0x04, 0x05, 0x28, 0x3c, 0x01, 0x28,
  0x37, 0x2d, 0x23, 0x0b, 0x09, 0x09, 0x09, 0x0a,
  0x37, 0x22, 0x02, 0x07, 0x07, 0x18, 0x07, 0x37,
  0x37, 0x0d, 0x0c, 0x0c, 0x0f, 0x0c, 0x0c, 0x37,
  0x37, 0x08, 0x02, 0x1d, 0x10, 0x1d, 0x01, 0x37,
  0x37, 0x30, 0x3c, 0x01, 0x37, 0x08, 0x01, 0x7b,
  0x37, 0x08, 0x01, 0x28, 0x28, 0x28, 0x3c, 0x37,
  0x2a, 0x2e, 0x28, 0x0b, 0x09, 0x09, 0x09, 0x0a,
  0x37, 0x2f, 0x34, 0x17, 0x3b, 0x3b, 0x17, 0x7b,
  0x37, 0x06, 0x2e, 0x0b, 0x09, 0x0a, 0x2d, 0x37,
  0x32, 0x2f, 0x34, 0x17, 0x3b, 0x17, 0x3d, 0x37,
  0x37, 0x2d, 0x0c, 0x0c, 0x3c, 0x0f, 0x0c, 0x37,
  0x37, 0x0d, 0x0f, 0x3c, 0x0f, 0x22, 0x01, 0x37,
  0x7c, 0x08, 0x10, 0x0f, 0x22, 0x22, 0x02, 0x7b,
  0x37, 0x2d, 0x37, 0x30, 0x28, 0x37, 0x2d, 0x37,
  0x37, 0x22, 0x28, 0x3c, 0x05, 0x37, 0x22, 0x37,
  0x37, 0x08, 0x02, 0x3f, 0x23, 0x07, 0x2e, 0x37,
  0x37, 0x08, 0x02, 0x3f, 0x23, 0x23, 0x02, 0x0a,
  0x0b, 0x20, 0x0e, 0x32, 0x2f, 0x34, 0x2b, 0x37,
  0x37, 0x06, 0x07, 0x1f, 0x11, 0x2e, 0x0b, 0x0a,
  0x07, 0x2e, 0x16, 0x1e, 0x13, 0x0b, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x0b, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0a,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x87, 0x85, 0x85, 0x85, 0x85, 0x85, 0x80,
  0x80, 0x86, 0x84, 0x84, 0x84, 0x84, 0xb2, 0xaa,
  0x80, 0x86, 0x84, 0x84, 0x84, 0x99, 0x99, 0x80,
  0x8a, 0x88, 0x84, 0x84, 0x84, 0x84, 0x84, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x83, 0x8f, 0x8d, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x90, 0x99, 0x80,
  0x8a, 0x85, 0x85, 0x85, 0x85, 0x85, 0x84, 0x80,
  0x80, 0x8f, 0x8d, 0x8d, 0x99, 0x80, 0x80, 0x80,
  0x80, 0x90, 0x84, 0x84, 0x84, 0xac, 0x87, 0x80,
  0x82, 0x81, 0x83, 0x8f, 0x82, 0x81, 0x81, 0x83,
  0x80, 0x87, 0x85, 0xb9, 0x85, 0x80, 0xae, 0x80,
  0x80, 0x86, 0x99, 0x80, 0x80, 0xae, 0xa1, 0x85,
  0x80, 0x86, 0x84, 0x85, 0x85, 0x88, 0x9b, 0x9c,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x83, 0x87, 0x85, 0x82, 0x81, 0x83,
  0x80, 0x87, 0x85, 0x88, 0x84, 0x85, 0x85, 0x80,
  0x85, 0x88, 0x84, 0x93, 0x93, 0x93, 0x84, 0x85,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85,
  0x80, 0x86, 0x96, 0x95, 0x96, 0x95, 0x93, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x83, 0x87, 0x85, 0x82, 0x81, 0x83,
  0x80, 0x87, 0x85, 0x88, 0x84, 0x85, 0x85, 0x80,
  0x85, 0x88, 0x84, 0x93, 0x93, 0x93, 0x84, 0x85,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85,
  0x80, 0x86, 0x96, 0x95, 0x96, 0x95, 0x94, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x87, 0x85, 0x85, 0x85, 0x85, 0x85, 0x80,
  0x8a, 0x88, 0x94, 0x93, 0xb2, 0x84, 0x84, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x86, 0x80,
  0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x88, 0x80,
  0x82, 0x83, 0x8e, 0x8d, 0x8d, 0x8d, 0x8c, 0x80,
  0x80, 0x87, 0x88, 0x84, 0x84, 0x84, 0x8b, 0x80,
  0x80, 0x8f, 0x80, 0x86, 0x84, 0x84, 0x9f, 0x80,
  0x80, 0x90, 0x80, 0x95, 0x94, 0x94, 0xb0, 0x80,
  0x80, 0x90, 0x99, 0x9a, 0xaf, 0x9f, 0x9f, 0x80,
  0x9c, 0x9c, 0x9d, 0xb1, 0x84, 0x84, 0xb2, 0x80,
  0x80, 0x80, 0x80, 0xae, 0xa1, 0x9b, 0x9c, 0x9c,
  0x80, 0x87, 0x85, 0x88, 0x9a, 0x9f, 0x9f, 0x80,
  0x80, 0x86, 0x94, 0x97, 0xb1, 0x93, 0x84, 0x80,
  0x80, 0xae, 0x99, 0x99, 0x99, 0x99, 0xa1, 0xaa,
  0x80, 0x86, 0x82, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x8f, 0x80, 0x80, 0x80, 0x87, 0x85, 0x85,
  0x8a, 0xb9, 0x85, 0x85, 0x85, 0x88, 0x93, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x83, 0x87, 0x85, 0x82, 0x81, 0x83,
  0x80, 0x89, 0x85, 0x88, 0x84, 0x85, 0x89, 0x80,
  0x85, 0x88, 0x84, 0x84, 0x84, 0x84, 0x84, 0x80,
  0x80, 0x8f, 0x8d, 0x8c, 0x8d, 0x8c, 0x8c, 0x80,
  0x8a, 0xb9, 0x84, 0x8b, 0x84, 0x8b, 0x8b, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x8f, 0x80,
  0x80, 0x87, 0xa8, 0xa7, 0xa7, 0xa9, 0x8b, 0x80,
  0x80, 0x86, 0xa5, 0xa4, 0xa4, 0xa6, 0x8b, 0x80,
  0x80, 0x86, 0x82, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x86, 0xad, 0x87, 0x85, 0x85, 0x85, 0x80,
  0x80, 0x86, 0x82, 0x81, 0x81, 0x83, 0x86, 0x85,
  0x80, 0x86, 0x99, 0x99, 0xab, 0x85, 0x88, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x87, 0x85, 0xa8, 0xa7, 0xa7, 0xa9, 0x80,
  0x87, 0x88, 0x84, 0xa5, 0xa4, 0xa4, 0xa6, 0x85,
  0x80, 0x86, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x8a, 0x88, 0x85, 0xa8, 0xa7, 0xa9, 0x85, 0x85,
  0x9d, 0x84, 0x84, 0xa5, 0xa4, 0xa6, 0x9b, 0x9c,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x85, 0x85, 0x85, 0xb3, 0x9c, 0x9e, 0x85, 0xaa,
  0x9d, 0x84, 0x84, 0x84, 0x85, 0x88, 0x84, 0x9b,
  0x80, 0xb7, 0xbc, 0x80, 0xae, 0xa1, 0x9b, 0x9c,
  0x80, 0x80, 0x80, 0x87, 0x88, 0x84, 0x99, 0x80,
  0x8a, 0x85, 0x85, 0x88, 0x84, 0xb2, 0x93, 0xaa,
  0x80, 0x8e, 0x8c, 0x8d, 0x8d, 0x8d, 0x8d, 0x80,
  0x8a, 0xb4, 0x90, 0x84, 0x84, 0x84, 0xb2, 0xaa,
  0x80, 0x8e, 0x8d, 0x8d, 0x8d, 0x8c, 0x8d, 0x80,
  0x8a, 0xb4, 0x84, 0x84, 0x84, 0x8b, 0x84, 0xaa,
  0x80, 0x8e, 0x8c, 0x8d, 0x8d, 0x8d, 0x8d, 0x80,
  0x80, 0x86, 0x8b, 0x84, 0x84, 0x84, 0xb2, 0x80,
  0x80, 0x80, 0x80, 0x80, 0xbb, 0x84, 0x82, 0x83,
  0x80, 0x87, 0x85, 0x85, 0xba, 0x84, 0x85, 0xb5,
  0x9c, 0x9c, 0x9d, 0x84, 0x84, 0x9b, 0x9c, 0x9c,
  0x8a, 0x91, 0x85, 0x88, 0x9b, 0x9c, 0x9e, 0x91,
  0x9c, 0x9c, 0x9d, 0x84, 0x91, 0x85, 0x88, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x87, 0x85, 0x85, 0x85, 0xb3, 0x9c, 0x9c,
  0x85, 0x88, 0x84, 0xb6, 0x86, 0x84, 0x85, 0x85,
  0x80, 0xae, 0x8f, 0x80, 0x86, 0x80, 0x8f, 0x80,
  0x85, 0x88, 0xb9, 0x80, 0x86, 0x80, 0x90, 0x85,
  0x80, 0x86, 0x80, 0x87, 0x88, 0x85, 0xb9, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x89, 0xa8, 0xa7, 0xa9, 0x85, 0x89, 0x80,
  0x85, 0x88, 0xa5, 0xa4, 0xa6, 0x84, 0x84, 0x80,
  0x80, 0xae, 0x99, 0x99, 0x99, 0xa1, 0x84, 0x80,
  0x80, 0x86, 0xa2, 0xa2, 0xa2, 0xa2, 0x80, 0x80,
  0x80, 0x8f, 0x80, 0x87, 0xa8, 0xa7, 0xa9, 0x80,
  0x80, 0x90, 0x85, 0x88, 0xa5, 0xa4, 0xa6, 0x80,
  0x80, 0x8f, 0x8d, 0xb8, 0x82, 0x81, 0x81, 0x83,
  0x85, 0xb9, 0x84, 0x84, 0xa3, 0xa8, 0xa7, 0x80,
  0x82, 0x83, 0x86, 0x84, 0x85, 0xa5, 0xa4, 0x80,
  0x80, 0xae, 0x99, 0x80, 0x8e, 0x8d, 0x8c, 0x80,
  0x80, 0x86, 0x84, 0x85, 0x88, 0x84, 0x8b, 0x80,
  0x8a, 0x88, 0x80, 0xb7, 0xa2, 0xa2, 0x80, 0x80,
  0x80, 0x86, 0x85, 0x80, 0xbb, 0x85, 0x85, 0x80,
  0x80, 0x86, 0x84, 0x91, 0xba, 0x84, 0x94, 0x91,
  0x80, 0x8e, 0xb8, 0x99, 0xbb, 0x84, 0x80, 0x80,
  0x80, 0x8e, 0xb8, 0x84, 0xba, 0x84, 0x85, 0x91,
  0x80, 0xb7, 0xbc, 0xb7, 0x80, 0x86, 0x84, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x87, 0xb9, 0x91, 0x85, 0x91, 0x85, 0x80,
  0x8a, 0x88, 0x8b, 0x82, 0x81, 0x83, 0x86, 0x85,
  0x80, 0x86, 0x8b, 0x99, 0xab, 0x85, 0x80, 0x80,
  0x85, 0x88, 0x84, 0x84, 0x84, 0x84, 0x85, 0x85,
  0x80, 0xb7, 0x8b, 0x80, 0xb7, 0xbc, 0x86, 0xb6,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x89, 0x85, 0x85, 0x85, 0x85, 0x89, 0x80,
  0x85, 0x88, 0x84, 0x84, 0x84, 0x84, 0x84, 0x99,
  0x80, 0x8f, 0x8d, 0x8d, 0x8d, 0x8d, 0x8c, 0x80,
  0x82, 0x81, 0x81, 0x83, 0x8f, 0x82, 0x81, 0x83,
  0x80, 0x87, 0x85, 0x85, 0xb9, 0x85, 0x85, 0xb6,
  0x80, 0x86, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x86, 0x85, 0x85, 0x85, 0x85, 0x85, 0x80,
  0x80, 0x86, 0x98, 0x8d, 0xb8, 0x80, 0x86, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x83, 0x86, 0x80,
  0x80, 0x87, 0xa8, 0xa7, 0xa9, 0x85, 0x88, 0x85,
  0x80, 0x86, 0xa5, 0xa4, 0xa6, 0x80, 0x86, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x89, 0x85, 0x85, 0x85, 0x85, 0x89, 0x80,
  0x80, 0x86, 0x8c, 0x8d, 0x8d, 0xb8, 0x8d, 0x80,
  0x80, 0x8e, 0x8c, 0xb8, 0x84, 0x8d, 0x8d, 0x80,
  0x85, 0x88, 0x8b, 0x84, 0x84, 0x84, 0x84, 0x85,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x87, 0x85, 0x85, 0x80, 0x87, 0x85, 0x80,
  0x80, 0x86, 0x84, 0x84, 0x85, 0x8c, 0xb8, 0x91,
  0xa3, 0x88, 0x8d, 0xb8, 0x8d, 0xb8, 0x84, 0x80,
  0x80, 0x86, 0x84, 0x84, 0x84, 0x84, 0xa2, 0x80,
  0x8a, 0x88, 0x8d, 0x8d, 0x8d, 0xb8, 0x91, 0xaa,
  0x80, 0xae, 0xa1, 0x84, 0x84, 0x84, 0x99, 0x80,
  0x80, 0x86, 0x84, 0xa2, 0x80, 0xa2, 0xa2, 0x80,
  0x80, 0x8e, 0xb8, 0xa8, 0xa7, 0xa9, 0x85, 0x80,
  0x9c, 0x9d, 0x84, 0xa5, 0xa4, 0xa6, 0x84, 0x80,
  0x80, 0xae, 0x99, 0x99, 0x99, 0x99, 0x8c, 0x80,
  0x80, 0x86, 0x84, 0x84, 0x84, 0x84, 0x8b, 0x80,
  0x80, 0x8e, 0x8d, 0x8d, 0x8d, 0xb8, 0x84, 0x80,
  0x80, 0x8e, 0xb8, 0x84, 0x84, 0x84, 0x84, 0x80,
  0x80, 0x86, 0x8d, 0x8d, 0x8d, 0xb8, 0x8c, 0x80,
  0x80, 0x86, 0x84, 0x84, 0x84, 0x84, 0xa2, 0x80,
  0x85, 0x88, 0x84, 0x80, 0xbb, 0x84, 0x91, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0xa3, 0xa7, 0xa9, 0x85, 0x85, 0x85, 0x85, 0x80,
  0x80, 0xa4, 0xa6, 0x84, 0x80, 0x80, 0xbb, 0x85,
  0xa3, 0x8d, 0x8c, 0xb8, 0x85, 0x85, 0xba, 0x80,
  0x80, 0x86, 0x8c, 0x8c, 0x8c, 0xb8, 0x84, 0x80,
  0x80, 0x80, 0x8e, 0x8d, 0x8d, 0x8d, 0x8d, 0x80,
  0x80, 0x80, 0x86, 0x84, 0x84, 0x84, 0x8c, 0x80,
  0x80, 0x87, 0x88, 0x80, 0x86, 0x84, 0x8b, 0x80,
  0x8a, 0x88, 0x80, 0x80, 0x86, 0x80, 0xae, 0x80,
  0x80, 0x86, 0x85, 0x85, 0x88, 0x85, 0x88, 0x80,
  0x80, 0x86, 0x82, 0x83, 0xb7, 0x80, 0x86, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x8e, 0x80,
  0x80, 0x87, 0x85, 0x85, 0x85, 0x80, 0x8e, 0x80,
  0x80, 0x86, 0x8c, 0xb8, 0x84, 0x85, 0x8c, 0x80,
  0x80, 0x86, 0x8b, 0x84, 0x8d, 0xb8, 0x8b, 0x80,
  0x80, 0x86, 0x8b, 0x84, 0x84, 0x8d, 0x8d, 0x80,
  0x85, 0x88, 0x84, 0x84, 0x84, 0x84, 0x84, 0x80,
  0x80, 0x86, 0x8d, 0x8d, 0x8d, 0x8d, 0x8c, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x87, 0x85, 0x85, 0x85, 0x85, 0x85, 0x80,
  0x85, 0x88, 0x84, 0x8d, 0x8d, 0xb8, 0x9b, 0x80,
  0x80, 0x86, 0x84, 0x84, 0x84, 0x9b, 0x9c, 0x80,
  0x80, 0x86, 0x84, 0x80, 0x86, 0x80, 0x80, 0x80,
  0x8a, 0x88, 0x84, 0x85, 0x88, 0x85, 0x85, 0x80,
  0x80, 0x8e, 0x8d, 0x8d, 0x8c, 0x8d, 0x8d, 0x80,
  0x80, 0x86, 0x84, 0x98, 0x8c, 0xb8, 0x98, 0x80,
  0x8a, 0x88, 0x84, 0x84, 0x84, 0x84, 0x84, 0x80,
  0x80, 0xac, 0x86, 0x84, 0x84, 0xa2, 0x80, 0x80,
  0x80, 0x86, 0x84, 0x84, 0x8c, 0x85, 0x85, 0x80,
  0x80, 0x8e, 0xb8, 0x84, 0x8d, 0x8c, 0xb8, 0x80,
  0x80, 0x86, 0x84, 0xb0, 0x95, 0x8d, 0x8c, 0x80,
  0x80, 0x86, 0x8d, 0x8d, 0x8d, 0x8d, 0x8d, 0x80,
  0x80, 0xae, 0xa1, 0x84, 0xbc, 0x80, 0x86, 0x80,
  0x80, 0x86, 0x99, 0x80, 0xbb, 0x85, 0x88, 0x80,
  0x80, 0x8e, 0xb8, 0x85, 0xba, 0x8d, 0xb8, 0x80,
  0x80, 0x86, 0x8d, 0x8d, 0x8d, 0x8d, 0x8d, 0x80,
  0x80, 0x86, 0x99, 0x99, 0x99, 0x99, 0x99, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x86, 0x80,
  0x80, 0xa4, 0xae, 0xab, 0x85, 0x85, 0x88, 0x80,
  0x80, 0x80, 0x80, 0x8f, 0xb8, 0x98, 0x8d, 0x80,
  0x80, 0xa4, 0xae, 0xab, 0x84, 0x84, 0x84, 0x80,
  0x80, 0x80, 0x80, 0x8f, 0xb8, 0x84, 0x84, 0x80,
  0x80, 0x87, 0x85, 0x85, 0x84, 0x84, 0x80, 0x80,
  0x80, 0x8e, 0xb8, 0xb0, 0x95, 0x93, 0x85, 0x80,
  0x80, 0x86, 0x8d, 0x8d, 0x8c, 0x8d, 0x8d, 0x80,
  0x8a, 0x88, 0x84, 0x84, 0x8c, 0x99, 0x99, 0x80,
  0x80, 0x8e, 0xb8, 0x8d, 0xb9, 0x84, 0x84, 0x85,
  0x82, 0x83, 0xb7, 0xbc, 0x90, 0x84, 0x84, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x87, 0x91, 0x85, 0x91, 0x85, 0x80, 0x80,
  0x80, 0x86, 0x82, 0x81, 0x83, 0x86, 0x85, 0x85,
  0x80, 0x8f, 0xa8, 0xa7, 0xa9, 0x88, 0x99, 0x80,
  0x80, 0x90, 0xa5, 0xa4, 0xa6, 0x84, 0x84, 0x80,
  0x80, 0xad, 0xad, 0xad, 0xad, 0xad, 0x8f, 0x80,
  0x80, 0x86, 0x84, 0x84, 0x84, 0x84, 0x8b, 0x80,
  0x8a, 0x88, 0x99, 0xa1, 0x80, 0x86, 0x80, 0x80,
  0x80, 0x86, 0xa2, 0x97, 0x91, 0x88, 0x91, 0x80,
  0x80, 0x86, 0x99, 0xa1, 0x99, 0xa1, 0x99, 0x80,
  0x80, 0x86, 0x84, 0x8d, 0xb8, 0x8c, 0xb8, 0xaa,
  0x80, 0x86, 0x84, 0xa2, 0x97, 0x8b, 0x84, 0x80,
  0x80, 0x86, 0x84, 0x91, 0x99, 0x99, 0xa1, 0x80,
  0x80, 0x8f, 0xb8, 0x99, 0x99, 0x99, 0x99, 0x80,
  0x8a, 0x85, 0x84, 0x94, 0x94, 0x97, 0x84, 0x80,
  0x80, 0x86, 0x8d, 0x8d, 0x8d, 0x8d, 0x8c, 0x80,
  0x85, 0x88, 0x84, 0x84, 0x84, 0x84, 0x84, 0x80,
  0x80, 0xb7, 0xbc, 0xb7, 0xbc, 0xb7, 0xbc, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x87, 0x85, 0x99, 0x99, 0x99, 0xab, 0x80,
  0x80, 0x86, 0x80, 0x80, 0x80, 0x80, 0x86, 0x91,
  0x80, 0x8f, 0x85, 0xa8, 0xa7, 0xa9, 0x99, 0x80,
  0x80, 0x86, 0x84, 0xa5, 0xa4, 0xa6, 0x9b, 0x9c,
  0x8a, 0x88, 0x9b, 0x9c, 0x9c, 0x9c, 0x9c, 0x9c,
  0x9d, 0x84, 0x85, 0x85, 0x85, 0x85, 0xb3, 0x9c,
  0x9c, 0x9d, 0xb0, 0x95, 0x94, 0x97, 0x84, 0x80,
  0x80, 0x8e, 0x8d, 0x8d, 0x8d, 0x8d, 0x8c, 0x80,
  0x80, 0x80, 0x80, 0xbb, 0x84, 0x8d, 0x8c, 0x80,
  0x80, 0x87, 0x85, 0xba, 0x8d, 0x8d, 0x8c, 0x80,
  0x80, 0x86, 0x8d, 0xb8, 0x84, 0x84, 0x8b, 0xaa,
  0x80, 0x8f, 0xb8, 0x80, 0xbb, 0x84, 0x80, 0x80,
  0x80, 0x87, 0x84, 0x85, 0xba, 0x84, 0x85, 0x80,
  0x80, 0xbb, 0x84, 0x8d, 0x8d, 0xb8, 0x84, 0x80,
  0xa3, 0xba, 0x84, 0x84, 0x84, 0x84, 0x84, 0x80,
  0x85, 0x84, 0x84, 0xb0, 0x95, 0x9a, 0xaf, 0x80,
  0x80, 0xb7, 0xbc, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x80, 0x87, 0x85, 0x85, 0x85, 0x85, 0x85, 0xaa,
  0x91, 0x88, 0x8d, 0xb8, 0x8d, 0xb8, 0x8c, 0x80,
  0x80, 0x86, 0x80, 0xb7, 0x80, 0xb7, 0x8b, 0x80,
  0x80, 0x86, 0xac, 0xae, 0xac, 0xae, 0x90, 0x80,
  0x80, 0x80, 0xa2, 0x97, 0xa2, 0x97, 0x8b, 0x80,
  0x80, 0x87, 0x85, 0x99, 0xab, 0x88, 0x8b, 0x80,
  0x8a, 0x8c, 0x8d, 0x8d, 0x8d, 0x8d, 0x8d, 0x80,
  0x80, 0x8e, 0x8d, 0x8d, 0x8d, 0x8d, 0x8c, 0x80,
  0x80, 0x86, 0x84, 0x8d, 0xb8, 0x84, 0x8d, 0x80,
  0x80, 0x86, 0xb2, 0x84, 0x84, 0x84, 0xb2, 0x80,
  0x80, 0x86, 0x9a, 0x9f, 0x9a, 0xaf, 0x9f, 0x80,
  0x80, 0xae, 0x99, 0x99, 0x99, 0x99, 0xa1, 0x80,
  0x80, 0x86, 0x84, 0x84, 0x84, 0x84, 0x84, 0xaa,
  0x80, 0xbb, 0x84, 0xad, 0xad, 0x86, 0x80, 0x80,
  0x8a, 0xba, 0xb0, 0x95, 0x84, 0x84, 0x84, 0x80,
  0x80, 0xae, 0x9a, 0x9f, 0xa1, 0x9a, 0xab, 0x85,
  0x80, 0x86, 0xb1, 0x84, 0x93, 0xb1, 0x84, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x83,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
  0000, 0000, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xe6, 0xe0, 0xec, 0xec, 0xe0,
  0xe5, 0xc0, 0xed, 0xe7, 0xe1, 0xc4, 0xc4, 0xe1,
  0xc4, 0xc0, 0xc0, 0xef, 0xe1, 0xc4, 0xc4, 0xe1,
  0xee, 0xc0, 0xc0, 0xf1, 0xe1, 0xee, 0xc7, 0xe1,
  0xc4, 0xe5, 0xed, 0xbe, 0xe1, 0xf6, 0xf1, 0xe1,
  0xc4, 0xfe, 0xc0, 0xc9, 0xc9, 0xc9, 0xc9, 0xc9,
  0xc9, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xe6, 0xc0, 0xc0, 0xe6,
  0xc0, 0xc0, 0xc0, 0xc0, 0xe4, 0xc0, 0xc0, 0xe4,
  0xc0, 0xc0, 0xc0, 0xe6, 0xe7, 0xe5, 0xe5, 0xe7,
  0xe5, 0xc0, 0xc0, 0xbf, 0xe7, 0xc4, 0xc4, 0xc4,
  0xc4, 0xe5, 0xc0, 0xef, 0xee, 0xee, 0xee, 0xe7,
  0xbd, 0xc0, 0xc0, 0xf1, 0xc3, 0xf9, 0xc4, 0xc3,
  0xf9, 0xc0, 0xc0, 0xf1, 0xc1, 0xe4, 0xc4, 0xc1,
  0xf3, 0xc0, 0xc0, 0xf1, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xf1, 0xe5, 0xe5, 0xe5, 0xe5,
  0xe5, 0xc0, 0xc0, 0xbf, 0xee, 0xee, 0xc7, 0xee,
  0xee, 0xc0, 0xc0, 0xe4, 0xc3, 0xf9, 0xc8, 0xc3,
  0xf9, 0xc0, 0xc0, 0xbf, 0xc2, 0xbf, 0xc7, 0xc2,
  0xbf, 0xc0, 0xc0, 0xe4, 0xc1, 0xd4, 0xc8, 0xc1,
  0xd4, 0xfe, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xef, 0xc0, 0xc0, 0xe6, 0xe5, 0xe5, 0xe5, 0xe5,
  0xbe, 0xc0, 0xc0, 0xe4, 0xee, 0xee, 0xee, 0xe7,
  0xc8, 0xc0, 0xc0, 0xf7, 0xc5, 0xc5, 0xc6, 0xc5,
  0xfd, 0xc0, 0xc0, 0xef, 0xee, 0xee, 0xc7, 0xee,
  0xee, 0xfe, 0xc0, 0xf1, 0xc4, 0xc4, 0xc8, 0xc4,
  0xc4, 0xc0, 0xc0, 0xbf, 0xe7, 0xbd, 0xee, 0xee,
  0xc7, 0xc0, 0xc0, 0xe4, 0xc3, 0xf9, 0xc4, 0xc3,
  0xf1, 0xc0, 0xc0, 0xe4, 0xc2, 0xe4, 0xc4, 0xc2,
  0xf1, 0xc0, 0xc0, 0xe4, 0xc2, 0xe4, 0xc4, 0xc2,
  0xf1, 0xc0, 0xe5, 0xe7, 0xc1, 0xd4, 0xd3, 0xc1,
  0xf1, 0xc0, 0xc9, 0xc9, 0xc9, 0xc9, 0xc9, 0xc9,
  0xc9, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xe6, 0xec, 0xe6, 0xe5, 0xec,
  0xe6, 0xc0, 0xe5, 0xf7, 0xc5, 0xc5, 0xc5, 0xc5,
  0xc6, 0xfe, 0xc0, 0xef, 0xee, 0xee, 0xee, 0xee,
  0xc7, 0xc0, 0xc0, 0xf1, 0xc4, 0xc4, 0xc4, 0xc4,
  0xc8, 0xe5, 0xc0, 0xf1, 0xe9, 0xee, 0xde, 0xdf,
  0xc8, 0xc0, 0xc0, 0xc9, 0xc9, 0xc9, 0xc9, 0xc9,
  0xc9, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xe6, 0xe3, 0xe3, 0xec, 0xe3,
  0xe5, 0xc0, 0xe5, 0xe7, 0xda, 0xda, 0xc4, 0xda,
  0xc4, 0xc0, 0xc0, 0xe2, 0xf4, 0xf4, 0xf2, 0xf4,
  0xdc, 0xc0, 0xc0, 0xe4, 0xda, 0xd9, 0xfb, 0xf4,
  0xf5, 0xc0, 0xc0, 0xe4, 0xda, 0xc4, 0xda, 0xda,
  0xd7, 0xc0, 0xc0, 0xe2, 0xd9, 0xdc, 0xda, 0xd9,
  0xfb, 0xc0, 0xc0, 0xe4, 0xc4, 0xc4, 0xda, 0xc4,
  0xf4, 0xc0, 0xc0, 0xe2, 0xfb, 0xf2, 0xd9, 0xdc,
  0xd9, 0xc0, 0xc0, 0xe8, 0xd9, 0xdc, 0xc4, 0xc4,
  0xc4, 0xc0, 0xc0, 0xf1, 0xce, 0xf0, 0xf0, 0xcd,
  0xf0, 0xc0, 0xc0, 0xf1, 0xcc, 0xc0, 0xd4, 0xc4,
  0xd3, 0xc0, 0xc0, 0xf1, 0xcc, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xf1, 0xd0, 0xcf, 0xce, 0xcd,
  0xcd, 0xc0, 0xc0, 0xf1, 0xc4, 0xd0, 0xd2, 0xcd,
  0xcd, 0xc0, 0xc0, 0xf1, 0xc4, 0xc4, 0xd0, 0xcd,
  0xcd, 0xc0, 0xc0, 0xef, 0xee, 0xee, 0xee, 0xee,
  0xef, 0xc0, 0xc0, 0xf1, 0xc4, 0xee, 0xee, 0xee,
  0xf1, 0xc0, 0xc0, 0xf1, 0xc4, 0xee, 0xee, 0xee,
  0xee, 0xc0, 0xc0, 0xf1, 0xc4, 0xce, 0xf0, 0xcd,
  0xf0, 0xc0, 0xc0, 0xf1, 0xc4, 0xcc, 0xce, 0xf0,
  0xcd, 0xc0, 0xc0, 0xef, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xe6, 0x62, 0x62, 0x62, 0x62,
  0x62, 0x62, 0xc0, 0xe4, 0xc4, 0xc4, 0xc4, 0xc4,
  0xc4, 0xc0, 0xc0, 0xc9, 0xc9, 0xc9, 0xc9, 0xc9,
  0xc9, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xdd, 0xc0, 0xdd, 0xdb, 0xdb,
  0xdb, 0xc0, 0xe5, 0xe7, 0xc0, 0xbf, 0xc0, 0xe4,
  0xc4, 0xe5, 0xc0, 0xe4, 0xc0, 0xbf, 0xc0, 0xef,
  0xc7, 0xc0, 0xc0, 0xe4, 0xc0, 0xbf, 0xe5, 0xbe,
  0xc8, 0xc0, 0xc0, 0xe4, 0xd8, 0xe7, 0xfe, 0xf1,
  0xc8, 0xc0, 0xc0, 0xc9, 0xc9, 0xc9, 0xc9, 0xc9,
  0xc9, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xe6, 0xec, 0xe6, 0xe5, 0xec,
  0xf1, 0xc0, 0xc0, 0xe4, 0xc4, 0xc4, 0xc4, 0xc4,
  0xc8, 0xe5, 0xc0, 0xe4, 0xe9, 0xde, 0xde, 0xdf,
  0xc8, 0xfe, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xf1, 0xfe, 0xc0, 0xe6, 0xe3, 0xe3, 0xe3, 0xe3,
  0xbe, 0xfe, 0xc0, 0xe8, 0xd9, 0xd9, 0xd9, 0xd9,
  0xc0, 0xc0, 0xc0, 0xf1, 0xc4, 0xc4, 0xc4, 0xc4,
  0x7f, 0xc0, 0xc0, 0xfd, 0xc5, 0xc5, 0xc5, 0xc6,
  0xc0, 0xc0, 0xc0, 0x92, 0xee, 0xee, 0xee, 0xc7,
  0xee, 0xc0, 0xc0, 0xc0, 0xf7, 0xc5, 0xc5, 0xfd,
  0xc5, 0xc0, 0xc0, 0xbf, 0xc7, 0xee, 0xee, 0xee,
  0x7f, 0xc0, 0xc0, 0xc5, 0xfd, 0xc5, 0xc5, 0xc6,
  0xc0, 0xc0, 0xc0, 0xbf, 0xee, 0xee, 0xee, 0xc7,
  0xee, 0xc0, 0xc0, 0xe4, 0xc3, 0xc3, 0xc3, 0xf1,
  0xc4, 0xc0, 0xc0, 0xe4, 0xc1, 0xc1, 0xc1, 0xf1,
  0xc4, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xef, 0xfe, 0xc0, 0xe6, 0xe5, 0xe5, 0xe5, 0xe5,
  0xbe, 0xfe, 0xc0, 0xbf, 0xc7, 0xee, 0xee, 0xee,
  0xee, 0xc0, 0xc0, 0xe4, 0xc8, 0xc4, 0xc4, 0xc4,
  0xc4, 0xc0, 0xc0, 0xe4, 0xee, 0xee, 0xe7, 0xbd,
  0xc7, 0xc0, 0xc0, 0xc0, 0xe4, 0xc4, 0xc4, 0xc4,
  0xc8, 0xc0, 0xe5, 0x67, 0xc0, 0xe4, 0xf6, 0xe9,
  0xc4, 0xfe, 0xc0, 0xe4, 0x67, 0x67, 0x67, 0x67,
  0x35, 0xfe, 0xc0, 0xc9, 0xc9, 0xc9, 0xc9, 0xc9,
  0xc9, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xe6, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc3, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xe6, 0xd5, 0xc2, 0xd6, 0xe5,
  0xe5, 0xc0, 0xc0, 0xe4, 0xc4, 0xc2, 0xbf, 0xee,
  0xe7, 0xe5, 0xc0, 0xef, 0xee, 0xc2, 0xf3, 0xf8,
  0xf8, 0xc0, 0xed, 0xbe, 0xc4, 0xc2, 0xbf, 0xc0,
  0xef, 0xc0, 0xc0, 0xf1, 0xd3, 0xc1, 0xd4, 0x67,
  0xf1, 0xc0, 0xc0, 0xc9, 0xc9, 0xc9, 0xc9, 0xc9,
  0xc9, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xec, 0xe6, 0xe5, 0xe5, 0xe5,
  0xec, 0xc0, 0xe5, 0xe7, 0xc4, 0xee, 0xe7, 0xc4,
  0xc4, 0xc0, 0xc0, 0x61, 0xa0, 0xa0, 0xa0, 0xa0,
  0xa0, 0xc0, 0xc0, 0xe4, 0xf6, 0xe9, 0xc4, 0xc4,
  0xc4, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xe4, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xe6,
  0xe7, 0xc0, 0xed, 0xe5, 0xe5, 0xe5, 0xe5, 0xe7,
  0xee, 0x3e, 0xc0, 0xef, 0xee, 0xee, 0xee, 0xee,
  0xee, 0xfe, 0xc0, 0xf1, 0xc4, 0xc4, 0xc4, 0xc4,
  0xc4, 0xfe, 0xc0, 0xbf, 0xee, 0xee, 0xee, 0xee,
  0xe7, 0xc0, 0xc0, 0xd4, 0xc4, 0xc4, 0xc4, 0xc4,
  0xc4, 0xc0, 0xc0, 0xbf, 0xe7, 0xbd, 0xe7, 0xbd,
  0xe7, 0xfe, 0xc0, 0xe4, 0xee, 0xe7, 0xbd, 0xee,
  0xce, 0xc0, 0xc0, 0xd4, 0xc4, 0xc4, 0xeb, 0xea,
  0xeb, 0xc0, 0xc0, 0xbf, 0xe7, 0xc4, 0xc4, 0xc4,
  0xc4, 0x3e, 0xc0, 0x61, 0xa0, 0xa0, 0xa0, 0xa0,
  0xa0, 0xc0, 0xc0, 0xe4, 0xde, 0xde, 0xdf, 0xc4,
  0xc4, 0xfe, 0xc0, 0x67, 0x67, 0x67, 0x67, 0x67,
  0x35, 0xfe, 0xc0, 0xe4, 0x67, 0x67, 0x67, 0x67,
  0x67, 0xc0, 0xc0, 0xe4, 0xeb, 0xea, 0xeb, 0xe7,
  0xc4, 0xe5, 0xc0, 0xe4, 0xc4, 0xc4, 0xc4, 0xee,
  0xee, 0xfe, 0xc0, 0xe4, 0xc4, 0xee, 0xee, 0xe7,
  0xc4, 0xfe, 0xed, 0xe7, 0xbd, 0xe7, 0xca, 0xcb,
  0xc4, 0xfe, 0xc0, 0xc9, 0xc9, 0xc9, 0xc9, 0xc9,
  0xc9, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xe6, 0xc0, 0xc0, 0xc0,
  0xe6, 0xc0, 0xc0, 0xd6, 0xe7, 0xd5, 0xd6, 0xe5,
  0xe7, 0xc0, 0xc0, 0xe4, 0xc3, 0xf9, 0xc4, 0xc4,
  0xc3, 0xc0, 0xc0, 0xe4, 0xc2, 0xe8, 0xf2, 0xf2,
  0xc2, 0xc0, 0xed, 0xe7, 0xc2, 0xf1, 0x63, 0xf8,
  0xc2, 0xc0, 0xc0, 0xe4, 0xc1, 0xef, 0xee, 0xc4,
  0xc1, 0xe6, 0xc0, 0xc9, 0xc9, 0xc9, 0xc9, 0xc9,
  0xc9, 0xc9, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
  0xc0, 0xc0, 0000, 0000, 0000, 0000, 0000, 0000,
};

block_t map_blocks[MAP_NBR_BLOCKS] = {
  {0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000,
   0000, 0000, 0000, 0000, 0000, 0000, 0000, 0000},
  {0x29, 0x2a, 0x2d, 0x2e, 0x2b, 0x2c, 0x2f, 0x30,
   0x22, 0x31, 0x32, 0x20, 0x28, 0x33, 0x34, 0x26},
  {0x2d, 0x2e, 0x20, 0x22, 0x33, 0x34, 0x2b, 0x2c,
   0x22, 0x29, 0x2a, 0x20, 0x28, 0x26, 0x28, 0x26},
  {0x31, 0x32, 0x2d, 0x2e, 0x2b, 0x2c, 0x2f, 0x30,
   0x2e, 0x29, 0x2a, 0x31, 0x30, 0x33, 0x34, 0x2b},
  {0x29, 0x2a, 0x20, 0x22, 0x2b, 0x2c, 0x26, 0x28,
   0x22, 0x2d, 0x2e, 0x2d, 0x28, 0x2f, 0x30, 0x2f},
  {0x2d, 0x2e, 0x29, 0x2a, 0x2f, 0x30, 0x2b, 0x2c,
   0x2e, 0x2d, 0x2e, 0x20, 0x30, 0x2b, 0x2c, 0x26},
  {0x19, 0x1a, 0x19, 0x1a, 0x1b, 0x30, 0x2b, 0x2c,
   0x1e, 0x2d, 0x2e, 0x20, 0000, 0x2b, 0x2c, 0x26},
  {0x19, 0x1a, 0x19, 0x1a, 0x2f, 0x30, 0x2b, 0x2c,
   0x22, 0x2d, 0x2e, 0x20, 0x28, 0x2b, 0x2c, 0x26},
  {0x19, 0x2e, 0x29, 0x2a, 0x1b, 0x30, 0x2b, 0x2c,
   0x1e, 0x2d, 0x2e, 0x20, 0000, 0x2b, 0x2c, 0x26},
  {0xe1, 0xe2, 0xe8, 0xe3, 0xe4, 0xe5, 0xeb, 0xec,
   0xe8, 0xe9, 0xe7, 0xe8, 0xe5, 0xe6, 0xea, 0xeb},
  {0xe1, 0xe2, 0xe8, 0xe3, 0xe4, 0xe5, 0xeb, 0xe6,
   0xe8, 0xe9, 0xe7, 0xe3, 0xe5, 0xe6, 0xea, 0xec},
  {0xe1, 0xe2, 0xe8, 0xe3, 0xe4, 0xe5, 0xeb, 0xec,
   0xe7, 0xe9, 0xe7, 0xe8, 0xea, 0xe6, 0xea, 0xeb},
  {0xc1, 0xc2, 0xc2, 0xc3, 0xc5, 0xc4, 0xc5, 0xc4,
   0x1e, 0x19, 0x1a, 0x1d, 0x28, 0x2f, 0x30, 0x26},
  {0xc6, 0xc2, 0xc2, 0xc3, 0xc7, 0xc4, 0xc5, 0xc4,
   0x1e, 0x19, 0x1a, 0x1d, 0000, 0x33, 0x34, 0x26},
  {0xc1, 0xc2, 0xc2, 0xc3, 0xc4, 0xc5, 0xc4, 0xc5,
   0xe8, 0xe3, 0xe1, 0xe2, 0xeb, 0xec, 0xe4, 0xe5},
  {0xc3, 0xfc, 0xfd, 0xc1, 0xc5, 0x51, 0x52, 0xc4,
   0x1e, 0x53, 0x54, 0x1d, 0x28, 0x53, 0x54, 0x1f},
  {0x2d, 0x53, 0x54, 0x1a, 0x2f, 0x53, 0x54, 0x1c,
   0x22, 0x53, 0x54, 0x1d, 0x28, 0x53, 0x54, 0x1f},
  {0x91, 0x92, 0x93, 0x94, 0x1b, 0x95, 0x96, 0x1c,
   0x22, 0x97, 0x98, 0x1d, 0x28, 0x95, 0x96, 0x1f},
  {0x31, 0x97, 0x98, 0x1a, 0x33, 0x95, 0x96, 0x1c,
   0x22, 0x97, 0x98, 0x1d, 0x28, 0x95, 0x96, 0x1f},
  {0x29, 0x97, 0x98, 0x1a, 0x2b, 0x95, 0x96, 0x1c,
   0x22, 0x97, 0x98, 0x1d, 0x99, 0x9a, 0x9b, 0x9c},
  {0x2d, 0x6a, 0x6b, 0x1a, 0x2f, 0x6c, 0x6d, 0x1c,
   0x22, 0x6e, 0x6f, 0x1d, 0x28, 0x70, 0x71, 0x1f},
  {0x19, 0x6e, 0x6f, 0x1a, 0x33, 0x6c, 0x6d, 0x1c,
   0x22, 0x72, 0x73, 0x1d, 0x28, 0x74, 0x75, 0x1f},
  {0x31, 0x32, 0x31, 0x32, 0x2f, 0x30, 0x2b, 0x2c,
   0x9d, 0x9e, 0x9f, 0xa0, 0xa1, 0xa2, 0xa3, 0xa4},
  {0x82, 0x83, 0x84, 0x1a, 0x7f, 0x80, 0x81, 0x1c,
   0x76, 0x77, 0x78, 0x1d, 0x79, 0x7a, 0x7b, 0x1f},
  {0x7c, 0x7d, 0x7e, 0x1a, 0x76, 0x77, 0x78, 0x1c,
   0x79, 0x7a, 0x7b, 0x1d, 0x7f, 0x80, 0x81, 0x1f},
  {0x04, 0x02, 0x03, 0x04, 0x05, 0x03, 0x02, 0x05,
   0x22, 0x02, 0x03, 0x20, 0x28, 0x03, 0x02, 0x26},
  {0x19, 0x66, 0x19, 0x1a, 0x33, 0x68, 0x1b, 0x30,
   0x22, 0x68, 0x1e, 0x20, 0x28, 0x68, 0000, 0x26},
  {0x31, 0x68, 0x19, 0x2a, 0x2b, 0x68, 0x1b, 0x2c,
   0x22, 0x68, 0x1e, 0x20, 0x28, 0x68, 0000, 0x26},
  {0x29, 0x68, 0x19, 0x2e, 0x33, 0x68, 0x1b, 0x30,
   0x22, 0x68, 0x1e, 0x20, 0x28, 0x67, 0000, 0x26},
  {0x29, 0x2a, 0x06, 0x07, 0x2b, 0x2c, 0x4b, 0x4c,
   0x22, 0x20, 0x49, 0x4a, 0x28, 0x26, 0x28, 0x26},
  {0x0b, 0x0c, 0x0d, 0x1a, 0x0e, 0x0f, 0x10, 0x1c,
   0x11, 0x12, 0x13, 0x1d, 0x14, 0x15, 0x16, 0x1f},
  {0x19, 0x1a, 0x19, 0x1a, 0x2f, 0x30, 0x2b, 0x2c,
   0x22, 0x2d, 0x2e, 0x20, 0x08, 0x09, 0x0a, 0x26},
  {0xbe, 0xbf, 0xbf, 0xc0, 0xc4, 0xc5, 0xc4, 0xc5,
   0xe8, 0xe3, 0xe1, 0xe2, 0xeb, 0xec, 0xe4, 0xe5},
  {0xc1, 0xc2, 0xc2, 0xc3, 0xc5, 0xc4, 0xc5, 0xc4,
   0x1e, 0x66, 0x1e, 0x1d, 0x28, 0x68, 0000, 0x26},
  {0x19, 0x53, 0x54, 0x1a, 0x1b, 0x53, 0x54, 0x1c,
   0x1e, 0x53, 0x54, 0x1d, 0000, 0x53, 0x54, 0x1f},
  {0x4d, 0x4e, 0x4d, 0x4e, 0x4f, 0x50, 0x4f, 0x50,
   0x22, 0x4d, 0x4e, 0x20, 0x28, 0x4f, 0x50, 0x26},
  {0xa5, 0xa6, 0xa7, 0x2a, 0xa8, 0xa9, 0xaa, 0x1c,
   0x22, 0xab, 0x1e, 0x1d, 0x28, 0xac, 0000, 0x26},
  {0x2d, 0xad, 0x19, 0x2a, 0x2f, 0xae, 0x1b, 0x2c,
   0x22, 0xae, 0x1a, 0x20, 0x28, 0xaf, 0x1c, 0x26},
  {0x29, 0x2a, 0x2d, 0x2e, 0x2b, 0x2c, 0x2f, 0x30,
   0x22, 0x31, 0x32, 0x20, 0x5c, 0x5c, 0x5c, 0x5c},
  {0x19, 0x2a, 0x2d, 0x2e, 0x1b, 0x2c, 0x2f, 0x30,
   0x1e, 0x31, 0x32, 0x20, 0x5c, 0x5c, 0x5c, 0x5c},
  {0xe1, 0xe2, 0xe8, 0xe3, 0xe4, 0xeb, 0xe5, 0xe6,
   0x1e, 0x19, 0x1a, 0x1d, 0x28, 0x33, 0x34, 0x26},
  {0x29, 0x2a, 0x2d, 0x2e, 0x2b, 0x2c, 0x2f, 0x30,
   0xe1, 0xe2, 0xe8, 0xe3, 0xe4, 0xe5, 0xeb, 0xe6},
  {0xe3, 0x1a, 0x19, 0x1a, 0xec, 0x1c, 0x2f, 0x30,
   0xe3, 0x19, 0x32, 0x20, 0xec, 0x1b, 0x34, 0x26},
  {0x29, 0x2a, 0x2d, 0x2e, 0x2b, 0x2c, 0x2f, 0x30,
   0xb6, 0xb6, 0xb6, 0xb6, 0x28, 0x2f, 0x30, 0x26},
  {0xc7, 0xc4, 0xc5, 0xc4, 0x1b, 0x1c, 0x5e, 0x1c,
   0x1e, 0x19, 0x1a, 0x1d, 0000, 0x33, 0x34, 0x26},
  {0xc6, 0xfc, 0xfd, 0xc1, 0xc7, 0x51, 0x52, 0xc4,
   0x1e, 0x53, 0x54, 0x1d, 0000, 0x53, 0x54, 0x1f},
  {0x19, 0x2a, 0x2d, 0x2e, 0x2b, 0x2c, 0x2f, 0x30,
   0x22, 0x31, 0x32, 0x20, 0x28, 0x33, 0x34, 0x26},
  {0x19, 0x2a, 0x2d, 0x2e, 0x1b, 0x2c, 0x2f, 0x30,
   0xe1, 0xe2, 0xe8, 0xe3, 0xe4, 0xe5, 0xeb, 0xe6},
  {0xe1, 0xe2, 0xe8, 0xe3, 0xe4, 0xeb, 0xe5, 0xe6,
   0x1e, 0x19, 0x1a, 0x1d, 0000, 0x33, 0x34, 0x26},
  {0xe1, 0xe2, 0xe3, 0x1a, 0xe4, 0xe5, 0xe6, 0x1c,
   0xe8, 0xe8, 0xe8, 0xb6, 0xe5, 0xeb, 0xec, 0x1f},
  {0xe1, 0xe2, 0xe8, 0xe3, 0xe4, 0xe5, 0xeb, 0x01,
   0xe8, 0xe9, 0xe7, 0xe9, 0xe5, 0xe6, 0xea, 0xec},
  {0x19, 0x1a, 0x19, 0x1a, 0x1b, 0x34, 0x2f, 0x30,
   0x1e, 0x20, 0x22, 0x20, 0x28, 0x26, 0x28, 0x26},
  {0x31, 0x32, 0x29, 0x2a, 0x2f, 0x30, 0x2b, 0x2c,
   0x1e, 0x2d, 0x2e, 0x20, 0000, 0x2b, 0x2c, 0x26},
  {0x18, 0x15, 0x16, 0x15, 0x19, 0x16, 0x17, 0x16,
   0x18, 0x17, 0x16, 0x15, 0x15, 0x16, 0x16, 0x17},
  {0x2d, 0x2e, 0x31, 0x32, 0x2f, 0x30, 0x2b, 0x2c,
   0x22, 0xe1, 0xe2, 0xe9, 0x28, 0xe4, 0xe5, 0xec},
  {0xe1, 0xe2, 0xe8, 0xe3, 0xe4, 0xe5, 0xeb, 0xe6,
   0xe7, 0xe9, 0xe1, 0xe9, 0xea, 0xe6, 0xe4, 0xec},
  {0x20, 0x53, 0x54, 0x1e, 0x26, 0x53, 0x54, 0000,
   0xe1, 0xe2, 0xe8, 0xe3, 0xe4, 0xe5, 0xeb, 0xe6},
  {0x5e, 0x5e, 0x5e, 0x5e, 0x1b, 0x1c, 0x1b, 0x1c,
   0x22, 0x29, 0x2a, 0x20, 0x28, 0x26, 0x28, 0x26},
  {0x5e, 0x5e, 0x5e, 0x5e, 0x1b, 0x1c, 0x1b, 0x1c,
   0x1e, 0x29, 0x2a, 0x20, 0000, 0x26, 0x28, 0x26},
  {0x5e, 0x5e, 0x5e, 0x5e, 0x1b, 0x1c, 0x1b, 0x1c,
   0x22, 0x29, 0x2a, 0x20, 0x28, 0x26, 0x28, 0x26},
  {0x19, 0x2e, 0x20, 0x22, 0x1b, 0x34, 0x2b, 0x2c,
   0x1e, 0x29, 0x2a, 0x20, 0x28, 0x26, 0x28, 0x26},
  {0x1d, 0x53, 0x54, 0x1a, 0x2f, 0x53, 0x54, 0x1c,
   0x22, 0x53, 0x54, 0x1d, 0x28, 0x53, 0x54, 0x1f},
  {0x18, 0x19, 0x18, 0xdc, 0x17, 0x16, 0x17, 0xde,
   0x16, 0x17, 0x16, 0xdc, 0x15, 0x16, 0x16, 0xde},
  {0xe1, 0xe2, 0xe3, 0x1a, 0xe4, 0xe5, 0xe6, 0x1c,
   0xe7, 0xe8, 0xe9, 0x1d, 0xea, 0xeb, 0xec, 0x1f},
  {0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40,
   0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48},
  {0000, 0000, 0000, 0000, 0x3d, 0x3e, 0x3f, 0x40,
   0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48},
  {0000, 0000, 0000, 0000, 0000, 0x3e, 0x3f, 0x40,
   0000, 0x42, 0x43, 0x44, 0000, 0x46, 0x47, 0x48},
  {0000, 0x3a, 0x3b, 0x3c, 0000, 0x3e, 0x3f, 0x40,
   0000, 0x42, 0x43, 0x44, 0000, 0x46, 0x47, 0x48},
  {0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0xc8, 0xc9, 0x40,
   0x41, 0xca, 0xcb, 0000, 0x45, 0x46, 0000, 0000},
  {0xd5, 0xd6, 0xd5, 0xd6, 0xd7, 0xd8, 0xd7, 0xd8,
   0xd9, 0xda, 0xd9, 0xda, 0xdb, 0xdc, 0xdb, 0xdc},
  {0xd9, 0xda, 0xd9, 0xda, 0xdb, 0xdc, 0xdb, 0xdc,
   0xd9, 0xda, 0xd9, 0xda, 0xdb, 0xdc, 0xdb, 0xdc},
  {0xd9, 0xda, 0xd9, 0xda, 0xdb, 0xdc, 0xdb, 0xdc,
   0xd9, 0xef, 0xf2, 0xee, 0xf1, 0000, 0000, 0xf1},
  {0xd9, 0xda, 0xd9, 0xda, 0xdb, 0xdc, 0xdb, 0xdc,
   0xf2, 0xf0, 0xd9, 0xf3, 0xed, 0xee, 0xef, 0xf0},
  {0xd9, 0xda, 0xd9, 0xf1, 0xdb, 0xf3, 0xed, 0xee,
   0xef, 0xf0, 0000, 0000, 0xf3, 0000, 0000, 0x48},
  {0xed, 0xee, 0xd9, 0xda, 0000, 0xef, 0xee, 0xdc,
   0x41, 0000, 0xef, 0xf0, 0x45, 0x46, 0000, 0xf1},
  {0000, 0000, 0x3b, 0000, 0x3d, 0x3e, 0x3f, 0x40,
   0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48},
  {0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8b, 0x8c,
   0x89, 0x8a, 0x8b, 0x8c, 0x89, 0x8a, 0x8b, 0x8c},
  {0x89, 0x8a, 0x8b, 0x8c, 0x89, 0x8a, 0x8b, 0x8c,
   0x89, 0x8a, 0x8b, 0x8c, 0x89, 0x8a, 0x8b, 0x8c},
  {0x89, 0x8a, 0x8b, 0x8c, 0x89, 0x8a, 0x8b, 0x8c,
   0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, 0x90},
  {0xd9, 0xda, 0xed, 0xee, 0xdb, 0xef, 0xf0, 0xed,
   0xd9, 0xda, 0xef, 0xee, 0xdb, 0xef, 0xee, 0xf1},
  {0xd9, 0xef, 0xf2, 0xee, 0xdb, 0xef, 0xf0, 0xf1,
   0xd9, 0xda, 0xf3, 0xf3, 0xdb, 0xf1, 0xdb, 0xef},
  {0xed, 0xee, 0xd9, 0xda, 0xf1, 0xf3, 0xdb, 0xdc,
   0xee, 0xed, 0xee, 0xda, 0xed, 0xee, 0xdb, 0xdc},
  {0xed, 0xee, 0xd9, 0xda, 0xf1, 0xef, 0xf0, 0xdc,
   0xef, 0xf2, 0xee, 0xda, 0xf3, 0xf3, 0xf1, 0xdc},
  {0xd9, 0xda, 0xd9, 0xda, 0xdb, 0xdc, 0xdb, 0xdc,
   0xd9, 0xed, 0xee, 0xef, 0xf1, 0xdc, 0xed, 0xee},
  {0xd9, 0xda, 0xd9, 0xda, 0xdb, 0xdc, 0xef, 0xf0,
   0xf1, 0xed, 0xee, 0xf1, 0xed, 0xee, 0xef, 0xf0},
  {0xd9, 0xda, 0xd9, 0xda, 0xdb, 0xdc, 0xdb, 0xdc,
   0xee, 0xed, 0xf0, 0xda, 0xed, 0xee, 0xef, 0xf0},
  {0x35, 0x3a, 0x3b, 0x3c, 0xdb, 0x36, 0x35, 0x36,
   0xd9, 0xda, 0xd9, 0xda, 0xdb, 0xdc, 0xdb, 0xdc},
  {0x39, 0x3a, 0x3b, 0x3c, 0x36, 0x35, 0x35, 0x36,
   0xd9, 0xda, 0xd9, 0xda, 0xdb, 0xdc, 0xdb, 0xdc},
  {0x39, 0x3a, 0xf4, 0xf5, 0x3d, 0x3e, 0000, 0xf8,
   0xf4, 0xf5, 0xf6, 0xf7, 0000, 0xf8, 0xf9, 0xfa},
  {0xf6, 0xf7, 0xf8, 0xf9, 0xf8, 0xf9, 0xfa, 0xfb,
   0xfa, 0xfb, 0xf8, 0xf9, 0xfb, 0xf8, 0xf9, 0xfa},
  {0xb6, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40,
   0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48},
  {0xb6, 0xb9, 0xba, 0xbb, 0x3d, 0xb2, 0xb3, 0xb4,
   0x41, 0x42, 0xb1, 0x44, 0x45, 0x46, 0xb0, 0x48},
  {0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40,
   0x41, 0x42, 0xb5, 0x44, 0x45, 0x46, 0xb0, 0x48},
  {0xb6, 0xfc, 0xfd, 0xb7, 0x3d, 0x53, 0x54, 0000,
   0x41, 0x53, 0x54, 0000, 0x45, 0x53, 0x54, 0000},
  {0xb6, 0xb7, 0xb8, 0xb7, 0x3d, 0x3e, 0x3f, 0x40,
   0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48},
  {0x39, 0x53, 0x54, 0000, 0x3d, 0x53, 0x54, 0000,
   0x41, 0x53, 0x54, 0000, 0x45, 0x53, 0x54, 0000},
  {0x39, 0xcd, 0xd9, 0xda, 0xce, 0xdc, 0xdb, 0xdc,
   0xd9, 0xda, 0xd9, 0xda, 0xdb, 0xdc, 0xdb, 0xdc},
  {0x18, 0x15, 0x16, 0x15, 0x19, 0x17, 0x16, 0x16,
   0x5f, 0x5f, 0x5f, 0x5f, 0x19, 0x16, 0x16, 0x17},
  {0x18, 0xcb, 0x19, 0x19, 0x5f, 0x5f, 0x5f, 0x5f,
   0x16, 0x17, 0x16, 0x15, 0x15, 0x16, 0x16, 0x17},
  {0x16, 0x15, 0x16, 0x15, 0x2a, 0x2b, 0x2c, 0xce,
   0x2f, 0x30, 0x31, 0x18, 0x18, 0x32, 0x18, 0x19},
  {0x39, 0x3a, 0xb0, 0x3c, 0x3d, 0x3e, 0xb1, 0x40,
   0x41, 0x42, 0xb1, 0x44, 0x45, 0x46, 0xb0, 0x48},
  {0xf6, 0xf7, 0x3b, 0x3c, 0xf9, 0000, 0x3f, 0x40,
   0xf4, 0xf5, 0xf6, 0xf7, 0xfb, 0xf8, 0xf9, 0000},
  {0xf8, 0xf9, 0xf4, 0xf5, 0xf8, 0xf9, 0xfa, 0xfb,
   0xfa, 0xfb, 0xf8, 0xf9, 0xfb, 0xf8, 0xf9, 0xfa},
  {0xdc, 0xdd, 0xdc, 0xdd, 0xde, 0xdf, 0xde, 0xdf,
   0x19, 0x18, 0x19, 0x18, 0x15, 0x16, 0x16, 0x17},
  {0xfa, 0xfb, 0xf8, 0xf9, 0xf8, 0xf9, 0xfa, 0xfb,
   0xfa, 0xfb, 0xf8, 0xf9, 0xfb, 0xf8, 0xf9, 0xfa},
  {0x5a, 0x3a, 0x3b, 0x59, 0x3d, 0x59, 0x5a, 0x40,
   0x41, 0x42, 0x59, 0x5a, 0x59, 0x5a, 0x47, 0x48},
  {0000, 0x53, 0x54, 0000, 0000, 0x53, 0x54, 0000,
   0000, 0x53, 0x54, 0000, 0000, 0x53, 0x54, 0000},
  {0xb7, 0xfc, 0xfd, 0xb6, 0000, 0x53, 0x54, 0000,
   0000, 0x53, 0x54, 0000, 0000, 0x53, 0x54, 0000},
  {0xb6, 0xb8, 0xb7, 0xb6, 0000, 0x3e, 0x3f, 0x40,
   0000, 0x42, 0x43, 0x44, 0000, 0x46, 0x47, 0x48},
  {0xf3, 0x37, 0x38, 0000, 0xf3, 0000, 0000, 0000,
   0xf3, 0000, 0x43, 0x44, 0xf3, 0x35, 0x36, 0x48},
  {0000, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40,
   0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48},
  {0xed, 0xee, 0xef, 0xee, 0xd7, 0xd8, 0xd7, 0xd8,
   0xd9, 0xda, 0xd9, 0xda, 0xdb, 0xdc, 0xdb, 0xdc},
  {0xef, 0xf0, 0xef, 0xee, 0xd7, 0xd8, 0xd7, 0xd8,
   0xd9, 0xda, 0xd9, 0xda, 0xdb, 0xdc, 0xdb, 0xdc},
  {0xed, 0xf0, 0xef, 0xee, 0xf1, 0xed, 0xee, 0xf3,
   0xef, 0xee, 0xf1, 0xf1, 0xf1, 0xf3, 0xed, 0xf0},
  {0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40,
   0x41, 0x42, 0x43, 0x44, 0x45, 0x5c, 0x5c, 0x48},
  {0000, 0x3a, 0x3b, 0x3c, 0000, 0x3e, 0x3f, 0x5b,
   0000, 0x42, 0x43, 0x5b, 0000, 0x46, 0x47, 0x48},
  {0000, 0x3a, 0x3b, 0x3c, 0000, 0x3e, 0x3f, 0x40,
   0000, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48},
  {0000, 0000, 0000, 0000, 0x3d, 0x3e, 0x3f, 0x40,
   0x41, 0x42, 0xb5, 0x44, 0x45, 0x46, 0xb1, 0x48},
  {0xf1, 0xef, 0xee, 0xf1, 0xf3, 0xf3, 0xf2, 0xf2,
   0xed, 0xee, 0xed, 0xf0, 0xf1, 0xef, 0xee, 0xf3},
  {0xed, 0xee, 0xed, 0xee, 0xf3, 0xef, 0xee, 0xf1,
   0000, 0000, 0000, 0000, 0x45, 0x46, 0x47, 0x48},
  {0000, 0000, 0000, 0000, 0000, 0x3e, 0x3f, 0x40,
   0000, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48},
  {0000, 0000, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 0x40,
   0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48},
  {0xd1, 0xbc, 0xbd, 0xd2, 0xd3, 0x5d, 0x5f, 0xdd,
   0xde, 0x60, 0x61, 0xdf, 0xe0, 0x62, 0x63, 0x64},
  {0x1d, 0x1e, 0xe7, 0xe9, 0x17, 0x18, 0xea, 0xec,
   0x21, 0x23, 0xe7, 0xe9, 0000, 0x1f, 0xea, 0xec},
  {0xe7, 0xe9, 0x19, 0x1a, 0xea, 0xec, 0x24, 0x25,
   0xe7, 0xe9, 0x27, 0x55, 0xea, 0xec, 0000, 0x1f},
  {0000, 0000, 0xed, 0xee, 0000, 0x56, 0xef, 0xf0,
   0000, 0x57, 0xf3, 0xf3, 0000, 0000, 0xef, 0xf0},
  {0xef, 0xf0, 0000, 0000, 0xed, 0xee, 0x58, 0000,
   0xed, 0xee, 0x65, 0000, 0xf3, 0xf1, 0000, 0000},
  {0xcf, 0xcf, 0xd0, 0xcf, 0x16, 0x47, 0x48, 0x41,
   0x17, 0x49, 0x4a, 0x42, 0x16, 0x3f, 0x40, 0x19},
  {0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
   0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef},
  {0xe2, 0xe3, 0xe0, 0xe1, 0xe6, 0xe7, 0xe4, 0xe5,
   0xea, 0xeb, 0xe8, 0xe9, 0xee, 0xef, 0xec, 0xed},
  {0xe0, 0xe3, 0xe0, 0xe1, 0xe8, 0xe7, 0xe4, 0xe5,
   0xe4, 0xeb, 0xe8, 0xe9, 0xec, 0xef, 0xec, 0xed},
  {0xe2, 0xe3, 0xe0, 0xe3, 0xe6, 0xe7, 0xe4, 0xeb,
   0xea, 0xeb, 0xe8, 0xe7, 0xee, 0xef, 0xec, 0xef},
  {0x1e, 0x1f, 0x22, 0x23, 0x20, 0x21, 0x24, 0x25,
   0x1f, 0x22, 0x23, 0x1e, 0x21, 0x24, 0x25, 0x20},
  {0x26, 0x27, 0x26, 0x27, 0x20, 0x21, 0x24, 0x25,
   0x1f, 0x22, 0x23, 0x1e, 0x21, 0x24, 0x25, 0x20},
  {0x26, 0x1f, 0x22, 0x23, 0x28, 0x21, 0x24, 0x25,
   0000, 0x22, 0x23, 0x1e, 0000, 0x24, 0x25, 0x20},
  {0x26, 0x27, 0x26, 0x27, 0x28, 0x21, 0x24, 0x25,
   0000, 0x22, 0x23, 0x1e, 0000, 0x24, 0x25, 0x20},
  {0x26, 0x1f, 0x22, 0x23, 0x20, 0x21, 0x24, 0x25,
   0x1f, 0x22, 0x23, 0x1e, 0x21, 0x24, 0x25, 0x20},
  {0x8c, 0x8d, 0x8e, 0x27, 0x8f, 0x90, 0xc0, 0000,
   0xc1, 0xc2, 0xc3, 0x26, 0000, 0x28, 0000, 0x28},
  {0xf7, 0x27, 0x26, 0x27, 0xf7, 0000, 0x24, 0x25,
   0xf7, 0x26, 0x23, 0x1e, 0xf7, 0x28, 0x25, 0x20},
  {0x1e, 0x39, 0x3a, 0x27, 0x20, 0x39, 0x3a, 0000,
   0x1f, 0x39, 0x3a, 0x26, 0x21, 0x39, 0x3a, 0x28},
  {0xd2, 0xfc, 0xfd, 0xd3, 0000, 0x39, 0x3a, 0000,
   0x1f, 0x39, 0x3a, 0x26, 0x21, 0x39, 0x3a, 0x28},
  {0xd2, 0xd3, 0xd4, 0xd3, 0x28, 0000, 0x28, 0000,
   0x1f, 0x22, 0x23, 0x1e, 0x21, 0x24, 0x25, 0x20},
  {0xd5, 0xd3, 0xd4, 0xd3, 0x28, 0000, 0x28, 0000,
   0x27, 0x22, 0x23, 0x1e, 0000, 0x24, 0x25, 0x20},
  {0xd5, 0xfc, 0xfd, 0xd3, 0000, 0x39, 0x3a, 0000,
   0x27, 0x39, 0x3a, 0x26, 0000, 0x39, 0x3a, 0x28},
  {0x26, 0x39, 0x3a, 0x27, 0x28, 0x39, 0x3a, 0000,
   0x27, 0x39, 0x3a, 0x26, 0000, 0x39, 0x3a, 0x28},
  {0x26, 0x79, 0x7a, 0x27, 0x20, 0x7b, 0x7c, 0000,
   0x1f, 0x7b, 0x7c, 0x26, 0x21, 0x7b, 0x7c, 0x28},
  {0xcf, 0xcf, 0xd0, 0xcf, 0x41, 0x4b, 0x4c, 0x19,
   0x42, 0x4d, 0x4e, 0x19, 0x19, 0x3f, 0x40, 0x18},
  {0x1e, 0x04, 0x05, 0x23, 0x20, 0x06, 0x07, 0x25,
   0x04, 0x05, 0x04, 0x05, 0x06, 0x07, 0x06, 0x07},
  {0x22, 0x23, 0x22, 0x23, 0x24, 0x25, 0x24, 0x25,
   0x6f, 0x70, 0x70, 0x71, 0x72, 0x73, 0x73, 0x74},
  {0x0a, 0x0b, 0x22, 0x23, 0x0a, 0x0c, 0x24, 0x25,
   0x0a, 0x0b, 0x23, 0x1e, 0x0a, 0x0c, 0x25, 0x20},
  {0x1e, 0x1f, 0x08, 0x0a, 0x20, 0x21, 0x09, 0x0a,
   0x1f, 0x22, 0x08, 0x0a, 0x21, 0x24, 0x09, 0x0a},
  {0x1e, 0x1f, 0x22, 0x23, 0x20, 0x21, 0x24, 0x25,
   0x27, 0x22, 0x23, 0x1e, 0000, 0x24, 0x25, 0x20},
  {0x1e, 0x1f, 0x22, 0xd3, 0xd2, 0xd3, 0xd4, 0000,
   0x27, 0x26, 0x27, 0x26, 0x21, 0x24, 0x25, 0x20},
  {0xe0, 0xe1, 0xe2, 0xe3, 0xec, 0xed, 0xee, 0xef,
   0x27, 0x26, 0x27, 0x26, 0x21, 0x24, 0x25, 0x20},
  {0xd2, 0xd3, 0xd4, 0xd3, 0xf8, 0xf9, 0xf8, 0xf9,
   0x27, 0xbe, 0xbf, 0x26, 0x21, 0xbe, 0xbf, 0x28},
  {0x1e, 0x1f, 0x22, 0xf4, 0x20, 0x21, 0xf4, 0xf5,
   0x1f, 0xf4, 0xf5, 0xf6, 0xf4, 0xf5, 0xf4, 0xf5},
  {0xf5, 0xf6, 0xf7, 0xf4, 0xf4, 0xf5, 0xf6, 0xf7,
   0xf7, 0xf6, 0xf7, 0xf4, 0xf4, 0xf5, 0xf6, 0xf7},
  {0xf5, 0x27, 0x22, 0x23, 0xf6, 0xf5, 0x28, 0x25,
   0xf5, 0xf6, 0xf7, 0x26, 0xf4, 0xf5, 0xf6, 0xf7},
  {0xf7, 0xf6, 0xf7, 0x27, 0xf6, 0xf7, 0x28, 0x25,
   0xf7, 0x26, 0x27, 0x1e, 0000, 0x28, 0x25, 0x20},
  {0xd2, 0xd3, 0xd2, 0xd3, 0xf8, 0xf8, 0xf8, 0xf8,
   0x27, 0x26, 0x27, 0x26, 0x21, 0x24, 0x25, 0x20},
  {0x15, 0x17, 0x15, 0x16, 0x16, 0x15, 0x17, 0x17,
   0x5f, 0x5f, 0x5f, 0x5f, 0x16, 0x15, 0x16, 0x16},
  {0x26, 0x1f, 0x22, 0x23, 0x28, 0x21, 0x24, 0x25,
   0x27, 0x22, 0x23, 0x1e, 0x21, 0x24, 0x25, 0x20},
  {0x1e, 0x1f, 0x22, 0x23, 0x20, 0x21, 0x24, 0x25,
   0xe0, 0xe1, 0xe2, 0xe3, 0xec, 0xed, 0xee, 0xef},
  {0xe0, 0xe1, 0xe3, 0x27, 0xe4, 0xe5, 0xe7, 0000,
   0xe8, 0xe9, 0xeb, 0x26, 0xec, 0xed, 0xef, 0x28},
  {0x34, 0x34, 0x34, 0x34, 0x35, 0x35, 0x35, 0x36,
   0x33, 0x33, 0x33, 0x33, 0x35, 0x35, 0x35, 0x35},
  {0x1e, 0x1f, 0x1a, 0x1b, 0x20, 0x21, 0x1c, 0x1d,
   0x1f, 0x22, 0x1a, 0x1b, 0x21, 0x24, 0x1c, 0x1d},
  {0x1a, 0x1b, 0x26, 0x23, 0x1c, 0x1d, 0x28, 0x25,
   0x1a, 0x1b, 0x27, 0x1e, 0x1c, 0x1d, 0000, 0x20},
  {0x26, 0x27, 0x26, 0x27, 0x20, 0x21, 0x24, 0x25,
   0x1a, 0x1b, 0x1a, 0x1b, 0x1c, 0x1d, 0x1c, 0x1d},
  {0x26, 0x27, 0x26, 0x27, 0x20, 0x21, 0x24, 0x25,
   0x1f, 0x22, 0x1a, 0x1b, 0x21, 0x24, 0x1c, 0x1d},
  {0x26, 0x27, 0x26, 0x27, 0x20, 0x21, 0x24, 0x25,
   0x1a, 0x1b, 0x27, 0x1e, 0x1c, 0x1d, 0000, 0x20},
  {0x26, 0x27, 0x26, 0xf4, 0x20, 0x21, 0x24, 0xf4,
   0x1f, 0x22, 0x23, 0xf4, 0x21, 0x24, 0x25, 0xf4},
  {0x26, 0x27, 0x26, 0x27, 0x28, 0x21, 0x24, 0x25,
   0x27, 0x22, 0x23, 0x1e, 0x21, 0x24, 0x25, 0x20},
  {0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
   0xec, 0xed, 0xee, 0xef, 0x27, 0x26, 0x27, 0x26},
  {0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
   0xec, 0xed, 0xee, 0xef, 0x27, 0x26, 0x27, 0x26},
  {0xe0, 0xe1, 0xe2, 0xe3, 0xec, 0xed, 0xee, 0xef,
   0x27, 0x26, 0x27, 0x26, 0000, 0x24, 0x25, 0x20},
  {0xd8, 0xd8, 0xd8, 0xd8, 0xf8, 0xf8, 0xf8, 0xf8,
   0x27, 0x26, 0x27, 0x26, 0x21, 0x24, 0x25, 0x20},
  {0x1e, 0x1f, 0x08, 0x0a, 0x20, 0x21, 0x09, 0x0a,
   0x1f, 0x22, 0x08, 0x0a, 0x21, 0x3c, 0x09, 0x0a},
  {0x1e, 0xbe, 0xbf, 0x27, 0x20, 0xbe, 0xbf, 0000,
   0x1f, 0xbe, 0xbf, 0x26, 0x21, 0xbe, 0xbf, 0x28},
  {0x1e, 0x23, 0x22, 0x23, 0x20, 0x25, 0x24, 0x25,
   0x04, 0x05, 0x04, 0x05, 0x06, 0x07, 0x06, 0x07},
  {0x26, 0xf6, 0xf7, 0xf4, 0x20, 0000, 0xf6, 0xf7,
   0x23, 0x1e, 0x27, 0xf4, 0x25, 0x1f, 0x21, 0x28},
  {0x26, 0x04, 0x05, 0x23, 0x22, 0x06, 0x07, 0x25,
   0x04, 0x05, 0x04, 0x05, 0x06, 0x07, 0x06, 0x07},
  {0x26, 0x27, 0xbe, 0xbf, 0x20, 0x21, 0xbe, 0xbf,
   0x1f, 0x22, 0xbe, 0xbf, 0x21, 0x24, 0xbe, 0xbf},
  {0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
   0xe8, 0xe9, 0xea, 0xeb, 0x29, 0xed, 0xee, 0xef},
  {0x26, 0x1f, 0x22, 0x23, 0x28, 0x21, 0x24, 0x25,
   0x27, 0x22, 0x23, 0x1e, 0x3b, 0x3b, 0x3b, 0x3b},
  {0x26, 0x1f, 0x22, 0x23, 0x28, 0x21, 0x24, 0x25,
   0x1f, 0x22, 0x23, 0x1e, 0x21, 0x24, 0x25, 0x20},
  {0x26, 0x39, 0x3a, 0x27, 0x20, 0x39, 0x3a, 0000,
   0x1f, 0x39, 0x3a, 0x26, 0x21, 0x39, 0x3a, 0x28},
  {0x26, 0x27, 0x26, 0x23, 0x20, 0x21, 0x24, 0x25,
   0x1f, 0x22, 0x23, 0x1e, 0x21, 0x24, 0x25, 0x20},
  {0xe0, 0xe3, 0x26, 0x23, 0xe4, 0xe7, 0x28, 0x25,
   0xe8, 0xeb, 0x27, 0x1e, 0xec, 0xef, 0000, 0x20},
  {0x1e, 0x1f, 0xe0, 0xe3, 0x20, 0x21, 0xe4, 0xe7,
   0x1f, 0x22, 0xe8, 0xeb, 0x3b, 0x3b, 0xec, 0xef},
  {0x15, 0x16, 0x17, 0xcf, 0x15, 0x16, 0x16, 0x16,
   0x16, 0x17, 0x16, 0x15, 0x15, 0x15, 0x16, 0x16},
  {0x19, 0x37, 0x38, 0x18, 0x16, 0x37, 0x38, 0x18,
   0x15, 0x37, 0x38, 0x19, 0x16, 0x37, 0x38, 0x18},
  {0xcf, 0xd0, 0xcf, 0xcf, 0x18, 0x16, 0x16, 0x16,
   0x18, 0x17, 0x16, 0x15, 0x18, 0x15, 0x16, 0x16},
  {0xdc, 0xdd, 0xdc, 0xdd, 0xde, 0xdf, 0xde, 0xdf,
   0xdc, 0xdd, 0xdc, 0xdd, 0xde, 0xdf, 0xde, 0xdf},
  {0xae, 0xaf, 0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5,
   0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd},
  {0x9e, 0x9f, 0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5,
   0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad},
  {0x15, 0x94, 0x95, 0x19, 0x15, 0x96, 0x97, 0x18,
   0x15, 0x98, 0x99, 0x19, 0x9a, 0x9b, 0x9c, 0x9d},
  {0x15, 0x17, 0x15, 0x16, 0x16, 0x16, 0x16, 0x16,
   0x16, 0x17, 0x16, 0x15, 0x16, 0x15, 0x16, 0x16},
  {0x15, 0x17, 0x15, 0x16, 0x0d, 0x0e, 0x0f, 0x10,
   0x0f, 0x11, 0x0d, 0x10, 0x77, 0x76, 0x77, 0x77},
  {0x15, 0x16, 0x15, 0x16, 0x0e, 0x0f, 0x10, 0x0e,
   0x11, 0x10, 0x0f, 0x11, 0x76, 0x02, 0x03, 0x76},
  {0xcf, 0xfa, 0xfb, 0xcf, 0x16, 0x37, 0x38, 0x18,
   0x16, 0x37, 0x38, 0x18, 0x16, 0x37, 0x38, 0x18},
  {0x16, 0x37, 0x38, 0x19, 0x16, 0x37, 0x38, 0x18,
   0x16, 0x37, 0x38, 0x19, 0x16, 0x37, 0x38, 0x18},
  {0xf0, 0xf1, 0xf2, 0xf1, 0xf9, 0xf8, 0xf9, 0xf8,
   0xdc, 0xdd, 0xdc, 0xdd, 0xde, 0xdf, 0xde, 0xdf},
  {0x16, 0x17, 0x16, 0x15, 0x15, 0x16, 0x15, 0x16,
   0x61, 0x62, 0x63, 0x64, 0x61, 0x62, 0x63, 0x64},
  {0x16, 0x17, 0x15, 0x16, 0x15, 0x16, 0x16, 0x15,
   0x65, 0x66, 0x67, 0x18, 0x65, 0x66, 0x67, 0x19},
  {0x15, 0x3f, 0x40, 0x18, 0x16, 0x3f, 0x40, 0x19,
   0x16, 0x3f, 0x40, 0x18, 0x16, 0x3f, 0x40, 0x19},
  {0x15, 0x17, 0x15, 0x16, 0x41, 0x41, 0x45, 0x41,
   0x42, 0x42, 0x46, 0x42, 0x18, 0x19, 0x18, 0x19},
  {0x15, 0x17, 0x15, 0x16, 0x16, 0x47, 0x48, 0x41,
   0x16, 0x49, 0x4a, 0x42, 0x16, 0x3f, 0x40, 0x19},
  {0x15, 0x17, 0x15, 0x16, 0x41, 0x4b, 0x4c, 0x15,
   0x42, 0x4d, 0x4e, 0x19, 0x19, 0x3f, 0x40, 0x18},
  {0x15, 0x3f, 0x40, 0x19, 0x16, 0x4f, 0x50, 0x41,
   0x16, 0x51, 0x52, 0x42, 0x16, 0x15, 0x18, 0x19},
  {0x15, 0x3f, 0x40, 0x19, 0x41, 0x53, 0x54, 0x18,
   0x42, 0x55, 0x56, 0x19, 0x19, 0x18, 0x19, 0x15},
  {0x15, 0x3f, 0x40, 0x18, 0x41, 0x53, 0x50, 0x41,
   0x42, 0x4d, 0x4a, 0x42, 0x18, 0x3f, 0x40, 0x18},
  {0x15, 0x17, 0x15, 0x16, 0x16, 0x58, 0x5e, 0x60,
   0x16, 0x5c, 0x19, 0x18, 0x16, 0x5c, 0x18, 0x16},
  {0x19, 0x17, 0x15, 0x16, 0x5f, 0x59, 0x18, 0x16,
   0x19, 0x5c, 0x18, 0x15, 0x18, 0x5c, 0x19, 0x16},
  {0x18, 0x5c, 0x19, 0x18, 0x16, 0x5a, 0x5d, 0x5d,
   0x16, 0x19, 0x18, 0x19, 0x16, 0x15, 0x16, 0x16},
  {0x18, 0x5c, 0x18, 0x19, 0x5d, 0x5b, 0x19, 0x16,
   0x18, 0x19, 0x18, 0x15, 0x16, 0x15, 0x16, 0x16},
  {0x15, 0x68, 0x01, 0x16, 0x16, 0x68, 0x01, 0x16,
   0x16, 0x68, 0x01, 0x16, 0x16, 0x68, 0x01, 0x17},
  {0x19, 0x68, 0x01, 0x19, 0x16, 0x68, 0x01, 0x18,
   0x16, 0x68, 0x01, 0x19, 0x16, 0x68, 0x01, 0x18},
  {0x16, 0xcc, 0x19, 0x16, 0xd6, 0xd7, 0xd6, 0xd6,
   0x19, 0x18, 0x19, 0x19, 0x16, 0x16, 0x16, 0x16},
  {0x16, 0xcb, 0x19, 0x16, 0x15, 0xcb, 0x19, 0x15,
   0x16, 0xcb, 0x18, 0x16, 0x16, 0xcb, 0x18, 0x15},
  {0x18, 0x18, 0x19, 0x18, 0xce, 0xce, 0xce, 0xc7,
   0x16, 0x17, 0x16, 0x16, 0x16, 0x16, 0x16, 0x17},
  {0x16, 0x17, 0x16, 0x16, 0x18, 0x16, 0x17, 0x16,
   0x19, 0x16, 0x16, 0x16, 0x16, 0x17, 0x16, 0x16},
  {0x18, 0x18, 0x19, 0x18, 0xce, 0xce, 0xce, 0xc7,
   0x18, 0x17, 0x16, 0x16, 0x19, 0x16, 0x16, 0x17},
  {0x15, 0x17, 0x15, 0x16, 0x16, 0x69, 0x6a, 0x6b,
   0x69, 0x6a, 0x6b, 0x69, 0x6c, 0x6d, 0x6e, 0x6c},
  {0x15, 0x17, 0x15, 0x16, 0x18, 0x16, 0x16, 0x16,
   0x6a, 0x6b, 0x18, 0x15, 0x6d, 0x6e, 0x19, 0x16},
  {0x19, 0x7d, 0x7e, 0x18, 0x16, 0x7f, 0x80, 0x18,
   0x16, 0x7f, 0x80, 0x19, 0x16, 0x7f, 0x80, 0x18},
  {0x15, 0x7f, 0x80, 0x19, 0x16, 0x7f, 0x80, 0x18,
   0x16, 0x7f, 0x80, 0x19, 0x16, 0x7f, 0x80, 0x18},
  {0x18, 0x16, 0x17, 0x16, 0xd6, 0xd6, 0xd6, 0xd6,
   0x19, 0x18, 0x19, 0x19, 0x18, 0x16, 0x16, 0x16},
  {0x19, 0xcb, 0x19, 0x18, 0x16, 0xcb, 0x18, 0x15,
   0x16, 0xcb, 0x19, 0x16, 0x16, 0xcb, 0x18, 0x15},
  {0x18, 0x17, 0x15, 0x16, 0x18, 0x16, 0x16, 0x16,
   0x19, 0x17, 0x16, 0x15, 0x19, 0x15, 0x16, 0x16},
  {0x19, 0x18, 0x19, 0x19, 0x16, 0x16, 0x16, 0x16,
   0x16, 0x17, 0x16, 0x15, 0x16, 0x15, 0x16, 0x16},
  {0x19, 0x19, 0x18, 0x19, 0x18, 0x16, 0x16, 0x16,
   0x19, 0x17, 0x16, 0x15, 0x18, 0x15, 0x16, 0x16},
  {0x19, 0x17, 0x15, 0x16, 0x16, 0x16, 0x16, 0x16,
   0x16, 0x17, 0x16, 0x15, 0x16, 0x15, 0x16, 0x16},
  {0x18, 0x02, 0x03, 0x15, 0xd6, 0xfa, 0xfb, 0xd6,
   0x18, 0x37, 0x38, 0x19, 0x18, 0x37, 0x38, 0x18},
  {0x15, 0x17, 0x15, 0x16, 0x16, 0x92, 0x93, 0x18,
   0x16, 0x92, 0x93, 0x19, 0x16, 0x92, 0x93, 0x19},
  {0x85, 0x86, 0x85, 0x86, 0x19, 0x18, 0x19, 0x18,
   0x16, 0x17, 0x16, 0x15, 0x16, 0x15, 0x16, 0x16},
  {0x89, 0x87, 0x88, 0x89, 0x19, 0x18, 0x19, 0x18,
   0x16, 0x17, 0x16, 0x15, 0x16, 0x15, 0x16, 0x16},
  {0xdc, 0xdd, 0xdc, 0xdd, 0xde, 0xdf, 0xde, 0xdf,
   0x19, 0x33, 0x33, 0x18, 0x81, 0x82, 0x83, 0x84},
  {0xdd, 0x18, 0x18, 0x18, 0xdf, 0x19, 0x16, 0x16,
   0xdd, 0x18, 0x16, 0x15, 0xdf, 0x19, 0x16, 0x17},
  {0xcf, 0xd0, 0xcf, 0xcf, 0x16, 0x16, 0x16, 0x16,
   0x16, 0x17, 0x16, 0x15, 0x16, 0x15, 0x16, 0x16},
  {0xcf, 0xfa, 0xfb, 0xcf, 0x18, 0x37, 0x38, 0x18,
   0x18, 0x37, 0x38, 0x18, 0x18, 0x37, 0x38, 0x18},
  {0x15, 0x17, 0x15, 0x16, 0xd1, 0xd1, 0xd1, 0xd1,
   0x42, 0x42, 0x42, 0x42, 0x18, 0x19, 0x18, 0x19},
  {0x18, 0x37, 0x38, 0x18, 0x18, 0x37, 0x38, 0x18,
   0x18, 0x37, 0x38, 0x18, 0x18, 0x37, 0x38, 0x18},
  {0x15, 0x16, 0x15, 0x16, 0xd6, 0xd6, 0xd6, 0xd6,
   0x19, 0x18, 0x19, 0x19, 0x16, 0x16, 0x16, 0x16},
  {0x18, 0x15, 0x15, 0x16, 0xce, 0xc4, 0xc5, 0xce,
   0x18, 0x15, 0x16, 0x16, 0x18, 0x15, 0x16, 0x15},
  {0x16, 0xcc, 0x19, 0x16, 0xd6, 0xd7, 0xd6, 0xd6,
   0x19, 0xcb, 0x19, 0x19, 0x16, 0xcb, 0x19, 0x16},
  {0x15, 0x16, 0x15, 0x16, 0xd6, 0xd6, 0xd6, 0xd6,
   0x18, 0x68, 0x01, 0x19, 0x16, 0x68, 0x01, 0x16},
  {0x16, 0x16, 0x15, 0x16, 0x16, 0x15, 0x92, 0x93,
   0x69, 0x6a, 0x6b, 0x93, 0x6c, 0x6d, 0x6e, 0x93},
  {0x19, 0x16, 0x15, 0x16, 0x0e, 0x0f, 0x10, 0x0e,
   0x11, 0x10, 0x0f, 0x11, 0x76, 0x02, 0x03, 0x76},
  {0x16, 0x15, 0x15, 0x16, 0xce, 0xce, 0xce, 0xce,
   0x16, 0x15, 0x16, 0x16, 0x16, 0x15, 0x16, 0x15},
  {0x15, 0x17, 0x15, 0x16, 0x16, 0x16, 0x16, 0x16,
   0x18, 0x17, 0x16, 0x15, 0x19, 0x16, 0x16, 0x16},
  {0x16, 0x37, 0x38, 0x19, 0xd6, 0x37, 0x38, 0xd6,
   0x16, 0x37, 0x38, 0x19, 0x19, 0x37, 0x38, 0x18},
  {0x16, 0x16, 0x17, 0x16, 0xd6, 0xd7, 0xd6, 0xd6,
   0x19, 0xcb, 0x19, 0x19, 0x16, 0xcb, 0x19, 0x16},
  {0x18, 0x37, 0x38, 0x18, 0x18, 0x37, 0x38, 0x18,
   0x18, 0x37, 0x38, 0x18, 0x18, 0x37, 0x38, 0x18},
  {0x15, 0x37, 0x38, 0x18, 0x0e, 0x37, 0x38, 0x0e,
   0x11, 0x37, 0x38, 0x11, 0x76, 0x76, 0x77, 0x76},
  {0xd9, 0x62, 0xda, 0xdb, 0xd9, 0x62, 0xda, 0xdb,
   0xd9, 0x62, 0xda, 0xdb, 0xd9, 0x62, 0xda, 0xdb},
  {0x19, 0x1a, 0x19, 0xe1, 0x2f, 0x30, 0x2b, 0xe4,
   0x22, 0x2d, 0x2e, 0xe7, 0x28, 0x2b, 0x2c, 0xea},
};

mark_t map_marks[MAP_NBR_MARKS] = {
  {0x18, 0x16, 0000, 0x08, 0x08}, /* 0 */
  {0x18, 0x2a, 0x88, 0x01, 0x28},
  {0x38, 0x04, 0xf0, 0x15, 0x29},
  {0x38, 0x17, 0x01, 0xe0, 0xe0},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x12, 0000, 0xc5, 0000}, /* 1 */
  {0x18, 0x19, 0x88, 0x95, 0xc3},
  {0x20, 0x04, 0000, 0x65, 0x71},
  {0x28, 0x04, 0xf0, 0x85, 0x82},
  {0x30, 0x04, 0000, 0x45, 0x60},
  {0x38, 0x19, 0x88, 0x11, 0x63},
  {0x48, 0x12, 0000, 0x4d, 0000},
  {0x60, 0x1b, 0x88, 0xc2, 0xc2},
  {0x68, 0x04, 0xf0, 0xb5, 0x61},
  {0x68, 0x19, 0x88, 0x11, 0x22},
  {0x68, 0x12, 0000, 0x55, 0000},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x05, 0000, 0x49, 0x03}, /* 2 */
  {0x18, 0x05, 0xf0, 0xc1, 0x01},
  {0x18, 0x06, 0000, 0x89, 0000},
  {0x20, 0x16, 0x01, 0x24, 0x24},
  {0x20, 0x17, 0x01, 0xc4, 0xc4},
  {0x20, 0x12, 0000, 0x75, 0000},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x16, 0000, 0000, 0000}, /* 3 */
  {0x18, 0x04, 0000, 0x81, 0x40},
  {0x18, 0x11, 0000, 0x99, 0000},
  {0x38, 0x2f, 0x81, 0x2d, 0x8d},
  {0x38, 0x1b, 0x88, 0x25, 0x25},
  {0x40, 0x2d, 0x8c, 0x72, 0x74},
  {0x40, 0x2d, 0x8e, 0x8a, 0x74},
  {0x48, 0x2b, 0xfc, 0x69, 0x69},
  {0x50, 0x04, 0000, 0x81, 0x28},
  {0x50, 0x19, 0x88, 0x11, 0x40},
  {0x60, 0x12, 0000, 0x55, 0000},
  {0x68, 0x2c, 0x1f, 0x86, 0x94},
  {0x78, 0x2e, 0x15, 0x7a, 0x6a},
  {0x78, 0x2e, 0x15, 0x8a, 0x7a},
  {0x80, 0x17, 0x01, 0xe0, 0xe0},
  {0x80, 0x12, 0000, 0x35, 0000},
  {0x80, 0x04, 0xf0, 0x35, 0x61},
  {0x80, 0x04, 0000, 0x85, 0x30},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x12, 0000, 0xae, 0000}, /* 4 */
  {0x30, 0x19, 0x88, 0x15, 0x84},
  {0x38, 0x31, 0x8c, 0x80, 0xa4},
  {0x40, 0x10, 0000, 0x0d, 0000},
  {0x40, 0x04, 0xf0, 0x55, 0x60},
  {0x48, 0x19, 0x48, 0x15, 0xc4},
  {0x48, 0x04, 0000, 0x85, 0x40},
  {0x48, 0x04, 0000, 0x75, 0x38},
  {0x50, 0x2e, 0x15, 0xc6, 0xb6},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x25, 0x84, 0x63, 0x84}, /* 5 */
  {0x18, 0x25, 0x84, 0xa3, 0x40},
  {0x20, 0x30, 0x8e, 0xe2, 0x44},
  {0xff, 0000, 0000, 0000, 0000},
  {0x20, 0x10, 0000, 0xa1, 0000}, /* 6 */
  {0x28, 0x48, 0x1f, 0x62, 0x80},
  {0x30, 0x04, 0x80, 0x45, 0x80},
  {0x30, 0x11, 0000, 0x65, 0000},
  {0x38, 0x1a, 0x88, 0xe5, 0x84},
  {0x40, 0x05, 0000, 0x65, 0x03},
  {0x50, 0x19, 0x88, 0x11, 0x20},
  {0x50, 0x05, 0xf0, 0x21, 0x07},
  {0x58, 0x05, 0000, 0x81, 0x05},
  {0x68, 0x04, 0000, 0xa5, 0x40},
  {0x70, 0x12, 0000, 0xcd, 0000},
  {0x70, 0x19, 0x88, 0x15, 0x64},
  {0x78, 0x04, 0xf0, 0x45, 0x60},
  {0x80, 0x04, 0xf0, 0x45, 0x80},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x2c, 0x1f, 0xe2, 0xc0}, /* 7 */
  {0x18, 0x19, 0x88, 0x15, 0x24},
  {0x28, 0x11, 0000, 0xc5, 0000},
  {0x28, 0x1a, 0x88, 0xd1, 0x20},
  {0x38, 0x04, 0000, 0x21, 0x70},
  {0x40, 0x04, 0xf0, 0x81, 0x60},
  {0x40, 0x1b, 0x88, 0x25, 0x24},
  {0x50, 0x12, 0000, 0x21, 0000},
  {0x50, 0x19, 0x88, 0x11, 0x60},
  {0x60, 0x1a, 0x88, 0xe1, 0xa0},
  {0x60, 0x19, 0x88, 0x15, 0xc4},
  {0x68, 0x04, 0000, 0x21, 0x60},
  {0x70, 0x19, 0x88, 0x15, 0x84},
  {0x78, 0x05, 0000, 0x45, 0000},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x27, 0x88, 0x62, 0x60}, /* 8 */
  {0x18, 0x1b, 0x88, 0x25, 0x24},
  {0x18, 0x1b, 0x88, 0x85, 0x84},
  {0x30, 0x1a, 0x88, 0xe1, 0x40},
  {0x30, 0x19, 0x88, 0x11, 0x40},
  {0x38, 0x04, 0xf0, 0x55, 0x60},
  {0x58, 0x1b, 0x88, 0x81, 0x80},
  {0x58, 0x04, 0xf0, 0x85, 0x40},
  {0x68, 0x27, 0x88, 0x62, 0x60},
  {0x68, 0x12, 0000, 0x25, 0000},
  {0x78, 0x1a, 0x88, 0xe1, 0000},
  {0x80, 0x2c, 0x1f, 0x84, 0x80},
  {0x80, 0x2c, 0x1d, 0xe2, 0xc0},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x17, 0x01, 0xe0, 0xe0}, /* 9 */
  {0x18, 0x1d, 0x88, 0x81, 0x60},
  {0x18, 0x1e, 0x88, 0x89, 0xa0},
  {0x20, 0x07, 0000, 0xc1, 0x98},
  {0x20, 0x09, 0000, 0x89, 0x01},  /* HERE */
  {0x28, 0x1c, 0x1f, 0x42, 0x60},
  {0x30, 0x07, 0000, 0x65, 0x43},
  {0x30, 0x08, 0000, 0xc1, 0x05},
  {0x40, 0x20, 0x48, 0x70, 0x40},
  {0x40, 0x19, 0xc8, 0x41, 0x82},
  {0x48, 0x19, 0x88, 0x1d, 0x25},
  {0x48, 0x09, 0000, 0xcd, 0x04},
  {0x50, 0x07, 0000, 0x45, 0x80},
  {0x60, 0x1b, 0x88, 0x41, 0x41},
  {0x60, 0x1a, 0x88, 0xe5, 0x24},
  {0x68, 0x13, 0000, 0x2d, 0000},
  {0x70, 0x18, 0x8e, 0xc8, 0xce},
  {0x78, 0x1a, 0x88, 0xe5, 0x24},
  {0x78, 0x16, 0000, 0x22, 0x22},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x17, 0x01, 0xe0, 0xe0}, /* 9 */
  {0x20, 0x09, 0000, 0x82, 0000},
  {0x20, 0x1b, 0x88, 0x82, 0x78},
  {0x30, 0x19, 0x88, 0x19, 0x81},
  {0x30, 0x07, 0000, 0x51, 0x40},
  {0x30, 0x1b, 0x88, 0xa5, 0xa5},
  {0x40, 0x07, 0xf0, 0x81, 0x30},
  {0x40, 0x13, 0000, 0xcf, 0000},
  {0x50, 0x1b, 0x88, 0x58, 0x51},
  {0x58, 0x1f, 0x8e, 0x72, 0x64},
  {0x60, 0x09, 0000, 0x85, 0x01},
  {0x60, 0x16, 0000, 0x84, 0x84},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x1c, 0x1f, 0x42, 0x20}, /* a */
  {0x18, 0x28, 0xf8, 0x69, 0x61},
  {0x18, 0x07, 0xf0, 0x89, 0x28},
  {0x18, 0x07, 0xf0, 0x81, 0x50},
  {0x18, 0x07, 0xf0, 0xa9, 0x28},
  {0x18, 0x20, 0x88, 0xc4, 0xa0},
  {0x28, 0x27, 0x88, 0x44, 0x4c},
  {0x30, 0x21, 0x8c, 0x5c, 0x25},
  {0x30, 0x21, 0x8c, 0x74, 0x25},
  {0x30, 0x21, 0x8c, 0x8c, 0x25},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x1d, 0x89, 0x8d, 0x71}, /* b */
  {0x18, 0x1e, 0x89, 0x65, 0x71},
  {0x18, 0x22, 0x81, 0x79, 0x71},
  {0x18, 0x23, 0x8e, 0x7c, 0x71},
  {0x20, 0x16, 0x01, 0x71, 0x71},
  {0x20, 0x17, 0x01, 0x75, 0x75},
  {0x30, 0x09, 0000, 0xc1, 0x02},
  {0x30, 0x09, 0000, 0xb1, 0x03},
  {0x30, 0x09, 0000, 0xa1, 0x01},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x08, 0000, 0x2d, 0x01}, /* c */
  {0x18, 0x07, 0xf0, 0xad, 0x50},
  {0x18, 0x13, 0000, 0xbd, 0000},
  {0x28, 0x11, 0000, 0xc1, 0000},
  {0x30, 0x1b, 0x88, 0xc0, 0xe0},
  {0x30, 0x1b, 0x88, 0xa4, 0xc4},
  {0x38, 0x1a, 0x88, 0xc1, 0x01},
  {0x38, 0x09, 0000, 0x61, 0x03},
  {0xff, 0000, 0000, 0000, 0000},
  {0x10, 0x08, 0000, 0x4b, 0x02}, /* d */
  {0x10, 0x08, 0000, 0xab, 0x04},
  {0x20, 0x24, 0x2e, 0x60, 0x1c},
  {0x20, 0x1b, 0x88, 0x24, 0x24},
  {0x30, 0x1a, 0x88, 0xcd, 0x24},
  {0x38, 0x25, 0x24, 0xc3, 0xd0},
  {0x48, 0x16, 0000, 0x24, 0x24},
  {0x48, 0x1b, 0x88, 0x24, 0x27},
  {0x50, 0x10, 0000, 0x81, 0000},
  {0x50, 0x07, 0000, 0x81, 0x19},
  {0x60, 0x26, 0x2e, 0x26, 0xd2},
  {0x60, 0x17, 0x01, 0xe0, 0xe0},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x28, 0xf8, 0x41, 0x40}, /* e */
  {0x18, 0x28, 0x88, 0x61, 0xa0},
  {0x18, 0x11, 0000, 0xc9, 0000},
  {0x20, 0x29, 0x78, 0x85, 0x84},
  {0x28, 0x1b, 0x88, 0x40, 0x50},
  {0x30, 0x09, 0000, 0x43, 0000},
  {0x40, 0x07, 0000, 0x21, 0x82},
  {0x40, 0x1c, 0x1f, 0x64, 0x60},
  {0x40, 0x16, 0000, 0x65, 0x65},
  {0x58, 0x07, 0xf0, 0xa3, 0x12},
  {0x68, 0x1c, 0x1f, 0xaa, 0xa8},
  {0x78, 0x09, 0000, 0x43, 0000},
  {0x78, 0x09, 0000, 0xa3, 0000},
  {0x78, 0x09, 0000, 0x83, 0000},
  {0x78, 0x17, 0x01, 0xe0, 0xe0},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x49, 0x1f, 0xe2, 0xc0}, /* f */
  {0x20, 0x07, 0000, 0x41, 0x80},
  {0x28, 0x19, 0x88, 0x11, 0x60},
  {0x28, 0x09, 0000, 0x81, 0000},
  {0x30, 0x11, 0000, 0x85, 0000},
  {0x40, 0x07, 0000, 0x11, 0x48},
  {0x48, 0x1a, 0x88, 0xe1, 0x40},
  {0x48, 0x13, 0000, 0x29, 0000},
  {0x50, 0x10, 0000, 0x21, 0000},
  {0x58, 0x09, 0000, 0xc1, 0000},
  {0x58, 0x07, 0000, 0x21, 0x60},
  {0x60, 0x08, 0xf0, 0xc5, 0x03},
  {0x68, 0x19, 0x88, 0x15, 0x24},
  {0x78, 0x27, 0x88, 0x84, 0x82},
  {0x80, 0x1a, 0x88, 0xe5, 0x14},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x21, 0x8c, 0x80, 0x62}, /* 10 */
  {0x18, 0x21, 0x8c, 0x98, 0x62},
  {0x18, 0x21, 0x8c, 0xb0, 0x62},
  {0x28, 0x49, 0x45, 0x66, 0000},
  {0x30, 0x1b, 0x88, 0x85, 0x74},
  {0x38, 0x07, 0xf0, 0xc9, 0x20},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x1a, 0x88, 0xd1, 0000}, /* 11 */
  {0x18, 0x07, 0000, 0x43, 0x70},
  {0x18, 0x10, 0000, 0xab, 0000},
  {0x30, 0x1b, 0x88, 0xa1, 0xa0},
  {0x38, 0x19, 0x88, 0x11, 0x40},
  {0x40, 0x25, 0x45, 0x63, 0x84},
  {0x40, 0x25, 0x45, 0x83, 0x84},
  {0x48, 0x1a, 0x88, 0xd1, 0x80},
  {0x50, 0x07, 0xf0, 0x81, 0x10},
  {0x68, 0x13, 0000, 0x2d, 0000},
  {0x68, 0x07, 0000, 0x85, 0x60},
  {0x68, 0x09, 0000, 0xa5, 0000},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x49, 0x1d, 0xea, 0xc0}, /* 12 */
  {0x18, 0x1b, 0x88, 0x21, 0x20},
  {0x20, 0x49, 0x1f, 0x62, 0x80},
  {0x20, 0x07, 0xf0, 0x81, 0x60},
  {0x28, 0x27, 0x88, 0x66, 0x64},
  {0x28, 0x13, 0000, 0x6d, 0000},
  {0x30, 0x27, 0x88, 0xc2, 0xd0},
  {0x30, 0x07, 0xf0, 0xc1, 0x50},
  {0x48, 0x1a, 0x88, 0xd5, 0x54},
  {0x58, 0x25, 0x85, 0x47, 0x39},
  {0x58, 0x25, 0x85, 0x27, 0x39},
  {0x68, 0x08, 0000, 0x81, 0000},
  {0xff, 0000, 0000, 0000, 0000},
  {0x20, 0x42, 0x89, 0xc1, 0000}, /* 13 */
  {0x28, 0x35, 0x89, 0xc5, 0xa4},
  {0x30, 0x38, 0000, 0xcd, 0xcd},
  {0x30, 0x39, 0x8c, 0xc7, 0x24},
  {0x40, 0x36, 0x11, 0x73, 0x66},
  {0x40, 0x37, 0x1f, 0x76, 0x66},
  {0x40, 0x0c, 0000, 0xd1, 0000},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x0a, 0xf1, 0x61, 0x40}, /* 14 */
  {0x18, 0x0a, 0xf1, 0x81, 0x40},
  {0x18, 0x0a, 0x01, 0xa1, 0x40},
  {0x20, 0x0b, 0xf1, 0x65, 0x01},
  {0x20, 0x0c, 0x01, 0x85, 0000},
  {0x20, 0x0b, 0x01, 0xa5, 0x01},
  {0x20, 0x10, 0000, 0xcd, 0000},
  {0x20, 0x11, 0000, 0x75, 0000},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x0a, 0x01, 0x61, 0x40}, /* 15 */
  {0x18, 0x0b, 0x01, 0x81, 0x01},
  {0x18, 0x0a, 0xf1, 0xa1, 0x40},
  {0x20, 0x0b, 0000, 0x65, 0x01},
  {0x20, 0x0c, 0000, 0x85, 0x01},
  {0x20, 0x0b, 0xf0, 0xa5, 0000},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x35, 0x79, 0x81, 0x81}, /* 16 */
  {0x18, 0x0b, 0000, 0x39, 0x01},
  {0x28, 0x0a, 0xf0, 0x21, 0x20},
  {0x30, 0x32, 0x79, 0xcf, 0xc7},
  {0x38, 0x0b, 0000, 0x85, 0000},
  {0x40, 0x0a, 0xf0, 0x55, 0x40},
  {0x40, 0x0a, 0xf0, 0x45, 0x40},
  {0x48, 0x2e, 0x15, 0xb2, 0xca},
  {0x48, 0x2e, 0x15, 0xe2, 0xca},
  {0x50, 0x42, 0x19, 0x9d, 0x74},
  {0x50, 0x36, 0x11, 0x83, 0x74},
  {0x50, 0x37, 0x1f, 0x86, 0x74},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x16, 0000, 0000, 0000}, /* 17 */
  {0x18, 0x0a, 0xf0, 0x49, 0x20},
  {0x18, 0x0a, 0000, 0xc9, 0x20},
  {0x20, 0x0c, 0000, 0xc1, 0x01},
  {0x20, 0x35, 0x79, 0x61, 0x60},
  {0x28, 0x14, 0000, 0x6d, 0000},
  {0x28, 0x14, 0000, 0x85, 0000},
  {0x30, 0x39, 0x8c, 0x8f, 0x21},
  {0x30, 0x38, 0x31, 0x85, 0x85},
  {0x38, 0x0a, 0xf0, 0x85, 0x60},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x17, 0x01, 0000, 0000}, /* 18 */
  {0x18, 0x14, 0000, 0x89, 0000},
  {0x18, 0x14, 0000, 0xa1, 0000},
  {0x18, 0x0a, 0xf0, 0xa1, 0x40},
  {0x20, 0x14, 0000, 0x8d, 0000},
  {0x20, 0x0b, 0xf1, 0xc1, 0x02},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x2d, 0x8c, 0x80, 0x24}, /* 19 */
  {0x28, 0x3d, 0x88, 0xd1, 0x20},
  {0x30, 0x33, 0x88, 0x21, 0x20},
  {0x38, 0x3d, 0x88, 0xe1, 0x20},
  {0x40, 0x0a, 0000, 0x29, 0x40},
  {0x40, 0x11, 0000, 0xc1, 0000},
  {0x48, 0x10, 0000, 0x29, 0000},
  {0x50, 0x0b, 0000, 0x31, 0xa4},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x25, 0x44, 0x1b, 0x60}, /* 1a */
  {0x18, 0x25, 0x44, 0xa3, 0x60},
  {0x18, 0x27, 0x48, 0xe2, 0x60},
  {0x20, 0x3e, 0x88, 0x85, 0x84},
  {0x20, 0x27, 0x88, 0x26, 0x25},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x0b, 0xf0, 0x21, 0x07}, /* 1b */
  {0x18, 0x14, 0000, 0x61, 0000},
  {0x28, 0x14, 0000, 0xa1, 0000},
  {0x28, 0x0b, 0000, 0x31, 0000},
  {0x30, 0x0a, 0xf0, 0x45, 0x60},
  {0x30, 0x36, 0x11, 0x83, 0x6c},
  {0x30, 0x37, 0x1f, 0x86, 0x6c},
  {0x30, 0x14, 0000, 0xc5, 0000},
  {0x40, 0x2e, 0x15, 0x90, 0xa0},
  {0x48, 0x1b, 0x88, 0x21, 0x18},
  {0x50, 0x0a, 0000, 0xb5, 0xa3},
  {0x50, 0x10, 0000, 0xc5, 0000},
  {0xff, 0000, 0000, 0000, 0000},
  {0x10, 0x0a, 0xf0, 0x7d, 0x20}, /* 1c */
  {0x10, 0x0a, 0000, 0x95, 0x20},
  {0x10, 0x0a, 0xf0, 0xad, 0x20},
  {0x20, 0x27, 0x88, 0x46, 0x46},
  {0x20, 0x27, 0x48, 0xc6, 0xe4},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x16, 0000, 0000, 0000}, /* 1d */
  {0x18, 0x0c, 0000, 0xc1, 0000},
  {0x18, 0x0b, 0xf0, 0x81, 0000},
  {0x18, 0x27, 0x88, 0x66, 0x64},
  {0x20, 0x34, 0x4c, 0x64, 0xe4},
  {0x28, 0x36, 0x11, 0xb3, 0xa4},
  {0x28, 0x37, 0x1f, 0xb6, 0xa4},
  {0x30, 0x0a, 0xf0, 0x31, 0x25},
  {0x30, 0x0a, 0000, 0x79, 0x21},
  {0x38, 0x27, 0x88, 0xc6, 0xc4},
  {0x38, 0x17, 0x01, 0xe0, 0xe0},
  {0x38, 0x0a, 0000, 0x45, 0x50},
  {0xff, 0000, 0000, 0000, 0000},
  {0x10, 0x0e, 0000, 0xc5, 0000}, /* 1e */
  {0x18, 0x0b, 0xf0, 0xc1, 0x02},
  {0x18, 0x0b, 0000, 0x21, 0x02},
  {0x20, 0x35, 0x89, 0xa1, 0000},
  {0x20, 0x16, 0000, 0000, 0000},
  {0x20, 0x17, 0x01, 0xe0, 0xe0},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x0a, 0xf0, 0x81, 0x10}, /* 1f */
  {0x20, 0x0b, 0xf0, 0x61, 0x07},
  {0x28, 0x11, 0000, 0xc3, 0000},
  {0x28, 0x27, 0x88, 0xa4, 0xa2},
  {0x30, 0x0b, 0xf0, 0x21, 0x04},
  {0x30, 0x14, 0000, 0x8d, 0000},
  {0x38, 0x0a, 0xf0, 0x25, 0x60},
  {0x40, 0x0b, 0xf0, 0x65, 0x07},
  {0x48, 0x0b, 0xf0, 0x75, 0000},
  {0x50, 0x11, 0000, 0xc9, 0000},
  {0xff, 0000, 0000, 0000, 0000},
  {0x10, 0x0a, 0xf0, 0x85, 0x48}, /* 20 */
  {0x18, 0x14, 0000, 0x21, 0000},
  {0x18, 0x0c, 0000, 0x21, 0000},
  {0x20, 0x0c, 0000, 0x21, 0x04},
  {0x28, 0x27, 0x88, 0xa6, 0xbc},
  {0x30, 0x2d, 0x8c, 0x48, 0x20},
  {0x38, 0x27, 0x88, 0x22, 0x20},
  {0x40, 0x0c, 0000, 0xc1, 0x01},
  {0x50, 0x0a, 0000, 0x41, 0x90},
  {0x50, 0x27, 0x88, 0x42, 0x40},
  {0x50, 0x0c, 0000, 0x25, 0000},
  {0xff, 0000, 0000, 0000, 0000},
  {0x10, 0x0b, 0000, 0xcd, 0x05}, /* 21 */
  {0x18, 0x14, 0000, 0x65, 0000},
  {0x20, 0x42, 0x89, 0xcd, 0x84},
  {0x20, 0x27, 0x88, 0x26, 0x24},
  {0x30, 0x27, 0x88, 0x22, 0x20},
  {0x30, 0x0b, 0xf0, 0xc9, 0x05},
  {0x48, 0x27, 0x88, 0x26, 0x24},
  {0x50, 0x27, 0x88, 0xc2, 0xc0},
  {0x50, 0x11, 0000, 0xcd, 0000},
  {0x60, 0x14, 0000, 0x21, 0000},
  {0x68, 0x14, 0000, 0x21, 0000},
  {0x78, 0x0c, 0000, 0xc1, 0x01},
  {0x80, 0x0c, 0000, 0xc5, 0x01},
  {0x80, 0x0a, 0xf0, 0x85, 0x42},
  {0xff, 0000, 0000, 0000, 0000},
  {0x10, 0x0c, 0000, 0x65, 0x01}, /* 22 */
  {0x20, 0x0c, 0000, 0x21, 0x02},
  {0x20, 0x14, 0000, 0x61, 0000},
  {0x30, 0x27, 0x88, 0x66, 0x64},
  {0x38, 0x0a, 0000, 0x83, 0x38},
  {0x38, 0x10, 0000, 0xe1, 0000},
  {0x48, 0x0a, 0xf0, 0x41, 0x90},
  {0xff, 0000, 0000, 0000, 0000},
  {0x20, 0x0b, 0000, 0xa9, 0x07}, /* 23 */
  {0x20, 0x14, 0000, 0x89, 0000},
  {0x28, 0x0b, 0xf0, 0xc5, 0x04},
  {0x30, 0x0b, 0000, 0xc1, 0x04},
  {0x38, 0x14, 0000, 0xe5, 0000},
  {0x38, 0x0a, 0xf0, 0x65, 0x20},
  {0x40, 0x0a, 0xf0, 0x65, 0x30},
  {0xff, 0000, 0000, 0000, 0000},
  {0x10, 0x11, 0000, 0xe5, 0000}, /* 24 */
  {0x18, 0x27, 0x88, 0x42, 0x40},
  {0x20, 0x27, 0x88, 0x22, 0x20},
  {0x28, 0x42, 0x89, 0xc5, 0x64},
  {0x38, 0x47, 0x88, 0xd1, 0x40},
  {0x40, 0x27, 0x88, 0xc6, 0xd4},
  {0x48, 0x27, 0x88, 0xa6, 0x98},
  {0x50, 0x0c, 0000, 0x25, 0000},
  {0x50, 0x0a, 0xf0, 0x25, 0xa0},
  {0x50, 0x0a, 0000, 0x85, 0x60},
  {0xff, 0000, 0000, 0000, 0000},
  {0x20, 0x38, 0x80, 0xc1, 0xc0}, /* 25 */
  {0x20, 0x39, 0x8c, 0xc3, 0x20},
  {0x20, 0x39, 0x8c, 0xcb, 0000},
  {0x20, 0x0a, 0xf0, 0x65, 0x30},
  {0x28, 0x0f, 0000, 0x25, 0x01},
  {0x28, 0x3f, 0x8c, 0xe6, 0x14},
  {0x28, 0x0c, 0000, 0xc5, 0000},
  {0x28, 0x15, 0000, 0x15, 0000},
  {0xff, 0000, 0000, 0000, 0000},
  {0x10, 0x0f, 0000, 0x2d, 0x07}, /* 26 */
  {0x20, 0x0d, 0000, 0x95, 0x50},
  {0x20, 0x0e, 0xf0, 0xa5, 0x07},
  {0x28, 0x40, 0x88, 0x29, 0x2b},
  {0x28, 0x41, 0x89, 0xa5, 0xa5},
  {0x30, 0x15, 0000, 0x8d, 0000},
  {0x38, 0x3f, 0x8c, 0xe5, 0xc4},
  {0x40, 0x0e, 0xf0, 0x85, 0x07},
  {0x48, 0x0c, 0000, 0xa5, 0000},
  {0x48, 0x0d, 0xf0, 0x25, 0x50},
  {0x50, 0x3f, 0x8d, 0xe1, 0x88},
  {0x60, 0x40, 0x88, 0xc9, 0xc8},
  {0x68, 0x40, 0x88, 0x70, 0x80},
  {0x68, 0x41, 0x89, 0xc9, 0xc0},
  {0x68, 0x0f, 0000, 0xc1, 0000},
  {0x68, 0x0e, 0xf0, 0x41, 0000},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x3f, 0x8c, 0xe1, 0x40}, /* 27 */
  {0x18, 0x41, 0x89, 0x69, 0x69},
  {0x20, 0x0f, 0000, 0x25, 0x02},
  {0x20, 0x41, 0x89, 0xa5, 0xa5},
  {0x20, 0x0d, 0xf0, 0xc5, 0xc0},
  {0x20, 0x16, 0000, 0xd0, 0xd0},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x11, 0000, 0x62, 0000}, /* 28 */
  {0x18, 0x0b, 0xf0, 0xb2, 0000},
  {0x20, 0x0d, 0000, 0x26, 0x38},
  {0x20, 0x0d, 0000, 0xce, 0x30},
  {0x20, 0x10, 0000, 0xce, 0000},
  {0x38, 0x0b, 0xf0, 0xb5, 0000},
  {0x38, 0x40, 0x88, 0x4e, 0x45},
  {0x40, 0x3b, 0x88, 0x26, 0x26},
  {0x48, 0x0e, 0000, 0x95, 0x04},
  {0x50, 0x3b, 0x88, 0x21, 0x20},
  {0x50, 0x0a, 0000, 0x61, 0x48},
  {0x50, 0x15, 0000, 0x65, 0000},
  {0x50, 0x41, 0x88, 0xad, 0xa5},
  {0x60, 0x41, 0x88, 0x41, 0x41},
  {0x60, 0x0d, 0xf0, 0x61, 0x60},
  {0x68, 0x3c, 0x8e, 0x41, 0x2c},
  {0x68, 0x46, 0x8c, 0xc6, 0x2c},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x40, 0x88, 0x69, 0x70}, /* 29 */
  {0x18, 0x3a, 0x1f, 0xca, 0xb9},
  {0x18, 0x17, 0x88, 0xa0, 0xa0},
  {0x18, 0x3b, 0x88, 0xa5, 0xad},
  {0x20, 0x40, 0x88, 0x29, 0x30},
  {0x20, 0x0f, 0000, 0xa5, 0000},
  {0x20, 0x0f, 0000, 0xc5, 0000},
  {0x20, 0x0e, 0000, 0x89, 0x01},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x17, 0x01, 0xe0, 0xe0}, /* 2a */
  {0x18, 0x16, 0000, 0x24, 0x24},
  {0x18, 0x3f, 0x8c, 0xe5, 0x04},
  {0x30, 0x0d, 0xf0, 0x81, 0x30},
  {0x38, 0x3b, 0x88, 0x41, 0x41},
  {0x38, 0x0c, 0000, 0x81, 0x01},
  {0x38, 0x15, 0000, 0xd1, 0000},
  {0x40, 0x41, 0x89, 0x49, 0x40},
  {0x48, 0x0c, 0000, 0x45, 0000},
  {0x50, 0x3f, 0x8c, 0xe5, 0x24},
  {0x58, 0x0d, 0xf0, 0x45, 0x30},
  {0x58, 0x0e, 0xf0, 0xcd, 0x07},
  {0x60, 0x3b, 0x88, 0x44, 0x44},
  {0x68, 0x3f, 0x8c, 0xe5, 0x24},
  {0xff, 0000, 0000, 0000, 0000},
  {0x10, 0x0d, 0xf0, 0x85, 0x10}, /* 2b */
  {0x18, 0x0e, 0xf0, 0xcd, 0x06},
  {0x18, 0x0c, 0000, 0x21, 0000},
  {0x18, 0x40, 0x88, 0xce, 0xce},
  {0x20, 0x40, 0x88, 0xcd, 0xc5},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x3c, 0x8e, 0x26, 0000}, /* 2c */
  {0x20, 0x40, 0x88, 0xcd, 0xd4},
  {0x20, 0x41, 0x89, 0x91, 0x91},
  {0x20, 0x41, 0x89, 0xa9, 0xa9},
  {0x28, 0x3a, 0x8c, 0xa6, 0xb8},
  {0x30, 0x3f, 0x8c, 0xe2, 0x22},
  {0x30, 0x0a, 0xf0, 0x3d, 0x40},
  {0x40, 0x3f, 0x8c, 0xe2, 0x50},
  {0x48, 0x3b, 0x88, 0x21, 0x18},
  {0x48, 0x40, 0x88, 0xe5, 0xdd},
  {0x50, 0x45, 0x8e, 0x22, 0x20},
  {0x50, 0x3f, 0x8c, 0xe6, 0x24},
  {0x60, 0x0d, 0xf0, 0xb1, 0x20},
  {0x60, 0x0d, 0xf0, 0x65, 0x20},
  {0x68, 0x3f, 0x8c, 0xe5, 0x24},
  {0x68, 0x10, 0000, 0x1d, 0000},
  {0xff, 0000, 0000, 0000, 0000},
  {0x18, 0x0d, 0xf0, 0x61, 0x20}, /* 2e */
  {0x18, 0x0d, 0xf0, 0x81, 0x20},
  {0x20, 0x43, 0x19, 0x80, 0x80},
  {0x20, 0x44, 0x19, 0x8f, 0x80},
  {0x20, 0x43, 0x19, 0x8f, 0x80},
  {0x20, 0x44, 0x19, 0x7f, 0x80},
  {0x20, 0x36, 0x11, 0xeb, 0x80},
  {0x20, 0x37, 0x1f, 0xee, 0x80},
  {0xff, 0000, 0000, 0000, 0000},
};

U8 map_eflg_c[MAP_NBR_EFLGC] = {
  0x4d, 0000, 0x0e, 0x02, 0x04, 0x04, 0x57, 0x08,
  0x08, 0x18, 0x03, 0x68, 0x3b, 0x48, 0x04, 0x80,
  0x37, 0000, 0x04, 0x02, 0x04, 0x04, 0x90, 0x08,
  0x09, 0x18, 0x01, 0x68, 0x21, 0x48, 0x06, 0x80,
};

/* eof */
