/*
 * xrick/src/e_bonus.c
 *
 * This source code file is part of the xrick distribution, and as such is
 * copyrighted. Please read the README file in the root directory of the
 * distribution for information about copyrights, trademarks, license,
 * disclaimers, etc.
 */

#include "system.h"
#include "game.h"
#include "ents.h"
#include "e_bonus.h"

#include "e_rick.h"
#include "maps.h"


/*
 * Entity action
 *
 * ASM 242C
 */
void
e_bonus_action(U8 e)
{
#define seq c1

  if (ent_ents[e].seq == 0) {
    if (e_rick_boxtest(e)) {
      game_score += 500;
#ifdef ENABLE_SOUND
      syssnd_play(WAV_BONUS, 1);
#endif
      map_marks[ent_ents[e].mark].ent |= MAP_MARK_NACT;
      ent_ents[e].seq = 1;
      ent_ents[e].sprite = 0xad;
      ent_ents[e].front = TRUE;
      ent_ents[e].y -= 0x08;
    }
  }

  else if (ent_ents[e].seq > 0 && ent_ents[e].seq < 10) {
    ent_ents[e].seq++;
    ent_ents[e].y -= 2;
  }

  else {
    ent_ents[e].n = 0;
  }
}


/* eof */


